/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.template.url;

import java.net.URL;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class WhiteListURLMatcher {
    private static final String[] SUPPORTED_PROTOCOLS = new String[]{"http", "https"};

    public static boolean urlIsAllowed(URL url, String whiteList) {
        if (whiteList == null) {
            return false;
        }
        boolean unsupportedProtocol = true;
        for (String protocol : SUPPORTED_PROTOCOLS) {
            if (!protocol.equalsIgnoreCase(url.getProtocol())) continue;
            unsupportedProtocol = false;
            break;
        }
        if (unsupportedProtocol) {
            return false;
        }
        String[] whiteListPatterns = whiteList.split("\\,");
        boolean supportedPattern = false;
        if (whiteListPatterns != null) {
            for (String whiteListPattern : whiteListPatterns) {
                whiteListPattern = whiteListPattern.trim();
                String includedProtocol = null;
                for (String protocol : SUPPORTED_PROTOCOLS) {
                    if (!whiteListPattern.toLowerCase().startsWith(protocol.toLowerCase() + "://")) continue;
                    includedProtocol = protocol;
                    whiteListPattern = whiteListPattern.substring(protocol.toLowerCase().length() + "://".length());
                    break;
                }
                if (!WhiteListURLMatcher.matchesString(whiteListPattern.toLowerCase(), url.getHost().toLowerCase()) || includedProtocol != null && !includedProtocol.equalsIgnoreCase(url.getProtocol())) continue;
                supportedPattern = true;
                break;
            }
        }
        return supportedPattern;
    }

    private static boolean matchesString(String pattern, String target) {
        StringTokenizer stok = new StringTokenizer(pattern, "*?", true);
        StringBuilder newPattern = new StringBuilder();
        while (stok.hasMoreTokens()) {
            String currentToken = stok.nextToken();
            if ("*".equals(currentToken)) {
                newPattern.append(".*");
                continue;
            }
            if ("?".equals(currentToken)) {
                newPattern.append(".?");
                continue;
            }
            newPattern.append(Pattern.quote(currentToken));
        }
        return target.matches(newPattern.toString());
    }
}

