/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.template.url;

import com.eucalyptus.cloudformation.ValidationErrorException;
import com.google.common.net.InetAddresses;
import java.net.URL;
import java.net.URLDecoder;
import java.util.StringTokenizer;

public class S3Helper {
    public static BucketAndKey getBucketAndKeyFromUrl(URL url, String[] validServicePaths, String[] validHostBucketSuffixes, String[] validDomains) throws ValidationErrorException {
        if (url.getHost() == null || url.getPath() == null) {
            throw new ValidationErrorException("Invalid S3 " + url);
        }
        if (InetAddresses.isInetAddress((String)url.getHost())) {
            for (String validServicePath : validServicePaths) {
                if (!url.getPath().startsWith(validServicePath)) continue;
                return S3Helper.getBucketAndKeyFromPath(url.getPath().substring(validServicePath.length()), url);
            }
            throw new ValidationErrorException("Invalid S3 url" + url + ", contains IP address but no OSG service path");
        }
        for (String validDomain : validDomains) {
            String validHostNameBucketNameSuffixLower;
            String validDomainLower;
            String hostLower = url.getHost().toLowerCase();
            if (!hostLower.endsWith(validDomainLower = validDomain.toLowerCase())) continue;
            for (String validHostBucketSuffix : validHostBucketSuffixes) {
                validHostNameBucketNameSuffixLower = validHostBucketSuffix.toLowerCase();
                if (!hostLower.contains("." + validHostNameBucketNameSuffixLower)) continue;
                String bucket = hostLower.substring(0, hostLower.indexOf("." + validHostNameBucketNameSuffixLower));
                return S3Helper.getBucketAndKeyFromPath(bucket + "/" + url.getPath(), url);
            }
            for (String validHostBucketSuffix : validHostBucketSuffixes) {
                validHostNameBucketNameSuffixLower = validHostBucketSuffix.toLowerCase();
                if (!hostLower.startsWith(validHostNameBucketNameSuffixLower + ".")) continue;
                return S3Helper.getBucketAndKeyFromPath(url.getPath(), url);
            }
        }
        throw new ValidationErrorException("Invalid S3 url " + url + ", does not match any known S3 domains");
    }

    private static BucketAndKey getBucketAndKeyFromPath(String path, URL url) throws ValidationErrorException {
        try {
            StringTokenizer stok = new StringTokenizer(path, "/");
            String bucket = URLDecoder.decode(stok.nextToken());
            String delimiter = "";
            StringBuilder keyBuilder = new StringBuilder();
            do {
                keyBuilder.append(delimiter).append(URLDecoder.decode(stok.nextToken()));
                delimiter = "/";
            } while (stok.hasMoreTokens());
            return new BucketAndKey(bucket, keyBuilder.toString());
        }
        catch (Exception ex) {
            throw new ValidationErrorException("S3 URL " + url + " parses to invalid bucket/key pairs.");
        }
    }

    public static class BucketAndKey {
        String bucket;
        String key;

        BucketAndKey(String bucket, String key) {
            this.bucket = bucket;
            this.key = key;
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            return "BucketAndKey{bucket='" + this.bucket + '\'' + ", key='" + this.key + '\'' + '}';
        }
    }
}

