/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.template.dependencies;

import com.eucalyptus.cloudformation.CloudFormationException;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.template.dependencies.CyclicDependencyException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;

public class DependencyManager {
    private Set<String> nodes = Sets.newLinkedHashSet();
    private Table<String, String, Integer> edgeTable = TreeBasedTable.create();

    public Set<String> getNodes() {
        return this.nodes;
    }

    public Collection<String> getDependentNodes(String independentNode) {
        return this.edgeTable.row((Object)independentNode).keySet();
    }

    public Collection<String> getReverseDependentNodes(String independentNode) {
        return this.edgeTable.column((Object)independentNode).keySet();
    }

    public synchronized void addNode(String node) {
        this.nodes.add(node);
    }

    public synchronized boolean containsNode(String node) {
        return this.nodes.contains(node);
    }

    public synchronized void addDependency(String dependentNode, String independentNode) throws NoSuchElementException {
        if (!this.nodes.contains(dependentNode)) {
            throw new NoSuchElementException(dependentNode);
        }
        if (!this.nodes.contains(independentNode)) {
            throw new NoSuchElementException(independentNode);
        }
        this.edgeTable.put((Object)independentNode, (Object)dependentNode, (Object)1);
    }

    public synchronized List<String> dependencyList() throws CyclicDependencyException {
        LinkedList sortedNodes = Lists.newLinkedList();
        TreeSet unmarkedNodes = Sets.newTreeSet(this.nodes);
        LinkedHashSet temporarilyMarkedNodes = Sets.newLinkedHashSet();
        HashSet permanentlyMarkedNodes = Sets.newHashSet();
        while (!unmarkedNodes.isEmpty()) {
            String currentNode = (String)unmarkedNodes.iterator().next();
            this.visitNode(currentNode, unmarkedNodes, temporarilyMarkedNodes, permanentlyMarkedNodes, sortedNodes);
        }
        return sortedNodes;
    }

    private void visitNode(String currentNode, Set<String> unmarkedNodes, Set<String> temporarilyMarkedNodes, Set<String> permanentlyMarkedNodes, LinkedList<String> sortedNodes) throws CyclicDependencyException {
        if (temporarilyMarkedNodes.contains(currentNode)) {
            throw new CyclicDependencyException(this.subListFrom(Lists.newArrayList(temporarilyMarkedNodes), currentNode).toString());
        }
        if (unmarkedNodes.contains(currentNode)) {
            unmarkedNodes.remove(currentNode);
            temporarilyMarkedNodes.add(currentNode);
            for (String adjacentNode : this.edgeTable.row((Object)currentNode).keySet()) {
                this.visitNode(adjacentNode, unmarkedNodes, temporarilyMarkedNodes, permanentlyMarkedNodes, sortedNodes);
            }
            temporarilyMarkedNodes.remove(currentNode);
            permanentlyMarkedNodes.add(currentNode);
            sortedNodes.addFirst(currentNode);
        }
    }

    public String toJson() throws CloudFormationException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            String nodesStr = mapper.writeValueAsString(this.nodes);
            Map<String, List<String>> dependencies = this.convertToMap(this.edgeTable);
            String dependenciesStr = mapper.writeValueAsString(dependencies);
            ObjectNode objectNode = mapper.createObjectNode();
            objectNode.put("nodes", nodesStr);
            objectNode.put("dependencies", dependenciesStr);
            return objectNode.toString();
        }
        catch (JsonProcessingException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    private Map<String, List<String>> convertToMap(Table<String, String, Integer> table) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (String row : table.rowKeySet()) {
            map.put(row, Lists.newArrayList(table.row((Object)row).keySet()));
        }
        return map;
    }

    public static DependencyManager fromJson(String json) throws CloudFormationException {
        if (json == null) {
            return new DependencyManager();
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(json);
            String nodeStr = jsonNode.get("nodes").asText();
            String dependenciesStr = jsonNode.get("dependencies").asText();
            ArrayList nodes = (ArrayList)mapper.readValue(nodeStr, (TypeReference)new TypeReference<ArrayList<String>>(){});
            Map dependencies = (Map)mapper.readValue(dependenciesStr, (TypeReference)new TypeReference<LinkedHashMap<String, List<String>>>(){});
            DependencyManager dependencyManager = new DependencyManager();
            for (String node : nodes) {
                dependencyManager.addNode(node);
            }
            for (String row : dependencies.keySet()) {
                for (String column : (List)dependencies.get(row)) {
                    dependencyManager.addDependency(column, row);
                }
            }
            return dependencyManager;
        }
        catch (IOException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    private List<String> subListFrom(List<String> list, String element) {
        int index = list.indexOf(element);
        if (index == -1) {
            return list;
        }
        return list.subList(index, list.size());
    }
}

