/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.template;

import com.eucalyptus.cloudformation.CloudFormationException;
import com.eucalyptus.cloudformation.InsufficientCapabilitiesException;
import com.eucalyptus.cloudformation.Limits;
import com.eucalyptus.cloudformation.Parameter;
import com.eucalyptus.cloudformation.ResourceList;
import com.eucalyptus.cloudformation.TemplateParameter;
import com.eucalyptus.cloudformation.TemplateParameters;
import com.eucalyptus.cloudformation.ValidateTemplateResult;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.entity.StackEntity;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceResolverManager;
import com.eucalyptus.cloudformation.template.FunctionEvaluation;
import com.eucalyptus.cloudformation.template.IntrinsicFunction;
import com.eucalyptus.cloudformation.template.IntrinsicFunctions;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.template.PseudoParameterValues;
import com.eucalyptus.cloudformation.template.Template;
import com.eucalyptus.cloudformation.template.dependencies.CyclicDependencyException;
import com.eucalyptus.cloudformation.template.dependencies.DependencyManager;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;

public class TemplateParser {
    private static final String NO_ECHO_PARAMETER_VALUE = "****";
    private static final Logger LOG = Logger.getLogger(TemplateParser.class);
    public static final String AWS_ACCOUNT_ID = "AWS::AccountId";
    public static final String AWS_NOTIFICATION_ARNS = "AWS::NotificationARNs";
    public static final String AWS_NO_VALUE = "AWS::NoValue";
    public static final String AWS_REGION = "AWS::Region";
    public static final String AWS_STACK_ID = "AWS::StackId";
    public static final String AWS_STACK_NAME = "AWS::StackName";
    private static final String DEFAULT_TEMPLATE_VERSION = "2010-09-09";
    private static final String[] validTemplateVersions = new String[]{"2010-09-09"};
    private ObjectMapper objectMapper = new ObjectMapper();

    public Template parse(String templateBody, List<Parameter> userParameters, List<String> capabilities, PseudoParameterValues pseudoParameterValues) throws CloudFormationException {
        Template template = new Template();
        template.setResourceInfoMap(Maps.newLinkedHashMap());
        JsonNode templateJsonNode = null;
        try {
            templateJsonNode = this.objectMapper.readTree(templateBody);
        }
        catch (IOException ex) {
            throw new ValidationErrorException(ex.getMessage());
        }
        if (!templateJsonNode.isObject()) {
            throw new ValidationErrorException("Template body is not a JSON object");
        }
        template.setTemplateBody(templateBody);
        this.addPseudoParameters(template, pseudoParameterValues);
        this.buildResourceMap(template, templateJsonNode);
        this.parseValidTopLevelKeys(templateJsonNode);
        this.parseVersion(template, templateJsonNode);
        this.parseDescription(template, templateJsonNode);
        this.parseMappings(template, templateJsonNode);
        ParameterParser.parseParameters(template, templateJsonNode, userParameters, false);
        this.parseConditions(template, templateJsonNode, false);
        this.parseResources(template, templateJsonNode, false);
        ArrayList requiredCapabilities = Lists.newArrayList();
        for (ResourceInfo resourceInfo : template.getResourceInfoMap().values()) {
            if (resourceInfo.getRequiredCapabilities() == null) continue;
            requiredCapabilities.addAll(resourceInfo.getRequiredCapabilities());
        }
        LinkedHashSet missingRequiredCapabilities = Sets.newLinkedHashSet();
        if (!requiredCapabilities.isEmpty()) {
            for (String requiredCapability : requiredCapabilities) {
                if (capabilities != null && capabilities.contains(requiredCapability)) continue;
                missingRequiredCapabilities.add(requiredCapability);
            }
        }
        if (!missingRequiredCapabilities.isEmpty()) {
            throw new InsufficientCapabilitiesException("Required capabilities:" + missingRequiredCapabilities);
        }
        this.parseOutputs(template, templateJsonNode);
        return template;
    }

    public ValidateTemplateResult validateTemplate(String templateBody, List<Parameter> userParameters, PseudoParameterValues pseudoParameterValues) throws CloudFormationException {
        Template template = new Template();
        template.setResourceInfoMap(Maps.newLinkedHashMap());
        JsonNode templateJsonNode = null;
        try {
            templateJsonNode = this.objectMapper.readTree(templateBody);
        }
        catch (IOException ex) {
            throw new ValidationErrorException(ex.getMessage());
        }
        if (!templateJsonNode.isObject()) {
            throw new ValidationErrorException("Template body is not a JSON object");
        }
        template.setTemplateBody(templateBody);
        this.addPseudoParameters(template, pseudoParameterValues);
        this.buildResourceMap(template, templateJsonNode);
        this.parseValidTopLevelKeys(templateJsonNode);
        this.parseVersion(template, templateJsonNode);
        this.parseDescription(template, templateJsonNode);
        this.parseMappings(template, templateJsonNode);
        ParameterParser.parseParameters(template, templateJsonNode, userParameters, true);
        this.parseConditions(template, templateJsonNode, true);
        this.parseResources(template, templateJsonNode, true);
        this.parseOutputs(template, templateJsonNode);
        LinkedHashSet capabilitiesResourceTypes = Sets.newLinkedHashSet();
        LinkedHashSet requiredCapabilities = Sets.newLinkedHashSet();
        for (ResourceInfo resourceInfo : template.getResourceInfoMap().values()) {
            if (resourceInfo.getRequiredCapabilities() == null || resourceInfo.getRequiredCapabilities().isEmpty()) continue;
            requiredCapabilities.addAll(resourceInfo.getRequiredCapabilities());
            capabilitiesResourceTypes.add(resourceInfo.getType());
        }
        ValidateTemplateResult validateTemplateResult = new ValidateTemplateResult();
        validateTemplateResult.setDescription(template.getDescription());
        validateTemplateResult.setCapabilities(new ResourceList());
        validateTemplateResult.getCapabilities().setMember(Lists.newArrayList((Iterable)requiredCapabilities));
        if (!requiredCapabilities.isEmpty()) {
            validateTemplateResult.setCapabilitiesReason("The following resource(s) require capabilities: " + capabilitiesResourceTypes);
        }
        validateTemplateResult.setParameters(new TemplateParameters());
        validateTemplateResult.getParameters().setMember(template.getTemplateParameters());
        return validateTemplateResult;
    }

    private void addPseudoParameters(Template template, PseudoParameterValues pseudoParameterValues) throws CloudFormationException {
        Map<String, String> pseudoParameterMap = template.getPseudoParameterMap();
        ObjectMapper mapper = new ObjectMapper();
        pseudoParameterMap.put(AWS_ACCOUNT_ID, JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(pseudoParameterValues.getAccountId())));
        ArrayNode notificationsArnNode = this.objectMapper.createArrayNode();
        if (pseudoParameterValues.getNotificationArns() != null) {
            for (String notificationArn : pseudoParameterValues.getNotificationArns()) {
                notificationsArnNode.add(notificationArn);
            }
        }
        pseudoParameterMap.put(AWS_NOTIFICATION_ARNS, JsonHelper.getStringFromJsonNode((JsonNode)notificationsArnNode));
        ObjectNode noValueNode = mapper.createObjectNode();
        noValueNode.put("Ref", AWS_NO_VALUE);
        pseudoParameterMap.put(AWS_NO_VALUE, JsonHelper.getStringFromJsonNode((JsonNode)noValueNode));
        pseudoParameterMap.put(AWS_REGION, JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(pseudoParameterValues.getRegion())));
        pseudoParameterMap.put(AWS_STACK_ID, JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(pseudoParameterValues.getStackId())));
        pseudoParameterMap.put(AWS_STACK_NAME, JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(pseudoParameterValues.getStackName())));
        template.setPseudoParameterMap(pseudoParameterMap);
        template.setAvailabilityZoneMap(pseudoParameterValues.getAvailabilityZones());
    }

    private void parseValidTopLevelKeys(JsonNode templateJsonNode) throws CloudFormationException {
        HashSet tempTopLevelKeys = Sets.newHashSet((Iterator)templateJsonNode.fieldNames());
        for (TemplateSection section : TemplateSection.values()) {
            tempTopLevelKeys.remove(section.toString());
        }
        if (!tempTopLevelKeys.isEmpty()) {
            throw new ValidationErrorException("Invalid template property or properties " + tempTopLevelKeys);
        }
    }

    private void parseVersion(Template template, JsonNode templateJsonNode) throws CloudFormationException {
        String templateFormatVersion = JsonHelper.getString(templateJsonNode, TemplateSection.AWSTemplateFormatVersion.toString(), "unsupported value for " + (Object)((Object)TemplateSection.AWSTemplateFormatVersion) + ".  No such version.");
        if (templateFormatVersion == null) {
            template.setTemplateFormatVersion(DEFAULT_TEMPLATE_VERSION);
            return;
        }
        if (!Arrays.asList(validTemplateVersions).contains(templateFormatVersion)) {
            throw new ValidationErrorException("Template format error: unsupported value for " + (Object)((Object)TemplateSection.AWSTemplateFormatVersion) + ".");
        }
        template.setTemplateFormatVersion(templateFormatVersion);
    }

    private void parseDescription(Template template, JsonNode templateJsonNode) throws CloudFormationException {
        String description = JsonHelper.getString(templateJsonNode, TemplateSection.Description.toString());
        if (description == null) {
            return;
        }
        if ((long)description.getBytes().length > 1024L) {
            throw new ValidationErrorException("Template format error: " + (Object)((Object)TemplateSection.Description) + " must " + "be no longer than " + 1024L + " bytes");
        }
        template.setDescription(description);
    }

    private void parseMappings(Template template, JsonNode templateJsonNode) throws CloudFormationException {
        Map<String, Map<String, Map<String, String>>> mapping = template.getMapping();
        JsonNode mappingsJsonNode = JsonHelper.checkObject(templateJsonNode, TemplateSection.Mappings.toString());
        if (mappingsJsonNode == null) {
            return;
        }
        for (String mapName : Lists.newArrayList((Iterator)mappingsJsonNode.fieldNames())) {
            if ((long)mapName.length() > 255L) {
                throw new ValidationErrorException("Mapping name " + mapName + " exceeds the maximum number of allowed characters (" + 255L + ")");
            }
            JsonNode mappingJsonNode = JsonHelper.checkObject(mappingsJsonNode, mapName, "Every " + (Object)((Object)TemplateSection.Mappings) + " member " + mapName + " must be a map");
            for (String mapKey : Lists.newArrayList((Iterator)mappingJsonNode.fieldNames())) {
                if ((long)mapKey.length() > 255L) {
                    throw new ValidationErrorException("Mapping key " + mapKey + " exceeds the maximum number of allowed characters (" + 255L + ")");
                }
                JsonNode attributesJsonNode = JsonHelper.checkObject(mappingJsonNode, mapKey, "Every " + (Object)((Object)TemplateSection.Mappings) + " member " + mapKey + " must be a map");
                if ((long)Lists.newArrayList((Iterator)attributesJsonNode.fieldNames()).size() > Limits.MAX_ATTRIBUTES_PER_MAPPING) {
                    throw new ValidationErrorException("Mapping with key " + mapKey + " has more than " + Limits.MAX_ATTRIBUTES_PER_MAPPING + ", the max allowed.");
                }
                for (String attribute : Lists.newArrayList((Iterator)attributesJsonNode.fieldNames())) {
                    if ((long)attribute.length() > 255L) {
                        throw new ValidationErrorException("Attribute " + attribute + " exceeds the maximum number of allowed characters (" + 255L + ")");
                    }
                    JsonNode valueJsonNode = JsonHelper.checkStringOrArray(attributesJsonNode, attribute, "Every " + (Object)((Object)TemplateSection.Mappings) + " attribute must be a String or a List.");
                    if (!mapping.containsKey(mapName)) {
                        mapping.put(mapName, Maps.newLinkedHashMap());
                    }
                    if (!mapping.get(mapName).containsKey(mapKey)) {
                        mapping.get(mapName).put(mapKey, Maps.newLinkedHashMap());
                    }
                    mapping.get(mapName).get(mapKey).put(attribute, JsonHelper.getStringFromJsonNode(valueJsonNode));
                }
            }
        }
        if ((long)mapping.keySet().size() > Limits.MAX_MAPPINGS_PER_TEMPLATE) {
            throw new ValidationErrorException("Mappings exceed maximum allowed of " + Limits.MAX_MAPPINGS_PER_TEMPLATE + " mappings per template");
        }
        template.setMapping(mapping);
    }

    private void parseConditions(Template template, JsonNode templateJsonNode, boolean onlyEvaluateTemplate) throws CloudFormationException {
        JsonNode conditionJsonNode;
        JsonNode conditionsJsonNode = JsonHelper.checkObject(templateJsonNode, TemplateSection.Conditions.toString());
        if (conditionsJsonNode == null) {
            return;
        }
        LinkedHashSet conditionNames = Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Iterator)conditionsJsonNode.fieldNames()));
        DependencyManager conditionDependencyManager = new DependencyManager();
        for (String conditionName : conditionNames) {
            conditionDependencyManager.addNode(conditionName);
        }
        LinkedHashSet resourceReferences = Sets.newLinkedHashSet();
        LinkedHashSet unresolvedConditionDependencies = Sets.newLinkedHashSet();
        for (String conditionName : conditionNames) {
            conditionJsonNode = JsonHelper.checkObject(conditionsJsonNode, conditionName, "Any " + (Object)((Object)TemplateSection.Conditions) + " member must be a JSON object.");
            this.conditionDependencyCrawl(conditionName, conditionJsonNode, conditionDependencyManager, template, resourceReferences, unresolvedConditionDependencies);
            FunctionEvaluation.validateConditionSectionArgTypesWherePossible(conditionJsonNode);
        }
        if (resourceReferences != null && !resourceReferences.isEmpty()) {
            throw new ValidationErrorException("Template format error: Unresolved dependencies " + resourceReferences + ". Cannot reference resources in the Conditions block of the template");
        }
        if (unresolvedConditionDependencies != null && !resourceReferences.isEmpty()) {
            throw new ValidationErrorException("Template format error: Unresolved condition dependencies " + unresolvedConditionDependencies + " in the Conditions block of the template");
        }
        try {
            for (String conditionName : conditionDependencyManager.dependencyList()) {
                conditionJsonNode = conditionsJsonNode.get(conditionName);
                Map<String, Boolean> conditionMap = template.getConditionMap();
                if (onlyEvaluateTemplate) {
                    conditionMap.put(conditionName, Boolean.FALSE);
                } else {
                    conditionMap.put(conditionName, FunctionEvaluation.evaluateBoolean(FunctionEvaluation.evaluateFunctions(conditionJsonNode, template)));
                }
                template.setConditionMap(conditionMap);
            }
        }
        catch (CyclicDependencyException ex) {
            throw new ValidationErrorException("Template error: Found circular condition dependency: " + ex.getMessage());
        }
    }

    private void conditionDependencyCrawl(String originalConditionName, JsonNode currentNode, DependencyManager conditionDependencyManager, Template template, Set<String> resourceReferences, Set<String> unresolvedConditionDependencies) throws CloudFormationException {
        IntrinsicFunction.MatchResult ifMatcher;
        if (currentNode == null) {
            return;
        }
        if (currentNode.isArray()) {
            for (int i = 0; i < currentNode.size(); ++i) {
                this.conditionDependencyCrawl(originalConditionName, currentNode.get(i), conditionDependencyManager, template, resourceReferences, unresolvedConditionDependencies);
            }
        } else if (!currentNode.isObject()) {
            return;
        }
        if ((ifMatcher = IntrinsicFunctions.IF.evaluateMatch(currentNode)).isMatch()) {
            IntrinsicFunctions.IF.validateArgTypesWherePossible(ifMatcher);
            String conditionName = currentNode.get("Fn::If").get(0).asText();
            if (!conditionDependencyManager.containsNode(conditionName)) {
                unresolvedConditionDependencies.add(conditionName);
            } else {
                conditionDependencyManager.addDependency(originalConditionName, conditionName);
            }
            return;
        }
        IntrinsicFunction.MatchResult conditionMatcher = IntrinsicFunctions.CONDITION.evaluateMatch(currentNode);
        if (conditionMatcher.isMatch()) {
            IntrinsicFunctions.CONDITION.validateArgTypesWherePossible(conditionMatcher);
            String conditionName = currentNode.get("Condition").asText();
            if (!conditionDependencyManager.containsNode(conditionName)) {
                unresolvedConditionDependencies.add(conditionName);
            } else {
                conditionDependencyManager.addDependency(originalConditionName, conditionName);
            }
            return;
        }
        IntrinsicFunction.MatchResult refMatcher = IntrinsicFunctions.REF.evaluateMatch(currentNode);
        if (refMatcher.isMatch()) {
            IntrinsicFunctions.REF.validateArgTypesWherePossible(refMatcher);
            String refName = currentNode.get("Ref").asText();
            Map<String, String> pseudoParameterMap = template.getPseudoParameterMap();
            Map<String, StackEntity.Parameter> parameterMap = template.getParameterMap();
            if (!pseudoParameterMap.containsKey(refName) && !parameterMap.containsKey(refName)) {
                resourceReferences.add(refName);
            }
            return;
        }
        IntrinsicFunction.MatchResult fnAttMatcher = IntrinsicFunctions.GET_ATT.evaluateMatch(currentNode);
        if (fnAttMatcher.isMatch()) {
            IntrinsicFunctions.GET_ATT.validateArgTypesWherePossible(fnAttMatcher);
            String refName = currentNode.get("Fn::GetAtt").get(0).asText();
            String attName = currentNode.get("Fn::GetAtt").get(1).asText();
            if (template.getResourceInfoMap().containsKey(refName)) {
                ResourceInfo resourceInfo = template.getResourceInfoMap().get(refName);
                if (!resourceInfo.isAttributeAllowed(attName)) {
                    throw new ValidationErrorException("Template error: resource " + refName + " does not support attribute type " + attName + " in Fn::GetAtt");
                }
                resourceReferences.add(refName);
            }
            return;
        }
        ArrayList fieldNames = Lists.newArrayList((Iterator)currentNode.fieldNames());
        for (String fieldName : fieldNames) {
            this.conditionDependencyCrawl(originalConditionName, currentNode.get(fieldName), conditionDependencyManager, template, resourceReferences, unresolvedConditionDependencies);
        }
    }

    private void buildResourceMap(Template template, JsonNode templateJsonNode) throws CloudFormationException {
        JsonNode resourcesJsonNode = JsonHelper.checkObject(templateJsonNode, TemplateSection.Resources.toString());
        if (resourcesJsonNode == null || resourcesJsonNode.size() == 0) {
            throw new ValidationErrorException("At least one " + (Object)((Object)TemplateSection.Resources) + " member must be defined.");
        }
        ArrayList resourceKeys = Lists.newArrayList((Iterator)resourcesJsonNode.fieldNames());
        Map<String, String> pseudoParameterMap = template.getPseudoParameterMap();
        String accountId = JsonHelper.getJsonNodeFromString(pseudoParameterMap.get(AWS_ACCOUNT_ID)).asText();
        for (String resourceKey : resourceKeys) {
            JsonNode resourceJsonNode = resourcesJsonNode.get(resourceKey);
            if (!resourceJsonNode.isObject()) {
                throw new ValidationErrorException("Template format error: Any Resources member must be a JSON object.");
            }
            String type = JsonHelper.getString(resourceJsonNode, "Type");
            if (type == null) {
                throw new ValidationErrorException("Type is a required property of Resource");
            }
            ResourceInfo resourceInfo = new ResourceResolverManager().resolveResourceInfo(type);
            if (resourceInfo == null) {
                throw new ValidationErrorException("Unknown resource type " + type);
            }
            resourceInfo.setAccountId(accountId);
            template.getResourceInfoMap().put(resourceKey, resourceInfo);
        }
    }

    private void parseResources(Template template, JsonNode templateJsonNode, boolean onlyValidateTemplate) throws CloudFormationException {
        Map<String, Boolean> conditionMap = template.getConditionMap();
        Map<String, String> pseudoParameterMap = template.getPseudoParameterMap();
        Map<String, StackEntity.Parameter> parameterMap = template.getParameterMap();
        JsonNode resourcesJsonNode = JsonHelper.checkObject(templateJsonNode, TemplateSection.Resources.toString());
        ArrayList resourceKeys = Lists.newArrayList((Iterator)resourcesJsonNode.fieldNames());
        Sets.SetView commonParametersAndResources = Sets.intersection((Set)Sets.newHashSet((Iterable)resourceKeys), (Set)Sets.union(parameterMap.keySet(), pseudoParameterMap.keySet()));
        if (!commonParametersAndResources.isEmpty()) {
            throw new ValidationErrorException("Template error: all resources and parameters must have unique names. Common name(s):" + commonParametersAndResources);
        }
        DependencyManager resourceDependencies = new DependencyManager();
        if ((long)resourceKeys.size() > Limits.MAX_RESOURCES_PER_TEMPLATE) {
            throw new ValidationErrorException("Too many resources in the template.  Max allowed is " + Limits.MAX_RESOURCES_PER_TEMPLATE + ".");
        }
        for (String resourceKey : resourceKeys) {
            if (resourceKey != null && (long)resourceKey.length() > 255L) {
                throw new ValidationErrorException("Resource name " + resourceKey + " exceeds the maximum resource name length of " + 255L + " characters.");
            }
            if (!resourceKey.matches("^[\\p{Alnum}]*$")) {
                throw new ValidationErrorException("Resource name " + resourceKey + " must be alphanumeric.");
            }
            resourceDependencies.addNode(resourceKey);
        }
        LinkedHashSet unresolvedResourceDependencies = Sets.newLinkedHashSet();
        for (String resourceKey : resourceKeys) {
            String conditionKey;
            JsonNode propertiesNode;
            JsonNode resourceJsonNode = resourcesJsonNode.get(resourceKey);
            JsonNode dependsOnJsonNode = resourceJsonNode.get(ResourceKey.DependsOn.toString());
            if (dependsOnJsonNode != null) {
                FunctionEvaluation.validateNonConditionSectionArgTypesWherePossible(dependsOnJsonNode);
                if (dependsOnJsonNode.isArray()) {
                    for (int i = 0; i < dependsOnJsonNode.size(); ++i) {
                        if (dependsOnJsonNode.get(i) != null && dependsOnJsonNode.get(i).isValueNode()) {
                            String dependeningOnResourceName = dependsOnJsonNode.get(i).asText();
                            if (!template.getResourceInfoMap().containsKey(dependeningOnResourceName)) {
                                unresolvedResourceDependencies.add(dependeningOnResourceName);
                                continue;
                            }
                            resourceDependencies.addDependency(resourceKey, dependeningOnResourceName);
                            continue;
                        }
                        throw new ValidationErrorException("Template format error: Every DependsOn value must be a string.");
                    }
                } else if (dependsOnJsonNode.isValueNode()) {
                    String dependeningOnResourceName = dependsOnJsonNode.asText();
                    if (!template.getResourceInfoMap().containsKey(dependeningOnResourceName)) {
                        unresolvedResourceDependencies.add(dependeningOnResourceName);
                    } else {
                        resourceDependencies.addDependency(resourceKey, dependeningOnResourceName);
                    }
                } else {
                    throw new ValidationErrorException("Template format error: DependsOn must be a string or list of strings.");
                }
            }
            ResourceInfo resourceInfo = template.getResourceInfoMap().get(resourceKey);
            String description = JsonHelper.getString(resourceJsonNode, ResourceKey.Description.toString());
            if (description != null && description.length() > 4000) {
                throw new ValidationErrorException("Template format error: " + (Object)((Object)ResourceKey.Description) + " must be no " + "longer than 4000 characters.");
            }
            resourceInfo.setDescription(description);
            JsonNode metadataNode = JsonHelper.checkObject(resourceJsonNode, ResourceKey.Metadata.toString());
            if (metadataNode != null) {
                FunctionEvaluation.validateNonConditionSectionArgTypesWherePossible(metadataNode);
                resourceInfo.setMetadataJson(JsonHelper.getStringFromJsonNode(metadataNode));
            }
            if ((propertiesNode = JsonHelper.checkObject(resourceJsonNode, ResourceKey.Properties.toString())) != null) {
                FunctionEvaluation.validateNonConditionSectionArgTypesWherePossible(propertiesNode);
                resourceInfo.setPropertiesJson(JsonHelper.getStringFromJsonNode(propertiesNode));
            }
            JsonNode updatePolicyNode = JsonHelper.checkObject(resourceJsonNode, ResourceKey.UpdatePolicy.toString());
            if (propertiesNode != null) {
                FunctionEvaluation.validateNonConditionSectionArgTypesWherePossible(propertiesNode);
                resourceInfo.setUpdatePolicyJson(JsonHelper.getStringFromJsonNode(updatePolicyNode));
            }
            resourceInfo.setLogicalResourceId(resourceKey);
            this.resourceDependencyCrawl(resourceKey, metadataNode, resourceDependencies, template, unresolvedResourceDependencies, !onlyValidateTemplate);
            this.resourceDependencyCrawl(resourceKey, propertiesNode, resourceDependencies, template, unresolvedResourceDependencies, !onlyValidateTemplate);
            this.resourceDependencyCrawl(resourceKey, updatePolicyNode, resourceDependencies, template, unresolvedResourceDependencies, !onlyValidateTemplate);
            String deletionPolicy = JsonHelper.getString(resourceJsonNode, ResourceKey.DeletionPolicy.toString());
            if (deletionPolicy != null) {
                if (!(DeletionPolicyValues.Delete.toString().equals(deletionPolicy) || DeletionPolicyValues.Retain.toString().equals(deletionPolicy) || DeletionPolicyValues.Snapshot.toString().equals(deletionPolicy))) {
                    throw new ValidationErrorException("Template format error: Unrecognized DeletionPolicy " + deletionPolicy + " for resource " + resourceKey);
                }
                if (DeletionPolicyValues.Snapshot.toString().equals(deletionPolicy) && !resourceInfo.supportsSnapshot()) {
                    throw new ValidationErrorException("Template error: resource type " + resourceInfo.getType() + " does not support deletion policy Snapshot");
                }
                resourceInfo.setDeletionPolicy(deletionPolicy);
            }
            if ((conditionKey = JsonHelper.getString(resourceJsonNode, ResourceKey.Condition.toString())) != null) {
                if (!conditionMap.containsKey(conditionKey)) {
                    throw new ValidationErrorException("Template format error: Condition " + conditionKey + "  is not defined.");
                }
                resourceInfo.setAllowedByCondition(onlyValidateTemplate ? Boolean.TRUE : conditionMap.get(conditionKey));
                continue;
            }
            resourceInfo.setAllowedByCondition(Boolean.TRUE);
        }
        if (!unresolvedResourceDependencies.isEmpty()) {
            throw new ValidationErrorException("Template format error: Unresolved resource dependencies " + unresolvedResourceDependencies + " in the Resources block of the template");
        }
        try {
            resourceDependencies.dependencyList();
        }
        catch (CyclicDependencyException ex) {
            throw new ValidationErrorException("Circular dependency between resources: " + ex.getMessage());
        }
        template.setResourceDependencyManager(resourceDependencies);
    }

    private void resourceDependencyCrawl(String resourceKey, JsonNode jsonNode, DependencyManager resourceDependencies, Template template, Set<String> unresolvedResourceDependencies, boolean onLiveBranch) throws CloudFormationException {
        IntrinsicFunction.MatchResult fnIfMatcher;
        Map<String, String> pseudoParameterMap = template.getPseudoParameterMap();
        Map<String, StackEntity.Parameter> parameterMap = template.getParameterMap();
        if (jsonNode == null) {
            return;
        }
        if (jsonNode.isArray()) {
            for (int i = 0; i < jsonNode.size(); ++i) {
                this.resourceDependencyCrawl(resourceKey, jsonNode.get(i), resourceDependencies, template, unresolvedResourceDependencies, onLiveBranch);
            }
        }
        if ((fnIfMatcher = IntrinsicFunctions.IF.evaluateMatch(jsonNode)).isMatch()) {
            IntrinsicFunctions.IF.validateArgTypesWherePossible(fnIfMatcher);
            JsonNode keyJsonNode = jsonNode.get("Fn::If");
            String key = keyJsonNode.get(0).asText();
            Map<String, Boolean> conditionMap = template.getConditionMap();
            if (!conditionMap.containsKey(key)) {
                throw new ValidationErrorException("Template error: unresolved condition dependency: " + key);
            }
            boolean booleanValue = template.getConditionMap().get(key);
            this.resourceDependencyCrawl(resourceKey, keyJsonNode.get(1), resourceDependencies, template, unresolvedResourceDependencies, onLiveBranch && booleanValue);
            this.resourceDependencyCrawl(resourceKey, keyJsonNode.get(2), resourceDependencies, template, unresolvedResourceDependencies, onLiveBranch && !booleanValue);
            return;
        }
        IntrinsicFunction.MatchResult refMatcher = IntrinsicFunctions.REF.evaluateMatch(jsonNode);
        if (refMatcher.isMatch()) {
            IntrinsicFunctions.REF.validateArgTypesWherePossible(refMatcher);
            String refName = jsonNode.get("Ref").asText();
            if (template.getResourceInfoMap().containsKey(refName)) {
                if (onLiveBranch) {
                    resourceDependencies.addDependency(resourceKey, refName);
                }
            } else if (!parameterMap.containsKey(refName) && !pseudoParameterMap.containsKey(refName)) {
                unresolvedResourceDependencies.add(refName);
            }
            return;
        }
        IntrinsicFunction.MatchResult fnAttMatcher = IntrinsicFunctions.GET_ATT.evaluateMatch(jsonNode);
        if (fnAttMatcher.isMatch()) {
            IntrinsicFunctions.GET_ATT.validateArgTypesWherePossible(fnAttMatcher);
            String refName = jsonNode.get("Fn::GetAtt").get(0).asText();
            String attName = jsonNode.get("Fn::GetAtt").get(1).asText();
            if (template.getResourceInfoMap().containsKey(refName)) {
                ResourceInfo resourceInfo = template.getResourceInfoMap().get(refName);
                if (!resourceInfo.isAttributeAllowed(attName)) {
                    throw new ValidationErrorException("Template error: resource " + refName + " does not support attribute type " + attName + " in Fn::GetAtt");
                }
                if (onLiveBranch) {
                    resourceDependencies.addDependency(resourceKey, refName);
                }
            } else {
                throw new ValidationErrorException("Template error: instance of Fn::GetAtt references undefined resource " + refName);
            }
            return;
        }
        ArrayList fieldNames = Lists.newArrayList((Iterator)jsonNode.fieldNames());
        for (String fieldName : fieldNames) {
            this.resourceDependencyCrawl(resourceKey, jsonNode.get(fieldName), resourceDependencies, template, unresolvedResourceDependencies, onLiveBranch);
        }
    }

    private void parseOutputs(Template template, JsonNode templateJsonNode) throws CloudFormationException {
        Map<String, Boolean> conditionMap = template.getConditionMap();
        ArrayList<StackEntity.Output> outputs = template.getOutputs();
        JsonNode outputsJsonNode = JsonHelper.checkObject(templateJsonNode, TemplateSection.Outputs.toString());
        if (outputsJsonNode != null) {
            ArrayList unresolvedResourceDependencies = Lists.newArrayList();
            ArrayList outputKeys = Lists.newArrayList((Iterator)outputsJsonNode.fieldNames());
            for (String outputKey : outputKeys) {
                if ((long)outputKey.length() > 255L) {
                    throw new ValidationErrorException("Output " + outputKey + " name exceeds the maximum length of " + 255L + " characters");
                }
                JsonNode outputJsonNode = outputsJsonNode.get(outputKey);
                this.validateValidResourcesInOutputs(outputKey, outputJsonNode, template, unresolvedResourceDependencies);
                HashSet tempOutputKeys = Sets.newHashSet((Iterator)outputJsonNode.fieldNames());
                for (OutputKey validOutputKey : OutputKey.values()) {
                    tempOutputKeys.remove(validOutputKey.toString());
                }
                if (!tempOutputKeys.isEmpty()) {
                    throw new ValidationErrorException("Invalid output property or properties " + tempOutputKeys);
                }
                String description = JsonHelper.getString(outputsJsonNode.get(outputKey), OutputKey.Description.toString());
                if (description != null && description.length() > 4000) {
                    throw new ValidationErrorException("Template format error: " + (Object)((Object)OutputKey.Description) + " must be no " + "longer than 4000 characters.");
                }
                String conditionKey = JsonHelper.getString(outputJsonNode, OutputKey.Condition.toString());
                if (conditionKey != null && !conditionMap.containsKey(conditionKey)) {
                    throw new ValidationErrorException("Template format error: Condition " + conditionKey + "  is not defined.");
                }
                if (!outputJsonNode.has(OutputKey.Value.toString())) {
                    throw new ValidationErrorException("Every Outputs member must contain a Value object");
                }
                FunctionEvaluation.validateNonConditionSectionArgTypesWherePossible(outputsJsonNode.get(outputKey));
                StackEntity.Output output = new StackEntity.Output();
                output.setKey(outputKey);
                JsonNode outputValueNode = outputJsonNode.get(OutputKey.Value.toString());
                boolean match = false;
                for (IntrinsicFunctions intrinsicFunction : IntrinsicFunctions.values()) {
                    IntrinsicFunction.MatchResult matchResult = intrinsicFunction.evaluateMatch(outputValueNode);
                    if (!matchResult.isMatch()) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    if (outputValueNode.isObject()) {
                        throw new ValidationErrorException("The Value field of every Outputs member must evaluate to a String and not a Map.");
                    }
                    if (outputValueNode.isArray()) {
                        throw new ValidationErrorException("The Value field of every Outputs member must evaluate to a String and not a List.");
                    }
                }
                output.setJsonValue(JsonHelper.getStringFromJsonNode(outputJsonNode.get(OutputKey.Value.toString())));
                output.setReady(false);
                output.setAllowedByCondition(conditionMap.get(conditionKey) != Boolean.FALSE);
                outputs.add(output);
            }
            if (!unresolvedResourceDependencies.isEmpty()) {
                throw new ValidationErrorException("Template format error: Unresolved resource dependencies " + unresolvedResourceDependencies + " in the Outputs block of the template");
            }
            if ((long)outputs.size() > Limits.MAX_OUTPUTS_PER_TEMPLATE) {
                throw new ValidationErrorException("Stack exceeds the maximum allowed number of outputs.(" + Limits.MAX_OUTPUTS_PER_TEMPLATE + ")");
            }
            template.setOutputs(outputs);
        }
    }

    private void validateValidResourcesInOutputs(String outputKey, JsonNode jsonNode, Template template, List<String> unresolvedResourceDependencies) throws CloudFormationException {
        Map<String, String> pseudoParameterMap = template.getPseudoParameterMap();
        Map<String, StackEntity.Parameter> parameterMap = template.getParameterMap();
        Map<String, ResourceInfo> resourceInfoMap = template.getResourceInfoMap();
        if (jsonNode == null) {
            return;
        }
        if (jsonNode.isArray()) {
            for (int i = 0; i < jsonNode.size(); ++i) {
                this.validateValidResourcesInOutputs(outputKey, jsonNode.get(i), template, unresolvedResourceDependencies);
            }
        }
        IntrinsicFunction.MatchResult fnIfMatcher = IntrinsicFunctions.IF.evaluateMatch(jsonNode);
        IntrinsicFunction.MatchResult refMatcher = IntrinsicFunctions.REF.evaluateMatch(jsonNode);
        if (refMatcher.isMatch()) {
            IntrinsicFunctions.REF.validateArgTypesWherePossible(refMatcher);
            String refName = jsonNode.get("Ref").asText();
            if (!(parameterMap.containsKey(refName) || pseudoParameterMap.containsKey(refName) || resourceInfoMap.containsKey(refName))) {
                unresolvedResourceDependencies.add(refName);
            }
            return;
        }
        IntrinsicFunction.MatchResult fnAttMatcher = IntrinsicFunctions.GET_ATT.evaluateMatch(jsonNode);
        if (fnAttMatcher.isMatch()) {
            IntrinsicFunctions.GET_ATT.validateArgTypesWherePossible(fnAttMatcher);
            String refName = jsonNode.get("Fn::GetAtt").get(0).asText();
            String attName = jsonNode.get("Fn::GetAtt").get(1).asText();
            if (resourceInfoMap.containsKey(refName)) {
                ResourceInfo resourceInfo = resourceInfoMap.get(refName);
                if (!resourceInfo.isAttributeAllowed(attName)) {
                    throw new ValidationErrorException("Template error: resource " + refName + " does not support attribute type " + attName + " in Fn::GetAtt");
                }
            } else {
                throw new ValidationErrorException("Template error: instance of Fn::GetAtt references undefined resource " + refName);
            }
            return;
        }
        ArrayList fieldNames = Lists.newArrayList((Iterator)jsonNode.fieldNames());
        for (String fieldName : fieldNames) {
            this.validateValidResourcesInOutputs(outputKey, jsonNode.get(fieldName), template, unresolvedResourceDependencies);
        }
    }

    static class ParameterParser {
        ParameterParser() {
        }

        static void parseParameters(Template template, JsonNode templateJsonNode, List<com.eucalyptus.cloudformation.Parameter> userParameters, boolean onlyEvaluateTemplate) throws CloudFormationException {
            JsonNode parametersJsonNode = JsonHelper.checkObject(templateJsonNode, TemplateSection.Parameters.toString());
            if (parametersJsonNode != null) {
                HashMap userParameterMap = Maps.newHashMap();
                if (userParameters != null) {
                    for (com.eucalyptus.cloudformation.Parameter userParameter : userParameters) {
                        userParameterMap.put(userParameter.getParameterKey(), userParameter.getParameterValue());
                    }
                }
                ArrayList parameterList = Lists.newArrayList();
                for (String parameterKey : Lists.newArrayList((Iterator)parametersJsonNode.fieldNames())) {
                    JsonNode parameterJsonNode = JsonHelper.checkObject(parametersJsonNode, parameterKey, "Any " + (Object)((Object)TemplateSection.Parameters) + " member must be a JSON object.");
                    Parameter parameter = ParameterParser.parseParameter(parameterKey, parameterJsonNode, userParameterMap);
                    parameterList.add(parameter);
                }
                ArrayList noValueParameters = Lists.newArrayList();
                if ((long)parameterList.size() > Limits.MAX_PARAMETERS_PER_TEMPLATE) {
                    throw new ValidationErrorException("Too many parameters in the template.  Max of " + Limits.MAX_PARAMETERS_PER_TEMPLATE + " allowed.");
                }
                for (Parameter parameter : parameterList) {
                    if ((long)parameter.getParameter().getKey().length() > 255L) {
                        throw new ValidationErrorException("Parameter " + parameter.getParameter().getKey() + " exceeds the maximum parameter name length of " + 255L + " characters.");
                    }
                    if (parameter.getParameter().getStringValue() != null && (long)parameter.getParameter().getStringValue().getBytes().length > 4096L) {
                        throw new ValidationErrorException("Parameter " + parameter.getParameter().getKey() + " exceeds the maximum parameter value length of " + 4096L + " bytes.");
                    }
                    template.getParameters().add(parameter.getParameter());
                    template.getTemplateParameters().add(parameter.getTemplateParameter());
                    if (parameter.getParameter().getStringValue() != null) continue;
                    noValueParameters.add(parameter.getParameter().getKey());
                }
                if (!noValueParameters.isEmpty() && !onlyEvaluateTemplate) {
                    throw new ValidationErrorException("Parameters: " + noValueParameters + " must have values");
                }
                HashSet userParamKeys = Sets.newHashSet();
                HashSet templateParamKeys = Sets.newHashSet();
                if (userParameterMap != null) {
                    userParamKeys.addAll(userParameterMap.keySet());
                }
                if (parametersJsonNode != null) {
                    templateParamKeys.addAll(Sets.newHashSet((Iterator)parametersJsonNode.fieldNames()));
                }
                userParamKeys.removeAll(templateParamKeys);
                if (!userParamKeys.isEmpty()) {
                    throw new ValidationErrorException("Parameters: " + userParamKeys + " do not exist in the template");
                }
            }
        }

        private static Parameter parseParameter(String parameterName, JsonNode parameterJsonNode, Map<String, String> userParameterMap) throws CloudFormationException {
            ParameterParser.validateParameterKeys(parameterJsonNode);
            ParameterType type = ParameterParser.parseType(parameterJsonNode);
            String[] allowedValues = ParameterParser.parseAllowedValues(parameterJsonNode);
            String allowedPattern = ParameterParser.parseAllowedPattern(parameterName, parameterJsonNode, type);
            String constraintDescription = ParameterParser.parseConstraintDescription(parameterName, parameterJsonNode);
            String description = ParameterParser.parseDescription(parameterName, parameterJsonNode);
            Double maxLength = ParameterParser.parseMaxLength(parameterName, parameterJsonNode, type);
            Double minLength = ParameterParser.parseMinLength(parameterName, parameterJsonNode, type);
            if (maxLength != null && minLength != null && maxLength < minLength) {
                throw new ValidationErrorException("Template error: Parameter '" + parameterName + "' " + (Object)((Object)ParameterKey.MinLength) + " must be less than " + (Object)((Object)ParameterKey.MaxLength) + ".");
            }
            Double maxValue = ParameterParser.parseMaxValue(parameterName, parameterJsonNode, type);
            Double minValue = ParameterParser.parseMinValue(parameterName, parameterJsonNode, type);
            if (maxValue != null && minValue != null && maxValue < minValue) {
                throw new ValidationErrorException("Template error: Parameter '" + parameterName + "' " + (Object)((Object)ParameterKey.MinValue) + " must be less than " + (Object)((Object)ParameterKey.MaxValue) + ".");
            }
            String defaultValue = JsonHelper.getString(parameterJsonNode, ParameterKey.Default.toString());
            String userDefinedValue = userParameterMap.get(parameterName);
            boolean noEcho = "true".equalsIgnoreCase(JsonHelper.getString(parameterJsonNode, ParameterKey.NoEcho.toString()));
            block10: for (String value : Lists.newArrayList((Object[])new String[]{defaultValue, userDefinedValue})) {
                if (value != null) {
                    ParameterParser.checkAllowedValues(parameterName, value, allowedValues, constraintDescription);
                }
                switch (type) {
                    case String: {
                        if (value == null) continue block10;
                        ParameterParser.parseStringParameter(parameterName, value, allowedPattern, minLength, maxLength, constraintDescription);
                        continue block10;
                    }
                    case Number: {
                        if (value == null) continue block10;
                        ParameterParser.parseNumberParameter(parameterName, value, minValue, maxValue, constraintDescription);
                        continue block10;
                    }
                    case CommaDelimitedList: {
                        continue block10;
                    }
                }
                throw new ValidationErrorException("Template format error: Unrecognized parameter type: " + (Object)((Object)type));
            }
            String stringValue = null;
            if (defaultValue != null) {
                stringValue = defaultValue;
            }
            if (userDefinedValue != null) {
                stringValue = userDefinedValue;
            }
            TextNode jsonValueNode = null;
            if (stringValue != null) {
                switch (type) {
                    case String: {
                        jsonValueNode = new TextNode(stringValue);
                        break;
                    }
                    case Number: {
                        jsonValueNode = new TextNode(stringValue);
                        break;
                    }
                    case CommaDelimitedList: {
                        ArrayNode arrayNode = new ObjectMapper().createArrayNode();
                        StringTokenizer stok = new StringTokenizer(stringValue, ",");
                        while (stok.hasMoreTokens()) {
                            arrayNode.add(stok.nextToken());
                        }
                        jsonValueNode = arrayNode;
                        break;
                    }
                    default: {
                        throw new ValidationErrorException("Template format error: Unrecognized parameter type: " + (Object)((Object)type));
                    }
                }
            }
            StackEntity.Parameter parameter = new StackEntity.Parameter();
            parameter.setKey(parameterName);
            parameter.setNoEcho(noEcho);
            parameter.setJsonValue(JsonHelper.getStringFromJsonNode((JsonNode)jsonValueNode));
            parameter.setStringValue(stringValue);
            TemplateParameter templateParameter = new TemplateParameter();
            templateParameter.setDescription(description);
            templateParameter.setDefaultValue(defaultValue);
            templateParameter.setNoEcho(Boolean.valueOf(noEcho));
            templateParameter.setParameterKey(parameterName);
            return new Parameter(parameter, templateParameter);
        }

        private static void parseNumberParameter(String parameterName, String value, Double minValue, Double maxValue, String constraintDescription) throws ValidationErrorException {
            String constraintErrorMessage = null;
            Double valueDouble = null;
            try {
                valueDouble = Double.parseDouble(value);
            }
            catch (NumberFormatException ex) {
                constraintErrorMessage = "Template error: Parameter '" + parameterName + "' must be a number";
            }
            if (constraintErrorMessage == null && minValue != null && minValue > valueDouble) {
                constraintErrorMessage = "Template error: Parameter '" + parameterName + "' must be a number not less than " + minValue;
            }
            if (constraintErrorMessage == null && maxValue != null && maxValue < valueDouble) {
                constraintErrorMessage = "Template error: Parameter '" + parameterName + "' must be a number not greater than " + maxValue;
            }
            if (constraintErrorMessage != null && constraintDescription != null) {
                constraintErrorMessage = "Parameter '" + parameterName + "' failed to satisfy constraint: " + constraintDescription;
            }
            if (constraintErrorMessage != null) {
                throw new ValidationErrorException(constraintErrorMessage);
            }
        }

        private static void parseStringParameter(String parameterName, String value, String allowedPattern, Double minLength, Double maxLength, String constraintDescription) throws ValidationErrorException {
            String constraintErrorMessage = null;
            if (minLength != null && minLength > (double)value.length()) {
                constraintErrorMessage = "Template error: Parameter '" + parameterName + "' must contain at least " + minLength + " characters";
            }
            if (constraintErrorMessage == null && maxLength != null && maxLength < (double)value.length()) {
                constraintErrorMessage = "Template error: Parameter '" + parameterName + "' must contain at most " + maxLength + " characters";
            }
            if (constraintErrorMessage == null && allowedPattern != null) {
                try {
                    if (!value.matches(allowedPattern)) {
                        constraintErrorMessage = "Template error: Parameter '" + parameterName + "' must match pattern " + allowedPattern;
                    }
                }
                catch (PatternSyntaxException ex) {
                    throw new ValidationErrorException("Parameter '" + parameterName + "' " + (Object)((Object)ParameterKey.AllowedPattern) + " must be a valid regular expression.");
                }
            }
            if (constraintErrorMessage != null && constraintDescription != null) {
                constraintErrorMessage = "Parameter '" + parameterName + "' failed to satisfy constraint: " + constraintDescription;
            }
            if (constraintErrorMessage != null) {
                throw new ValidationErrorException(constraintErrorMessage);
            }
        }

        private static void checkAllowedValues(String parameterName, String value, String[] allowedValues, String constraintDescription) throws ValidationErrorException {
            if (allowedValues != null && !Arrays.asList(allowedValues).contains(value)) {
                String constraintErrorMessage = "Template error: Parameter '" + parameterName + "' must be one of " + (Object)((Object)ParameterKey.AllowedValues);
                if (constraintDescription != null) {
                    constraintErrorMessage = "Parameter '" + parameterName + "' failed to satisfy constraint: " + constraintDescription;
                }
                throw new ValidationErrorException(constraintErrorMessage);
            }
        }

        private static Double parseMinValue(String parameterName, JsonNode parameterJsonNode, ParameterType type) throws CloudFormationException {
            Double minValue = JsonHelper.getDouble(parameterJsonNode, ParameterKey.MinValue.toString());
            ParameterParser.checkParameterType(minValue, parameterName, ParameterKey.MinValue, type, ParameterType.Number);
            return minValue;
        }

        private static Double parseMaxValue(String parameterName, JsonNode parameterJsonNode, ParameterType type) throws CloudFormationException {
            Double maxValue = JsonHelper.getDouble(parameterJsonNode, ParameterKey.MaxValue.toString());
            ParameterParser.checkParameterType(maxValue, parameterName, ParameterKey.MaxValue, type, ParameterType.Number);
            return maxValue;
        }

        private static Double parseMinLength(String parameterName, JsonNode parameterJsonNode, ParameterType type) throws CloudFormationException {
            Double minLength = JsonHelper.getDouble(parameterJsonNode, ParameterKey.MinLength.toString());
            ParameterParser.checkParameterType(minLength, parameterName, ParameterKey.MinLength, type, ParameterType.String);
            return minLength;
        }

        private static Double parseMaxLength(String parameterName, JsonNode parameterJsonNode, ParameterType type) throws CloudFormationException {
            Double maxLength = JsonHelper.getDouble(parameterJsonNode, ParameterKey.MaxLength.toString());
            ParameterParser.checkParameterType(maxLength, parameterName, ParameterKey.MaxLength, type, ParameterType.String);
            return maxLength;
        }

        private static String parseConstraintDescription(String parameterName, JsonNode parameterJsonNode) throws CloudFormationException {
            String constraintDescription = JsonHelper.getString(parameterJsonNode, ParameterKey.ConstraintDescription.toString());
            return constraintDescription;
        }

        private static String parseDescription(String parameterName, JsonNode parameterJsonNode) throws CloudFormationException {
            String description = JsonHelper.getString(parameterJsonNode, ParameterKey.Description.toString());
            return description;
        }

        private static String parseAllowedPattern(String parameterName, JsonNode parameterJsonNode, ParameterType type) throws CloudFormationException {
            String allowedPattern = JsonHelper.getString(parameterJsonNode, ParameterKey.AllowedPattern.toString());
            ParameterParser.checkParameterType(allowedPattern, parameterName, ParameterKey.AllowedPattern, type, ParameterType.String);
            return allowedPattern;
        }

        private static void checkParameterType(Object value, String name, ParameterKey key, ParameterType valueType, ParameterType requiredType) throws ValidationErrorException {
            if (value != null && valueType != requiredType) {
                throw new ValidationErrorException("Template error: Parameter '" + name + "' " + (Object)((Object)key) + " must be on a parameter of type " + (Object)((Object)requiredType));
            }
        }

        private static void validateParameterKeys(JsonNode parameterJsonNode) throws ValidationErrorException {
            HashSet tempParameterKeys = Sets.newHashSet((Iterator)parameterJsonNode.fieldNames());
            for (ParameterKey validParameterKey : ParameterKey.values()) {
                tempParameterKeys.remove(validParameterKey.toString());
            }
            if (!tempParameterKeys.isEmpty()) {
                throw new ValidationErrorException("Invalid template parameter property or properties " + tempParameterKeys);
            }
        }

        private static String[] parseAllowedValues(JsonNode parameterJsonNode) throws CloudFormationException {
            String[] allowedValues = null;
            JsonNode allowedValuesJsonNode = JsonHelper.checkArray(parameterJsonNode, ParameterKey.AllowedValues.toString());
            if (allowedValuesJsonNode != null) {
                allowedValues = new String[allowedValuesJsonNode.size()];
                for (int index = 0; index < allowedValues.length; ++index) {
                    String errorMsg = "Every " + (Object)((Object)ParameterKey.AllowedValues) + "value must be a string.";
                    String allowedValue = JsonHelper.getString(allowedValuesJsonNode, index, errorMsg);
                    if (allowedValue == null) {
                        throw new ValidationErrorException("Template format error: " + errorMsg);
                    }
                    allowedValues[index] = allowedValue;
                }
            }
            return allowedValues;
        }

        private static ParameterType parseType(JsonNode parameterJsonNode) throws CloudFormationException {
            String typeStr = JsonHelper.getString(parameterJsonNode, ParameterKey.Type.toString());
            if (typeStr == null) {
                throw new ValidationErrorException("Template format error: Every " + (Object)((Object)TemplateSection.Parameters) + " object " + "must contain a " + (Object)((Object)ParameterKey.Type) + " member.");
            }
            ParameterType type = null;
            try {
                type = ParameterType.valueOf(typeStr);
            }
            catch (IllegalArgumentException ex) {
                throw new ValidationErrorException("Template format error: Unrecognized parameter type: " + typeStr + ".  Valid values are " + Arrays.toString((Object[])ParameterType.values()));
            }
            return type;
        }

        private static class Parameter {
            private StackEntity.Parameter stackEntityParameter;
            private TemplateParameter templateParameter;

            private Parameter(StackEntity.Parameter stackEntityParameter, TemplateParameter templateParameter) {
                this.stackEntityParameter = stackEntityParameter;
                this.templateParameter = templateParameter;
            }

            StackEntity.Parameter getParameter() {
                return this.stackEntityParameter;
            }

            TemplateParameter getTemplateParameter() {
                return this.templateParameter;
            }
        }
    }

    private static enum OutputKey {
        Description,
        Condition,
        Value;

    }

    private static enum DeletionPolicyValues {
        Delete,
        Retain,
        Snapshot;

    }

    private static enum ResourceKey {
        Properties,
        DeletionPolicy,
        Description,
        DependsOn,
        Metadata,
        UpdatePolicy,
        Condition;

    }

    private static enum ParameterKey {
        Type,
        Default,
        NoEcho,
        AllowedValues,
        AllowedPattern,
        MaxLength,
        MinLength,
        MaxValue,
        MinValue,
        Description,
        ConstraintDescription;

    }

    private static enum TemplateSection {
        AWSTemplateFormatVersion,
        Description,
        Parameters,
        Mappings,
        Conditions,
        Resources,
        Outputs;

    }

    private static enum ParameterType {
        String,
        Number,
        CommaDelimitedList;

    }
}

