/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.template;

import com.eucalyptus.cloudformation.CloudFormationException;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class JsonHelper {
    public static JsonNode checkObject(JsonNode parent, String key, String errorMsg) throws CloudFormationException {
        JsonNode jsonNode = parent.get(key);
        if (jsonNode != null && !jsonNode.isObject()) {
            throw JsonHelper.error(errorMsg);
        }
        return jsonNode;
    }

    public static JsonNode checkObject(JsonNode parent, String key) throws CloudFormationException {
        return JsonHelper.checkObject(parent, key, JsonHelper.errorMsg(key, "JSON object"));
    }

    public static JsonNode checkArray(JsonNode parent, String key, String errorMsg) throws CloudFormationException {
        JsonNode jsonNode = parent.get(key);
        if (jsonNode != null && !jsonNode.isArray()) {
            throw JsonHelper.error(errorMsg);
        }
        return jsonNode;
    }

    public static JsonNode checkArray(JsonNode parent, String key) throws CloudFormationException {
        return JsonHelper.checkArray(parent, key, JsonHelper.errorMsg(key, "list"));
    }

    public static JsonNode checkString(JsonNode parent, String key, String errorMsg) throws CloudFormationException {
        JsonNode jsonNode = parent.get(key);
        if (jsonNode != null && !jsonNode.isValueNode()) {
            throw JsonHelper.error(errorMsg);
        }
        return jsonNode;
    }

    public static JsonNode checkString(JsonNode parent, int index, String errorMsg) throws CloudFormationException {
        JsonNode jsonNode = parent.get(index);
        if (jsonNode != null && !jsonNode.isValueNode()) {
            throw JsonHelper.error(errorMsg);
        }
        return jsonNode;
    }

    public static JsonNode checkString(JsonNode parent, String key) throws CloudFormationException {
        return JsonHelper.checkString(parent, key, JsonHelper.errorMsg(key, "string"));
    }

    public static String getString(JsonNode parent, String key, String errorMsg) throws CloudFormationException {
        return JsonHelper.getString(JsonHelper.checkString(parent, key, errorMsg));
    }

    public static String getString(JsonNode parent, int index, String errorMsg) throws CloudFormationException {
        return JsonHelper.getString(JsonHelper.checkString(parent, index, errorMsg));
    }

    public static String getString(JsonNode parent, String key) throws CloudFormationException {
        return JsonHelper.getString(JsonHelper.checkString(parent, key));
    }

    public static Double getDouble(JsonNode parent, String key, String errorMsg) throws CloudFormationException {
        return JsonHelper.getDouble(JsonHelper.checkDouble(parent, key, errorMsg));
    }

    public static Double getDouble(JsonNode parent, String key) throws CloudFormationException {
        return JsonHelper.getDouble(JsonHelper.checkDouble(parent, key));
    }

    private static String getString(JsonNode node) {
        return node == null ? null : node.asText();
    }

    private static Double getDouble(JsonNode node) {
        return node == null ? null : Double.valueOf(Double.parseDouble(node.asText()));
    }

    public static JsonNode checkDouble(JsonNode parent, String key, String errorMsg) throws CloudFormationException {
        JsonNode jsonNode = JsonHelper.checkString(parent, key, errorMsg);
        try {
            if (jsonNode != null) {
                Double.parseDouble(jsonNode.asText());
            }
        }
        catch (NullPointerException | NumberFormatException ex) {
            throw JsonHelper.error(errorMsg);
        }
        return jsonNode;
    }

    public static JsonNode checkDouble(JsonNode parent, String key) throws CloudFormationException {
        JsonNode jsonNode = parent.get(key);
        if (jsonNode != null && !jsonNode.isValueNode()) {
            throw JsonHelper.error(JsonHelper.errorMsg(key, "number"));
        }
        try {
            if (jsonNode != null) {
                Double.parseDouble(jsonNode.asText());
            }
        }
        catch (NumberFormatException ex) {
            throw JsonHelper.error(JsonHelper.errorMsg(key, "number (" + jsonNode.asText() + ")"));
        }
        return jsonNode;
    }

    public static JsonNode checkStringOrArray(JsonNode parent, String key, String errorMsg) throws CloudFormationException {
        JsonNode jsonNode = parent.get(key);
        if (jsonNode != null && !jsonNode.isValueNode() && !jsonNode.isArray()) {
            throw JsonHelper.error(errorMsg);
        }
        return jsonNode;
    }

    public static JsonNode checkStringOrArray(JsonNode parent, String key) throws CloudFormationException {
        return JsonHelper.checkStringOrArray(parent, key, JsonHelper.errorMsg(key, "String or a List"));
    }

    private static String errorMsg(String key, String valueType) {
        return "Every " + key + " member must be a " + valueType;
    }

    private static ValidationErrorException error(String errorMsg) {
        return new ValidationErrorException("Template format error: " + errorMsg);
    }

    public static JsonNode getJsonNodeFromString(String json) throws ValidationErrorException {
        if (json == null) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.readTree(json);
        }
        catch (IOException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    public static String getStringFromJsonNode(JsonNode jsonNode) {
        return jsonNode == null || jsonNode.isValueNode() && jsonNode.asText() == null ? null : jsonNode.toString();
    }
}

