/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.template;

import com.eucalyptus.cloudformation.CloudFormationException;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.entity.StackEntity;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.template.FunctionEvaluation;
import com.eucalyptus.cloudformation.template.IntrinsicFunction;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.template.Template;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bouncycastle.util.encoders.Base64;

public enum IntrinsicFunctions implements IntrinsicFunction
{
    NO_VALUE{

        @Override
        public IntrinsicFunction.MatchResult evaluateMatch(JsonNode jsonNode) {
            boolean match = jsonNode != null && jsonNode.isObject() && jsonNode.size() == 1 && jsonNode.has("Ref") && jsonNode.get("Ref") != null && jsonNode.get("Ref").isValueNode() && "AWS::NoValue".equals(jsonNode.get("Ref").asText());
            return new IntrinsicFunction.MatchResult(match, jsonNode, this);
        }

        @Override
        public IntrinsicFunction.ValidateResult validateArgTypesWherePossible(IntrinsicFunction.MatchResult matchResult) throws CloudFormationException {
            this.checkState(matchResult, (IntrinsicFunction)this);
            return new IntrinsicFunction.ValidateResult(matchResult.getJsonNode(), this);
        }

        @Override
        public JsonNode evaluateFunction(IntrinsicFunction.ValidateResult validateResult, Template template) throws CloudFormationException {
            this.checkState(validateResult, (IntrinsicFunction)this);
            return validateResult.getJsonNode();
        }

        @Override
        public boolean isBooleanFunction() {
            return false;
        }
    }
    ,
    REF{

        @Override
        public IntrinsicFunction.MatchResult evaluateMatch(JsonNode jsonNode) {
            boolean match = jsonNode != null && jsonNode.isObject() && jsonNode.size() == 1 && jsonNode.has("Ref");
            return new IntrinsicFunction.MatchResult(match, jsonNode, this);
        }

        @Override
        public IntrinsicFunction.ValidateResult validateArgTypesWherePossible(IntrinsicFunction.MatchResult matchResult) throws CloudFormationException {
            this.checkState(matchResult, (IntrinsicFunction)this);
            JsonNode keyJsonNode = matchResult.getJsonNode().get("Ref");
            if (keyJsonNode == null || !keyJsonNode.isValueNode()) {
                throw new ValidationErrorException("Template error: All References must be of type string");
            }
            return new IntrinsicFunction.ValidateResult(matchResult.getJsonNode(), this);
        }

        @Override
        public JsonNode evaluateFunction(IntrinsicFunction.ValidateResult validateResult, Template template) throws CloudFormationException {
            this.checkState(validateResult, (IntrinsicFunction)this);
            JsonNode keyJsonNode = validateResult.getJsonNode().get("Ref");
            String key = keyJsonNode.asText();
            Map<String, String> pseudoParameterMap = template.getPseudoParameterMap();
            Map<String, StackEntity.Parameter> parameterMap = template.getParameterMap();
            if (pseudoParameterMap.containsKey(key)) {
                return JsonHelper.getJsonNodeFromString(pseudoParameterMap.get(key));
            }
            if (parameterMap.containsKey(key)) {
                return JsonHelper.getJsonNodeFromString(parameterMap.get(key).getJsonValue());
            }
            if (template.getResourceInfoMap().containsKey(key)) {
                ResourceInfo resourceInfo = template.getResourceInfoMap().get(key);
                if (!resourceInfo.getReady().booleanValue()) {
                    throw new ValidationErrorException("Template error: reference " + key + " not ready");
                }
                return JsonHelper.getJsonNodeFromString(resourceInfo.getReferenceValueJson());
            }
            throw new ValidationErrorException("Template error: unresolved resource dependency: " + key);
        }

        @Override
        public boolean isBooleanFunction() {
            return false;
        }
    }
    ,
    CONDITION{

        @Override
        public IntrinsicFunction.MatchResult evaluateMatch(JsonNode jsonNode) {
            boolean match = jsonNode != null && jsonNode.isObject() && jsonNode.size() == 1 && jsonNode.has("Condition");
            return new IntrinsicFunction.MatchResult(match, jsonNode, this);
        }

        @Override
        public IntrinsicFunction.ValidateResult validateArgTypesWherePossible(IntrinsicFunction.MatchResult matchResult) throws CloudFormationException {
            this.checkState(matchResult, (IntrinsicFunction)this);
            JsonNode keyJsonNode = matchResult.getJsonNode().get("Condition");
            if (keyJsonNode == null || !keyJsonNode.isValueNode()) {
                throw new ValidationErrorException("Template error: All Conditions must be of type string");
            }
            return new IntrinsicFunction.ValidateResult(matchResult.getJsonNode(), this);
        }

        @Override
        public JsonNode evaluateFunction(IntrinsicFunction.ValidateResult validateResult, Template template) throws CloudFormationException {
            this.checkState(validateResult, (IntrinsicFunction)this);
            JsonNode keyJsonNode = validateResult.getJsonNode().get("Condition");
            String key = keyJsonNode.asText();
            Map<String, Boolean> conditionMap = template.getConditionMap();
            if (!conditionMap.containsKey(key)) {
                throw new ValidationErrorException("Template error: unresolved condition dependency: " + key);
            }
            return new TextNode(String.valueOf(conditionMap.get(key)));
        }

        @Override
        public boolean isBooleanFunction() {
            return true;
        }
    }
    ,
    IF{

        @Override
        public IntrinsicFunction.MatchResult evaluateMatch(JsonNode jsonNode) {
            boolean match = jsonNode != null && jsonNode.isObject() && jsonNode.size() == 1 && jsonNode.has("Fn::If");
            return new IntrinsicFunction.MatchResult(match, jsonNode, this);
        }

        @Override
        public IntrinsicFunction.ValidateResult validateArgTypesWherePossible(IntrinsicFunction.MatchResult matchResult) throws CloudFormationException {
            this.checkState(matchResult, (IntrinsicFunction)this);
            JsonNode keyJsonNode = matchResult.getJsonNode().get("Fn::If");
            if (keyJsonNode == null || !keyJsonNode.isArray() || keyJsonNode.size() < 1 || keyJsonNode.get(0) == null || !keyJsonNode.get(0).isValueNode()) {
                throw new ValidationErrorException("Template error: Fn::If requires a list argument with the first element being a condition");
            }
            if (keyJsonNode.size() != 3) {
                throw new ValidationErrorException("Template error: Fn::If requires a list argument with three elements");
            }
            return new IntrinsicFunction.ValidateResult(matchResult.getJsonNode(), this);
        }

        @Override
        public JsonNode evaluateFunction(IntrinsicFunction.ValidateResult validateResult, Template template) throws CloudFormationException {
            this.checkState(validateResult, (IntrinsicFunction)this);
            JsonNode keyJsonNode = validateResult.getJsonNode().get("Fn::If");
            String key = keyJsonNode.get(0).asText();
            boolean booleanValue = template.getConditionMap().get(key);
            return FunctionEvaluation.evaluateFunctions(keyJsonNode.get(booleanValue ? 1 : 2), template);
        }

        @Override
        public boolean isBooleanFunction() {
            return false;
        }
    }
    ,
    EQUALS{

        @Override
        public IntrinsicFunction.MatchResult evaluateMatch(JsonNode jsonNode) {
            boolean match = jsonNode != null && jsonNode.isObject() && jsonNode.size() == 1 && jsonNode.has("Fn::Equals");
            return new IntrinsicFunction.MatchResult(match, jsonNode, this);
        }

        @Override
        public IntrinsicFunction.ValidateResult validateArgTypesWherePossible(IntrinsicFunction.MatchResult matchResult) throws CloudFormationException {
            this.checkState(matchResult, (IntrinsicFunction)this);
            JsonNode keyJsonNode = matchResult.getJsonNode().get("Fn::Equals");
            if (keyJsonNode == null || !keyJsonNode.isArray() || keyJsonNode.size() != 2) {
                throw new ValidationErrorException("Template error: Fn::Equals requires a list argument with two elements");
            }
            return new IntrinsicFunction.ValidateResult(matchResult.getJsonNode(), this);
        }

        @Override
        public JsonNode evaluateFunction(IntrinsicFunction.ValidateResult validateResult, Template template) throws CloudFormationException {
            this.checkState(validateResult, (IntrinsicFunction)this);
            JsonNode keyJsonNode = validateResult.getJsonNode().get("Fn::Equals");
            JsonNode evaluatedArg0 = FunctionEvaluation.evaluateFunctions(keyJsonNode.get(0), template);
            JsonNode evaluatedArg1 = FunctionEvaluation.evaluateFunctions(keyJsonNode.get(1), template);
            if (evaluatedArg0 == null || evaluatedArg1 == null) {
                return new TextNode("false");
            }
            return new TextNode(String.valueOf(evaluatedArg0.equals((Object)evaluatedArg1)));
        }

        @Override
        public boolean isBooleanFunction() {
            return true;
        }
    }
    ,
    AND{

        @Override
        public IntrinsicFunction.MatchResult evaluateMatch(JsonNode jsonNode) {
            boolean match = jsonNode != null && jsonNode.isObject() && jsonNode.size() == 1 && jsonNode.has("Fn::And");
            return new IntrinsicFunction.MatchResult(match, jsonNode, this);
        }

        @Override
        public IntrinsicFunction.ValidateResult validateArgTypesWherePossible(IntrinsicFunction.MatchResult matchResult) throws CloudFormationException {
            this.checkState(matchResult, (IntrinsicFunction)this);
            JsonNode keyJsonNode = matchResult.getJsonNode().get("Fn::And");
            if (keyJsonNode == null || !keyJsonNode.isArray() || keyJsonNode.size() < 2 || keyJsonNode.size() > 10) {
                throw new ValidationErrorException("Template error: every Fn::And object requires a list of at least 2 and at most 10 boolean parameters.");
            }
            for (int i = 0; i < keyJsonNode.size(); ++i) {
                JsonNode argNode = keyJsonNode.get(i);
                if (argNode != null && argNode.isObject() && FunctionEvaluation.representsBooleanFunction(argNode)) continue;
                throw new ValidationErrorException("Template error: every Fn::And object requires a list of at least 2 and at most 10 boolean parameters.");
            }
            return new IntrinsicFunction.ValidateResult(matchResult.getJsonNode(), this);
        }

        @Override
        public JsonNode evaluateFunction(IntrinsicFunction.ValidateResult validateResult, Template template) throws CloudFormationException {
            this.checkState(validateResult, (IntrinsicFunction)this);
            JsonNode keyJsonNode = validateResult.getJsonNode().get("Fn::And");
            boolean returnValue = true;
            for (int i = 0; i < keyJsonNode.size(); ++i) {
                JsonNode argNode = keyJsonNode.get(i);
                JsonNode evaluatedArgNode = FunctionEvaluation.evaluateFunctions(argNode, template);
                boolean boolValueArgNode = FunctionEvaluation.evaluateBoolean(evaluatedArgNode);
                returnValue = returnValue && boolValueArgNode;
            }
            return new TextNode(String.valueOf(returnValue));
        }

        @Override
        public boolean isBooleanFunction() {
            return true;
        }
    }
    ,
    OR{

        @Override
        public IntrinsicFunction.MatchResult evaluateMatch(JsonNode jsonNode) {
            boolean match = jsonNode != null && jsonNode.isObject() && jsonNode.size() == 1 && jsonNode.has("Fn::Or");
            return new IntrinsicFunction.MatchResult(match, jsonNode, this);
        }

        @Override
        public IntrinsicFunction.ValidateResult validateArgTypesWherePossible(IntrinsicFunction.MatchResult matchResult) throws CloudFormationException {
            this.checkState(matchResult, (IntrinsicFunction)this);
            JsonNode keyJsonNode = matchResult.getJsonNode().get("Fn::Or");
            if (keyJsonNode == null || !keyJsonNode.isArray() || keyJsonNode.size() < 2 || keyJsonNode.size() > 10) {
                throw new ValidationErrorException("Template error: every Fn::Or object requires a list of at least 2 and at most 10 boolean parameters.");
            }
            for (int i = 0; i < keyJsonNode.size(); ++i) {
                JsonNode argNode = keyJsonNode.get(i);
                if (argNode != null && argNode.isObject() && FunctionEvaluation.representsBooleanFunction(argNode)) continue;
                throw new ValidationErrorException("Template error: every Fn::Or object requires a list of at least 2 and at most 10 boolean parameters.");
            }
            return new IntrinsicFunction.ValidateResult(matchResult.getJsonNode(), this);
        }

        @Override
        public JsonNode evaluateFunction(IntrinsicFunction.ValidateResult validateResult, Template template) throws CloudFormationException {
            this.checkState(validateResult, (IntrinsicFunction)this);
            JsonNode keyJsonNode = validateResult.getJsonNode().get("Fn::Or");
            boolean returnValue = false;
            for (int i = 0; i < keyJsonNode.size(); ++i) {
                JsonNode argNode = keyJsonNode.get(i);
                JsonNode evaluatedArgNode = FunctionEvaluation.evaluateFunctions(argNode, template);
                boolean boolValueArgNode = FunctionEvaluation.evaluateBoolean(evaluatedArgNode);
                returnValue = returnValue || boolValueArgNode;
            }
            return new TextNode(String.valueOf(returnValue));
        }

        @Override
        public boolean isBooleanFunction() {
            return true;
        }
    }
    ,
    NOT{

        @Override
        public IntrinsicFunction.MatchResult evaluateMatch(JsonNode jsonNode) {
            boolean match = jsonNode != null && jsonNode.isObject() && jsonNode.size() == 1 && jsonNode.has("Fn::Not");
            return new IntrinsicFunction.MatchResult(match, jsonNode, this);
        }

        @Override
        public IntrinsicFunction.ValidateResult validateArgTypesWherePossible(IntrinsicFunction.MatchResult matchResult) throws CloudFormationException {
            this.checkState(matchResult, (IntrinsicFunction)this);
            JsonNode keyJsonNode = matchResult.getJsonNode().get("Fn::Not");
            if (keyJsonNode == null || !keyJsonNode.isArray() || keyJsonNode.size() != 1) {
                throw new ValidationErrorException("Template error: Fn::Not requires a list argument with one element");
            }
            JsonNode arg0Node = keyJsonNode.get(0);
            if (arg0Node == null || !arg0Node.isObject() || !FunctionEvaluation.representsBooleanFunction(arg0Node)) {
                throw new ValidationErrorException("Template error: Fn::Not requires a list argument with one function token");
            }
            return new IntrinsicFunction.ValidateResult(matchResult.getJsonNode(), this);
        }

        @Override
        public JsonNode evaluateFunction(IntrinsicFunction.ValidateResult validateResult, Template template) throws CloudFormationException {
            this.checkState(validateResult, (IntrinsicFunction)this);
            JsonNode keyJsonNode = validateResult.getJsonNode().get("Fn::Not");
            JsonNode arg0Node = keyJsonNode.get(0);
            JsonNode evaluatedArg0Node = FunctionEvaluation.evaluateFunctions(arg0Node, template);
            boolean boolValueArg0Node = FunctionEvaluation.evaluateBoolean(evaluatedArg0Node);
            return new TextNode(String.valueOf(!boolValueArg0Node));
        }

        @Override
        public boolean isBooleanFunction() {
            return true;
        }
    }
    ,
    FIND_IN_MAP{

        @Override
        public IntrinsicFunction.MatchResult evaluateMatch(JsonNode jsonNode) {
            boolean match = jsonNode != null && jsonNode.isObject() && jsonNode.size() == 1 && jsonNode.has("Fn::FindInMap");
            return new IntrinsicFunction.MatchResult(match, jsonNode, this);
        }

        @Override
        public IntrinsicFunction.ValidateResult validateArgTypesWherePossible(IntrinsicFunction.MatchResult matchResult) throws CloudFormationException {
            this.checkState(matchResult, (IntrinsicFunction)this);
            JsonNode key = matchResult.getJsonNode().get("Fn::FindInMap");
            if (key == null || !key.isArray() || key.size() != 3) {
                throw new ValidationErrorException("Template error: every Fn::FindInMap object requires three parameters, the map name, map key and the attribute for return value");
            }
            return new IntrinsicFunction.ValidateResult(matchResult.getJsonNode(), this);
        }

        @Override
        public JsonNode evaluateFunction(IntrinsicFunction.ValidateResult validateResult, Template template) throws CloudFormationException {
            this.checkState(validateResult, (IntrinsicFunction)this);
            JsonNode key = validateResult.getJsonNode().get("Fn::FindInMap");
            JsonNode arg0Node = FunctionEvaluation.evaluateFunctions(key.get(0), template);
            JsonNode arg1Node = FunctionEvaluation.evaluateFunctions(key.get(1), template);
            JsonNode arg2Node = FunctionEvaluation.evaluateFunctions(key.get(2), template);
            if (!(arg0Node != null && arg1Node != null && arg2Node != null && arg0Node.isValueNode() && arg1Node.isValueNode() && arg2Node.isValueNode() && arg0Node != null && arg1Node.asText() != null && arg2Node.asText() != null)) {
                throw new ValidationErrorException("Template error: every Fn::FindInMap object requires three parameters, the map name, map key and the attribute for return value");
            }
            String mapName = arg0Node.asText();
            String mapKey = arg1Node.asText();
            String attribute = arg2Node.asText();
            Map<String, Map<String, Map<String, String>>> mapping = template.getMapping();
            if (!mapping.containsKey(mapName)) {
                throw new ValidationErrorException("Template error: Mapping named '" + mapName + "' is not " + "present in the 'Mappings' section of template");
            }
            if (!mapping.get(mapName).containsKey(mapKey) || !mapping.get(mapName).get(mapKey).containsKey(attribute)) {
                throw new ValidationErrorException("Template error: Unable to get mapping for " + mapName + "::" + mapKey + "::" + attribute);
            }
            return JsonHelper.getJsonNodeFromString(mapping.get(mapName).get(mapKey).get(attribute));
        }

        @Override
        public boolean isBooleanFunction() {
            return false;
        }
    }
    ,
    BASE64{

        @Override
        public IntrinsicFunction.MatchResult evaluateMatch(JsonNode jsonNode) {
            boolean match = jsonNode != null && jsonNode.isObject() && jsonNode.size() == 1 && jsonNode.has("Fn::Base64");
            return new IntrinsicFunction.MatchResult(match, jsonNode, this);
        }

        @Override
        public IntrinsicFunction.ValidateResult validateArgTypesWherePossible(IntrinsicFunction.MatchResult matchResult) throws CloudFormationException {
            this.checkState(matchResult, (IntrinsicFunction)this);
            return new IntrinsicFunction.ValidateResult(matchResult.getJsonNode(), this);
        }

        @Override
        public JsonNode evaluateFunction(IntrinsicFunction.ValidateResult validateResult, Template template) throws CloudFormationException {
            this.checkState(validateResult, (IntrinsicFunction)this);
            JsonNode keyJsonNode = FunctionEvaluation.evaluateFunctions(validateResult.getJsonNode().get("Fn::Base64"), template);
            if (keyJsonNode == null || !keyJsonNode.isValueNode()) {
                throw new ValidationErrorException("Template error: every Fn::Base64 object must have a String-typed value.");
            }
            String key = keyJsonNode.asText();
            if (key == null) {
                throw new ValidationErrorException("Template error: every Fn::Base64 object must not have a null value.");
            }
            return key == null ? validateResult.getJsonNode() : new TextNode(new String(Base64.encode((byte[])key.getBytes())));
        }

        @Override
        public boolean isBooleanFunction() {
            return false;
        }
    }
    ,
    SELECT{

        @Override
        public IntrinsicFunction.MatchResult evaluateMatch(JsonNode jsonNode) {
            boolean match = jsonNode != null && jsonNode.isObject() && jsonNode.size() == 1 && jsonNode.has("Fn::Select");
            return new IntrinsicFunction.MatchResult(match, jsonNode, this);
        }

        @Override
        public IntrinsicFunction.ValidateResult validateArgTypesWherePossible(IntrinsicFunction.MatchResult matchResult) throws CloudFormationException {
            this.checkState(matchResult, (IntrinsicFunction)this);
            JsonNode key = matchResult.getJsonNode().get("Fn::Select");
            if (key == null || !key.isArray() || key.size() < 1) {
                throw new ValidationErrorException("Template error: Fn::Select requires a list argument with a valid index value as its first element");
            }
            return new IntrinsicFunction.ValidateResult(matchResult.getJsonNode(), this);
        }

        @Override
        public JsonNode evaluateFunction(IntrinsicFunction.ValidateResult validateResult, Template template) throws CloudFormationException {
            this.checkState(validateResult, (IntrinsicFunction)this);
            JsonNode key = validateResult.getJsonNode().get("Fn::Select");
            JsonNode evaluatedIndex = FunctionEvaluation.evaluateFunctions(key.get(0), template);
            if (evaluatedIndex == null || !evaluatedIndex.isValueNode() || evaluatedIndex.asText() == null) {
                throw new ValidationErrorException("Template error: Fn::Select requires a list argument with a valid index value as its first element");
            }
            int index = -1;
            try {
                index = Integer.parseInt(evaluatedIndex.asText());
            }
            catch (NumberFormatException ex) {
                throw new ValidationErrorException("Template error: Fn::Select requires a list argument with a valid index value as its first element");
            }
            if (key.size() != 2) {
                throw new ValidationErrorException("Template error: Fn::Select requires a list argument with two elements: an integer index and a list");
            }
            JsonNode argArray = FunctionEvaluation.evaluateFunctions(key.get(1), template);
            if (argArray == null || !argArray.isArray()) {
                throw new ValidationErrorException("Template error: Fn::Select requires a list argument with two elements: an integer index and a list");
            }
            if (argArray == null || index < 0 || index >= argArray.size()) {
                throw new ValidationErrorException("Template error: Fn::Select cannot select nonexistent value at index " + index);
            }
            return argArray.get(index);
        }

        @Override
        public boolean isBooleanFunction() {
            return false;
        }
    }
    ,
    JOIN{

        @Override
        public IntrinsicFunction.MatchResult evaluateMatch(JsonNode jsonNode) {
            boolean match = jsonNode != null && jsonNode.isObject() && jsonNode.size() == 1 && jsonNode.has("Fn::Join");
            return new IntrinsicFunction.MatchResult(match, jsonNode, this);
        }

        @Override
        public IntrinsicFunction.ValidateResult validateArgTypesWherePossible(IntrinsicFunction.MatchResult matchResult) throws CloudFormationException {
            this.checkState(matchResult, (IntrinsicFunction)this);
            JsonNode key = matchResult.getJsonNode().get("Fn::Join");
            if (key == null || !key.isArray() || key.size() != 2) {
                throw new ValidationErrorException("Template error: every Fn::Join object requires two parameters, (1) a string delimiter and (2) a list of strings to be joined or a function that returns a list of strings (such as Fn::GetAZs) to be joined.");
            }
            return new IntrinsicFunction.ValidateResult(matchResult.getJsonNode(), this);
        }

        @Override
        public JsonNode evaluateFunction(IntrinsicFunction.ValidateResult validateResult, Template template) throws CloudFormationException {
            this.checkState(validateResult, (IntrinsicFunction)this);
            JsonNode key = validateResult.getJsonNode().get("Fn::Join");
            JsonNode delimiterNode = FunctionEvaluation.evaluateFunctions(key.get(0), template);
            JsonNode arrayOfStrings = FunctionEvaluation.evaluateFunctions(key.get(1), template);
            if (delimiterNode == null || !delimiterNode.isValueNode() || delimiterNode.asText() == null || arrayOfStrings == null || !arrayOfStrings.isArray()) {
                throw new ValidationErrorException("Template error: every Fn::Join object requires two parameters, (1) a string delimiter and (2) a list of strings to be joined or a function that returns a list of strings (such as Fn::GetAZs) to be joined.");
            }
            String delimiter = delimiterNode.asText();
            if (arrayOfStrings == null || arrayOfStrings.size() == 0) {
                return new TextNode("");
            }
            String tempDelimiter = "";
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < arrayOfStrings.size(); ++i) {
                if (arrayOfStrings.get(i) == null || !arrayOfStrings.get(i).isValueNode() || arrayOfStrings.get(i).asText() == null) {
                    throw new ValidationErrorException("Template error: every Fn::Join object requires two parameters, (1) a string delimiter and (2) a list of strings to be joined or a function that returns a list of strings (such as Fn::GetAZs) to be joined.");
                }
                buffer.append(tempDelimiter).append(arrayOfStrings.get(i).asText());
                tempDelimiter = delimiter;
            }
            return new TextNode(buffer.toString());
        }

        @Override
        public boolean isBooleanFunction() {
            return false;
        }
    }
    ,
    GET_AZS{

        @Override
        public IntrinsicFunction.MatchResult evaluateMatch(JsonNode jsonNode) {
            boolean match = jsonNode != null && jsonNode.isObject() && jsonNode.size() == 1 && jsonNode.has("Fn::GetAZs");
            return new IntrinsicFunction.MatchResult(match, jsonNode, this);
        }

        @Override
        public IntrinsicFunction.ValidateResult validateArgTypesWherePossible(IntrinsicFunction.MatchResult matchResult) throws CloudFormationException {
            this.checkState(matchResult, (IntrinsicFunction)this);
            return new IntrinsicFunction.ValidateResult(matchResult.getJsonNode(), this);
        }

        @Override
        public JsonNode evaluateFunction(IntrinsicFunction.ValidateResult validateResult, Template template) throws CloudFormationException {
            this.checkState(validateResult, (IntrinsicFunction)this);
            JsonNode keyJsonNode = FunctionEvaluation.evaluateFunctions(validateResult.getJsonNode().get("Fn::GetAZs"), template);
            if (keyJsonNode == null || !keyJsonNode.isValueNode()) {
                throw new ValidationErrorException("Template error: every Fn::GetAZs object must have a String-typed value.");
            }
            String key = keyJsonNode.asText();
            if (key == null) {
                throw new ValidationErrorException("Template error: every Fn::GetAZs object must not have a null value.");
            }
            ArrayList availabilityZones = Lists.newArrayList();
            Map<String, List<String>> availabilityZoneMap = template.getAvailabilityZoneMap();
            if (availabilityZoneMap != null && availabilityZoneMap.containsKey(key)) {
                availabilityZones.addAll((Collection)availabilityZoneMap.get(key));
            }
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode arrayNode = objectMapper.createArrayNode();
            for (String availabilityZone : availabilityZones) {
                arrayNode.add(availabilityZone);
            }
            return arrayNode;
        }

        @Override
        public boolean isBooleanFunction() {
            return false;
        }
    }
    ,
    GET_ATT{

        @Override
        public IntrinsicFunction.MatchResult evaluateMatch(JsonNode jsonNode) {
            boolean match = jsonNode != null && jsonNode.isObject() && jsonNode.size() == 1 && jsonNode.has("Fn::GetAtt");
            return new IntrinsicFunction.MatchResult(match, jsonNode, this);
        }

        @Override
        public IntrinsicFunction.ValidateResult validateArgTypesWherePossible(IntrinsicFunction.MatchResult matchResult) throws CloudFormationException {
            this.checkState(matchResult, (IntrinsicFunction)this);
            JsonNode key = matchResult.getJsonNode().get("Fn::GetAtt");
            if (key == null || !key.isArray() || key.size() != 2 || key.get(0) == null || !key.get(0).isValueNode() || key.get(0).asText() == null || key.get(0).asText().isEmpty() || key.get(1) == null || !key.get(1).isValueNode() || key.get(1).asText() == null || key.get(1).asText().isEmpty()) {
                throw new ValidationErrorException("Template error: every Fn::GetAtt object requires two non-empty parameters, the resource name and the resource attribute");
            }
            return new IntrinsicFunction.ValidateResult(matchResult.getJsonNode(), this);
        }

        @Override
        public JsonNode evaluateFunction(IntrinsicFunction.ValidateResult validateResult, Template template) throws CloudFormationException {
            this.checkState(validateResult, (IntrinsicFunction)this);
            JsonNode key = validateResult.getJsonNode().get("Fn::GetAtt");
            String resourceName = key.get(0).asText();
            if (!template.getResourceInfoMap().containsKey(resourceName)) {
                throw new ValidationErrorException("Template error: instance of Fn::GetAtt references undefined resource " + resourceName);
            }
            ResourceInfo resourceInfo = template.getResourceInfoMap().get(resourceName);
            if (!resourceInfo.getReady().booleanValue()) {
                throw new ValidationErrorException("Template error: reference " + resourceName + " not ready");
            }
            String attributeName = key.get(1).asText();
            try {
                return JsonHelper.getJsonNodeFromString(resourceInfo.getResourceAttributeJson(attributeName));
            }
            catch (Exception ex) {
                throw new ValidationErrorException("Template error: resource " + resourceName + " does not support " + "attribute type " + attributeName + " in Fn::GetAtt");
            }
        }

        @Override
        public boolean isBooleanFunction() {
            return false;
        }
    }
    ,
    UNKNOWN{

        @Override
        public IntrinsicFunction.MatchResult evaluateMatch(JsonNode jsonNode) {
            boolean match = jsonNode != null && jsonNode.isObject() && jsonNode.size() == 1 && ((String)jsonNode.fieldNames().next()).startsWith("Fn:");
            return new IntrinsicFunction.MatchResult(match, jsonNode, this);
        }

        @Override
        public IntrinsicFunction.ValidateResult validateArgTypesWherePossible(IntrinsicFunction.MatchResult matchResult) throws CloudFormationException {
            this.checkState(matchResult, (IntrinsicFunction)this);
            return new IntrinsicFunction.ValidateResult(matchResult.getJsonNode(), this);
        }

        @Override
        public JsonNode evaluateFunction(IntrinsicFunction.ValidateResult validateResult, Template template) throws CloudFormationException {
            this.checkState(validateResult, (IntrinsicFunction)this);
            throw new ValidationErrorException("Template Error: Encountered unsupported function: " + (String)validateResult.getJsonNode().fieldNames().next() + " Supported functions are: [Fn::Base64, Fn::GetAtt, " + "Fn::GetAZs, Fn::Join, Fn::FindInMap, Fn::Select, Ref, Fn::Equals, Fn::If, Fn::Not, " + "Condition, Fn::And, Fn::Or]");
        }

        @Override
        public boolean isBooleanFunction() {
            return false;
        }
    };


    public abstract boolean isBooleanFunction();

    protected void checkState(IntrinsicFunction.MatchResult matchResult, IntrinsicFunction intrinsicFunction) {
        if (matchResult == null || !matchResult.isMatch() || !intrinsicFunction.equals(matchResult.getCallingFunction())) {
            throw new IllegalStateException("MatchResult passed in is null, false or used with the wrong function");
        }
    }

    protected void checkState(IntrinsicFunction.ValidateResult validateResult, IntrinsicFunction intrinsicFunction) {
        if (validateResult == null || !this.equals(validateResult.getCallingFunction())) {
            throw new IllegalStateException("ValidateResult passed in is null, false or used with the wrong function");
        }
    }
}

