/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.template;

import com.eucalyptus.cloudformation.CloudFormationException;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.entity.StackEntity;
import com.eucalyptus.cloudformation.entity.StackEntityHelper;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.template.IntrinsicFunction;
import com.eucalyptus.cloudformation.template.IntrinsicFunctions;
import com.eucalyptus.cloudformation.template.Template;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class FunctionEvaluation {
    public static final String REF_STR = "Ref";
    public static final String CONDITION_STR = "Condition";
    public static final String FN_AND = "Fn::And";
    public static final String FN_EQUALS = "Fn::Equals";
    public static final String FN_IF = "Fn::If";
    public static final String FN_NOT = "Fn::Not";
    public static final String FN_OR = "Fn::Or";
    public static final String FN_BASE64 = "Fn::Base64";
    public static final String FN_SELECT = "Fn::Select";
    public static final String FN_JOIN = "Fn::Join";
    public static final String FN_FIND_IN_MAP = "Fn::FindInMap";
    public static final String FN_GET_AZS = "Fn::GetAZs";
    public static final String FN_GET_ATT = "Fn::GetAtt";
    public static final String AWS_NO_VALUE = "AWS::NoValue";

    public static boolean representsBooleanFunction(JsonNode jsonNode) {
        for (IntrinsicFunctions value : IntrinsicFunctions.values()) {
            if (!value.evaluateMatch(jsonNode).isMatch() || !value.isBooleanFunction()) continue;
            return true;
        }
        return false;
    }

    public static boolean evaluateBoolean(JsonNode jsonNode) throws CloudFormationException {
        if (jsonNode == null || !jsonNode.isValueNode() || !"true".equalsIgnoreCase(jsonNode.asText()) && !"false".equalsIgnoreCase(jsonNode.asText())) {
            throw new ValidationErrorException("Template error: Invalid boolean value " + jsonNode);
        }
        return "true".equalsIgnoreCase(jsonNode.asText());
    }

    public static void validateConditionSectionArgTypesWherePossible(JsonNode jsonNode) throws CloudFormationException {
        FunctionEvaluation.validateArgTypesWherePossible(jsonNode, true);
    }

    public static void validateNonConditionSectionArgTypesWherePossible(JsonNode jsonNode) throws CloudFormationException {
        FunctionEvaluation.validateArgTypesWherePossible(jsonNode, false);
    }

    private static void validateArgTypesWherePossible(JsonNode jsonNode, boolean inConditionsSection) throws CloudFormationException {
        block4: {
            block5: {
                if (jsonNode == null) break block4;
                if (!jsonNode.isArray()) break block5;
                for (int i = 0; i < jsonNode.size(); ++i) {
                    FunctionEvaluation.validateConditionSectionArgTypesWherePossible(jsonNode.get(i));
                }
                break block4;
            }
            if (!jsonNode.isObject()) break block4;
            ArrayList fieldNames = Lists.newArrayList((Iterator)jsonNode.fieldNames());
            for (String key : fieldNames) {
                FunctionEvaluation.validateConditionSectionArgTypesWherePossible(jsonNode.get(key));
            }
            for (IntrinsicFunctions intrinsicFunction : IntrinsicFunctions.values()) {
                IntrinsicFunction.MatchResult matchResult = intrinsicFunction.evaluateMatch(jsonNode);
                if (!matchResult.isMatch()) continue;
                intrinsicFunction.validateArgTypesWherePossible(matchResult);
                if (intrinsicFunction == IntrinsicFunctions.CONDITION && !inConditionsSection) {
                    throw new ValidationErrorException("Template error: Condition token can only be used in Conditions block");
                }
                if (intrinsicFunction != IntrinsicFunctions.EQUALS || inConditionsSection) continue;
                throw new ValidationErrorException("Template error: Fn::Equals cannot be partially collapsed");
            }
        }
    }

    public static JsonNode evaluateFunctions(JsonNode jsonNode, Template template) throws CloudFormationException {
        if (jsonNode == null) {
            return jsonNode;
        }
        if (!jsonNode.isArray() && !jsonNode.isObject()) {
            return jsonNode;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        if (jsonNode.isArray()) {
            ArrayNode arrayCopy = objectMapper.createArrayNode();
            for (int i = 0; i < jsonNode.size(); ++i) {
                JsonNode arrayElement = FunctionEvaluation.evaluateFunctions(jsonNode.get(i), template);
                arrayCopy.add(arrayElement);
            }
            return arrayCopy;
        }
        for (IntrinsicFunctions intrinsicFunction : IntrinsicFunctions.values()) {
            IntrinsicFunction.MatchResult matchResult = intrinsicFunction.evaluateMatch(jsonNode);
            if (!matchResult.isMatch()) continue;
            IntrinsicFunction.ValidateResult validateResult = intrinsicFunction.validateArgTypesWherePossible(matchResult);
            return intrinsicFunction.evaluateFunction(validateResult, template);
        }
        ObjectNode objectCopy = objectMapper.createObjectNode();
        ArrayList fieldNames = Lists.newArrayList((Iterator)jsonNode.fieldNames());
        for (String key : fieldNames) {
            JsonNode objectElement = FunctionEvaluation.evaluateFunctions(jsonNode.get(key), template);
            objectCopy.put(key, objectElement);
        }
        return objectCopy;
    }

    public static JsonNode evaluateFunctions(JsonNode jsonNode, StackEntity stackEntity, Map<String, ResourceInfo> resourceInfoMap) throws CloudFormationException {
        Template template = new Template();
        template.setResourceInfoMap(resourceInfoMap);
        StackEntityHelper.populateTemplateWithStackEntity(template, stackEntity);
        JsonNode result = FunctionEvaluation.evaluateFunctions(jsonNode, template);
        StackEntityHelper.populateStackEntityWithTemplate(stackEntity, template);
        return result;
    }
}

