/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.BucketCrossOriginConfiguration;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.BucketLoggingConfiguration;
import com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.services.s3.model.BucketTaggingConfiguration;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.BucketWebsiteConfiguration;
import com.amazonaws.services.s3.model.CORSRule;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.RedirectRule;
import com.amazonaws.services.s3.model.RoutingRule;
import com.amazonaws.services.s3.model.RoutingRuleCondition;
import com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.TagSet;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.login.AuthenticationException;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.tokens.SecurityTokenAWSCredentialsProvider;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.TagHelper;
import com.eucalyptus.cloudformation.resources.standard.info.AWSS3BucketResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSS3BucketProperties;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.CloudFormationResourceTag;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.S3CorsConfiguration;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.S3CorsConfigurationRule;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.S3LifecycleConfiguration;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.S3LifecycleRule;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.S3LoggingConfiguration;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.S3NotificationConfiguration;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.S3NotificationTopicConfiguration;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.S3VersioningConfiguration;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.S3WebsiteConfiguration;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.S3WebsiteConfigurationRoutingRule;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.crypto.util.Timestamps;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.objectstorage.client.EucaS3Client;
import com.eucalyptus.objectstorage.client.EucaS3ClientFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class AWSS3BucketResourceAction
extends ResourceAction {
    private AWSS3BucketProperties properties = new AWSS3BucketProperties();
    private AWSS3BucketResourceInfo info = new AWSS3BucketResourceInfo();

    public AWSS3BucketResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSS3BucketProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSS3BucketResourceInfo)resourceInfo;
    }

    private BucketWebsiteConfiguration convertWebsiteConfiguration(S3WebsiteConfiguration websiteConfiguration) {
        BucketWebsiteConfiguration bucketWebsiteConfiguration = new BucketWebsiteConfiguration();
        bucketWebsiteConfiguration.setErrorDocument(websiteConfiguration.getErrorDocument());
        bucketWebsiteConfiguration.setIndexDocumentSuffix(websiteConfiguration.getIndexDocument());
        if (websiteConfiguration.getRedirectAllRequestsTo() != null) {
            RedirectRule redirectAllRequestsTo = new RedirectRule();
            redirectAllRequestsTo.setHostName(websiteConfiguration.getRedirectAllRequestsTo().getHostName());
            redirectAllRequestsTo.setProtocol(websiteConfiguration.getRedirectAllRequestsTo().getProtocol());
            bucketWebsiteConfiguration.setRedirectAllRequestsTo(redirectAllRequestsTo);
        }
        if (websiteConfiguration.getRoutingRules() != null) {
            ArrayList routingRules = Lists.newArrayList();
            for (S3WebsiteConfigurationRoutingRule s3WebsiteConfigurationRoutingRule : websiteConfiguration.getRoutingRules()) {
                RoutingRule routingRule = new RoutingRule();
                if (s3WebsiteConfigurationRoutingRule.getRoutingRuleCondition() != null) {
                    RoutingRuleCondition condition = new RoutingRuleCondition();
                    condition.setHttpErrorCodeReturnedEquals(s3WebsiteConfigurationRoutingRule.getRoutingRuleCondition().getHttpErrorCodeReturnedEquals());
                    condition.setKeyPrefixEquals(s3WebsiteConfigurationRoutingRule.getRoutingRuleCondition().getKeyPrefixEquals());
                    routingRule.setCondition(condition);
                }
                if (s3WebsiteConfigurationRoutingRule.getRedirectRule() != null) {
                    RedirectRule redirect = new RedirectRule();
                    redirect.setReplaceKeyWith(s3WebsiteConfigurationRoutingRule.getRedirectRule().getReplaceKeyWith());
                    redirect.setReplaceKeyPrefixWith(s3WebsiteConfigurationRoutingRule.getRedirectRule().getReplaceKeyPrefixWith());
                    redirect.setProtocol(s3WebsiteConfigurationRoutingRule.getRedirectRule().getProtocol());
                    redirect.setHttpRedirectCode(s3WebsiteConfigurationRoutingRule.getRedirectRule().getHttpRedirectCode());
                    redirect.setHostName(s3WebsiteConfigurationRoutingRule.getRedirectRule().getHostName());
                    routingRule.setRedirect(redirect);
                }
                routingRules.add(routingRule);
            }
            bucketWebsiteConfiguration.setRoutingRules((List)routingRules);
        }
        return bucketWebsiteConfiguration;
    }

    private SetBucketVersioningConfigurationRequest convertVersioningConfiguration(String bucketName, S3VersioningConfiguration versioningConfiguration) {
        BucketVersioningConfiguration bucketVersioningConfiguration = new BucketVersioningConfiguration(versioningConfiguration.getStatus());
        return new SetBucketVersioningConfigurationRequest(bucketName, bucketVersioningConfiguration);
    }

    private BucketTaggingConfiguration convertTags(List<CloudFormationResourceTag> tags) {
        BucketTaggingConfiguration bucketTaggingConfiguration = new BucketTaggingConfiguration();
        ArrayList tagSets = Lists.newArrayList();
        TagSet tagSet = new TagSet();
        for (CloudFormationResourceTag cloudformationResourceTag : tags) {
            tagSet.setTag(cloudformationResourceTag.getKey(), cloudformationResourceTag.getValue());
        }
        tagSets.add(tagSet);
        bucketTaggingConfiguration.setTagSets((Collection)tagSets);
        return bucketTaggingConfiguration;
    }

    private BucketNotificationConfiguration convertNotificationConfiguration(S3NotificationConfiguration notificationConfiguration) {
        BucketNotificationConfiguration bucketNotificationConfiguration = new BucketNotificationConfiguration();
        if (notificationConfiguration.getTopicConfigurations() != null) {
            ArrayList topicConfigurations = Lists.newArrayList();
            for (S3NotificationTopicConfiguration s3NotificationTopicConfiguration : notificationConfiguration.getTopicConfigurations()) {
                topicConfigurations.add(new BucketNotificationConfiguration.TopicConfiguration(s3NotificationTopicConfiguration.getTopic(), s3NotificationTopicConfiguration.getEvent()));
            }
            bucketNotificationConfiguration.setTopicConfigurations((Collection)topicConfigurations);
        }
        return bucketNotificationConfiguration;
    }

    private SetBucketLoggingConfigurationRequest convertLoggingConfiguration(String bucketName, S3LoggingConfiguration loggingConfiguration) {
        BucketLoggingConfiguration bucketLoggingConfiguration = new BucketLoggingConfiguration();
        bucketLoggingConfiguration.setDestinationBucketName(loggingConfiguration.getDestinationBucketName());
        bucketLoggingConfiguration.setLogFilePrefix(loggingConfiguration.getLogFilePrefix());
        return new SetBucketLoggingConfigurationRequest(bucketName, bucketLoggingConfiguration);
    }

    private BucketLifecycleConfiguration convertLifecycleConfiguration(S3LifecycleConfiguration lifecycleConfiguration) throws AuthenticationException {
        BucketLifecycleConfiguration bucketLifecycleConfiguration = new BucketLifecycleConfiguration();
        if (lifecycleConfiguration.getRules() != null) {
            ArrayList rules = Lists.newArrayList();
            for (S3LifecycleRule s3LifecycleRule : lifecycleConfiguration.getRules()) {
                BucketLifecycleConfiguration.Rule rule = new BucketLifecycleConfiguration.Rule();
                rule.setId(s3LifecycleRule.getId());
                if (s3LifecycleRule.getExpirationDate() != null) {
                    rule.setExpirationDate(Timestamps.parseIso8601Timestamp((String)s3LifecycleRule.getExpirationDate()));
                }
                if (s3LifecycleRule.getExpirationInDays() != null) {
                    rule.setExpirationInDays(s3LifecycleRule.getExpirationInDays().intValue());
                }
                rule.setPrefix(s3LifecycleRule.getPrefix());
                rule.setStatus(s3LifecycleRule.getStatus());
                if (s3LifecycleRule.getTransition() != null) {
                    BucketLifecycleConfiguration.Transition transition = new BucketLifecycleConfiguration.Transition();
                    if (s3LifecycleRule.getTransition().getStorageClass() != null) {
                        transition.setStorageClass(StorageClass.valueOf((String)s3LifecycleRule.getTransition().getStorageClass()));
                    }
                    if (s3LifecycleRule.getExpirationDate() != null) {
                        transition.setDate(Timestamps.parseIso8601Timestamp((String)s3LifecycleRule.getExpirationDate()));
                    }
                    if (s3LifecycleRule.getExpirationInDays() != null) {
                        transition.setDays(s3LifecycleRule.getExpirationInDays().intValue());
                    }
                    rule.setTransition(transition);
                }
                rules.add(rule);
            }
            bucketLifecycleConfiguration.setRules((List)rules);
        }
        return bucketLifecycleConfiguration;
    }

    private BucketCrossOriginConfiguration convertCrossOriginConfiguration(S3CorsConfiguration corsConfiguration) {
        BucketCrossOriginConfiguration bucketCrossOriginConfiguration = new BucketCrossOriginConfiguration();
        if (corsConfiguration.getCorsRule() != null) {
            ArrayList rules = Lists.newArrayList();
            for (S3CorsConfigurationRule s3CorsConfigurationRule : corsConfiguration.getCorsRule()) {
                CORSRule rule = new CORSRule();
                rule.setAllowedHeaders(s3CorsConfigurationRule.getAllowedHeaders());
                if (s3CorsConfigurationRule.getAllowedMethods() != null) {
                    ArrayList allowedMethods = Lists.newArrayList();
                    for (String allowedMethodStr : s3CorsConfigurationRule.getAllowedMethods()) {
                        allowedMethods.add(CORSRule.AllowedMethods.valueOf((String)allowedMethodStr));
                    }
                    rule.setAllowedMethods((List)allowedMethods);
                }
                rule.setAllowedOrigins(s3CorsConfigurationRule.getAllowedOrigins());
                rule.setExposedHeaders(s3CorsConfigurationRule.getExposedHeaders());
                rule.setId(s3CorsConfigurationRule.getId());
                rule.setMaxAgeSeconds(s3CorsConfigurationRule.getMaxAge().intValue());
                rules.add(rule);
            }
            bucketCrossOriginConfiguration.setRules((List)rules);
        }
        return bucketCrossOriginConfiguration;
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        KICK_BUCKET{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSS3BucketResourceAction action;
                block15: {
                    action = (AWSS3BucketResourceAction)resourceAction;
                    if (action.info.getPhysicalResourceId() == null) {
                        return action;
                    }
                    User user = Accounts.lookupUserById((String)action.getResourceInfo().getEffectiveUserId());
                    try (EucaS3Client s3c = EucaS3ClientFactory.getEucaS3Client((AWSCredentialsProvider)new SecurityTokenAWSCredentialsProvider(user));){
                        s3c.deleteBucket(action.info.getPhysicalResourceId());
                    }
                    catch (AmazonS3Exception ex) {
                        if ("NoSuchBucket".equalsIgnoreCase(ex.getErrorCode())) break block15;
                        throw ex;
                    }
                }
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_BUCKET{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSS3BucketResourceAction action = (AWSS3BucketResourceAction)resourceAction;
                User user = Accounts.lookupUserById((String)action.getResourceInfo().getEffectiveUserId());
                try (EucaS3Client s3c = EucaS3ClientFactory.getEucaS3Client((AWSCredentialsProvider)new SecurityTokenAWSCredentialsProvider(user));){
                    String bucketName;
                    String string = bucketName = action.properties.getBucketName() != null ? action.properties.getBucketName() : action.getDefaultPhysicalResourceId(63).toLowerCase();
                    if (s3c.doesBucketExist(bucketName)) {
                        throw new Exception("Bucket " + bucketName + " exists");
                    }
                    s3c.createBucket(bucketName);
                    action.info.setPhysicalResourceId(bucketName);
                }
                return action;
            }
        }
        ,
        ADD_BUCKET_STUFF{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSS3BucketResourceAction action = (AWSS3BucketResourceAction)resourceAction;
                URI serviceURI = ServiceUris.remotePublicify(ObjectStorage.class, (String[])new String[0]);
                User user = Accounts.lookupUserById((String)action.getResourceInfo().getEffectiveUserId());
                String bucketName = action.info.getPhysicalResourceId();
                try (EucaS3Client s3c = EucaS3ClientFactory.getEucaS3Client((AWSCredentialsProvider)new SecurityTokenAWSCredentialsProvider(user));){
                    if (action.properties.getAccessControl() != null) {
                        s3c.setBucketAcl(bucketName, CannedAccessControlList.valueOf((String)action.properties.getAccessControl()));
                    }
                    if (action.properties.getCorsConfiguration() != null) {
                        s3c.setBucketCrossOriginConfiguration(bucketName, action.convertCrossOriginConfiguration(action.properties.getCorsConfiguration()));
                    }
                    if (action.properties.getLifecycleConfiguration() != null) {
                        s3c.setBucketLifecycleConfiguration(bucketName, action.convertLifecycleConfiguration(action.properties.getLifecycleConfiguration()));
                    }
                    if (action.properties.getLoggingConfiguration() != null) {
                        s3c.setBucketLoggingConfiguration(action.convertLoggingConfiguration(bucketName, action.properties.getLoggingConfiguration()));
                    }
                    if (action.properties.getNotificationConfiguration() != null) {
                        s3c.setBucketNotificationConfiguration(bucketName, action.convertNotificationConfiguration(action.properties.getNotificationConfiguration()));
                    }
                    List<CloudFormationResourceTag> systemTags = TagHelper.getCloudFormationResourceSystemTags(action.info, action.getStackEntity());
                    List<CloudFormationResourceTag> nonSystemTags = TagHelper.getCloudFormationResourceStackTags(action.getStackEntity());
                    if (action.properties.getTags() != null && !action.properties.getTags().isEmpty()) {
                        TagHelper.checkReservedCloudFormationResourceTemplateTags(action.properties.getTags());
                        nonSystemTags.addAll(action.properties.getTags());
                    }
                    if (!nonSystemTags.isEmpty()) {
                        ArrayList allTags = Lists.newArrayList();
                        allTags.addAll(systemTags);
                        allTags.addAll(nonSystemTags);
                        s3c.setBucketTaggingConfiguration(bucketName, action.convertTags(allTags));
                    } else {
                        EucaS3Client s3cAdmin = EucaS3ClientFactory.getEucaS3Client((AWSCredentialsProvider)new SecurityTokenAWSCredentialsProvider(user.getAccount().lookupAdmin()));
                        s3cAdmin.setBucketTaggingConfiguration(bucketName, action.convertTags(systemTags));
                    }
                    if (action.properties.getVersioningConfiguration() != null) {
                        s3c.setBucketVersioningConfiguration(action.convertVersioningConfiguration(bucketName, action.properties.getVersioningConfiguration()));
                    }
                    if (action.properties.getWebsiteConfiguration() != null) {
                        s3c.setBucketWebsiteConfiguration(bucketName, action.convertWebsiteConfiguration(action.properties.getWebsiteConfiguration()));
                    }
                }
                String domainName = null;
                domainName = serviceURI.getPath() == null || serviceURI.getPath().replace("/", "").isEmpty() ? bucketName + "." + serviceURI.getHost() + (serviceURI.getPort() != -1 ? ":" + serviceURI.getPort() : "") : serviceURI.getHost() + (serviceURI.getPort() != -1 ? ":" + serviceURI.getPort() : "") + serviceURI.getPath() + "/" + bucketName;
                action.info.setDomainName(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(domainName)));
                action.info.setWebsiteURL(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode("http://" + domainName)));
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

