/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.auth.euare.AddUserToGroupType;
import com.eucalyptus.auth.euare.GetGroupResponseType;
import com.eucalyptus.auth.euare.GetGroupType;
import com.eucalyptus.auth.euare.GroupType;
import com.eucalyptus.auth.euare.ListGroupsResponseType;
import com.eucalyptus.auth.euare.ListGroupsType;
import com.eucalyptus.auth.euare.ListUsersResponseType;
import com.eucalyptus.auth.euare.ListUsersType;
import com.eucalyptus.auth.euare.RemoveUserFromGroupType;
import com.eucalyptus.auth.euare.UserType;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSIAMUserToGroupAdditionResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSIAMUserToGroupAdditionProperties;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Euare;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

public class AWSIAMUserToGroupAdditionResourceAction
extends ResourceAction {
    private AWSIAMUserToGroupAdditionProperties properties = new AWSIAMUserToGroupAdditionProperties();
    private AWSIAMUserToGroupAdditionResourceInfo info = new AWSIAMUserToGroupAdditionResourceInfo();

    public AWSIAMUserToGroupAdditionResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSIAMUserToGroupAdditionProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSIAMUserToGroupAdditionResourceInfo)resourceInfo;
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        REMOVE_USER_FROM_GROUP{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSIAMUserToGroupAdditionResourceAction action = (AWSIAMUserToGroupAdditionResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                boolean seenAllGroups = false;
                boolean foundGroup = false;
                String groupMarker = null;
                block0: while (!seenAllGroups && !foundGroup) {
                    ListGroupsResponseType listGroupsResponseType;
                    ListGroupsType listGroupsType = MessageHelper.createMessage(ListGroupsType.class, action.info.getEffectiveUserId());
                    if (groupMarker != null) {
                        listGroupsType.setMarker(groupMarker);
                    }
                    if ((listGroupsResponseType = (ListGroupsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)listGroupsType)).getListGroupsResult().getIsTruncated() == Boolean.TRUE) {
                        groupMarker = listGroupsResponseType.getListGroupsResult().getMarker();
                    } else {
                        seenAllGroups = true;
                    }
                    if (listGroupsResponseType.getListGroupsResult().getGroups() == null || listGroupsResponseType.getListGroupsResult().getGroups().getMemberList() == null) continue;
                    for (GroupType groupType : listGroupsResponseType.getListGroupsResult().getGroups().getMemberList()) {
                        if (!groupType.getGroupName().equals(action.properties.getGroupName())) continue;
                        foundGroup = true;
                        continue block0;
                    }
                }
                if (!foundGroup) {
                    return action;
                }
                ArrayList realUsersToRemoveFromGroup = Lists.newArrayList();
                HashSet passedInUsers = action.properties.getUsers() == null ? new HashSet() : Sets.newHashSet(action.properties.getUsers());
                boolean seenAllUsers = false;
                String userMarker = null;
                while (!seenAllUsers) {
                    GetGroupResponseType getGroupResponseType;
                    GetGroupType getGroupType = MessageHelper.createMessage(GetGroupType.class, action.info.getEffectiveUserId());
                    getGroupType.setGroupName(action.properties.getGroupName());
                    if (userMarker != null) {
                        getGroupType.setMarker(userMarker);
                    }
                    if ((getGroupResponseType = (GetGroupResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)getGroupType)).getGetGroupResult().getIsTruncated() == Boolean.TRUE) {
                        userMarker = getGroupResponseType.getGetGroupResult().getMarker();
                    } else {
                        seenAllUsers = true;
                    }
                    if (getGroupResponseType.getGetGroupResult().getUsers() == null || getGroupResponseType.getGetGroupResult().getUsers().getMemberList() == null) continue;
                    for (UserType userType : getGroupResponseType.getGetGroupResult().getUsers().getMemberList()) {
                        if (!passedInUsers.contains(userType.getUserName())) continue;
                        realUsersToRemoveFromGroup.add(userType.getUserName());
                    }
                }
                for (String user : realUsersToRemoveFromGroup) {
                    RemoveUserFromGroupType removeUserFromGroupType = MessageHelper.createMessage(RemoveUserFromGroupType.class, action.info.getEffectiveUserId());
                    removeUserFromGroupType.setGroupName(action.properties.getGroupName());
                    removeUserFromGroupType.setUserName(user);
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)removeUserFromGroupType);
                }
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        ADD_USER_TO_GROUP{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSIAMUserToGroupAdditionResourceAction action = (AWSIAMUserToGroupAdditionResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
                boolean seenAllGroups = false;
                boolean foundGroup = false;
                String groupMarker = null;
                block0: while (!seenAllGroups && !foundGroup) {
                    ListGroupsResponseType listGroupsResponseType;
                    ListGroupsType listGroupsType = MessageHelper.createMessage(ListGroupsType.class, action.info.getEffectiveUserId());
                    if (groupMarker != null) {
                        listGroupsType.setMarker(groupMarker);
                    }
                    if ((listGroupsResponseType = (ListGroupsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)listGroupsType)).getListGroupsResult().getIsTruncated() == Boolean.TRUE) {
                        groupMarker = listGroupsResponseType.getListGroupsResult().getMarker();
                    } else {
                        seenAllGroups = true;
                    }
                    if (listGroupsResponseType.getListGroupsResult().getGroups() == null || listGroupsResponseType.getListGroupsResult().getGroups().getMemberList() == null) continue;
                    for (GroupType groupType : listGroupsResponseType.getListGroupsResult().getGroups().getMemberList()) {
                        if (!groupType.getGroupName().equals(action.properties.getGroupName())) continue;
                        foundGroup = true;
                        continue block0;
                    }
                }
                if (!foundGroup) {
                    throw new ValidationErrorException("No such group " + action.properties.getGroupName());
                }
                boolean seenAllUsers = false;
                ArrayList currentUsers = Lists.newArrayList();
                String userMarker = null;
                while (!seenAllUsers) {
                    ListUsersResponseType listUsersResponseType;
                    ListUsersType listUsersType = MessageHelper.createMessage(ListUsersType.class, action.info.getEffectiveUserId());
                    if (userMarker != null) {
                        listUsersType.setMarker(userMarker);
                    }
                    if ((listUsersResponseType = (ListUsersResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)listUsersType)).getListUsersResult().getIsTruncated() == Boolean.TRUE) {
                        userMarker = listUsersResponseType.getListUsersResult().getMarker();
                    } else {
                        seenAllUsers = true;
                    }
                    if (listUsersResponseType.getListUsersResult().getUsers() == null || listUsersResponseType.getListUsersResult().getUsers().getMemberList() == null) continue;
                    for (UserType userType : listUsersResponseType.getListUsersResult().getUsers().getMemberList()) {
                        currentUsers.add(userType.getUserName());
                    }
                }
                ArrayList nonexistantUsers = Lists.newArrayList();
                for (String user : action.properties.getUsers()) {
                    if (currentUsers.contains(user)) continue;
                    nonexistantUsers.add(user);
                }
                if (!nonexistantUsers.isEmpty()) {
                    throw new ValidationErrorException("No such user(s) " + ((Object)nonexistantUsers).toString());
                }
                for (String userName : action.properties.getUsers()) {
                    AddUserToGroupType addUserToGroupType = MessageHelper.createMessage(AddUserToGroupType.class, action.info.getEffectiveUserId());
                    addUserToGroupType.setGroupName(action.properties.getGroupName());
                    addUserToGroupType.setUserName(userName);
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)addUserToGroupType);
                }
                action.info.setPhysicalResourceId(action.getDefaultPhysicalResourceId());
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

