/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.auth.euare.AddUserToGroupType;
import com.eucalyptus.auth.euare.CreateLoginProfileType;
import com.eucalyptus.auth.euare.CreateUserResponseType;
import com.eucalyptus.auth.euare.CreateUserType;
import com.eucalyptus.auth.euare.DeleteUserPolicyType;
import com.eucalyptus.auth.euare.DeleteUserType;
import com.eucalyptus.auth.euare.GroupType;
import com.eucalyptus.auth.euare.ListGroupsForUserResponseType;
import com.eucalyptus.auth.euare.ListGroupsForUserType;
import com.eucalyptus.auth.euare.ListUsersResponseType;
import com.eucalyptus.auth.euare.ListUsersType;
import com.eucalyptus.auth.euare.PutUserPolicyType;
import com.eucalyptus.auth.euare.RemoveUserFromGroupType;
import com.eucalyptus.auth.euare.UserType;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSIAMUserResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSIAMUserProperties;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.EmbeddedIAMPolicy;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Euare;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class AWSIAMUserResourceAction
extends ResourceAction {
    private AWSIAMUserProperties properties = new AWSIAMUserProperties();
    private AWSIAMUserResourceInfo info = new AWSIAMUserResourceInfo();

    public AWSIAMUserResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSIAMUserProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSIAMUserResourceInfo)resourceInfo;
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_USER{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSIAMUserResourceAction action = (AWSIAMUserResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                boolean seenAllUsers = false;
                boolean foundUser = false;
                String userMarker = null;
                block0: while (!seenAllUsers && !foundUser) {
                    ListUsersResponseType listUsersResponseType;
                    ListUsersType listUsersType = MessageHelper.createMessage(ListUsersType.class, action.info.getEffectiveUserId());
                    if (userMarker != null) {
                        listUsersType.setMarker(userMarker);
                    }
                    if ((listUsersResponseType = (ListUsersResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)listUsersType)).getListUsersResult().getIsTruncated() == Boolean.TRUE) {
                        userMarker = listUsersResponseType.getListUsersResult().getMarker();
                    } else {
                        seenAllUsers = true;
                    }
                    if (listUsersResponseType.getListUsersResult().getUsers() == null || listUsersResponseType.getListUsersResult().getUsers().getMemberList() == null) continue;
                    for (UserType UserType2 : listUsersResponseType.getListUsersResult().getUsers().getMemberList()) {
                        if (!UserType2.getUserName().equals(action.info.getPhysicalResourceId())) continue;
                        foundUser = true;
                        continue block0;
                    }
                }
                if (!foundUser) {
                    return action;
                }
                if (action.properties.getGroups() != null) {
                    boolean seenAllGroups = false;
                    ArrayList currentGroups = Lists.newArrayList();
                    String groupMarker = null;
                    while (!seenAllGroups) {
                        ListGroupsForUserResponseType listGroupsForUserResponseType;
                        ListGroupsForUserType listGroupsForUserType = MessageHelper.createMessage(ListGroupsForUserType.class, action.info.getEffectiveUserId());
                        listGroupsForUserType.setUserName(action.info.getPhysicalResourceId());
                        if (groupMarker != null) {
                            listGroupsForUserType.setMarker(groupMarker);
                        }
                        if ((listGroupsForUserResponseType = (ListGroupsForUserResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)listGroupsForUserType)).getListGroupsForUserResult().getIsTruncated() == Boolean.TRUE) {
                            groupMarker = listGroupsForUserResponseType.getListGroupsForUserResult().getMarker();
                        } else {
                            seenAllGroups = true;
                        }
                        if (listGroupsForUserResponseType.getListGroupsForUserResult().getGroups() == null || listGroupsForUserResponseType.getListGroupsForUserResult().getGroups().getMemberList() == null) continue;
                        for (GroupType groupType : listGroupsForUserResponseType.getListGroupsForUserResult().getGroups().getMemberList()) {
                            currentGroups.add(groupType.getGroupName());
                        }
                    }
                    for (String groupName : action.properties.getGroups()) {
                        if (!currentGroups.contains(groupName)) continue;
                        RemoveUserFromGroupType removeUserFromGroupType = MessageHelper.createMessage(RemoveUserFromGroupType.class, action.info.getEffectiveUserId());
                        removeUserFromGroupType.setGroupName(groupName);
                        removeUserFromGroupType.setUserName(action.info.getPhysicalResourceId());
                        AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)removeUserFromGroupType);
                    }
                }
                if (action.properties.getPolicies() != null) {
                    for (EmbeddedIAMPolicy policy : action.properties.getPolicies()) {
                        DeleteUserPolicyType deleteUserPolicyType = MessageHelper.createMessage(DeleteUserPolicyType.class, action.info.getEffectiveUserId());
                        deleteUserPolicyType.setUserName(action.info.getPhysicalResourceId());
                        deleteUserPolicyType.setPolicyName(policy.getPolicyName());
                        AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deleteUserPolicyType);
                    }
                }
                DeleteUserType deleteUserType = MessageHelper.createMessage(DeleteUserType.class, action.info.getEffectiveUserId());
                deleteUserType.setUserName(action.info.getPhysicalResourceId());
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deleteUserType);
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_USER{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSIAMUserResourceAction action = (AWSIAMUserResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
                String userName = action.getDefaultPhysicalResourceId();
                CreateUserType createUserType = MessageHelper.createMessage(CreateUserType.class, action.info.getEffectiveUserId());
                createUserType.setUserName(userName);
                createUserType.setPath(action.properties.getPath());
                CreateUserResponseType createUserResponseType = (CreateUserResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createUserType);
                String arn = createUserResponseType.getCreateUserResult().getUser().getArn();
                action.info.setPhysicalResourceId(userName);
                action.info.setArn(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(arn)));
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        }
        ,
        ADD_LOGIN_PROFILE{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSIAMUserResourceAction action = (AWSIAMUserResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
                if (action.properties.getLoginProfile() != null) {
                    CreateLoginProfileType createLoginProfileType = MessageHelper.createMessage(CreateLoginProfileType.class, action.info.getEffectiveUserId());
                    createLoginProfileType.setPassword(action.properties.getLoginProfile().getPassword());
                    createLoginProfileType.setUserName(action.info.getPhysicalResourceId());
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createLoginProfileType);
                }
                return action;
            }
        }
        ,
        ADD_POLICIES{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSIAMUserResourceAction action = (AWSIAMUserResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
                if (action.properties.getPolicies() != null) {
                    for (EmbeddedIAMPolicy policy : action.properties.getPolicies()) {
                        PutUserPolicyType putUserPolicyType = MessageHelper.createMessage(PutUserPolicyType.class, action.info.getEffectiveUserId());
                        putUserPolicyType.setUserName(action.info.getPhysicalResourceId());
                        putUserPolicyType.setPolicyName(policy.getPolicyName());
                        putUserPolicyType.setPolicyDocument(policy.getPolicyDocument().toString());
                        AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)putUserPolicyType);
                    }
                }
                return action;
            }
        }
        ,
        ADD_GROUPS{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSIAMUserResourceAction action = (AWSIAMUserResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
                if (action.properties.getGroups() != null) {
                    for (String groupName : action.properties.getGroups()) {
                        AddUserToGroupType addUserToGroupType = MessageHelper.createMessage(AddUserToGroupType.class, action.info.getEffectiveUserId());
                        addUserToGroupType.setGroupName(groupName);
                        addUserToGroupType.setUserName(action.info.getPhysicalResourceId());
                        AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)addUserToGroupType);
                    }
                }
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

