/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.auth.euare.CreateRoleResponseType;
import com.eucalyptus.auth.euare.CreateRoleType;
import com.eucalyptus.auth.euare.DeleteRolePolicyType;
import com.eucalyptus.auth.euare.DeleteRoleType;
import com.eucalyptus.auth.euare.ListRolesResponseType;
import com.eucalyptus.auth.euare.ListRolesType;
import com.eucalyptus.auth.euare.PutRolePolicyType;
import com.eucalyptus.auth.euare.RoleType;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSIAMRoleResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSIAMRoleProperties;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.EmbeddedIAMPolicy;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Euare;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.List;
import javax.annotation.Nullable;

public class AWSIAMRoleResourceAction
extends ResourceAction {
    private AWSIAMRoleProperties properties = new AWSIAMRoleProperties();
    private AWSIAMRoleResourceInfo info = new AWSIAMRoleResourceInfo();

    public AWSIAMRoleResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSIAMRoleProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSIAMRoleResourceInfo)resourceInfo;
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_ROLE{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSIAMRoleResourceAction action = (AWSIAMRoleResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                boolean seenAllRoles = false;
                boolean foundRole = false;
                String RoleMarker = null;
                block0: while (!seenAllRoles && !foundRole) {
                    ListRolesResponseType listRolesResponseType;
                    ListRolesType listRolesType = MessageHelper.createMessage(ListRolesType.class, action.info.getEffectiveUserId());
                    if (RoleMarker != null) {
                        listRolesType.setMarker(RoleMarker);
                    }
                    if ((listRolesResponseType = (ListRolesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)listRolesType)).getListRolesResult().getIsTruncated() == Boolean.TRUE) {
                        RoleMarker = listRolesResponseType.getListRolesResult().getMarker();
                    } else {
                        seenAllRoles = true;
                    }
                    if (listRolesResponseType.getListRolesResult().getRoles() == null || listRolesResponseType.getListRolesResult().getRoles().getMember() == null) continue;
                    for (RoleType roleType : listRolesResponseType.getListRolesResult().getRoles().getMember()) {
                        if (!roleType.getRoleName().equals(action.info.getPhysicalResourceId())) continue;
                        foundRole = true;
                        continue block0;
                    }
                }
                if (!foundRole) {
                    return action;
                }
                if (action.properties.getPolicies() != null) {
                    for (EmbeddedIAMPolicy policy : action.properties.getPolicies()) {
                        DeleteRolePolicyType deleteRolePolicyType = MessageHelper.createMessage(DeleteRolePolicyType.class, action.info.getEffectiveUserId());
                        deleteRolePolicyType.setRoleName(action.info.getPhysicalResourceId());
                        deleteRolePolicyType.setPolicyName(policy.getPolicyName());
                        AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deleteRolePolicyType);
                    }
                }
                DeleteRoleType deleteRoleType = MessageHelper.createMessage(DeleteRoleType.class, action.info.getEffectiveUserId());
                deleteRoleType.setRoleName(action.info.getPhysicalResourceId());
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deleteRoleType);
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_ROLE{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSIAMRoleResourceAction action = (AWSIAMRoleResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
                String roleName = action.getDefaultPhysicalResourceId();
                CreateRoleType createRoleType = MessageHelper.createMessage(CreateRoleType.class, action.info.getEffectiveUserId());
                createRoleType.setRoleName(roleName);
                createRoleType.setPath(action.properties.getPath());
                createRoleType.setAssumeRolePolicyDocument(action.properties.getAssumeRolePolicyDocument().toString());
                CreateRoleResponseType createRoleResponseType = (CreateRoleResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createRoleType);
                String arn = createRoleResponseType.getCreateRoleResult().getRole().getArn();
                action.info.setPhysicalResourceId(roleName);
                action.info.setArn(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(arn)));
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        }
        ,
        ADD_POLICIES{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSIAMRoleResourceAction action = (AWSIAMRoleResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
                if (action.properties.getPolicies() != null) {
                    for (EmbeddedIAMPolicy policy : action.properties.getPolicies()) {
                        PutRolePolicyType putRolePolicyType = MessageHelper.createMessage(PutRolePolicyType.class, action.info.getEffectiveUserId());
                        putRolePolicyType.setRoleName(action.info.getPhysicalResourceId());
                        putRolePolicyType.setPolicyName(policy.getPolicyName());
                        putRolePolicyType.setPolicyDocument(policy.getPolicyDocument().toString());
                        AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)putRolePolicyType);
                    }
                }
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

