/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.auth.euare.DeleteGroupPolicyType;
import com.eucalyptus.auth.euare.DeleteRolePolicyType;
import com.eucalyptus.auth.euare.DeleteUserPolicyType;
import com.eucalyptus.auth.euare.GroupType;
import com.eucalyptus.auth.euare.ListGroupsResponseType;
import com.eucalyptus.auth.euare.ListGroupsType;
import com.eucalyptus.auth.euare.ListRolesResponseType;
import com.eucalyptus.auth.euare.ListRolesType;
import com.eucalyptus.auth.euare.ListUsersResponseType;
import com.eucalyptus.auth.euare.ListUsersType;
import com.eucalyptus.auth.euare.PutGroupPolicyType;
import com.eucalyptus.auth.euare.PutRolePolicyType;
import com.eucalyptus.auth.euare.PutUserPolicyType;
import com.eucalyptus.auth.euare.RoleType;
import com.eucalyptus.auth.euare.UserType;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSIAMPolicyResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSIAMPolicyProperties;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Euare;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

public class AWSIAMPolicyResourceAction
extends ResourceAction {
    private AWSIAMPolicyProperties properties = new AWSIAMPolicyProperties();
    private AWSIAMPolicyResourceInfo info = new AWSIAMPolicyResourceInfo();

    public AWSIAMPolicyResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSIAMPolicyProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSIAMPolicyResourceInfo)resourceInfo;
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_POLICY{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSIAMPolicyResourceAction action = (AWSIAMPolicyResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                if (action.properties.getRoles() != null && action.properties.getRoles().size() > 0) {
                    ArrayList realRolesToRemovePolicyFrom = Lists.newArrayList();
                    HashSet passedInRoles = action.properties.getRoles() == null ? new HashSet() : Sets.newHashSet(action.properties.getRoles());
                    boolean seenAllRoles = false;
                    String roleMarker = null;
                    while (!seenAllRoles) {
                        ListRolesResponseType listRolesResponseType;
                        ListRolesType listRolesType = MessageHelper.createMessage(ListRolesType.class, action.info.getEffectiveUserId());
                        if (roleMarker != null) {
                            listRolesType.setMarker(roleMarker);
                        }
                        if ((listRolesResponseType = (ListRolesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)listRolesType)).getListRolesResult().getIsTruncated() == Boolean.TRUE) {
                            roleMarker = listRolesResponseType.getListRolesResult().getMarker();
                        } else {
                            seenAllRoles = true;
                        }
                        if (listRolesResponseType.getListRolesResult().getRoles() == null || listRolesResponseType.getListRolesResult().getRoles().getMember() == null) continue;
                        for (RoleType roleType : listRolesResponseType.getListRolesResult().getRoles().getMember()) {
                            if (!passedInRoles.contains(roleType.getRoleName())) continue;
                            realRolesToRemovePolicyFrom.add(roleType.getRoleName());
                        }
                    }
                    for (String role : realRolesToRemovePolicyFrom) {
                        DeleteRolePolicyType deleteRolePolicyType = MessageHelper.createMessage(DeleteRolePolicyType.class, action.info.getEffectiveUserId());
                        deleteRolePolicyType.setRoleName(role);
                        deleteRolePolicyType.setPolicyName(action.properties.getPolicyName());
                        AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deleteRolePolicyType);
                    }
                }
                if (action.properties.getUsers() != null && action.properties.getUsers().size() > 0) {
                    ArrayList realUsersToRemovePolicyFrom = Lists.newArrayList();
                    HashSet passedInUsers = action.properties.getUsers() == null ? new HashSet() : Sets.newHashSet(action.properties.getUsers());
                    boolean seenAllUsers = false;
                    String userMarker = null;
                    while (!seenAllUsers) {
                        ListUsersResponseType listUsersResponseType;
                        ListUsersType listUsersType = MessageHelper.createMessage(ListUsersType.class, action.info.getEffectiveUserId());
                        if (userMarker != null) {
                            listUsersType.setMarker(userMarker);
                        }
                        if ((listUsersResponseType = (ListUsersResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)listUsersType)).getListUsersResult().getIsTruncated() == Boolean.TRUE) {
                            userMarker = listUsersResponseType.getListUsersResult().getMarker();
                        } else {
                            seenAllUsers = true;
                        }
                        if (listUsersResponseType.getListUsersResult().getUsers() == null || listUsersResponseType.getListUsersResult().getUsers().getMemberList() == null) continue;
                        for (UserType userType : listUsersResponseType.getListUsersResult().getUsers().getMemberList()) {
                            if (!passedInUsers.contains(userType.getUserName())) continue;
                            realUsersToRemovePolicyFrom.add(userType.getUserName());
                        }
                    }
                    for (String user : realUsersToRemovePolicyFrom) {
                        DeleteUserPolicyType deleteUserPolicyType = MessageHelper.createMessage(DeleteUserPolicyType.class, action.info.getEffectiveUserId());
                        deleteUserPolicyType.setUserName(user);
                        deleteUserPolicyType.setPolicyName(action.properties.getPolicyName());
                        AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deleteUserPolicyType);
                    }
                }
                if (action.properties.getGroups() != null && action.properties.getGroups().size() > 0) {
                    ArrayList realGroupsToRemovePolicyFrom = Lists.newArrayList();
                    HashSet passedInGroups = action.properties.getGroups() == null ? new HashSet() : Sets.newHashSet(action.properties.getGroups());
                    boolean seenAllGroups = false;
                    String groupMarker = null;
                    while (!seenAllGroups) {
                        ListGroupsResponseType listGroupsResponseType;
                        ListGroupsType listGroupsType = MessageHelper.createMessage(ListGroupsType.class, action.info.getEffectiveUserId());
                        if (groupMarker != null) {
                            listGroupsType.setMarker(groupMarker);
                        }
                        if ((listGroupsResponseType = (ListGroupsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)listGroupsType)).getListGroupsResult().getIsTruncated() == Boolean.TRUE) {
                            groupMarker = listGroupsResponseType.getListGroupsResult().getMarker();
                        } else {
                            seenAllGroups = true;
                        }
                        if (listGroupsResponseType.getListGroupsResult().getGroups() == null || listGroupsResponseType.getListGroupsResult().getGroups().getMemberList() == null) continue;
                        for (GroupType groupType : listGroupsResponseType.getListGroupsResult().getGroups().getMemberList()) {
                            if (!passedInGroups.contains(groupType.getGroupName())) continue;
                            realGroupsToRemovePolicyFrom.add(groupType.getGroupName());
                        }
                    }
                    for (String group : realGroupsToRemovePolicyFrom) {
                        DeleteGroupPolicyType deleteGroupPolicyType = MessageHelper.createMessage(DeleteGroupPolicyType.class, action.info.getEffectiveUserId());
                        deleteGroupPolicyType.setGroupName(group);
                        deleteGroupPolicyType.setPolicyName(action.properties.getPolicyName());
                        AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deleteGroupPolicyType);
                    }
                }
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_POLICY{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSIAMPolicyResourceAction action = (AWSIAMPolicyResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
                action.info.setPhysicalResourceId(action.getDefaultPhysicalResourceId());
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        }
        ,
        ATTACH_TO_GROUPS{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSIAMPolicyResourceAction action = (AWSIAMPolicyResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
                if (action.properties.getGroups() != null) {
                    for (String groupName : action.properties.getGroups()) {
                        PutGroupPolicyType putGroupPolicyType = MessageHelper.createMessage(PutGroupPolicyType.class, action.info.getEffectiveUserId());
                        putGroupPolicyType.setGroupName(groupName);
                        putGroupPolicyType.setPolicyName(action.properties.getPolicyName());
                        putGroupPolicyType.setPolicyDocument(action.properties.getPolicyDocument().toString());
                        AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)putGroupPolicyType);
                    }
                }
                return action;
            }
        }
        ,
        ATTACH_TO_USERS{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSIAMPolicyResourceAction action = (AWSIAMPolicyResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
                if (action.properties.getUsers() != null) {
                    for (String userName : action.properties.getUsers()) {
                        PutUserPolicyType putUserPolicyType = MessageHelper.createMessage(PutUserPolicyType.class, action.info.getEffectiveUserId());
                        putUserPolicyType.setUserName(userName);
                        putUserPolicyType.setPolicyName(action.properties.getPolicyName());
                        putUserPolicyType.setPolicyDocument(action.properties.getPolicyDocument().toString());
                        AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)putUserPolicyType);
                    }
                }
                return action;
            }
        }
        ,
        ATTACH_TO_ROLES{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSIAMPolicyResourceAction action = (AWSIAMPolicyResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
                if (action.properties.getRoles() != null) {
                    for (String roleName : action.properties.getRoles()) {
                        PutRolePolicyType putRolePolicyType = MessageHelper.createMessage(PutRolePolicyType.class, action.info.getEffectiveUserId());
                        putRolePolicyType.setRoleName(roleName);
                        putRolePolicyType.setPolicyName(action.properties.getPolicyName());
                        putRolePolicyType.setPolicyDocument(action.properties.getPolicyDocument().toString());
                        AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)putRolePolicyType);
                    }
                }
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

