/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.auth.euare.CreateGroupResponseType;
import com.eucalyptus.auth.euare.CreateGroupType;
import com.eucalyptus.auth.euare.DeleteGroupPolicyType;
import com.eucalyptus.auth.euare.DeleteGroupType;
import com.eucalyptus.auth.euare.GroupType;
import com.eucalyptus.auth.euare.ListGroupsResponseType;
import com.eucalyptus.auth.euare.ListGroupsType;
import com.eucalyptus.auth.euare.PutGroupPolicyType;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSIAMGroupResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSIAMGroupProperties;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.EmbeddedIAMPolicy;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Euare;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.List;
import javax.annotation.Nullable;

public class AWSIAMGroupResourceAction
extends ResourceAction {
    private AWSIAMGroupProperties properties = new AWSIAMGroupProperties();
    private AWSIAMGroupResourceInfo info = new AWSIAMGroupResourceInfo();

    public AWSIAMGroupResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSIAMGroupProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSIAMGroupResourceInfo)resourceInfo;
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_GROUP{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSIAMGroupResourceAction action = (AWSIAMGroupResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                boolean seenAllGroups = false;
                boolean foundGroup = false;
                String groupMarker = null;
                block0: while (!seenAllGroups && !foundGroup) {
                    ListGroupsResponseType listGroupsResponseType;
                    ListGroupsType listGroupsType = MessageHelper.createMessage(ListGroupsType.class, action.info.getEffectiveUserId());
                    if (groupMarker != null) {
                        listGroupsType.setMarker(groupMarker);
                    }
                    if ((listGroupsResponseType = (ListGroupsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)listGroupsType)).getListGroupsResult().getIsTruncated() == Boolean.TRUE) {
                        groupMarker = listGroupsResponseType.getListGroupsResult().getMarker();
                    } else {
                        seenAllGroups = true;
                    }
                    if (listGroupsResponseType.getListGroupsResult().getGroups() == null || listGroupsResponseType.getListGroupsResult().getGroups().getMemberList() == null) continue;
                    for (GroupType groupType : listGroupsResponseType.getListGroupsResult().getGroups().getMemberList()) {
                        if (!groupType.getGroupName().equals(action.info.getPhysicalResourceId())) continue;
                        foundGroup = true;
                        continue block0;
                    }
                }
                if (!foundGroup) {
                    return action;
                }
                if (action.properties.getPolicies() != null) {
                    for (EmbeddedIAMPolicy policy : action.properties.getPolicies()) {
                        DeleteGroupPolicyType deleteGroupPolicyType = MessageHelper.createMessage(DeleteGroupPolicyType.class, action.info.getEffectiveUserId());
                        deleteGroupPolicyType.setGroupName(action.info.getPhysicalResourceId());
                        deleteGroupPolicyType.setPolicyName(policy.getPolicyName());
                        AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deleteGroupPolicyType);
                    }
                }
                DeleteGroupType deleteGroupType = MessageHelper.createMessage(DeleteGroupType.class, action.info.getEffectiveUserId());
                deleteGroupType.setGroupName(action.info.getPhysicalResourceId());
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deleteGroupType);
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_GROUP{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSIAMGroupResourceAction action = (AWSIAMGroupResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
                String groupName = action.getDefaultPhysicalResourceId();
                CreateGroupType createGroupType = MessageHelper.createMessage(CreateGroupType.class, action.info.getEffectiveUserId());
                createGroupType.setGroupName(groupName);
                createGroupType.setPath(action.properties.getPath());
                CreateGroupResponseType createGroupResponseType = (CreateGroupResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createGroupType);
                String arn = createGroupResponseType.getCreateGroupResult().getGroup().getArn();
                action.info.setPhysicalResourceId(groupName);
                action.info.setArn(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(arn)));
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        }
        ,
        ADD_POLICIES{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSIAMGroupResourceAction action = (AWSIAMGroupResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
                if (action.properties.getPolicies() != null) {
                    for (EmbeddedIAMPolicy policy : action.properties.getPolicies()) {
                        PutGroupPolicyType putGroupPolicyType = MessageHelper.createMessage(PutGroupPolicyType.class, action.info.getEffectiveUserId());
                        putGroupPolicyType.setGroupName(action.info.getPhysicalResourceId());
                        putGroupPolicyType.setPolicyName(policy.getPolicyName());
                        putGroupPolicyType.setPolicyDocument(policy.getPolicyDocument().toString());
                        AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)putGroupPolicyType);
                    }
                }
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

