/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.auth.euare.AccessKeyMetadataType;
import com.eucalyptus.auth.euare.CreateAccessKeyResponseType;
import com.eucalyptus.auth.euare.CreateAccessKeyType;
import com.eucalyptus.auth.euare.DeleteAccessKeyType;
import com.eucalyptus.auth.euare.ListAccessKeysResponseType;
import com.eucalyptus.auth.euare.ListAccessKeysType;
import com.eucalyptus.auth.euare.ListUsersResponseType;
import com.eucalyptus.auth.euare.ListUsersType;
import com.eucalyptus.auth.euare.UpdateAccessKeyType;
import com.eucalyptus.auth.euare.UserType;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSIAMAccessKeyResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSIAMAccessKeyProperties;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Euare;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.List;
import javax.annotation.Nullable;

public class AWSIAMAccessKeyResourceAction
extends ResourceAction {
    private AWSIAMAccessKeyProperties properties = new AWSIAMAccessKeyProperties();
    private AWSIAMAccessKeyResourceInfo info = new AWSIAMAccessKeyResourceInfo();

    public AWSIAMAccessKeyResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSIAMAccessKeyProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSIAMAccessKeyResourceInfo)resourceInfo;
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_KEY{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSIAMAccessKeyResourceAction action = (AWSIAMAccessKeyResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                if (action.properties.getStatus() == null) {
                    action.properties.setStatus("Active");
                }
                boolean seenAllUsers = false;
                boolean foundUser = false;
                String userMarker = null;
                block0: while (!seenAllUsers && !foundUser) {
                    ListUsersResponseType listUsersResponseType;
                    ListUsersType listUsersType = MessageHelper.createMessage(ListUsersType.class, action.info.getEffectiveUserId());
                    if (userMarker != null) {
                        listUsersType.setMarker(userMarker);
                    }
                    if ((listUsersResponseType = (ListUsersResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)listUsersType)).getListUsersResult().getIsTruncated() == Boolean.TRUE) {
                        userMarker = listUsersResponseType.getListUsersResult().getMarker();
                    } else {
                        seenAllUsers = true;
                    }
                    if (listUsersResponseType.getListUsersResult().getUsers() == null || listUsersResponseType.getListUsersResult().getUsers().getMemberList() == null) continue;
                    for (UserType userType : listUsersResponseType.getListUsersResult().getUsers().getMemberList()) {
                        if (!userType.getUserName().equals(action.properties.getUserName())) continue;
                        foundUser = true;
                        continue block0;
                    }
                }
                if (!foundUser) {
                    return action;
                }
                boolean seenAllAccessKeys = false;
                boolean foundAccessKey = false;
                String accessKeyMarker = null;
                block2: while (!seenAllAccessKeys && !foundAccessKey) {
                    ListAccessKeysResponseType listAccessKeysResponseType;
                    ListAccessKeysType listAccessKeysType = MessageHelper.createMessage(ListAccessKeysType.class, action.info.getEffectiveUserId());
                    listAccessKeysType.setUserName(action.properties.getUserName());
                    if (accessKeyMarker != null) {
                        listAccessKeysType.setMarker(accessKeyMarker);
                    }
                    if ((listAccessKeysResponseType = (ListAccessKeysResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)listAccessKeysType)).getListAccessKeysResult().getIsTruncated() == Boolean.TRUE) {
                        accessKeyMarker = listAccessKeysResponseType.getListAccessKeysResult().getMarker();
                    } else {
                        seenAllAccessKeys = true;
                    }
                    if (listAccessKeysResponseType.getListAccessKeysResult().getAccessKeyMetadata() == null || listAccessKeysResponseType.getListAccessKeysResult().getAccessKeyMetadata().getMemberList() == null) continue;
                    for (AccessKeyMetadataType accessKeyMetadataType : listAccessKeysResponseType.getListAccessKeysResult().getAccessKeyMetadata().getMemberList()) {
                        if (!accessKeyMetadataType.getAccessKeyId().equals(action.info.getPhysicalResourceId())) continue;
                        foundAccessKey = true;
                        continue block2;
                    }
                }
                if (!foundAccessKey) {
                    return action;
                }
                DeleteAccessKeyType deleteAccessKeyType = MessageHelper.createMessage(DeleteAccessKeyType.class, action.info.getEffectiveUserId());
                deleteAccessKeyType.setUserName(action.properties.getUserName());
                deleteAccessKeyType.setAccessKeyId(action.info.getPhysicalResourceId());
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deleteAccessKeyType);
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_KEY{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSIAMAccessKeyResourceAction action = (AWSIAMAccessKeyResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
                if (action.properties.getStatus() == null) {
                    action.properties.setStatus("Active");
                }
                if (!"Active".equals(action.properties.getStatus()) && !"Inactive".equals(action.properties.getStatus())) {
                    throw new ValidationErrorException("Invalid status " + action.properties.getStatus());
                }
                CreateAccessKeyType createAccessKeyType = MessageHelper.createMessage(CreateAccessKeyType.class, action.info.getEffectiveUserId());
                createAccessKeyType.setUserName(action.properties.getUserName());
                CreateAccessKeyResponseType createAccessKeyResponseType = (CreateAccessKeyResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createAccessKeyType);
                action.info.setPhysicalResourceId(createAccessKeyResponseType.getCreateAccessKeyResult().getAccessKey().getAccessKeyId());
                action.info.setSecretAccessKey(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(createAccessKeyResponseType.getCreateAccessKeyResult().getAccessKey().getSecretAccessKey())));
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        }
        ,
        SET_STATUS{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSIAMAccessKeyResourceAction action = (AWSIAMAccessKeyResourceAction)resourceAction;
                if (action.properties.getStatus() == null) {
                    action.properties.setStatus("Active");
                }
                ServiceConfiguration configuration = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
                UpdateAccessKeyType updateAccessKeyType = MessageHelper.createMessage(UpdateAccessKeyType.class, action.info.getEffectiveUserId());
                updateAccessKeyType.setUserName(action.properties.getUserName());
                updateAccessKeyType.setAccessKeyId(action.info.getPhysicalResourceId());
                updateAccessKeyType.setStatus(action.properties.getStatus());
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)updateAccessKeyType);
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

