/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSElasticLoadBalancingLoadBalancerResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSElasticLoadBalancingLoadBalancerProperties;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.ElasticLoadBalancingListener;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.ElasticLoadBalancingPolicyType;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.ElasticLoadBalancingPolicyTypeAttribute;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.loadbalancing.common.LoadBalancing;
import com.eucalyptus.loadbalancing.common.msgs.AvailabilityZones;
import com.eucalyptus.loadbalancing.common.msgs.ConfigureHealthCheckType;
import com.eucalyptus.loadbalancing.common.msgs.CreateAppCookieStickinessPolicyType;
import com.eucalyptus.loadbalancing.common.msgs.CreateLBCookieStickinessPolicyType;
import com.eucalyptus.loadbalancing.common.msgs.CreateLoadBalancerPolicyType;
import com.eucalyptus.loadbalancing.common.msgs.CreateLoadBalancerResponseType;
import com.eucalyptus.loadbalancing.common.msgs.CreateLoadBalancerType;
import com.eucalyptus.loadbalancing.common.msgs.DeleteLoadBalancerType;
import com.eucalyptus.loadbalancing.common.msgs.DescribeLoadBalancersResponseType;
import com.eucalyptus.loadbalancing.common.msgs.DescribeLoadBalancersType;
import com.eucalyptus.loadbalancing.common.msgs.HealthCheck;
import com.eucalyptus.loadbalancing.common.msgs.Instance;
import com.eucalyptus.loadbalancing.common.msgs.Instances;
import com.eucalyptus.loadbalancing.common.msgs.Listener;
import com.eucalyptus.loadbalancing.common.msgs.Listeners;
import com.eucalyptus.loadbalancing.common.msgs.LoadBalancerDescription;
import com.eucalyptus.loadbalancing.common.msgs.LoadBalancerNames;
import com.eucalyptus.loadbalancing.common.msgs.PolicyAttribute;
import com.eucalyptus.loadbalancing.common.msgs.PolicyAttributes;
import com.eucalyptus.loadbalancing.common.msgs.PolicyNames;
import com.eucalyptus.loadbalancing.common.msgs.RegisterInstancesWithLoadBalancerType;
import com.eucalyptus.loadbalancing.common.msgs.SecurityGroups;
import com.eucalyptus.loadbalancing.common.msgs.SetLoadBalancerPoliciesOfListenerType;
import com.eucalyptus.loadbalancing.common.msgs.Subnets;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class AWSElasticLoadBalancingLoadBalancerResourceAction
extends ResourceAction {
    private AWSElasticLoadBalancingLoadBalancerProperties properties = new AWSElasticLoadBalancingLoadBalancerProperties();
    private AWSElasticLoadBalancingLoadBalancerResourceInfo info = new AWSElasticLoadBalancingLoadBalancerResourceInfo();

    public AWSElasticLoadBalancingLoadBalancerResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSElasticLoadBalancingLoadBalancerProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSElasticLoadBalancingLoadBalancerResourceInfo)resourceInfo;
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_LOAD_BALANCER{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSElasticLoadBalancingLoadBalancerResourceAction action = (AWSElasticLoadBalancingLoadBalancerResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(LoadBalancing.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                DescribeLoadBalancersType describeLoadBalancersType = MessageHelper.createMessage(DescribeLoadBalancersType.class, action.info.getEffectiveUserId());
                LoadBalancerNames loadBalancerNames = new LoadBalancerNames();
                ArrayList member = Lists.newArrayList((Object[])new String[]{action.info.getPhysicalResourceId()});
                loadBalancerNames.setMember(member);
                describeLoadBalancersType.setLoadBalancerNames(loadBalancerNames);
                DescribeLoadBalancersResponseType describeLoadBalancersResponseType = (DescribeLoadBalancersResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeLoadBalancersType);
                if (describeLoadBalancersResponseType != null && describeLoadBalancersResponseType.getDescribeLoadBalancersResult() != null && describeLoadBalancersResponseType.getDescribeLoadBalancersResult().getLoadBalancerDescriptions() != null && describeLoadBalancersResponseType.getDescribeLoadBalancersResult().getLoadBalancerDescriptions().getMember() != null && describeLoadBalancersResponseType.getDescribeLoadBalancersResult().getLoadBalancerDescriptions().getMember().size() == 1) {
                    DeleteLoadBalancerType deleteLoadBalancerType = MessageHelper.createMessage(DeleteLoadBalancerType.class, action.info.getEffectiveUserId());
                    deleteLoadBalancerType.setLoadBalancerName(action.info.getPhysicalResourceId());
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deleteLoadBalancerType);
                }
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_LOAD_BALANCER{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                ArrayList member;
                AWSElasticLoadBalancingLoadBalancerResourceAction action = (AWSElasticLoadBalancingLoadBalancerResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(LoadBalancing.class, (Partition[])new Partition[0]);
                CreateLoadBalancerType createLoadBalancerType = MessageHelper.createMessage(CreateLoadBalancerType.class, action.info.getEffectiveUserId());
                if (action.properties.getLoadBalancerName() == null) {
                    createLoadBalancerType.setLoadBalancerName(action.getDefaultPhysicalResourceId(32));
                } else {
                    createLoadBalancerType.setLoadBalancerName(action.properties.getLoadBalancerName());
                }
                if (action.properties.getAvailabilityZones() != null && !action.properties.getAvailabilityZones().isEmpty()) {
                    AvailabilityZones availabilityZones = new AvailabilityZones();
                    member = Lists.newArrayList(action.properties.getAvailabilityZones());
                    availabilityZones.setMember(member);
                    createLoadBalancerType.setAvailabilityZones(availabilityZones);
                }
                if (action.properties.getListeners() != null) {
                    Listeners listeners = new Listeners();
                    member = Lists.newArrayList();
                    for (ElasticLoadBalancingListener elasticLoadBalancingListener : action.properties.getListeners()) {
                        Listener listener = new Listener();
                        listener.setInstancePort(elasticLoadBalancingListener.getInstancePort());
                        listener.setInstanceProtocol(elasticLoadBalancingListener.getInstanceProtocol());
                        listener.setLoadBalancerPort(elasticLoadBalancingListener.getLoadBalancerPort());
                        listener.setProtocol(elasticLoadBalancingListener.getProtocol());
                        listener.setSSLCertificateId(elasticLoadBalancingListener.getSslCertificateId());
                        member.add(listener);
                    }
                    listeners.setMember(member);
                    createLoadBalancerType.setListeners(listeners);
                }
                createLoadBalancerType.setScheme(action.properties.getScheme());
                if (action.properties.getSecurityGroups() != null && !action.properties.getSecurityGroups().isEmpty()) {
                    SecurityGroups securityGroups = new SecurityGroups();
                    member = Lists.newArrayList(action.properties.getSecurityGroups());
                    securityGroups.setMember(member);
                    createLoadBalancerType.setSecurityGroups(securityGroups);
                }
                if (action.properties.getSubnets() != null && !action.properties.getSubnets().isEmpty()) {
                    Subnets subnets = new Subnets();
                    member = Lists.newArrayList(action.properties.getSubnets());
                    subnets.setMember(member);
                    createLoadBalancerType.setSubnets(subnets);
                }
                CreateLoadBalancerResponseType createLoadBalancerResponseType = (CreateLoadBalancerResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createLoadBalancerType);
                action.info.setPhysicalResourceId(createLoadBalancerType.getLoadBalancerName());
                action.info.setDnsName(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(createLoadBalancerResponseType.getCreateLoadBalancerResult().getDnsName())));
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        }
        ,
        ADD_INSTANCES_TO_LOAD_BALANCER{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSElasticLoadBalancingLoadBalancerResourceAction action = (AWSElasticLoadBalancingLoadBalancerResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(LoadBalancing.class, (Partition[])new Partition[0]);
                if (action.properties.getInstances() != null && !action.properties.getInstances().isEmpty()) {
                    RegisterInstancesWithLoadBalancerType registerInstancesWithLoadBalancerType = MessageHelper.createMessage(RegisterInstancesWithLoadBalancerType.class, action.info.getEffectiveUserId());
                    registerInstancesWithLoadBalancerType.setLoadBalancerName(action.info.getPhysicalResourceId());
                    Instances instances = new Instances();
                    ArrayList member = Lists.newArrayList();
                    for (String instanceId : action.properties.getInstances()) {
                        Instance instance = new Instance();
                        instance.setInstanceId(instanceId);
                        member.add(instance);
                    }
                    instances.setMember(member);
                    registerInstancesWithLoadBalancerType.setInstances(instances);
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)registerInstancesWithLoadBalancerType);
                }
                return action;
            }
        }
        ,
        ADD_HEALTH_CHECK_TO_LOAD_BALANCER{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSElasticLoadBalancingLoadBalancerResourceAction action = (AWSElasticLoadBalancingLoadBalancerResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(LoadBalancing.class, (Partition[])new Partition[0]);
                if (action.properties.getHealthCheck() != null) {
                    ConfigureHealthCheckType configureHealthCheckType = MessageHelper.createMessage(ConfigureHealthCheckType.class, action.info.getEffectiveUserId());
                    configureHealthCheckType.setLoadBalancerName(action.info.getPhysicalResourceId());
                    HealthCheck healthCheck = new HealthCheck();
                    healthCheck.setHealthyThreshold(action.properties.getHealthCheck().getHealthyThreshold());
                    healthCheck.setInterval(action.properties.getHealthCheck().getInterval());
                    healthCheck.setTarget(action.properties.getHealthCheck().getTarget());
                    healthCheck.setTimeout(action.properties.getHealthCheck().getTimeout());
                    healthCheck.setUnhealthyThreshold(action.properties.getHealthCheck().getUnhealthyThreshold());
                    configureHealthCheckType.setHealthCheck(healthCheck);
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)configureHealthCheckType);
                }
                return action;
            }
        }
        ,
        ADD_POLICIES_TO_LOAD_BALANCER{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSElasticLoadBalancingLoadBalancerResourceAction action = (AWSElasticLoadBalancingLoadBalancerResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(LoadBalancing.class, (Partition[])new Partition[0]);
                if (action.properties.getPolicies() != null) {
                    for (ElasticLoadBalancingPolicyType elasticLoadBalancingPropertyType : action.properties.getPolicies()) {
                        CreateLoadBalancerPolicyType createLoadBalancerPolicyType = MessageHelper.createMessage(CreateLoadBalancerPolicyType.class, action.info.getEffectiveUserId());
                        createLoadBalancerPolicyType.setLoadBalancerName(action.info.getPhysicalResourceId());
                        if (elasticLoadBalancingPropertyType.getAttributes() != null) {
                            PolicyAttributes policyAttributes = new PolicyAttributes();
                            ArrayList member = Lists.newArrayList();
                            for (ElasticLoadBalancingPolicyTypeAttribute elasticLoadBalancingPolicyTypeAttribute : elasticLoadBalancingPropertyType.getAttributes()) {
                                PolicyAttribute policyAttribute = new PolicyAttribute();
                                policyAttribute.setAttributeName(elasticLoadBalancingPolicyTypeAttribute.getName());
                                policyAttribute.setAttributeValue(elasticLoadBalancingPolicyTypeAttribute.getValue());
                                member.add(policyAttribute);
                            }
                            policyAttributes.setMember(member);
                            createLoadBalancerPolicyType.setPolicyAttributes(policyAttributes);
                        }
                        createLoadBalancerPolicyType.setPolicyName(elasticLoadBalancingPropertyType.getPolicyName());
                        createLoadBalancerPolicyType.setPolicyTypeName(elasticLoadBalancingPropertyType.getPolicyType());
                        AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createLoadBalancerPolicyType);
                    }
                }
                return action;
            }
        }
        ,
        ADD_LOAD_BALANCER_POLICIES_TO_LISTENERS{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSElasticLoadBalancingLoadBalancerResourceAction action = (AWSElasticLoadBalancingLoadBalancerResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(LoadBalancing.class, (Partition[])new Partition[0]);
                if (action.properties.getListeners() != null) {
                    for (ElasticLoadBalancingListener elasticLoadBalancingListener : action.properties.getListeners()) {
                        if (elasticLoadBalancingListener.getPolicyNames() == null) continue;
                        SetLoadBalancerPoliciesOfListenerType setLoadBalancerPoliciesOfListenerType = MessageHelper.createMessage(SetLoadBalancerPoliciesOfListenerType.class, action.info.getEffectiveUserId());
                        setLoadBalancerPoliciesOfListenerType.setLoadBalancerName(action.info.getPhysicalResourceId());
                        setLoadBalancerPoliciesOfListenerType.setLoadBalancerPort(elasticLoadBalancingListener.getLoadBalancerPort());
                        PolicyNames policyNames = new PolicyNames();
                        ArrayList member = Lists.newArrayList(elasticLoadBalancingListener.getPolicyNames());
                        policyNames.setMember(member);
                        setLoadBalancerPoliciesOfListenerType.setPolicyNames(policyNames);
                        AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)setLoadBalancerPoliciesOfListenerType);
                    }
                }
                return action;
            }
        }
        ,
        ADD_APP_STICKINESS_POLICY_TO_LOAD_BALANCER{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSElasticLoadBalancingLoadBalancerResourceAction action = (AWSElasticLoadBalancingLoadBalancerResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(LoadBalancing.class, (Partition[])new Partition[0]);
                if (action.properties.getAppCookieStickinessPolicy() != null) {
                    CreateAppCookieStickinessPolicyType createAppCookieStickinessPolicyType = MessageHelper.createMessage(CreateAppCookieStickinessPolicyType.class, action.info.getEffectiveUserId());
                    createAppCookieStickinessPolicyType.setPolicyName(action.properties.getAppCookieStickinessPolicy().getPolicyName());
                    createAppCookieStickinessPolicyType.setLoadBalancerName(action.info.getPhysicalResourceId());
                    createAppCookieStickinessPolicyType.setCookieName(action.properties.getAppCookieStickinessPolicy().getCookieName());
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createAppCookieStickinessPolicyType);
                }
                return action;
            }
        }
        ,
        ADD_LB_STICKINESS_POLICY_TO_LOAD_BALANCER{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSElasticLoadBalancingLoadBalancerResourceAction action = (AWSElasticLoadBalancingLoadBalancerResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(LoadBalancing.class, (Partition[])new Partition[0]);
                if (action.properties.getLbCookieStickinessPolicy() != null) {
                    CreateLBCookieStickinessPolicyType createLBCookieStickinessPolicyType = MessageHelper.createMessage(CreateLBCookieStickinessPolicyType.class, action.info.getEffectiveUserId());
                    createLBCookieStickinessPolicyType.setPolicyName(action.properties.getLbCookieStickinessPolicy().getPolicyName());
                    createLBCookieStickinessPolicyType.setLoadBalancerName(action.info.getPhysicalResourceId());
                    createLBCookieStickinessPolicyType.setCookieExpirationPeriod(action.properties.getLbCookieStickinessPolicy().getCookieExpirationPeriod());
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createLBCookieStickinessPolicyType);
                }
                return action;
            }
        }
        ,
        PLACEHOLDER_FOR_OTHER_FIELDS{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSElasticLoadBalancingLoadBalancerResourceAction action = (AWSElasticLoadBalancingLoadBalancerResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(LoadBalancing.class, (Partition[])new Partition[0]);
                return action;
            }
        }
        ,
        DESCRIBE_LOAD_BALANCER_TO_GET_ATTRIBUTES{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSElasticLoadBalancingLoadBalancerResourceAction action = (AWSElasticLoadBalancingLoadBalancerResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(LoadBalancing.class, (Partition[])new Partition[0]);
                DescribeLoadBalancersType describeLoadBalancersType = MessageHelper.createMessage(DescribeLoadBalancersType.class, action.info.getEffectiveUserId());
                LoadBalancerNames loadBalancerNames = new LoadBalancerNames();
                ArrayList member = Lists.newArrayList((Object[])new String[]{action.info.getPhysicalResourceId()});
                loadBalancerNames.setMember(member);
                describeLoadBalancersType.setLoadBalancerNames(loadBalancerNames);
                DescribeLoadBalancersResponseType describeLoadBalancersResponseType = (DescribeLoadBalancersResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeLoadBalancersType);
                if (describeLoadBalancersResponseType != null && describeLoadBalancersResponseType.getDescribeLoadBalancersResult() != null && describeLoadBalancersResponseType.getDescribeLoadBalancersResult().getLoadBalancerDescriptions() != null && describeLoadBalancersResponseType.getDescribeLoadBalancersResult().getLoadBalancerDescriptions().getMember() != null && describeLoadBalancersResponseType.getDescribeLoadBalancersResult().getLoadBalancerDescriptions().getMember().size() > 0) {
                    LoadBalancerDescription loadBalancerDescription = (LoadBalancerDescription)describeLoadBalancersResponseType.getDescribeLoadBalancersResult().getLoadBalancerDescriptions().getMember().get(0);
                    String canonicalHostedZoneName = loadBalancerDescription.getCanonicalHostedZoneName();
                    String canonicalHostedZoneNameId = loadBalancerDescription.getCanonicalHostedZoneNameID();
                    String sourceSecurityGroupGroupName = loadBalancerDescription.getSourceSecurityGroup().getGroupName();
                    String sourceSecurityGroupGroupOwnerAlias = loadBalancerDescription.getSourceSecurityGroup().getOwnerAlias();
                    if ("internal".equals(loadBalancerDescription.getScheme())) {
                        canonicalHostedZoneName = loadBalancerDescription.getDnsName();
                    }
                    action.info.setSourceSecurityGroupGroupName(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(sourceSecurityGroupGroupName)));
                    action.info.setSourceSecurityGroupOwnerAlias(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(sourceSecurityGroupGroupOwnerAlias)));
                    action.info.setCanonicalHostedZoneNameID(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(canonicalHostedZoneNameId)));
                    action.info.setCanonicalHostedZoneName(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(canonicalHostedZoneName)));
                }
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

