/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSEC2VolumeAttachmentResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSEC2VolumeAttachmentProperties;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.ValidationFailedException;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.AttachVolumeType;
import com.eucalyptus.compute.common.AttachedVolume;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.compute.common.DescribeInstancesResponseType;
import com.eucalyptus.compute.common.DescribeInstancesType;
import com.eucalyptus.compute.common.DescribeVolumesResponseType;
import com.eucalyptus.compute.common.DescribeVolumesType;
import com.eucalyptus.compute.common.DetachVolumeType;
import com.eucalyptus.compute.common.Volume;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.List;
import javax.annotation.Nullable;

@ConfigurableClass(root="cloudformation", description="Parameters controlling cloud formation")
public class AWSEC2VolumeAttachmentResourceAction
extends ResourceAction {
    private AWSEC2VolumeAttachmentProperties properties = new AWSEC2VolumeAttachmentProperties();
    private AWSEC2VolumeAttachmentResourceInfo info = new AWSEC2VolumeAttachmentResourceInfo();
    @ConfigurableField(initial="300", description="The amount of time (in seconds) to wait for a volume to be attached during create)")
    public static volatile Integer VOLUME_ATTACHMENT_MAX_CREATE_RETRY_SECS = 300;
    @ConfigurableField(initial="300", description="The amount of time (in seconds) to wait for a volume to detach during delete)")
    public static volatile Integer VOLUME_DETACHMENT_MAX_DELETE_RETRY_SECS = 300;

    public AWSEC2VolumeAttachmentResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSEC2VolumeAttachmentProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSEC2VolumeAttachmentResourceInfo)resourceInfo;
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DETACH_VOLUME{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2VolumeAttachmentResourceAction action = (AWSEC2VolumeAttachmentResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (DeleteSteps.notCreatedOrNoInstanceOrNoVolume(action, configuration)) {
                    return action;
                }
                DetachVolumeType detachVolumeType = MessageHelper.createMessage(DetachVolumeType.class, action.info.getEffectiveUserId());
                detachVolumeType.setInstanceId(action.properties.getInstanceId());
                detachVolumeType.setVolumeId(action.properties.getVolumeId());
                detachVolumeType.setDevice(action.properties.getDevice());
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)detachVolumeType);
                return action;
            }
        }
        ,
        WAIT_UNTIL_DETACHED{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2VolumeAttachmentResourceAction action = (AWSEC2VolumeAttachmentResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (DeleteSteps.notCreatedOrNoInstanceOrNoVolume(action, configuration)) {
                    return action;
                }
                boolean detached = false;
                DescribeVolumesType describeVolumesType = MessageHelper.createMessage(DescribeVolumesType.class, action.info.getEffectiveUserId());
                describeVolumesType.setVolumeSet(Lists.newArrayList((Object[])new String[]{action.properties.getVolumeId()}));
                DescribeVolumesResponseType describeVolumesResponseType = (DescribeVolumesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeVolumesType);
                if (describeVolumesResponseType.getVolumeSet().size() == 0) {
                    return action;
                }
                if (((Volume)describeVolumesResponseType.getVolumeSet().get(0)).getAttachmentSet() == null || ((Volume)describeVolumesResponseType.getVolumeSet().get(0)).getAttachmentSet().isEmpty()) {
                    return action;
                }
                for (AttachedVolume attachedVolume : ((Volume)describeVolumesResponseType.getVolumeSet().get(0)).getAttachmentSet()) {
                    if (!attachedVolume.getInstanceId().equals(action.properties.getInstanceId()) || !attachedVolume.getDevice().equals(action.properties.getDevice()) || !attachedVolume.getStatus().equals("detached")) continue;
                    detached = true;
                    break;
                }
                if (detached) {
                    return action;
                }
                throw new ValidationFailedException("Volume " + action.properties.getVolumeId() + " is not yet detached from instance " + action.properties.getInstanceId());
            }

            @Override
            public Integer getTimeout() {
                return VOLUME_DETACHMENT_MAX_DELETE_RETRY_SECS;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }

        private static boolean notCreatedOrNoInstanceOrNoVolume(AWSEC2VolumeAttachmentResourceAction action, ServiceConfiguration configuration) throws Exception {
            if (action.info.getPhysicalResourceId() == null) {
                return true;
            }
            DescribeInstancesType describeInstancesType = MessageHelper.createMessage(DescribeInstancesType.class, action.info.getEffectiveUserId());
            describeInstancesType.setInstancesSet(Lists.newArrayList((Object[])new String[]{action.properties.getInstanceId()}));
            DescribeInstancesResponseType describeInstancesResponseType = (DescribeInstancesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeInstancesType);
            if (describeInstancesResponseType.getReservationSet() == null || describeInstancesResponseType.getReservationSet().isEmpty()) {
                return true;
            }
            DescribeVolumesType describeVolumesType = MessageHelper.createMessage(DescribeVolumesType.class, action.info.getEffectiveUserId());
            describeVolumesType.setVolumeSet(Lists.newArrayList((Object[])new String[]{action.properties.getVolumeId()}));
            DescribeVolumesResponseType describeVolumesResponseType = (DescribeVolumesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeVolumesType);
            return describeVolumesResponseType.getVolumeSet().size() == 0;
        }
    }

    private static enum CreateSteps implements Step
    {
        ATTACH_VOLUME{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2VolumeAttachmentResourceAction action = (AWSEC2VolumeAttachmentResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                DescribeInstancesType describeInstancesType = MessageHelper.createMessage(DescribeInstancesType.class, action.info.getEffectiveUserId());
                describeInstancesType.setInstancesSet(Lists.newArrayList((Object[])new String[]{action.properties.getInstanceId()}));
                DescribeInstancesResponseType describeInstancesResponseType = (DescribeInstancesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeInstancesType);
                if (describeInstancesResponseType.getReservationSet() == null || describeInstancesResponseType.getReservationSet().isEmpty()) {
                    throw new ValidationErrorException("No such instance " + action.properties.getInstanceId());
                }
                DescribeVolumesType describeVolumesType = MessageHelper.createMessage(DescribeVolumesType.class, action.info.getEffectiveUserId());
                describeVolumesType.setVolumeSet(Lists.newArrayList((Object[])new String[]{action.properties.getVolumeId()}));
                DescribeVolumesResponseType describeVolumesResponseType = (DescribeVolumesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeVolumesType);
                if (describeVolumesResponseType.getVolumeSet().size() == 0) {
                    throw new ValidationErrorException("No such volume " + action.properties.getVolumeId());
                }
                if (!"available".equals(((Volume)describeVolumesResponseType.getVolumeSet().get(0)).getStatus())) {
                    throw new ValidationErrorException("Volume " + action.properties.getVolumeId() + " not available");
                }
                AttachVolumeType attachVolumeType = MessageHelper.createMessage(AttachVolumeType.class, action.info.getEffectiveUserId());
                attachVolumeType.setInstanceId(action.properties.getInstanceId());
                attachVolumeType.setVolumeId(action.properties.getVolumeId());
                attachVolumeType.setDevice(action.properties.getDevice());
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)attachVolumeType);
                return action;
            }
        }
        ,
        WAIT_UNTIL_ATTACHED{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2VolumeAttachmentResourceAction action = (AWSEC2VolumeAttachmentResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                boolean attached = false;
                DescribeVolumesType describeVolumesType = MessageHelper.createMessage(DescribeVolumesType.class, action.info.getEffectiveUserId());
                describeVolumesType.setVolumeSet(Lists.newArrayList((Object[])new String[]{action.properties.getVolumeId()}));
                DescribeVolumesResponseType describeVolumesResponseType = (DescribeVolumesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeVolumesType);
                if (describeVolumesResponseType.getVolumeSet().size() == 0) {
                    this.throwNotAttachedMessage(action.properties.getVolumeId(), action.properties.getInstanceId());
                }
                if (((Volume)describeVolumesResponseType.getVolumeSet().get(0)).getAttachmentSet() == null || ((Volume)describeVolumesResponseType.getVolumeSet().get(0)).getAttachmentSet().isEmpty()) {
                    this.throwNotAttachedMessage(action.properties.getVolumeId(), action.properties.getInstanceId());
                }
                for (AttachedVolume attachedVolume : ((Volume)describeVolumesResponseType.getVolumeSet().get(0)).getAttachmentSet()) {
                    if (!attachedVolume.getInstanceId().equals(action.properties.getInstanceId()) || !attachedVolume.getDevice().equals(action.properties.getDevice()) || !attachedVolume.getStatus().equals("attached")) continue;
                    attached = true;
                    break;
                }
                if (!attached) {
                    this.throwNotAttachedMessage(action.properties.getVolumeId(), action.properties.getInstanceId());
                }
                return action;
            }

            @Override
            public Integer getTimeout() {
                return VOLUME_ATTACHMENT_MAX_CREATE_RETRY_SECS;
            }

            public void throwNotAttachedMessage(String volumeId, String instanceId) throws ValidationFailedException {
                throw new ValidationFailedException("Volume " + volumeId + " not yet attached to instance " + instanceId);
            }
        }
        ,
        POPULATE_FIELDS{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2VolumeAttachmentResourceAction action = (AWSEC2VolumeAttachmentResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                action.info.setPhysicalResourceId(action.getDefaultPhysicalResourceId());
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

