/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSEC2VPCGatewayAttachmentResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSEC2VPCGatewayAttachmentProperties;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.AttachInternetGatewayType;
import com.eucalyptus.compute.common.AttachVpnGatewayType;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.compute.common.DescribeInternetGatewaysResponseType;
import com.eucalyptus.compute.common.DescribeInternetGatewaysType;
import com.eucalyptus.compute.common.DescribeVpcsResponseType;
import com.eucalyptus.compute.common.DescribeVpcsType;
import com.eucalyptus.compute.common.DescribeVpnGatewaysResponseType;
import com.eucalyptus.compute.common.DescribeVpnGatewaysType;
import com.eucalyptus.compute.common.DetachInternetGatewayType;
import com.eucalyptus.compute.common.DetachVpnGatewayType;
import com.eucalyptus.compute.common.InternetGatewayIdSetItemType;
import com.eucalyptus.compute.common.InternetGatewayIdSetType;
import com.eucalyptus.compute.common.VpcIdSetItemType;
import com.eucalyptus.compute.common.VpcIdSetType;
import com.eucalyptus.compute.common.VpnGatewayIdSetItemType;
import com.eucalyptus.compute.common.VpnGatewayIdSetType;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class AWSEC2VPCGatewayAttachmentResourceAction
extends ResourceAction {
    private AWSEC2VPCGatewayAttachmentProperties properties = new AWSEC2VPCGatewayAttachmentProperties();
    private AWSEC2VPCGatewayAttachmentResourceInfo info = new AWSEC2VPCGatewayAttachmentResourceInfo();

    public AWSEC2VPCGatewayAttachmentResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSEC2VPCGatewayAttachmentProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSEC2VPCGatewayAttachmentResourceInfo)resourceInfo;
    }

    private void setVpnGatewayId(DescribeVpnGatewaysType describeVpnGatewaysType, String vpnGatewayId) {
        VpnGatewayIdSetType vpnGatewaySet = new VpnGatewayIdSetType();
        describeVpnGatewaysType.setVpnGatewaySet(vpnGatewaySet);
        ArrayList item = Lists.newArrayList();
        vpnGatewaySet.setItem(item);
        VpnGatewayIdSetItemType vpnGatewayIdSetItem = new VpnGatewayIdSetItemType();
        item.add(vpnGatewayIdSetItem);
        vpnGatewayIdSetItem.setVpnGatewayId(vpnGatewayId);
    }

    private void setInternetGatewayId(DescribeInternetGatewaysType describeInternetGatewaysType, String internetGatewayId) {
        InternetGatewayIdSetType internetGatewaySet = new InternetGatewayIdSetType();
        describeInternetGatewaysType.setInternetGatewayIdSet(internetGatewaySet);
        ArrayList item = Lists.newArrayList();
        internetGatewaySet.setItem(item);
        InternetGatewayIdSetItemType internetgatewayIdSetItem = new InternetGatewayIdSetItemType();
        item.add(internetgatewayIdSetItem);
        internetgatewayIdSetItem.setInternetGatewayId(internetGatewayId);
    }

    private void setVpcId(DescribeVpcsType describeVpcsType, String vpcId) {
        VpcIdSetType vpcSet = new VpcIdSetType();
        describeVpcsType.setVpcSet(vpcSet);
        ArrayList item = Lists.newArrayList();
        vpcSet.setItem(item);
        VpcIdSetItemType vpcIdSetItem = new VpcIdSetItemType();
        item.add(vpcIdSetItem);
        vpcIdSetItem.setVpcId(vpcId);
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_ATTACHMENT{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2VPCGatewayAttachmentResourceAction action = (AWSEC2VPCGatewayAttachmentResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                DescribeInternetGatewaysType describeInternetGatewaysType = MessageHelper.createMessage(DescribeInternetGatewaysType.class, action.info.getEffectiveUserId());
                action.setInternetGatewayId(describeInternetGatewaysType, action.properties.getInternetGatewayId());
                DescribeInternetGatewaysResponseType describeInternetGatewaysResponseType = (DescribeInternetGatewaysResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeInternetGatewaysType);
                if (describeInternetGatewaysResponseType.getInternetGatewaySet() == null || describeInternetGatewaysResponseType.getInternetGatewaySet().getItem() == null || describeInternetGatewaysResponseType.getInternetGatewaySet().getItem().isEmpty()) {
                    return action;
                }
                if (action.properties.getVpcId() != null) {
                    DescribeVpcsType describeVpcsType = MessageHelper.createMessage(DescribeVpcsType.class, action.info.getEffectiveUserId());
                    action.setVpcId(describeVpcsType, action.properties.getVpcId());
                    DescribeVpcsResponseType describeVpcsResponseType = (DescribeVpcsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeVpcsType);
                    if (describeVpcsResponseType.getVpcSet() == null || describeVpcsResponseType.getVpcSet().getItem() == null || describeVpcsResponseType.getVpcSet().getItem().isEmpty()) {
                        return action;
                    }
                    DetachInternetGatewayType detachInternetGatewayType = MessageHelper.createMessage(DetachInternetGatewayType.class, action.info.getEffectiveUserId());
                    detachInternetGatewayType.setVpcId(action.properties.getVpcId());
                    detachInternetGatewayType.setInternetGatewayId(action.properties.getInternetGatewayId());
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)detachInternetGatewayType);
                } else {
                    DescribeVpnGatewaysType describeVpnGatewaysType = MessageHelper.createMessage(DescribeVpnGatewaysType.class, action.info.getEffectiveUserId());
                    action.setVpnGatewayId(describeVpnGatewaysType, action.properties.getVpnGatewayId());
                    DescribeVpnGatewaysResponseType describeVpnGatewaysResponseType = (DescribeVpnGatewaysResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeVpnGatewaysType);
                    if (describeVpnGatewaysResponseType.getVpnGatewaySet() == null || describeVpnGatewaysResponseType.getVpnGatewaySet().getItem() == null || describeVpnGatewaysResponseType.getVpnGatewaySet().getItem().isEmpty()) {
                        return action;
                    }
                    DetachVpnGatewayType detachVpnGatewayType = MessageHelper.createMessage(DetachVpnGatewayType.class, action.info.getEffectiveUserId());
                    detachVpnGatewayType.setVpcId(action.properties.getVpcId());
                    detachVpnGatewayType.setVpnGatewayId(action.properties.getVpnGatewayId());
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)detachVpnGatewayType);
                }
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_ATTACHMENT{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2VPCGatewayAttachmentResourceAction action = (AWSEC2VPCGatewayAttachmentResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (action.properties.getVpcId() != null && action.properties.getVpnGatewayId() != null) {
                    throw new ValidationErrorException("Both VpcId and VpnGatewayId can not be set.");
                }
                if (action.properties.getVpcId() == null && action.properties.getVpnGatewayId() == null) {
                    throw new ValidationErrorException("One of VpcId or VpnGatewayId must be set.");
                }
                if (action.properties.getVpcId() != null) {
                    AttachInternetGatewayType attachInternetGatewayType = MessageHelper.createMessage(AttachInternetGatewayType.class, action.info.getEffectiveUserId());
                    attachInternetGatewayType.setInternetGatewayId(action.properties.getInternetGatewayId());
                    attachInternetGatewayType.setVpcId(action.properties.getVpcId());
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)attachInternetGatewayType);
                } else {
                    AttachVpnGatewayType attachVpnGatewayType = MessageHelper.createMessage(AttachVpnGatewayType.class, action.info.getEffectiveUserId());
                    attachVpnGatewayType.setVpnGatewayId(action.properties.getVpnGatewayId());
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)attachVpnGatewayType);
                }
                action.info.setPhysicalResourceId(action.getDefaultPhysicalResourceId());
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

