/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSEC2VPCDHCPOptionsAssociationResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSEC2VPCDHCPOptionsAssociationProperties;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.AssociateDhcpOptionsType;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.compute.common.DescribeDhcpOptionsResponseType;
import com.eucalyptus.compute.common.DescribeDhcpOptionsType;
import com.eucalyptus.compute.common.DescribeVpcsResponseType;
import com.eucalyptus.compute.common.DescribeVpcsType;
import com.eucalyptus.compute.common.DhcpOptionsIdSetItemType;
import com.eucalyptus.compute.common.DhcpOptionsIdSetType;
import com.eucalyptus.compute.common.VpcIdSetItemType;
import com.eucalyptus.compute.common.VpcIdSetType;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class AWSEC2VPCDHCPOptionsAssociationResourceAction
extends ResourceAction {
    private AWSEC2VPCDHCPOptionsAssociationProperties properties = new AWSEC2VPCDHCPOptionsAssociationProperties();
    private AWSEC2VPCDHCPOptionsAssociationResourceInfo info = new AWSEC2VPCDHCPOptionsAssociationResourceInfo();

    public AWSEC2VPCDHCPOptionsAssociationResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSEC2VPCDHCPOptionsAssociationProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSEC2VPCDHCPOptionsAssociationResourceInfo)resourceInfo;
    }

    private void setVpcId(DescribeVpcsType describeVpcsType, String vpcId) {
        VpcIdSetType vpcSet = new VpcIdSetType();
        describeVpcsType.setVpcSet(vpcSet);
        ArrayList item = Lists.newArrayList();
        vpcSet.setItem(item);
        VpcIdSetItemType vpcIdSetItem = new VpcIdSetItemType();
        item.add(vpcIdSetItem);
        vpcIdSetItem.setVpcId(vpcId);
    }

    private void setDhcpOptionsId(DescribeDhcpOptionsType describeDhcpOptionsType, String dhcpOptionsId) {
        DhcpOptionsIdSetType dhcpOptionsSet = new DhcpOptionsIdSetType();
        ArrayList item = Lists.newArrayList();
        DhcpOptionsIdSetItemType dhcpOptionsIdSetItemType = new DhcpOptionsIdSetItemType();
        dhcpOptionsIdSetItemType.setDhcpOptionsId(dhcpOptionsId);
        item.add(dhcpOptionsIdSetItemType);
        dhcpOptionsSet.setItem(item);
        item.add(dhcpOptionsIdSetItemType);
        describeDhcpOptionsType.setDhcpOptionsSet(dhcpOptionsSet);
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_ASSOCIATION{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2VPCDHCPOptionsAssociationResourceAction action = (AWSEC2VPCDHCPOptionsAssociationResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                if (!"default".equals(action.properties.getDhcpOptionsId())) {
                    DescribeDhcpOptionsType describeDhcpOptionsType = MessageHelper.createMessage(DescribeDhcpOptionsType.class, action.info.getEffectiveUserId());
                    action.setDhcpOptionsId(describeDhcpOptionsType, action.properties.getDhcpOptionsId());
                    DescribeDhcpOptionsResponseType describeDhcpOptionsResponseType = (DescribeDhcpOptionsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeDhcpOptionsType);
                    if (describeDhcpOptionsResponseType.getDhcpOptionsSet() == null || describeDhcpOptionsResponseType.getDhcpOptionsSet().getItem() == null || describeDhcpOptionsResponseType.getDhcpOptionsSet().getItem().isEmpty()) {
                        return action;
                    }
                }
                DescribeVpcsType describeVpcsType = MessageHelper.createMessage(DescribeVpcsType.class, action.info.getEffectiveUserId());
                action.setVpcId(describeVpcsType, action.properties.getVpcId());
                DescribeVpcsResponseType describeVpcsResponseType = (DescribeVpcsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeVpcsType);
                if (describeVpcsResponseType.getVpcSet() == null || describeVpcsResponseType.getVpcSet().getItem() == null || describeVpcsResponseType.getVpcSet().getItem().isEmpty()) {
                    return action;
                }
                AssociateDhcpOptionsType associateDhcpOptionsType = MessageHelper.createMessage(AssociateDhcpOptionsType.class, action.info.getEffectiveUserId());
                associateDhcpOptionsType.setDhcpOptionsId("default");
                associateDhcpOptionsType.setVpcId(action.properties.getVpcId());
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)associateDhcpOptionsType);
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_ASSOCIATION{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2VPCDHCPOptionsAssociationResourceAction action = (AWSEC2VPCDHCPOptionsAssociationResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (!"default".equals(action.properties.getDhcpOptionsId())) {
                    DescribeDhcpOptionsType describeDhcpOptionsType = MessageHelper.createMessage(DescribeDhcpOptionsType.class, action.info.getEffectiveUserId());
                    action.setDhcpOptionsId(describeDhcpOptionsType, action.properties.getDhcpOptionsId());
                    DescribeDhcpOptionsResponseType describeDhcpOptionsResponseType = (DescribeDhcpOptionsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeDhcpOptionsType);
                    if (describeDhcpOptionsResponseType.getDhcpOptionsSet() == null || describeDhcpOptionsResponseType.getDhcpOptionsSet().getItem() == null || describeDhcpOptionsResponseType.getDhcpOptionsSet().getItem().isEmpty()) {
                        throw new ValidationErrorException("No such dhcp options: " + action.properties.getDhcpOptionsId());
                    }
                }
                DescribeVpcsType describeVpcsType = MessageHelper.createMessage(DescribeVpcsType.class, action.info.getEffectiveUserId());
                action.setVpcId(describeVpcsType, action.properties.getVpcId());
                DescribeVpcsResponseType describeVpcsResponseType = (DescribeVpcsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeVpcsType);
                if (describeVpcsResponseType.getVpcSet() == null || describeVpcsResponseType.getVpcSet().getItem() == null || describeVpcsResponseType.getVpcSet().getItem().isEmpty()) {
                    throw new ValidationErrorException("No such vpc: " + action.properties.getVpcId());
                }
                AssociateDhcpOptionsType associateDhcpOptionsType = MessageHelper.createMessage(AssociateDhcpOptionsType.class, action.info.getEffectiveUserId());
                associateDhcpOptionsType.setDhcpOptionsId(action.properties.getDhcpOptionsId());
                associateDhcpOptionsType.setVpcId(action.properties.getVpcId());
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)associateDhcpOptionsType);
                action.info.setPhysicalResourceId(action.getDefaultPhysicalResourceId());
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

