/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSEC2SubnetRouteTableAssociationResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSEC2SubnetRouteTableAssociationProperties;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.AssociateRouteTableResponseType;
import com.eucalyptus.compute.common.AssociateRouteTableType;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.compute.common.DescribeRouteTablesResponseType;
import com.eucalyptus.compute.common.DescribeRouteTablesType;
import com.eucalyptus.compute.common.DescribeSubnetsResponseType;
import com.eucalyptus.compute.common.DescribeSubnetsType;
import com.eucalyptus.compute.common.DisassociateRouteTableType;
import com.eucalyptus.compute.common.Filter;
import com.eucalyptus.compute.common.RouteTableIdSetItemType;
import com.eucalyptus.compute.common.RouteTableIdSetType;
import com.eucalyptus.compute.common.SubnetIdSetItemType;
import com.eucalyptus.compute.common.SubnetIdSetType;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class AWSEC2SubnetRouteTableAssociationResourceAction
extends ResourceAction {
    private AWSEC2SubnetRouteTableAssociationProperties properties = new AWSEC2SubnetRouteTableAssociationProperties();
    private AWSEC2SubnetRouteTableAssociationResourceInfo info = new AWSEC2SubnetRouteTableAssociationResourceInfo();

    public AWSEC2SubnetRouteTableAssociationResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSEC2SubnetRouteTableAssociationProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSEC2SubnetRouteTableAssociationResourceInfo)resourceInfo;
    }

    private String associateRouteTable(ServiceConfiguration configuration, String subnetId, String routeTableId) throws Exception {
        AssociateRouteTableType associateRouteTableType = MessageHelper.createMessage(AssociateRouteTableType.class, this.info.getEffectiveUserId());
        associateRouteTableType.setRouteTableId(routeTableId);
        associateRouteTableType.setSubnetId(subnetId);
        AssociateRouteTableResponseType associateRouteTableResponseType = (AssociateRouteTableResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)associateRouteTableType);
        return associateRouteTableResponseType.getAssociationId();
    }

    private void checkSubnetExists(ServiceConfiguration configuration) throws Exception {
        DescribeSubnetsType describeSubnetsType = MessageHelper.createMessage(DescribeSubnetsType.class, this.info.getEffectiveUserId());
        SubnetIdSetType SubnetIdSet = new SubnetIdSetType();
        SubnetIdSetItemType SubnetIdSetItem = new SubnetIdSetItemType();
        SubnetIdSetItem.setSubnetId(this.properties.getSubnetId());
        SubnetIdSet.setItem(Lists.newArrayList((Object[])new SubnetIdSetItemType[]{SubnetIdSetItem}));
        describeSubnetsType.setSubnetSet(SubnetIdSet);
        DescribeSubnetsResponseType describeSubnetsResponseType = (DescribeSubnetsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeSubnetsType);
        if (describeSubnetsResponseType.getSubnetSet() == null || describeSubnetsResponseType.getSubnetSet().getItem() == null || describeSubnetsResponseType.getSubnetSet().getItem().isEmpty()) {
            throw new ValidationErrorException("No such subnet with id '" + this.properties.getSubnetId());
        }
    }

    private void checkRouteTableExists(ServiceConfiguration configuration) throws Exception {
        DescribeRouteTablesType describeRouteTablesType = MessageHelper.createMessage(DescribeRouteTablesType.class, this.info.getEffectiveUserId());
        RouteTableIdSetType routeTableIdSet = new RouteTableIdSetType();
        RouteTableIdSetItemType routeTableIdSetItem = new RouteTableIdSetItemType();
        routeTableIdSetItem.setRouteTableId(this.properties.getRouteTableId());
        routeTableIdSet.setItem(Lists.newArrayList((Object[])new RouteTableIdSetItemType[]{routeTableIdSetItem}));
        describeRouteTablesType.setRouteTableIdSet(routeTableIdSet);
        DescribeRouteTablesResponseType describeRouteTablesResponseType = (DescribeRouteTablesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeRouteTablesType);
        if (describeRouteTablesResponseType.getRouteTableSet() == null || describeRouteTablesResponseType.getRouteTableSet().getItem() == null || describeRouteTablesResponseType.getRouteTableSet().getItem().isEmpty()) {
            throw new ValidationErrorException("No such route table with id '" + this.properties.getRouteTableId());
        }
    }

    private void disassociateRouteTable(ServiceConfiguration configuration, String associationId) throws Exception {
        DisassociateRouteTableType disassociateRouteTableType = MessageHelper.createMessage(DisassociateRouteTableType.class, this.info.getEffectiveUserId());
        disassociateRouteTableType.setAssociationId(associationId);
        AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)disassociateRouteTableType);
    }

    private boolean subnetExistsForDelete(ServiceConfiguration configuration) throws Exception {
        DescribeSubnetsType describeSubnetsType = MessageHelper.createMessage(DescribeSubnetsType.class, this.info.getEffectiveUserId());
        SubnetIdSetType SubnetIdSet = new SubnetIdSetType();
        SubnetIdSetItemType SubnetIdSetItem = new SubnetIdSetItemType();
        SubnetIdSetItem.setSubnetId(this.properties.getSubnetId());
        SubnetIdSet.setItem(Lists.newArrayList((Object[])new SubnetIdSetItemType[]{SubnetIdSetItem}));
        describeSubnetsType.setSubnetSet(SubnetIdSet);
        DescribeSubnetsResponseType describeSubnetsResponseType = (DescribeSubnetsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeSubnetsType);
        return describeSubnetsResponseType.getSubnetSet() != null && describeSubnetsResponseType.getSubnetSet().getItem() != null && !describeSubnetsResponseType.getSubnetSet().getItem().isEmpty();
    }

    private boolean routeTableExistsForDelete(ServiceConfiguration configuration) throws Exception {
        DescribeRouteTablesType describeRouteTablesType = MessageHelper.createMessage(DescribeRouteTablesType.class, this.info.getEffectiveUserId());
        RouteTableIdSetType routeTableIdSet = new RouteTableIdSetType();
        RouteTableIdSetItemType routeTableIdSetItem = new RouteTableIdSetItemType();
        routeTableIdSetItem.setRouteTableId(this.properties.getRouteTableId());
        routeTableIdSet.setItem(Lists.newArrayList((Object[])new RouteTableIdSetItemType[]{routeTableIdSetItem}));
        describeRouteTablesType.setRouteTableIdSet(routeTableIdSet);
        DescribeRouteTablesResponseType describeRouteTablesResponseType = (DescribeRouteTablesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeRouteTablesType);
        return describeRouteTablesResponseType.getRouteTableSet() != null && describeRouteTablesResponseType.getRouteTableSet().getItem() != null && !describeRouteTablesResponseType.getRouteTableSet().getItem().isEmpty();
    }

    private boolean associationIdExistsForDelete(ServiceConfiguration configuration) throws Exception {
        DescribeRouteTablesType describeRouteTablesType = MessageHelper.createMessage(DescribeRouteTablesType.class, this.info.getEffectiveUserId());
        ArrayList filterSet = Lists.newArrayList();
        Filter filter = new Filter();
        filter.setName("association.route-table-association-id");
        filter.setValueSet(Lists.newArrayList((Object[])new String[]{this.info.getPhysicalResourceId()}));
        filterSet.add(filter);
        describeRouteTablesType.setFilterSet(filterSet);
        DescribeRouteTablesResponseType describeRouteTablesResponseType = (DescribeRouteTablesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeRouteTablesType);
        return describeRouteTablesResponseType.getRouteTableSet() != null && describeRouteTablesResponseType.getRouteTableSet().getItem() != null && !describeRouteTablesResponseType.getRouteTableSet().getItem().isEmpty();
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_ASSOCIATION{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2SubnetRouteTableAssociationResourceAction action = (AWSEC2SubnetRouteTableAssociationResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                if (!action.associationIdExistsForDelete(configuration)) {
                    return action;
                }
                if (!action.routeTableExistsForDelete(configuration)) {
                    return action;
                }
                if (!action.subnetExistsForDelete(configuration)) {
                    return action;
                }
                action.disassociateRouteTable(configuration, action.info.getPhysicalResourceId());
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_ASSOCIATION{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2SubnetRouteTableAssociationResourceAction action = (AWSEC2SubnetRouteTableAssociationResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                action.checkRouteTableExists(configuration);
                action.checkSubnetExists(configuration);
                String associationId = action.associateRouteTable(configuration, action.properties.getSubnetId(), action.properties.getRouteTableId());
                action.info.setPhysicalResourceId(associationId);
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

