/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.auth.Accounts;
import com.eucalyptus.cloudformation.resources.EC2Helper;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.TagHelper;
import com.eucalyptus.cloudformation.resources.standard.info.AWSEC2SubnetResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSEC2SubnetProperties;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.EC2Tag;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.compute.common.CreateSubnetResponseType;
import com.eucalyptus.compute.common.CreateSubnetType;
import com.eucalyptus.compute.common.CreateTagsType;
import com.eucalyptus.compute.common.DeleteSubnetType;
import com.eucalyptus.compute.common.DescribeSubnetsResponseType;
import com.eucalyptus.compute.common.DescribeSubnetsType;
import com.eucalyptus.compute.common.DescribeVpcsResponseType;
import com.eucalyptus.compute.common.DescribeVpcsType;
import com.eucalyptus.compute.common.SubnetIdSetItemType;
import com.eucalyptus.compute.common.SubnetIdSetType;
import com.eucalyptus.compute.common.VpcIdSetItemType;
import com.eucalyptus.compute.common.VpcIdSetType;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class AWSEC2SubnetResourceAction
extends ResourceAction {
    private AWSEC2SubnetProperties properties = new AWSEC2SubnetProperties();
    private AWSEC2SubnetResourceInfo info = new AWSEC2SubnetResourceInfo();

    public AWSEC2SubnetResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSEC2SubnetProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSEC2SubnetResourceInfo)resourceInfo;
    }

    private void setSubnetId(DescribeSubnetsType describeSubnetsType, String subnetId) {
        SubnetIdSetType subnetSet = new SubnetIdSetType();
        describeSubnetsType.setSubnetSet(subnetSet);
        ArrayList item = Lists.newArrayList();
        subnetSet.setItem(item);
        SubnetIdSetItemType subnetIdSetItem = new SubnetIdSetItemType();
        item.add(subnetIdSetItem);
        subnetIdSetItem.setSubnetId(subnetId);
    }

    private void setVpcId(DescribeVpcsType describeVpcsType, String vpcId) {
        VpcIdSetType vpcSet = new VpcIdSetType();
        describeVpcsType.setVpcSet(vpcSet);
        ArrayList item = Lists.newArrayList();
        vpcSet.setItem(item);
        VpcIdSetItemType vpcIdSetItem = new VpcIdSetItemType();
        item.add(vpcIdSetItem);
        vpcIdSetItem.setVpcId(vpcId);
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_ROUTE_TABLE{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2SubnetResourceAction action = (AWSEC2SubnetResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                DescribeVpcsType describeVpcsType = MessageHelper.createMessage(DescribeVpcsType.class, action.info.getEffectiveUserId());
                action.setVpcId(describeVpcsType, action.properties.getVpcId());
                DescribeVpcsResponseType describeVpcsResponseType = (DescribeVpcsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeVpcsType);
                if (describeVpcsResponseType.getVpcSet() == null || describeVpcsResponseType.getVpcSet().getItem() == null || describeVpcsResponseType.getVpcSet().getItem().isEmpty()) {
                    return action;
                }
                DescribeSubnetsType describeSubnetsType = MessageHelper.createMessage(DescribeSubnetsType.class, action.info.getEffectiveUserId());
                action.setSubnetId(describeSubnetsType, action.info.getPhysicalResourceId());
                DescribeSubnetsResponseType describeSubnetsResponseType = (DescribeSubnetsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeSubnetsType);
                if (describeSubnetsResponseType.getSubnetSet() == null || describeSubnetsResponseType.getSubnetSet().getItem() == null || describeSubnetsResponseType.getSubnetSet().getItem().isEmpty()) {
                    return action;
                }
                DeleteSubnetType deleteSubnetType = MessageHelper.createMessage(DeleteSubnetType.class, action.info.getEffectiveUserId());
                deleteSubnetType.setSubnetId(action.info.getPhysicalResourceId());
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deleteSubnetType);
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_ROUTE_TABLE{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2SubnetResourceAction action = (AWSEC2SubnetResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                CreateSubnetType createSubnetType = MessageHelper.createMessage(CreateSubnetType.class, action.info.getEffectiveUserId());
                createSubnetType.setVpcId(action.properties.getVpcId());
                if (action.properties.getAvailabilityZone() != null) {
                    createSubnetType.setAvailabilityZone(action.properties.getAvailabilityZone());
                }
                createSubnetType.setCidrBlock(action.properties.getCidrBlock());
                CreateSubnetResponseType createSubnetResponseType = (CreateSubnetResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createSubnetType);
                action.info.setPhysicalResourceId(createSubnetResponseType.getSubnet().getSubnetId());
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                action.info.setAvailabilityZone(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(createSubnetResponseType.getSubnet().getAvailabilityZone())));
                return action;
            }
        }
        ,
        CREATE_TAGS{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2SubnetResourceAction action = (AWSEC2SubnetResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                String effectiveAdminUserId = Accounts.lookupUserById((String)action.info.getEffectiveUserId()).getAccount().lookupAdmin().getUserId();
                CreateTagsType createSystemTagsType = MessageHelper.createPrivilegedMessage(CreateTagsType.class, effectiveAdminUserId);
                createSystemTagsType.setResourcesSet(Lists.newArrayList((Object[])new String[]{action.info.getPhysicalResourceId()}));
                createSystemTagsType.setTagSet(EC2Helper.createTagSet(TagHelper.getEC2SystemTags(action.info, action.getStackEntity())));
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createSystemTagsType);
                List<EC2Tag> tags = TagHelper.getEC2StackTags(action.getStackEntity());
                if (action.properties.getTags() != null && !action.properties.getTags().isEmpty()) {
                    TagHelper.checkReservedEC2TemplateTags(action.properties.getTags());
                    tags.addAll(action.properties.getTags());
                }
                if (!tags.isEmpty()) {
                    CreateTagsType createTagsType = MessageHelper.createMessage(CreateTagsType.class, action.info.getEffectiveUserId());
                    createTagsType.setResourcesSet(Lists.newArrayList((Object[])new String[]{action.info.getPhysicalResourceId()}));
                    createTagsType.setTagSet(EC2Helper.createTagSet(tags));
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createTagsType);
                }
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

