/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSEC2SubnetNetworkAclAssociationResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSEC2SubnetNetworkAclAssociationProperties;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.compute.common.DescribeNetworkAclsResponseType;
import com.eucalyptus.compute.common.DescribeNetworkAclsType;
import com.eucalyptus.compute.common.DescribeSubnetsResponseType;
import com.eucalyptus.compute.common.DescribeSubnetsType;
import com.eucalyptus.compute.common.Filter;
import com.eucalyptus.compute.common.NetworkAclAssociationType;
import com.eucalyptus.compute.common.NetworkAclIdSetItemType;
import com.eucalyptus.compute.common.NetworkAclIdSetType;
import com.eucalyptus.compute.common.NetworkAclType;
import com.eucalyptus.compute.common.ReplaceNetworkAclAssociationResponseType;
import com.eucalyptus.compute.common.ReplaceNetworkAclAssociationType;
import com.eucalyptus.compute.common.SubnetIdSetItemType;
import com.eucalyptus.compute.common.SubnetIdSetType;
import com.eucalyptus.compute.common.SubnetType;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class AWSEC2SubnetNetworkAclAssociationResourceAction
extends ResourceAction {
    private AWSEC2SubnetNetworkAclAssociationProperties properties = new AWSEC2SubnetNetworkAclAssociationProperties();
    private AWSEC2SubnetNetworkAclAssociationResourceInfo info = new AWSEC2SubnetNetworkAclAssociationResourceInfo();

    public AWSEC2SubnetNetworkAclAssociationResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSEC2SubnetNetworkAclAssociationProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSEC2SubnetNetworkAclAssociationResourceInfo)resourceInfo;
    }

    private String replaceAssociation(ServiceConfiguration configuration, String associationId, String networkAclId) throws Exception {
        ReplaceNetworkAclAssociationType replaceNetworkAclAssociationType = MessageHelper.createMessage(ReplaceNetworkAclAssociationType.class, this.info.getEffectiveUserId());
        replaceNetworkAclAssociationType.setAssociationId(associationId);
        replaceNetworkAclAssociationType.setNetworkAclId(networkAclId);
        ReplaceNetworkAclAssociationResponseType replaceNetworkAclAssociationResponseType = (ReplaceNetworkAclAssociationResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)replaceNetworkAclAssociationType);
        return replaceNetworkAclAssociationResponseType.getNewAssociationId();
    }

    private void checkSubnetExists(ServiceConfiguration configuration) throws Exception {
        DescribeSubnetsType describeSubnetsType = MessageHelper.createMessage(DescribeSubnetsType.class, this.info.getEffectiveUserId());
        SubnetIdSetType SubnetIdSet = new SubnetIdSetType();
        SubnetIdSetItemType SubnetIdSetItem = new SubnetIdSetItemType();
        SubnetIdSetItem.setSubnetId(this.properties.getSubnetId());
        SubnetIdSet.setItem(Lists.newArrayList((Object[])new SubnetIdSetItemType[]{SubnetIdSetItem}));
        describeSubnetsType.setSubnetSet(SubnetIdSet);
        DescribeSubnetsResponseType describeSubnetsResponseType = (DescribeSubnetsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeSubnetsType);
        if (describeSubnetsResponseType.getSubnetSet() == null || describeSubnetsResponseType.getSubnetSet().getItem() == null || describeSubnetsResponseType.getSubnetSet().getItem().isEmpty()) {
            throw new ValidationErrorException("No such subnet with id '" + this.properties.getSubnetId());
        }
    }

    private void checkNetworkAclExists(ServiceConfiguration configuration) throws Exception {
        DescribeNetworkAclsType describeNetworkAclsType = MessageHelper.createMessage(DescribeNetworkAclsType.class, this.info.getEffectiveUserId());
        NetworkAclIdSetType networkAclIdSet = new NetworkAclIdSetType();
        NetworkAclIdSetItemType networkAclIdSetItem = new NetworkAclIdSetItemType();
        networkAclIdSetItem.setNetworkAclId(this.properties.getNetworkAclId());
        networkAclIdSet.setItem(Lists.newArrayList((Object[])new NetworkAclIdSetItemType[]{networkAclIdSetItem}));
        describeNetworkAclsType.setNetworkAclIdSet(networkAclIdSet);
        DescribeNetworkAclsResponseType describeNetworkAclsResponseType = (DescribeNetworkAclsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeNetworkAclsType);
        if (describeNetworkAclsResponseType.getNetworkAclSet() == null || describeNetworkAclsResponseType.getNetworkAclSet().getItem() == null || describeNetworkAclsResponseType.getNetworkAclSet().getItem().isEmpty()) {
            throw new ValidationErrorException("No such network acl with id '" + this.properties.getNetworkAclId());
        }
    }

    private String getAssociationId(ServiceConfiguration configuration) throws Exception {
        String associationId = null;
        DescribeNetworkAclsType describeNetworkAclsType = MessageHelper.createMessage(DescribeNetworkAclsType.class, this.info.getEffectiveUserId());
        ArrayList filterSet = Lists.newArrayList();
        Filter filter = new Filter();
        filter.setName("association.subnet-id");
        filter.setValueSet(Lists.newArrayList((Object[])new String[]{this.properties.getSubnetId()}));
        filterSet.add(filter);
        describeNetworkAclsType.setFilterSet(filterSet);
        DescribeNetworkAclsResponseType describeNetworkAclsResponseType = (DescribeNetworkAclsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeNetworkAclsType);
        if (describeNetworkAclsResponseType.getNetworkAclSet() == null || describeNetworkAclsResponseType.getNetworkAclSet().getItem() == null || describeNetworkAclsResponseType.getNetworkAclSet().getItem().isEmpty()) {
            throw new ValidationErrorException("Can not find existing network association for subnet " + this.properties.getSubnetId());
        }
        if (describeNetworkAclsResponseType.getNetworkAclSet().getItem().size() > 1) {
            throw new ValidationErrorException("More than one existing network association exists for subnet " + this.properties.getSubnetId());
        }
        if (((NetworkAclType)describeNetworkAclsResponseType.getNetworkAclSet().getItem().get(0)).getAssociationSet() != null && ((NetworkAclType)describeNetworkAclsResponseType.getNetworkAclSet().getItem().get(0)).getAssociationSet().getItem() != null) {
            for (NetworkAclAssociationType networkAclAssociationType : ((NetworkAclType)describeNetworkAclsResponseType.getNetworkAclSet().getItem().get(0)).getAssociationSet().getItem()) {
                if (!this.properties.getSubnetId().equals(networkAclAssociationType.getSubnetId())) continue;
                associationId = networkAclAssociationType.getNetworkAclAssociationId();
                break;
            }
        }
        return associationId;
    }

    private String findDefaultNetworkAclId(ServiceConfiguration configuration, String vpcId) throws Exception {
        DescribeNetworkAclsType describeNetworkAclsType = MessageHelper.createMessage(DescribeNetworkAclsType.class, this.info.getEffectiveUserId());
        ArrayList filterSet = Lists.newArrayList();
        Filter filter = new Filter();
        filter.setName("vpc-id");
        filter.setValueSet(Lists.newArrayList((Object[])new String[]{vpcId}));
        filterSet.add(filter);
        describeNetworkAclsType.setFilterSet(filterSet);
        DescribeNetworkAclsResponseType describeNetworkAclsResponseType = (DescribeNetworkAclsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeNetworkAclsType);
        if (describeNetworkAclsResponseType.getNetworkAclSet() == null || describeNetworkAclsResponseType.getNetworkAclSet().getItem() == null || describeNetworkAclsResponseType.getNetworkAclSet().getItem().isEmpty()) {
            return null;
        }
        for (NetworkAclType networkAclType : describeNetworkAclsResponseType.getNetworkAclSet().getItem()) {
            if (!vpcId.equals(networkAclType.getVpcId()) || !networkAclType.get_default().booleanValue()) continue;
            return networkAclType.getNetworkAclId();
        }
        return null;
    }

    private String checkSubnetIdAndGetVpcIdForDelete(ServiceConfiguration configuration) throws Exception {
        DescribeSubnetsType describeSubnetsType = MessageHelper.createMessage(DescribeSubnetsType.class, this.info.getEffectiveUserId());
        SubnetIdSetType SubnetIdSet = new SubnetIdSetType();
        SubnetIdSetItemType SubnetIdSetItem = new SubnetIdSetItemType();
        SubnetIdSetItem.setSubnetId(this.properties.getSubnetId());
        SubnetIdSet.setItem(Lists.newArrayList((Object[])new SubnetIdSetItemType[]{SubnetIdSetItem}));
        describeSubnetsType.setSubnetSet(SubnetIdSet);
        DescribeSubnetsResponseType describeSubnetsResponseType = (DescribeSubnetsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeSubnetsType);
        if (describeSubnetsResponseType.getSubnetSet() == null || describeSubnetsResponseType.getSubnetSet().getItem() == null || describeSubnetsResponseType.getSubnetSet().getItem().isEmpty()) {
            return null;
        }
        return ((SubnetType)describeSubnetsResponseType.getSubnetSet().getItem().get(0)).getVpcId();
    }

    private boolean networkAclExistsForDelete(ServiceConfiguration configuration) throws Exception {
        DescribeNetworkAclsType describeNetworkAclsType = MessageHelper.createMessage(DescribeNetworkAclsType.class, this.info.getEffectiveUserId());
        NetworkAclIdSetType networkAclIdSet = new NetworkAclIdSetType();
        NetworkAclIdSetItemType networkAclIdSetItem = new NetworkAclIdSetItemType();
        networkAclIdSetItem.setNetworkAclId(this.properties.getNetworkAclId());
        networkAclIdSet.setItem(Lists.newArrayList((Object[])new NetworkAclIdSetItemType[]{networkAclIdSetItem}));
        describeNetworkAclsType.setNetworkAclIdSet(networkAclIdSet);
        DescribeNetworkAclsResponseType describeNetworkAclsResponseType = (DescribeNetworkAclsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeNetworkAclsType);
        return describeNetworkAclsResponseType.getNetworkAclSet() != null && describeNetworkAclsResponseType.getNetworkAclSet().getItem() != null && !describeNetworkAclsResponseType.getNetworkAclSet().getItem().isEmpty();
    }

    private boolean associationIdExistsForDelete(ServiceConfiguration configuration) throws Exception {
        DescribeNetworkAclsType describeNetworkAclsType = MessageHelper.createMessage(DescribeNetworkAclsType.class, this.info.getEffectiveUserId());
        ArrayList filterSet = Lists.newArrayList();
        Filter filter = new Filter();
        filter.setName("association.association-id");
        filter.setValueSet(Lists.newArrayList((Object[])new String[]{this.info.getPhysicalResourceId()}));
        filterSet.add(filter);
        describeNetworkAclsType.setFilterSet(filterSet);
        DescribeNetworkAclsResponseType describeNetworkAclsResponseType = (DescribeNetworkAclsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeNetworkAclsType);
        return describeNetworkAclsResponseType.getNetworkAclSet() != null && describeNetworkAclsResponseType.getNetworkAclSet().getItem() != null && !describeNetworkAclsResponseType.getNetworkAclSet().getItem().isEmpty();
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_ASSOCIATION{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2SubnetNetworkAclAssociationResourceAction action = (AWSEC2SubnetNetworkAclAssociationResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                if (!action.associationIdExistsForDelete(configuration)) {
                    return action;
                }
                if (!action.networkAclExistsForDelete(configuration)) {
                    return action;
                }
                String vpcId = action.checkSubnetIdAndGetVpcIdForDelete(configuration);
                if (vpcId == null) {
                    return action;
                }
                String defaultNetworkAclId = action.findDefaultNetworkAclId(configuration, vpcId);
                if (defaultNetworkAclId == null) {
                    throw new ValidationErrorException("Unable to find the default network acl id for vpc " + vpcId);
                }
                action.replaceAssociation(configuration, action.info.getPhysicalResourceId(), defaultNetworkAclId);
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_ASSOCIATION{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2SubnetNetworkAclAssociationResourceAction action = (AWSEC2SubnetNetworkAclAssociationResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                action.checkNetworkAclExists(configuration);
                action.checkSubnetExists(configuration);
                String associationId = action.getAssociationId(configuration);
                if (associationId == null) {
                    throw new ValidationErrorException("Unable to find current network acl association id for subnet with id " + action.properties.getSubnetId());
                }
                String newAssociationId = action.replaceAssociation(configuration, associationId, action.properties.getNetworkAclId());
                action.info.setPhysicalResourceId(newAssociationId);
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

