/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.auth.Accounts;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.EC2Helper;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.TagHelper;
import com.eucalyptus.cloudformation.resources.standard.info.AWSEC2SecurityGroupResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSEC2SecurityGroupProperties;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.EC2SecurityGroupRule;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.EC2Tag;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.ValidationFailedException;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.AuthorizeSecurityGroupEgressResponseType;
import com.eucalyptus.compute.common.AuthorizeSecurityGroupEgressType;
import com.eucalyptus.compute.common.AuthorizeSecurityGroupIngressResponseType;
import com.eucalyptus.compute.common.AuthorizeSecurityGroupIngressType;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.compute.common.CreateSecurityGroupResponseType;
import com.eucalyptus.compute.common.CreateSecurityGroupType;
import com.eucalyptus.compute.common.CreateTagsType;
import com.eucalyptus.compute.common.DeleteSecurityGroupType;
import com.eucalyptus.compute.common.DescribeSecurityGroupsResponseType;
import com.eucalyptus.compute.common.DescribeSecurityGroupsType;
import com.eucalyptus.compute.common.IpPermissionType;
import com.eucalyptus.compute.common.RevokeSecurityGroupEgressResponseType;
import com.eucalyptus.compute.common.RevokeSecurityGroupEgressType;
import com.eucalyptus.compute.common.UserIdGroupPairType;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

@ConfigurableClass(root="cloudformation", description="Parameters controlling cloud formation")
public class AWSEC2SecurityGroupResourceAction
extends ResourceAction {
    @ConfigurableField(initial="300", description="The amount of time (in seconds) to retry security group deletes (may fail if instances from autoscaling group)")
    public static volatile Integer SECURITY_GROUP_MAX_DELETE_RETRY_SECS = 300;
    private static final Logger LOG = Logger.getLogger(AWSEC2SecurityGroupResourceAction.class);
    private AWSEC2SecurityGroupProperties properties = new AWSEC2SecurityGroupProperties();
    private AWSEC2SecurityGroupResourceInfo info = new AWSEC2SecurityGroupResourceInfo();

    public AWSEC2SecurityGroupResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSEC2SecurityGroupProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSEC2SecurityGroupResourceInfo)resourceInfo;
    }

    private static final IpPermissionType DEFAULT_EGRESS_RULE() {
        IpPermissionType ipPermissionType = new IpPermissionType();
        ipPermissionType.setIpProtocol("-1");
        ipPermissionType.setCidrIpRanges((Collection)Lists.newArrayList((Object[])new String[]{"0.0.0.0/0"}));
        return ipPermissionType;
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_GROUP{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2SecurityGroupResourceAction action = (AWSEC2SecurityGroupResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                String groupId = JsonHelper.getJsonNodeFromString(action.info.getGroupId()).asText();
                DescribeSecurityGroupsType describeSecurityGroupsType = MessageHelper.createMessage(DescribeSecurityGroupsType.class, action.info.getEffectiveUserId());
                describeSecurityGroupsType.setSecurityGroupIdSet(Lists.newArrayList((Object[])new String[]{groupId}));
                DescribeSecurityGroupsResponseType describeSecurityGroupsResponseType = (DescribeSecurityGroupsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeSecurityGroupsType);
                ArrayList securityGroupItemTypeArrayList = describeSecurityGroupsResponseType.getSecurityGroupInfo();
                if (securityGroupItemTypeArrayList == null || securityGroupItemTypeArrayList.isEmpty()) {
                    return action;
                }
                DeleteSecurityGroupType deleteSecurityGroupType = MessageHelper.createMessage(DeleteSecurityGroupType.class, action.info.getEffectiveUserId());
                deleteSecurityGroupType.setGroupId(groupId);
                try {
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deleteSecurityGroupType);
                    return action;
                }
                catch (Exception ex) {
                    Throwable cause = Throwables.getRootCause((Throwable)ex);
                    throw new ValidationFailedException(ex.getMessage());
                }
            }

            @Override
            public Integer getTimeout() {
                return SECURITY_GROUP_MAX_DELETE_RETRY_SECS;
            }
        };

    }

    private static enum CreateSteps implements Step
    {
        CREATE_GROUP{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2SecurityGroupResourceAction action = (AWSEC2SecurityGroupResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                CreateSecurityGroupType createSecurityGroupType = MessageHelper.createMessage(CreateSecurityGroupType.class, action.info.getEffectiveUserId());
                if (!Strings.isNullOrEmpty((String)action.properties.getGroupDescription())) {
                    createSecurityGroupType.setGroupDescription(action.properties.getGroupDescription());
                }
                if (!Strings.isNullOrEmpty((String)action.properties.getVpcId())) {
                    createSecurityGroupType.setVpcId(action.properties.getVpcId());
                }
                String groupName = action.getDefaultPhysicalResourceId();
                createSecurityGroupType.setGroupName(groupName);
                CreateSecurityGroupResponseType createSecurityGroupResponseType = (CreateSecurityGroupResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createSecurityGroupType);
                String groupId = createSecurityGroupResponseType.getGroupId();
                if (!Strings.isNullOrEmpty((String)action.properties.getVpcId())) {
                    action.info.setPhysicalResourceId(groupId);
                } else {
                    action.info.setPhysicalResourceId(groupName);
                }
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                action.info.setGroupId(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(groupId)));
                return action;
            }
        }
        ,
        CREATE_TAGS{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2SecurityGroupResourceAction action = (AWSEC2SecurityGroupResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                String effectiveAdminUserId = Accounts.lookupUserById((String)action.info.getEffectiveUserId()).getAccount().lookupAdmin().getUserId();
                CreateTagsType createSystemTagsType = MessageHelper.createPrivilegedMessage(CreateTagsType.class, effectiveAdminUserId);
                createSystemTagsType.setResourcesSet(Lists.newArrayList((Object[])new String[]{JsonHelper.getJsonNodeFromString(action.info.getGroupId()).asText()}));
                createSystemTagsType.setTagSet(EC2Helper.createTagSet(TagHelper.getEC2SystemTags(action.info, action.getStackEntity())));
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createSystemTagsType);
                List<EC2Tag> tags = TagHelper.getEC2StackTags(action.getStackEntity());
                if (action.properties.getTags() != null && !action.properties.getTags().isEmpty()) {
                    TagHelper.checkReservedEC2TemplateTags(action.properties.getTags());
                    tags.addAll(action.properties.getTags());
                }
                if (!tags.isEmpty()) {
                    CreateTagsType createTagsType = MessageHelper.createMessage(CreateTagsType.class, action.info.getEffectiveUserId());
                    createTagsType.setResourcesSet(Lists.newArrayList((Object[])new String[]{JsonHelper.getJsonNodeFromString(action.info.getGroupId()).asText()}));
                    createTagsType.setTagSet(EC2Helper.createTagSet(tags));
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createTagsType);
                }
                return action;
            }
        }
        ,
        CREATE_INGRESS_RULES{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2SecurityGroupResourceAction action = (AWSEC2SecurityGroupResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (action.properties.getSecurityGroupIngress() != null && !action.properties.getSecurityGroupIngress().isEmpty()) {
                    for (EC2SecurityGroupRule ec2SecurityGroupRule : action.properties.getSecurityGroupIngress()) {
                        AuthorizeSecurityGroupIngressType authorizeSecurityGroupIngressType = MessageHelper.createMessage(AuthorizeSecurityGroupIngressType.class, action.info.getEffectiveUserId());
                        authorizeSecurityGroupIngressType.setGroupId(JsonHelper.getJsonNodeFromString(action.info.getGroupId()).asText());
                        if (!(Strings.isNullOrEmpty((String)ec2SecurityGroupRule.getCidrIp()) || Strings.isNullOrEmpty((String)ec2SecurityGroupRule.getSourceSecurityGroupId()) && Strings.isNullOrEmpty((String)ec2SecurityGroupRule.getSourceSecurityGroupName()) && Strings.isNullOrEmpty((String)ec2SecurityGroupRule.getSourceSecurityGroupOwnerId()))) {
                            throw new ValidationErrorException("Both CidrIp and SourceSecurityGroup cannot be specified in SecurityGroupIngress");
                        }
                        if (!Strings.isNullOrEmpty((String)ec2SecurityGroupRule.getSourceSecurityGroupId()) && !Strings.isNullOrEmpty((String)ec2SecurityGroupRule.getSourceSecurityGroupName())) {
                            throw new ValidationErrorException("Both SourceSecurityGroupName and SourceSecurityGroupId cannot be specified in SecurityGroupIngress");
                        }
                        IpPermissionType ipPermissionType = new IpPermissionType(ec2SecurityGroupRule.getIpProtocol(), ec2SecurityGroupRule.getFromPort(), ec2SecurityGroupRule.getToPort());
                        if (!Strings.isNullOrEmpty((String)ec2SecurityGroupRule.getCidrIp())) {
                            ipPermissionType.setCidrIpRanges((Collection)Lists.newArrayList((Object[])new String[]{ec2SecurityGroupRule.getCidrIp()}));
                        }
                        if (!Strings.isNullOrEmpty((String)ec2SecurityGroupRule.getSourceSecurityGroupId())) {
                            ipPermissionType.setGroups(Lists.newArrayList((Object[])new UserIdGroupPairType[]{new UserIdGroupPairType(ec2SecurityGroupRule.getSourceSecurityGroupOwnerId(), null, ec2SecurityGroupRule.getSourceSecurityGroupId())}));
                        }
                        if (!Strings.isNullOrEmpty((String)ec2SecurityGroupRule.getSourceSecurityGroupName())) {
                            String sourceSecurityGroupOwnerId = ec2SecurityGroupRule.getSourceSecurityGroupOwnerId();
                            if (Strings.isNullOrEmpty((String)sourceSecurityGroupOwnerId)) {
                                sourceSecurityGroupOwnerId = action.getStackEntity().getAccountId();
                            }
                            ipPermissionType.setGroups(Lists.newArrayList((Object[])new UserIdGroupPairType[]{new UserIdGroupPairType(sourceSecurityGroupOwnerId, ec2SecurityGroupRule.getSourceSecurityGroupName(), null)}));
                        }
                        authorizeSecurityGroupIngressType.setIpPermissions(Lists.newArrayList((Object[])new IpPermissionType[]{ipPermissionType}));
                        AuthorizeSecurityGroupIngressResponseType authorizeSecurityGroupIngressResponseType = (AuthorizeSecurityGroupIngressResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)authorizeSecurityGroupIngressType);
                    }
                }
                return action;
            }
        }
        ,
        CREATE_EGRESS_RULES{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2SecurityGroupResourceAction action = (AWSEC2SecurityGroupResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (action.properties.getSecurityGroupEgress() != null && !action.properties.getSecurityGroupEgress().isEmpty()) {
                    RevokeSecurityGroupEgressType revokeSecurityGroupEgressType = MessageHelper.createMessage(RevokeSecurityGroupEgressType.class, action.info.getEffectiveUserId());
                    revokeSecurityGroupEgressType.setGroupId(JsonHelper.getJsonNodeFromString(action.info.getGroupId()).asText());
                    revokeSecurityGroupEgressType.setIpPermissions(Lists.newArrayList((Object[])new IpPermissionType[]{AWSEC2SecurityGroupResourceAction.DEFAULT_EGRESS_RULE()}));
                    RevokeSecurityGroupEgressResponseType revokeSecurityGroupEgressResponseType = (RevokeSecurityGroupEgressResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)revokeSecurityGroupEgressType);
                    for (EC2SecurityGroupRule ec2SecurityGroupRule : action.properties.getSecurityGroupEgress()) {
                        AuthorizeSecurityGroupEgressType authorizeSecurityGroupEgressType = MessageHelper.createMessage(AuthorizeSecurityGroupEgressType.class, action.info.getEffectiveUserId());
                        authorizeSecurityGroupEgressType.setGroupId(JsonHelper.getJsonNodeFromString(action.info.getGroupId()).asText());
                        if (!Strings.isNullOrEmpty((String)ec2SecurityGroupRule.getCidrIp()) && !Strings.isNullOrEmpty((String)ec2SecurityGroupRule.getDestinationSecurityGroupId())) {
                            throw new ValidationErrorException("Both CidrIp and DestinationSecurityGroup cannot be specified in SecurityGroupEgress");
                        }
                        IpPermissionType ipPermissionType = new IpPermissionType(ec2SecurityGroupRule.getIpProtocol(), ec2SecurityGroupRule.getFromPort(), ec2SecurityGroupRule.getToPort());
                        if (!Strings.isNullOrEmpty((String)ec2SecurityGroupRule.getCidrIp())) {
                            ipPermissionType.setCidrIpRanges((Collection)Lists.newArrayList((Object[])new String[]{ec2SecurityGroupRule.getCidrIp()}));
                        }
                        if (!Strings.isNullOrEmpty((String)ec2SecurityGroupRule.getDestinationSecurityGroupId())) {
                            ipPermissionType.setGroups(Lists.newArrayList((Object[])new UserIdGroupPairType[]{new UserIdGroupPairType(null, null, ec2SecurityGroupRule.getDestinationSecurityGroupId())}));
                        }
                        authorizeSecurityGroupEgressType.setIpPermissions(Lists.newArrayList((Object[])new IpPermissionType[]{ipPermissionType}));
                        AuthorizeSecurityGroupEgressResponseType authorizeSecurityGroupEgressResponseType = (AuthorizeSecurityGroupEgressResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)authorizeSecurityGroupEgressType);
                    }
                }
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

