/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSEC2SecurityGroupIngressResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSEC2SecurityGroupIngressProperties;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.AuthorizeSecurityGroupIngressResponseType;
import com.eucalyptus.compute.common.AuthorizeSecurityGroupIngressType;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.compute.common.DescribeSecurityGroupsResponseType;
import com.eucalyptus.compute.common.DescribeSecurityGroupsType;
import com.eucalyptus.compute.common.IpPermissionType;
import com.eucalyptus.compute.common.RevokeSecurityGroupIngressResponseType;
import com.eucalyptus.compute.common.RevokeSecurityGroupIngressType;
import com.eucalyptus.compute.common.SecurityGroupItemType;
import com.eucalyptus.compute.common.UserIdGroupPairType;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class AWSEC2SecurityGroupIngressResourceAction
extends ResourceAction {
    private static final Logger LOG = Logger.getLogger(AWSEC2SecurityGroupIngressResourceAction.class);
    private AWSEC2SecurityGroupIngressProperties properties = new AWSEC2SecurityGroupIngressProperties();
    private AWSEC2SecurityGroupIngressResourceInfo info = new AWSEC2SecurityGroupIngressResourceInfo();

    public AWSEC2SecurityGroupIngressResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSEC2SecurityGroupIngressProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSEC2SecurityGroupIngressResourceInfo)resourceInfo;
    }

    private void validateProperties() throws ValidationErrorException {
        if (Strings.isNullOrEmpty((String)this.properties.getGroupId()) && Strings.isNullOrEmpty((String)this.properties.getGroupName())) {
            throw new ValidationErrorException("Exactly one of GroupName and GroupId must be specified");
        }
        if (!Strings.isNullOrEmpty((String)this.properties.getGroupId()) && !Strings.isNullOrEmpty((String)this.properties.getGroupName())) {
            throw new ValidationErrorException("Exactly one of GroupName and GroupId must be specified");
        }
        if (!(Strings.isNullOrEmpty((String)this.properties.getCidrIp()) || Strings.isNullOrEmpty((String)this.properties.getSourceSecurityGroupId()) && Strings.isNullOrEmpty((String)this.properties.getSourceSecurityGroupName()) && Strings.isNullOrEmpty((String)this.properties.getSourceSecurityGroupOwnerId()))) {
            throw new ValidationErrorException("Both CidrIp and SourceSecurityGroup cannot be specified");
        }
        if (!Strings.isNullOrEmpty((String)this.properties.getSourceSecurityGroupId()) && !Strings.isNullOrEmpty((String)this.properties.getSourceSecurityGroupName())) {
            throw new ValidationErrorException("Both SourceSecurityGroupName and SourceSecurityGroupId cannot be specified");
        }
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_INGRESS_RULE{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                ArrayList securityGroupItemTypeArrayList;
                DescribeSecurityGroupsResponseType describeSecurityGroupsResponseType;
                DescribeSecurityGroupsType describeSecurityGroupsType;
                AWSEC2SecurityGroupIngressResourceAction action = (AWSEC2SecurityGroupIngressResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                action.validateProperties();
                if (!Strings.isNullOrEmpty((String)action.properties.getGroupId())) {
                    describeSecurityGroupsType = MessageHelper.createMessage(DescribeSecurityGroupsType.class, action.info.getEffectiveUserId());
                    describeSecurityGroupsType.setSecurityGroupIdSet(Lists.newArrayList((Object[])new String[]{action.properties.getGroupId()}));
                    describeSecurityGroupsResponseType = (DescribeSecurityGroupsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeSecurityGroupsType);
                    securityGroupItemTypeArrayList = describeSecurityGroupsResponseType.getSecurityGroupInfo();
                    if (securityGroupItemTypeArrayList == null || securityGroupItemTypeArrayList.isEmpty()) {
                        return action;
                    }
                }
                if (!Strings.isNullOrEmpty((String)action.properties.getGroupName())) {
                    describeSecurityGroupsType = MessageHelper.createMessage(DescribeSecurityGroupsType.class, action.info.getEffectiveUserId());
                    describeSecurityGroupsType.setSecurityGroupSet(Lists.newArrayList((Object[])new String[]{action.properties.getGroupName()}));
                    describeSecurityGroupsResponseType = (DescribeSecurityGroupsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeSecurityGroupsType);
                    securityGroupItemTypeArrayList = describeSecurityGroupsResponseType.getSecurityGroupInfo();
                    if (securityGroupItemTypeArrayList == null || securityGroupItemTypeArrayList.isEmpty()) {
                        return action;
                    }
                    boolean foundNonVpc = false;
                    for (SecurityGroupItemType securityGroupItemType : securityGroupItemTypeArrayList) {
                        if (!Strings.isNullOrEmpty((String)securityGroupItemType.getVpcId())) continue;
                        foundNonVpc = true;
                        break;
                    }
                    if (!foundNonVpc) {
                        return action;
                    }
                }
                RevokeSecurityGroupIngressType revokeSecurityGroupIngressType = MessageHelper.createMessage(RevokeSecurityGroupIngressType.class, action.info.getEffectiveUserId());
                if (!Strings.isNullOrEmpty((String)action.properties.getGroupId())) {
                    revokeSecurityGroupIngressType.setGroupId(action.properties.getGroupId());
                }
                if (!Strings.isNullOrEmpty((String)action.properties.getGroupName())) {
                    revokeSecurityGroupIngressType.setGroupName(action.properties.getGroupName());
                }
                IpPermissionType ipPermissionType = new IpPermissionType(action.properties.getIpProtocol(), action.properties.getFromPort(), action.properties.getToPort());
                if (!Strings.isNullOrEmpty((String)action.properties.getCidrIp())) {
                    ipPermissionType.setCidrIpRanges((Collection)Lists.newArrayList((Object[])new String[]{action.properties.getCidrIp()}));
                }
                if (!Strings.isNullOrEmpty((String)action.properties.getSourceSecurityGroupId())) {
                    ipPermissionType.setGroups(Lists.newArrayList((Object[])new UserIdGroupPairType[]{new UserIdGroupPairType(action.properties.getSourceSecurityGroupOwnerId(), null, action.properties.getSourceSecurityGroupId())}));
                }
                if (!Strings.isNullOrEmpty((String)action.properties.getSourceSecurityGroupName())) {
                    String sourceSecurityGroupOwnerId = action.properties.getSourceSecurityGroupOwnerId();
                    if (Strings.isNullOrEmpty((String)sourceSecurityGroupOwnerId)) {
                        sourceSecurityGroupOwnerId = action.stackEntity.getAccountId();
                    }
                    ipPermissionType.setGroups(Lists.newArrayList((Object[])new UserIdGroupPairType[]{new UserIdGroupPairType(sourceSecurityGroupOwnerId, action.properties.getSourceSecurityGroupName(), null)}));
                }
                revokeSecurityGroupIngressType.setIpPermissions(Lists.newArrayList((Object[])new IpPermissionType[]{ipPermissionType}));
                RevokeSecurityGroupIngressResponseType revokeSecurityGroupIngressResponseType = (RevokeSecurityGroupIngressResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)revokeSecurityGroupIngressType);
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_INGRESS_RULE{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                ArrayList securityGroupItemTypeArrayList;
                DescribeSecurityGroupsResponseType describeSecurityGroupsResponseType;
                DescribeSecurityGroupsType describeSecurityGroupsType;
                AWSEC2SecurityGroupIngressResourceAction action = (AWSEC2SecurityGroupIngressResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                action.validateProperties();
                if (!Strings.isNullOrEmpty((String)action.properties.getGroupId())) {
                    describeSecurityGroupsType = MessageHelper.createMessage(DescribeSecurityGroupsType.class, action.info.getEffectiveUserId());
                    describeSecurityGroupsType.setSecurityGroupIdSet(Lists.newArrayList((Object[])new String[]{action.properties.getGroupId()}));
                    describeSecurityGroupsResponseType = (DescribeSecurityGroupsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeSecurityGroupsType);
                    securityGroupItemTypeArrayList = describeSecurityGroupsResponseType.getSecurityGroupInfo();
                    if (securityGroupItemTypeArrayList == null || securityGroupItemTypeArrayList.isEmpty()) {
                        throw new ValidationErrorException("No such group with id '" + action.properties.getGroupId() + "'");
                    }
                }
                if (!Strings.isNullOrEmpty((String)action.properties.getGroupName())) {
                    describeSecurityGroupsType = MessageHelper.createMessage(DescribeSecurityGroupsType.class, action.info.getEffectiveUserId());
                    describeSecurityGroupsType.setSecurityGroupSet(Lists.newArrayList((Object[])new String[]{action.properties.getGroupName()}));
                    describeSecurityGroupsResponseType = (DescribeSecurityGroupsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeSecurityGroupsType);
                    securityGroupItemTypeArrayList = describeSecurityGroupsResponseType.getSecurityGroupInfo();
                    if (securityGroupItemTypeArrayList == null || securityGroupItemTypeArrayList.isEmpty()) {
                        throw new ValidationErrorException("No such group with name '" + action.properties.getGroupName() + "'");
                    }
                    boolean foundNonVpc = false;
                    for (SecurityGroupItemType securityGroupItemType : securityGroupItemTypeArrayList) {
                        if (!Strings.isNullOrEmpty((String)securityGroupItemType.getVpcId())) continue;
                        foundNonVpc = true;
                        break;
                    }
                    if (!foundNonVpc) {
                        throw new ValidationErrorException("Invalid value '" + action.properties.getGroupName() + "' for groupName. " + "You may not reference VPC security groups by name. Please use the corresponding id for this operation.");
                    }
                }
                AuthorizeSecurityGroupIngressType authorizeSecurityGroupIngressType = MessageHelper.createMessage(AuthorizeSecurityGroupIngressType.class, action.info.getEffectiveUserId());
                if (!Strings.isNullOrEmpty((String)action.properties.getGroupId())) {
                    authorizeSecurityGroupIngressType.setGroupId(action.properties.getGroupId());
                }
                if (!Strings.isNullOrEmpty((String)action.properties.getGroupName())) {
                    authorizeSecurityGroupIngressType.setGroupName(action.properties.getGroupName());
                }
                IpPermissionType ipPermissionType = new IpPermissionType(action.properties.getIpProtocol(), action.properties.getFromPort(), action.properties.getToPort());
                if (!Strings.isNullOrEmpty((String)action.properties.getCidrIp())) {
                    ipPermissionType.setCidrIpRanges((Collection)Lists.newArrayList((Object[])new String[]{action.properties.getCidrIp()}));
                }
                if (!Strings.isNullOrEmpty((String)action.properties.getSourceSecurityGroupId())) {
                    ipPermissionType.setGroups(Lists.newArrayList((Object[])new UserIdGroupPairType[]{new UserIdGroupPairType(action.properties.getSourceSecurityGroupOwnerId(), null, action.properties.getSourceSecurityGroupId())}));
                }
                if (!Strings.isNullOrEmpty((String)action.properties.getSourceSecurityGroupName())) {
                    String sourceSecurityGroupOwnerId = action.properties.getSourceSecurityGroupOwnerId();
                    if (Strings.isNullOrEmpty((String)sourceSecurityGroupOwnerId)) {
                        sourceSecurityGroupOwnerId = action.stackEntity.getAccountId();
                    }
                    ipPermissionType.setGroups(Lists.newArrayList((Object[])new UserIdGroupPairType[]{new UserIdGroupPairType(sourceSecurityGroupOwnerId, action.properties.getSourceSecurityGroupName(), null)}));
                }
                authorizeSecurityGroupIngressType.setIpPermissions(Lists.newArrayList((Object[])new IpPermissionType[]{ipPermissionType}));
                AuthorizeSecurityGroupIngressResponseType authorizeSecurityGroupIngressResponseType = (AuthorizeSecurityGroupIngressResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)authorizeSecurityGroupIngressType);
                action.info.setPhysicalResourceId(action.info.getLogicalResourceId());
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

