/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSEC2SecurityGroupEgressResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSEC2SecurityGroupEgressProperties;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.AuthorizeSecurityGroupEgressResponseType;
import com.eucalyptus.compute.common.AuthorizeSecurityGroupEgressType;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.compute.common.DescribeSecurityGroupsResponseType;
import com.eucalyptus.compute.common.DescribeSecurityGroupsType;
import com.eucalyptus.compute.common.IpPermissionType;
import com.eucalyptus.compute.common.RevokeSecurityGroupEgressResponseType;
import com.eucalyptus.compute.common.RevokeSecurityGroupEgressType;
import com.eucalyptus.compute.common.SecurityGroupItemType;
import com.eucalyptus.compute.common.UserIdGroupPairType;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class AWSEC2SecurityGroupEgressResourceAction
extends ResourceAction {
    private AWSEC2SecurityGroupEgressProperties properties = new AWSEC2SecurityGroupEgressProperties();
    private AWSEC2SecurityGroupEgressResourceInfo info = new AWSEC2SecurityGroupEgressResourceInfo();

    public AWSEC2SecurityGroupEgressResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSEC2SecurityGroupEgressProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSEC2SecurityGroupEgressResourceInfo)resourceInfo;
    }

    private static final IpPermissionType DEFAULT_EGRESS_RULE() {
        IpPermissionType ipPermissionType = new IpPermissionType();
        ipPermissionType.setIpProtocol("-1");
        ipPermissionType.setCidrIpRanges((Collection)Lists.newArrayList((Object[])new String[]{"0.0.0.0/0"}));
        return ipPermissionType;
    }

    private boolean isDefaultEgressRule(IpPermissionType ipPermissionType) {
        return ipPermissionType.getIpProtocol().equals("-1") && ipPermissionType.getFromPort() == null && ipPermissionType.getToPort() == null && ipPermissionType.getCidrIpRanges() != null && ipPermissionType.getCidrIpRanges().size() == 1 && ((String)ipPermissionType.getCidrIpRanges().get(0)).equals("0.0.0.0/0");
    }

    private void validateProperties() throws ValidationErrorException {
        if (!Strings.isNullOrEmpty((String)this.properties.getCidrIp()) && !Strings.isNullOrEmpty((String)this.properties.getDestinationSecurityGroupId())) {
            throw new ValidationErrorException("Both CidrIp and DestinationSecurityGroup cannot be specified");
        }
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_EGRESS_RULE{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2SecurityGroupEgressResourceAction action = (AWSEC2SecurityGroupEgressResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                action.validateProperties();
                DescribeSecurityGroupsType describeSecurityGroupsType = MessageHelper.createMessage(DescribeSecurityGroupsType.class, action.info.getEffectiveUserId());
                describeSecurityGroupsType.setSecurityGroupIdSet(Lists.newArrayList((Object[])new String[]{action.properties.getGroupId()}));
                DescribeSecurityGroupsResponseType describeSecurityGroupsResponseType = (DescribeSecurityGroupsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeSecurityGroupsType);
                ArrayList securityGroupItemTypeArrayList = describeSecurityGroupsResponseType.getSecurityGroupInfo();
                if (securityGroupItemTypeArrayList == null || securityGroupItemTypeArrayList.isEmpty()) {
                    return action;
                }
                RevokeSecurityGroupEgressType revokeSecurityGroupEgressType = MessageHelper.createMessage(RevokeSecurityGroupEgressType.class, action.info.getEffectiveUserId());
                revokeSecurityGroupEgressType.setGroupId(action.properties.getGroupId());
                IpPermissionType ipPermissionType = new IpPermissionType(action.properties.getIpProtocol(), action.properties.getFromPort(), action.properties.getToPort());
                if (!Strings.isNullOrEmpty((String)action.properties.getCidrIp())) {
                    ipPermissionType.setCidrIpRanges((Collection)Lists.newArrayList((Object[])new String[]{action.properties.getCidrIp()}));
                }
                if (!Strings.isNullOrEmpty((String)action.properties.getDestinationSecurityGroupId())) {
                    ipPermissionType.setGroups(Lists.newArrayList((Object[])new UserIdGroupPairType[]{new UserIdGroupPairType(null, null, action.properties.getDestinationSecurityGroupId())}));
                }
                revokeSecurityGroupEgressType.setIpPermissions(Lists.newArrayList((Object[])new IpPermissionType[]{ipPermissionType}));
                RevokeSecurityGroupEgressResponseType revokeSecurityGroupEgressResponseType = (RevokeSecurityGroupEgressResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)revokeSecurityGroupEgressType);
                DescribeSecurityGroupsType describeSecurityGroupsType2 = MessageHelper.createMessage(DescribeSecurityGroupsType.class, action.info.getEffectiveUserId());
                describeSecurityGroupsType2.setSecurityGroupIdSet(Lists.newArrayList((Object[])new String[]{action.properties.getGroupId()}));
                DescribeSecurityGroupsResponseType describeSecurityGroupsResponseType2 = (DescribeSecurityGroupsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeSecurityGroupsType);
                ArrayList securityGroupItemTypeArrayList2 = describeSecurityGroupsResponseType2.getSecurityGroupInfo();
                if (securityGroupItemTypeArrayList2 == null || securityGroupItemTypeArrayList2.isEmpty()) {
                    return action;
                }
                if (((SecurityGroupItemType)securityGroupItemTypeArrayList2.get(0)).getIpPermissionsEgress() == null || ((SecurityGroupItemType)securityGroupItemTypeArrayList2.get(0)).getIpPermissionsEgress().isEmpty()) {
                    AuthorizeSecurityGroupEgressType authorizeSecurityGroupEgressType = MessageHelper.createMessage(AuthorizeSecurityGroupEgressType.class, action.info.getEffectiveUserId());
                    authorizeSecurityGroupEgressType.setGroupId(action.properties.getGroupId());
                    authorizeSecurityGroupEgressType.setIpPermissions(Lists.newArrayList((Object[])new IpPermissionType[]{AWSEC2SecurityGroupEgressResourceAction.DEFAULT_EGRESS_RULE()}));
                    AuthorizeSecurityGroupEgressResponseType authorizeSecurityGroupEgressResponseType = (AuthorizeSecurityGroupEgressResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)authorizeSecurityGroupEgressType);
                }
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_EGRESS_RULE{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2SecurityGroupEgressResourceAction action = (AWSEC2SecurityGroupEgressResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                action.validateProperties();
                DescribeSecurityGroupsType describeSecurityGroupsType = MessageHelper.createMessage(DescribeSecurityGroupsType.class, action.info.getEffectiveUserId());
                describeSecurityGroupsType.setSecurityGroupIdSet(Lists.newArrayList((Object[])new String[]{action.properties.getGroupId()}));
                DescribeSecurityGroupsResponseType describeSecurityGroupsResponseType = (DescribeSecurityGroupsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeSecurityGroupsType);
                ArrayList securityGroupItemTypeArrayList = describeSecurityGroupsResponseType.getSecurityGroupInfo();
                boolean hasDefaultEgressRule = false;
                if (securityGroupItemTypeArrayList == null || securityGroupItemTypeArrayList.isEmpty()) {
                    throw new ValidationErrorException("No such group with id '" + action.properties.getGroupId() + "'");
                }
                SecurityGroupItemType securityGroupItemType = (SecurityGroupItemType)securityGroupItemTypeArrayList.get(0);
                if (securityGroupItemType.getIpPermissionsEgress() != null) {
                    for (IpPermissionType ipPermissionType : securityGroupItemType.getIpPermissionsEgress()) {
                        if (!action.isDefaultEgressRule(ipPermissionType)) continue;
                        hasDefaultEgressRule = true;
                        break;
                    }
                }
                AuthorizeSecurityGroupEgressType authorizeSecurityGroupEgressType = MessageHelper.createMessage(AuthorizeSecurityGroupEgressType.class, action.info.getEffectiveUserId());
                authorizeSecurityGroupEgressType.setGroupId(action.properties.getGroupId());
                IpPermissionType ipPermissionType = new IpPermissionType(action.properties.getIpProtocol(), action.properties.getFromPort(), action.properties.getToPort());
                if (!Strings.isNullOrEmpty((String)action.properties.getCidrIp())) {
                    ipPermissionType.setCidrIpRanges((Collection)Lists.newArrayList((Object[])new String[]{action.properties.getCidrIp()}));
                }
                if (!Strings.isNullOrEmpty((String)action.properties.getDestinationSecurityGroupId())) {
                    ipPermissionType.setGroups(Lists.newArrayList((Object[])new UserIdGroupPairType[]{new UserIdGroupPairType(null, null, action.properties.getDestinationSecurityGroupId())}));
                }
                authorizeSecurityGroupEgressType.setIpPermissions(Lists.newArrayList((Object[])new IpPermissionType[]{ipPermissionType}));
                AuthorizeSecurityGroupEgressResponseType authorizeSecurityGroupIngressResponseType = (AuthorizeSecurityGroupEgressResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)authorizeSecurityGroupEgressType);
                if (hasDefaultEgressRule) {
                    RevokeSecurityGroupEgressType revokeSecurityGroupEgressType = MessageHelper.createMessage(RevokeSecurityGroupEgressType.class, action.info.getEffectiveUserId());
                    revokeSecurityGroupEgressType.setGroupId(action.properties.getGroupId());
                    revokeSecurityGroupEgressType.setIpPermissions(Lists.newArrayList((Object[])new IpPermissionType[]{AWSEC2SecurityGroupEgressResourceAction.DEFAULT_EGRESS_RULE()}));
                    RevokeSecurityGroupEgressResponseType revokeSecurityGroupEgressResponseType = (RevokeSecurityGroupEgressResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)revokeSecurityGroupEgressType);
                }
                action.info.setPhysicalResourceId(action.getDefaultPhysicalResourceId());
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

