/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSEC2RouteResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSEC2RouteProperties;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.compute.common.CreateRouteResponseType;
import com.eucalyptus.compute.common.CreateRouteType;
import com.eucalyptus.compute.common.DeleteRouteResponseType;
import com.eucalyptus.compute.common.DeleteRouteType;
import com.eucalyptus.compute.common.DescribeRouteTablesResponseType;
import com.eucalyptus.compute.common.DescribeRouteTablesType;
import com.eucalyptus.compute.common.RouteTableIdSetItemType;
import com.eucalyptus.compute.common.RouteTableIdSetType;
import com.eucalyptus.compute.common.RouteTableType;
import com.eucalyptus.compute.common.RouteType;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class AWSEC2RouteResourceAction
extends ResourceAction {
    private AWSEC2RouteProperties properties = new AWSEC2RouteProperties();
    private AWSEC2RouteResourceInfo info = new AWSEC2RouteResourceInfo();

    public AWSEC2RouteResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSEC2RouteProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSEC2RouteResourceInfo)resourceInfo;
    }

    private void validateProperties() throws ValidationErrorException {
        ArrayList oneOfTheseParams = Lists.newArrayList((Object[])new String[]{this.properties.getGatewayId(), this.properties.getInstanceId(), this.properties.getNetworkInterfaceId(), this.properties.getVpcPeeringConnectionId()});
        int numNonNullOrEmpty = 0;
        for (String item : oneOfTheseParams) {
            if (Strings.isNullOrEmpty((String)item)) continue;
            ++numNonNullOrEmpty;
        }
        if (numNonNullOrEmpty != 1) {
            throw new ValidationErrorException("Exactly one of GatewayID, InstanceID, NetworkInterfaceId, or VpcPeeringConnectionId must be specified");
        }
    }

    private boolean equalRoutes(AWSEC2RouteProperties properties, RouteType routeType) {
        if (!properties.getDestinationCidrBlock().equals(routeType.getDestinationCidrBlock())) {
            return false;
        }
        if (this.differentIfNotNullOrEmpty(properties.getInstanceId(), routeType.getInstanceId())) {
            return false;
        }
        if (this.differentIfNotNullOrEmpty(properties.getGatewayId(), routeType.getGatewayId())) {
            return false;
        }
        if (this.differentIfNotNullOrEmpty(properties.getNetworkInterfaceId(), routeType.getNetworkInterfaceId())) {
            return false;
        }
        return !this.differentIfNotNullOrEmpty(properties.getVpcPeeringConnectionId(), routeType.getVpcPeeringConnectionId());
    }

    private boolean differentIfNotNullOrEmpty(String s1, String s2) {
        if (Strings.isNullOrEmpty((String)s1) && Strings.isNullOrEmpty((String)s2)) {
            return false;
        }
        if (Strings.isNullOrEmpty((String)s1) != Strings.isNullOrEmpty((String)s2)) {
            return true;
        }
        return !s1.equals(s2);
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_ROUTE{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2RouteResourceAction action = (AWSEC2RouteResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                DescribeRouteTablesType describeRouteTablesType = MessageHelper.createMessage(DescribeRouteTablesType.class, action.info.getEffectiveUserId());
                RouteTableIdSetType routeTableIdSet = new RouteTableIdSetType();
                RouteTableIdSetItemType routeTableIdSetItem = new RouteTableIdSetItemType();
                routeTableIdSetItem.setRouteTableId(action.properties.getRouteTableId());
                routeTableIdSet.setItem(Lists.newArrayList((Object[])new RouteTableIdSetItemType[]{routeTableIdSetItem}));
                describeRouteTablesType.setRouteTableIdSet(routeTableIdSet);
                DescribeRouteTablesResponseType describeRouteTablesResponseType = (DescribeRouteTablesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeRouteTablesType);
                if (describeRouteTablesResponseType.getRouteTableSet() == null || describeRouteTablesResponseType.getRouteTableSet().getItem() == null || describeRouteTablesResponseType.getRouteTableSet().getItem().isEmpty()) {
                    return action;
                }
                boolean foundRoute = false;
                block0: for (RouteTableType routeTableType : describeRouteTablesResponseType.getRouteTableSet().getItem()) {
                    if (!action.properties.getRouteTableId().equals(routeTableType.getRouteTableId()) || routeTableType.getRouteSet() == null || routeTableType.getRouteSet().getItem() == null || routeTableType.getRouteSet().getItem().isEmpty()) continue;
                    for (RouteType routeType : routeTableType.getRouteSet().getItem()) {
                        if (!action.equalRoutes(action.properties, routeType)) continue;
                        foundRoute = true;
                        continue block0;
                    }
                }
                if (!foundRoute) {
                    return action;
                }
                DeleteRouteType deleteRouteType = MessageHelper.createMessage(DeleteRouteType.class, action.info.getEffectiveUserId());
                deleteRouteType.setRouteTableId(action.properties.getRouteTableId());
                deleteRouteType.setDestinationCidrBlock(action.properties.getDestinationCidrBlock());
                DeleteRouteResponseType deleteRouteResponseType = (DeleteRouteResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deleteRouteType);
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_ROUTE{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2RouteResourceAction action = (AWSEC2RouteResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                action.validateProperties();
                if (action.properties.getRouteTableId().isEmpty()) {
                    throw new ValidationErrorException("RouteTableId is a required field");
                }
                DescribeRouteTablesType describeRouteTablesType = MessageHelper.createMessage(DescribeRouteTablesType.class, action.info.getEffectiveUserId());
                RouteTableIdSetType routeTableIdSet = new RouteTableIdSetType();
                RouteTableIdSetItemType routeTableIdSetItem = new RouteTableIdSetItemType();
                routeTableIdSetItem.setRouteTableId(action.properties.getRouteTableId());
                routeTableIdSet.setItem(Lists.newArrayList((Object[])new RouteTableIdSetItemType[]{routeTableIdSetItem}));
                describeRouteTablesType.setRouteTableIdSet(routeTableIdSet);
                DescribeRouteTablesResponseType describeRouteTablesResponseType = (DescribeRouteTablesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeRouteTablesType);
                if (describeRouteTablesResponseType.getRouteTableSet() == null || describeRouteTablesResponseType.getRouteTableSet().getItem() == null || describeRouteTablesResponseType.getRouteTableSet().getItem().isEmpty()) {
                    throw new ValidationErrorException("No such route table with id '" + action.properties.getRouteTableId());
                }
                CreateRouteType createRouteType = MessageHelper.createMessage(CreateRouteType.class, action.info.getEffectiveUserId());
                createRouteType.setRouteTableId(action.properties.getRouteTableId());
                if (!Strings.isNullOrEmpty((String)action.properties.getGatewayId())) {
                    createRouteType.setGatewayId(action.properties.getGatewayId());
                }
                if (!Strings.isNullOrEmpty((String)action.properties.getInstanceId())) {
                    createRouteType.setInstanceId(action.properties.getInstanceId());
                }
                if (!Strings.isNullOrEmpty((String)action.properties.getVpcPeeringConnectionId())) {
                    createRouteType.setVpcPeeringConnectionId(action.properties.getVpcPeeringConnectionId());
                }
                if (!Strings.isNullOrEmpty((String)action.properties.getNetworkInterfaceId())) {
                    createRouteType.setNetworkInterfaceId(action.properties.getNetworkInterfaceId());
                }
                createRouteType.setDestinationCidrBlock(action.properties.getDestinationCidrBlock());
                CreateRouteResponseType createRouteResponseType = (CreateRouteResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createRouteType);
                action.info.setPhysicalResourceId(action.getDefaultPhysicalResourceId());
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

