/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.auth.Accounts;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.EC2Helper;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.TagHelper;
import com.eucalyptus.cloudformation.resources.standard.info.AWSEC2NetworkInterfaceResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSEC2NetworkInterfaceProperties;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.EC2Tag;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.PrivateIpAddressSpecification;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.ValidationFailedException;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.compute.common.CreateNetworkInterfaceResponseType;
import com.eucalyptus.compute.common.CreateNetworkInterfaceType;
import com.eucalyptus.compute.common.CreateTagsType;
import com.eucalyptus.compute.common.DeleteNetworkInterfaceType;
import com.eucalyptus.compute.common.DescribeNetworkInterfacesResponseType;
import com.eucalyptus.compute.common.DescribeNetworkInterfacesType;
import com.eucalyptus.compute.common.NetworkInterfaceIdSetItemType;
import com.eucalyptus.compute.common.NetworkInterfaceIdSetType;
import com.eucalyptus.compute.common.NetworkInterfacePrivateIpAddressesSetItemType;
import com.eucalyptus.compute.common.NetworkInterfaceType;
import com.eucalyptus.compute.common.PrivateIpAddressesSetItemRequestType;
import com.eucalyptus.compute.common.PrivateIpAddressesSetRequestType;
import com.eucalyptus.compute.common.SecurityGroupIdSetItemType;
import com.eucalyptus.compute.common.SecurityGroupIdSetType;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class AWSEC2NetworkInterfaceResourceAction
extends ResourceAction {
    private AWSEC2NetworkInterfaceProperties properties = new AWSEC2NetworkInterfaceProperties();
    private AWSEC2NetworkInterfaceResourceInfo info = new AWSEC2NetworkInterfaceResourceInfo();
    @ConfigurableField(initial="300", description="The amount of time (in seconds) to wait for a network interface to be available after create)")
    public static volatile Integer NETWORK_INTERFACE_AVAILABLE_MAX_CREATE_RETRY_SECS = 300;
    @ConfigurableField(initial="300", description="The amount of time (in seconds) to wait for a network interface to be deleted)")
    public static volatile Integer NETWORK_INTERFACE_DELETED_MAX_DELETE_RETRY_SECS = 300;

    public AWSEC2NetworkInterfaceResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    private NetworkInterfaceIdSetType getNetworkInterfaceIdSetType(String networkInterfaceId) {
        NetworkInterfaceIdSetType networkInterfaceIdSet = new NetworkInterfaceIdSetType();
        ArrayList item = Lists.newArrayList();
        NetworkInterfaceIdSetItemType networkInterfaceIdSetItemType = new NetworkInterfaceIdSetItemType();
        networkInterfaceIdSetItemType.setNetworkInterfaceId(networkInterfaceId);
        item.add(networkInterfaceIdSetItemType);
        networkInterfaceIdSet.setItem(item);
        return networkInterfaceIdSet;
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSEC2NetworkInterfaceProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSEC2NetworkInterfaceResourceInfo)resourceInfo;
    }

    private NetworkInterfaceIdSetType convertNetworkInterfaceIdSet(String networkInterfaceId) {
        NetworkInterfaceIdSetType networkInterfaceIdSetType = new NetworkInterfaceIdSetType();
        ArrayList item = Lists.newArrayList();
        NetworkInterfaceIdSetItemType networkInterfaceIdSetItemType = new NetworkInterfaceIdSetItemType();
        networkInterfaceIdSetItemType.setNetworkInterfaceId(networkInterfaceId);
        item.add(networkInterfaceIdSetItemType);
        networkInterfaceIdSetType.setItem(item);
        return networkInterfaceIdSetType;
    }

    private SecurityGroupIdSetType convertGroupSet(List<String> groupSet) {
        SecurityGroupIdSetType securityGroupIdSetType = new SecurityGroupIdSetType();
        ArrayList item = Lists.newArrayList();
        for (String groupId : groupSet) {
            SecurityGroupIdSetItemType securityGroupIdSetItemType = new SecurityGroupIdSetItemType();
            securityGroupIdSetItemType.setGroupId(groupId);
            item.add(securityGroupIdSetItemType);
        }
        securityGroupIdSetType.setItem(item);
        return securityGroupIdSetType;
    }

    private PrivateIpAddressesSetRequestType convertPrivateIpAddresses(List<PrivateIpAddressSpecification> privateIpAddresses) {
        PrivateIpAddressesSetRequestType privateIpAddressesSetRequestType = new PrivateIpAddressesSetRequestType();
        ArrayList item = Lists.newArrayList();
        for (PrivateIpAddressSpecification privateIpAddressSpecification : privateIpAddresses) {
            PrivateIpAddressesSetItemRequestType privateIpAddressesSetItemRequestType = new PrivateIpAddressesSetItemRequestType();
            privateIpAddressesSetItemRequestType.setPrivateIpAddress(privateIpAddressSpecification.getPrivateIpAddress());
            privateIpAddressesSetItemRequestType.setPrimary(privateIpAddressSpecification.getPrimary());
            item.add(privateIpAddressesSetItemRequestType);
        }
        privateIpAddressesSetRequestType.setItem(item);
        return privateIpAddressesSetRequestType;
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_NETWORK_INTERFACE{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2NetworkInterfaceResourceAction action = (AWSEC2NetworkInterfaceResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                if (DeleteSteps.checkDeleted(action, configuration)) {
                    return action;
                }
                DeleteNetworkInterfaceType deleteNetworkInterfaceType = MessageHelper.createMessage(DeleteNetworkInterfaceType.class, action.info.getEffectiveUserId());
                deleteNetworkInterfaceType.setNetworkInterfaceId(action.info.getPhysicalResourceId());
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deleteNetworkInterfaceType);
                return action;
            }
        }
        ,
        VERIFY_DELETE{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2NetworkInterfaceResourceAction action = (AWSEC2NetworkInterfaceResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                if (DeleteSteps.checkDeleted(action, configuration)) {
                    return action;
                }
                throw new ValidationFailedException("Network interface " + action.info.getPhysicalResourceId() + " not yet deleted");
            }

            @Override
            public Integer getTimeout() {
                return NETWORK_INTERFACE_DELETED_MAX_DELETE_RETRY_SECS;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }

        private static boolean checkDeleted(AWSEC2NetworkInterfaceResourceAction action, ServiceConfiguration configuration) throws Exception {
            DescribeNetworkInterfacesType describeNetworkInterfacesType = MessageHelper.createMessage(DescribeNetworkInterfacesType.class, action.info.getEffectiveUserId());
            describeNetworkInterfacesType.setNetworkInterfaceIdSet(action.convertNetworkInterfaceIdSet(action.info.getPhysicalResourceId()));
            DescribeNetworkInterfacesResponseType describeNetworkInterfacesResponseType = (DescribeNetworkInterfacesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeNetworkInterfacesType);
            return describeNetworkInterfacesResponseType.getNetworkInterfaceSet() == null || describeNetworkInterfacesResponseType.getNetworkInterfaceSet().getItem() == null || describeNetworkInterfacesResponseType.getNetworkInterfaceSet().getItem().isEmpty();
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_NETWORK_INTERFACE{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2NetworkInterfaceResourceAction action = (AWSEC2NetworkInterfaceResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                CreateNetworkInterfaceType createNetworkInterfaceType = MessageHelper.createMessage(CreateNetworkInterfaceType.class, action.info.getEffectiveUserId());
                createNetworkInterfaceType.setSubnetId(action.properties.getSubnetId());
                if (!Strings.isNullOrEmpty((String)action.properties.getDescription())) {
                    createNetworkInterfaceType.setDescription(action.properties.getDescription());
                }
                if (!Strings.isNullOrEmpty((String)action.properties.getPrivateIpAddress())) {
                    createNetworkInterfaceType.setPrivateIpAddress(action.properties.getPrivateIpAddress());
                }
                if (action.properties.getPrivateIpAddresses() != null && !action.properties.getPrivateIpAddresses().isEmpty()) {
                    createNetworkInterfaceType.setPrivateIpAddressesSet(action.convertPrivateIpAddresses(action.properties.getPrivateIpAddresses()));
                }
                if (action.properties.getGroupSet() != null && !action.properties.getGroupSet().isEmpty()) {
                    createNetworkInterfaceType.setGroupSet(action.convertGroupSet(action.properties.getGroupSet()));
                }
                if (action.properties.getSecondaryPrivateIpAddressCount() != null) {
                    action.properties.setSecondaryPrivateIpAddressCount(action.properties.getSecondaryPrivateIpAddressCount());
                }
                CreateNetworkInterfaceResponseType createNetworkInterfaceResponseType = (CreateNetworkInterfaceResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createNetworkInterfaceType);
                action.info.setPhysicalResourceId(createNetworkInterfaceResponseType.getNetworkInterface().getNetworkInterfaceId());
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        }
        ,
        GET_PRIVATE_IP_ADDRESS{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2NetworkInterfaceResourceAction action = (AWSEC2NetworkInterfaceResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                DescribeNetworkInterfacesType describeNetworkInterfacesType = MessageHelper.createMessage(DescribeNetworkInterfacesType.class, action.info.getEffectiveUserId());
                describeNetworkInterfacesType.setNetworkInterfaceIdSet(action.convertNetworkInterfaceIdSet(action.info.getPhysicalResourceId()));
                DescribeNetworkInterfacesResponseType describeNetworkInterfacesResponseType = (DescribeNetworkInterfacesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeNetworkInterfacesType);
                if (describeNetworkInterfacesResponseType.getNetworkInterfaceSet() == null || describeNetworkInterfacesResponseType.getNetworkInterfaceSet().getItem() == null || describeNetworkInterfacesResponseType.getNetworkInterfaceSet().getItem().size() != 1) {
                    throw new ValidationErrorException("Network interface " + action.info.getPhysicalResourceId() + " either does not exist or is not unique");
                }
                String primaryIp = null;
                boolean foundPrimary = false;
                ArrayNode secondaryIpArrayNode = new ObjectMapper().createArrayNode();
                for (NetworkInterfacePrivateIpAddressesSetItemType networkInterfacePrivateIpAddressesSetItemType : ((NetworkInterfaceType)describeNetworkInterfacesResponseType.getNetworkInterfaceSet().getItem().get(0)).getPrivateIpAddressesSet().getItem()) {
                    if (networkInterfacePrivateIpAddressesSetItemType.getPrimary().booleanValue()) {
                        if (foundPrimary) {
                            throw new ValidationErrorException("Network interface " + action.info.getPhysicalResourceId() + " has a non-unique primary private ip address");
                        }
                        primaryIp = networkInterfacePrivateIpAddressesSetItemType.getPrivateIpAddress();
                        foundPrimary = true;
                        continue;
                    }
                    secondaryIpArrayNode.add(networkInterfacePrivateIpAddressesSetItemType.getPrivateIpAddress());
                }
                if (!foundPrimary) {
                    throw new ValidationErrorException("Network interface " + action.info.getPhysicalResourceId() + " has no primary private ip address");
                }
                action.info.setPrimaryPrivateIpAddress(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(primaryIp)));
                action.info.setSecondaryPrivateIpAddresses(JsonHelper.getStringFromJsonNode((JsonNode)secondaryIpArrayNode));
                return action;
            }
        }
        ,
        VERIFY_AVAILABLE{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2NetworkInterfaceResourceAction action = (AWSEC2NetworkInterfaceResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                DescribeNetworkInterfacesType describeNetworkInterfacesType = MessageHelper.createMessage(DescribeNetworkInterfacesType.class, action.info.getEffectiveUserId());
                NetworkInterfaceIdSetType networkInterfaceIdSet = action.getNetworkInterfaceIdSetType(action.info.getPhysicalResourceId());
                describeNetworkInterfacesType.setNetworkInterfaceIdSet(networkInterfaceIdSet);
                DescribeNetworkInterfacesResponseType describeNetworkInterfacesResponseType = (DescribeNetworkInterfacesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeNetworkInterfacesType);
                if (describeNetworkInterfacesResponseType.getNetworkInterfaceSet().getItem().size() == 0) {
                    throw new ValidationFailedException("Network interface " + action.info.getPhysicalResourceId() + " not yet available");
                }
                if (!"available".equals(((NetworkInterfaceType)describeNetworkInterfacesResponseType.getNetworkInterfaceSet().getItem().get(0)).getStatus())) {
                    throw new ValidationFailedException("Volume " + action.info.getPhysicalResourceId() + " not yet available");
                }
                return action;
            }

            @Override
            public Integer getTimeout() {
                return NETWORK_INTERFACE_AVAILABLE_MAX_CREATE_RETRY_SECS;
            }
        }
        ,
        CREATE_TAGS{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2NetworkInterfaceResourceAction action = (AWSEC2NetworkInterfaceResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                String effectiveAdminUserId = Accounts.lookupUserById((String)action.info.getEffectiveUserId()).getAccount().lookupAdmin().getUserId();
                CreateTagsType createSystemTagsType = MessageHelper.createPrivilegedMessage(CreateTagsType.class, effectiveAdminUserId);
                createSystemTagsType.setResourcesSet(Lists.newArrayList((Object[])new String[]{action.info.getPhysicalResourceId()}));
                createSystemTagsType.setTagSet(EC2Helper.createTagSet(TagHelper.getEC2SystemTags(action.info, action.getStackEntity())));
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createSystemTagsType);
                List<EC2Tag> tags = TagHelper.getEC2StackTags(action.getStackEntity());
                if (action.properties.getTags() != null && !action.properties.getTags().isEmpty()) {
                    TagHelper.checkReservedEC2TemplateTags(action.properties.getTags());
                    tags.addAll(action.properties.getTags());
                }
                if (!tags.isEmpty()) {
                    CreateTagsType createTagsType = MessageHelper.createMessage(CreateTagsType.class, action.info.getEffectiveUserId());
                    createTagsType.setResourcesSet(Lists.newArrayList((Object[])new String[]{action.info.getPhysicalResourceId()}));
                    createTagsType.setTagSet(EC2Helper.createTagSet(tags));
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createTagsType);
                }
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

