/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSEC2NetworkAclEntryResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSEC2NetworkAclEntryProperties;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.EC2ICMP;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.EC2PortRange;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.compute.common.CreateNetworkAclEntryResponseType;
import com.eucalyptus.compute.common.CreateNetworkAclEntryType;
import com.eucalyptus.compute.common.DeleteNetworkAclEntryResponseType;
import com.eucalyptus.compute.common.DeleteNetworkAclEntryType;
import com.eucalyptus.compute.common.DescribeNetworkAclsResponseType;
import com.eucalyptus.compute.common.DescribeNetworkAclsType;
import com.eucalyptus.compute.common.IcmpTypeCodeType;
import com.eucalyptus.compute.common.NetworkAclEntryType;
import com.eucalyptus.compute.common.NetworkAclIdSetItemType;
import com.eucalyptus.compute.common.NetworkAclIdSetType;
import com.eucalyptus.compute.common.NetworkAclType;
import com.eucalyptus.compute.common.PortRangeType;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.List;
import javax.annotation.Nullable;

public class AWSEC2NetworkAclEntryResourceAction
extends ResourceAction {
    private AWSEC2NetworkAclEntryProperties properties = new AWSEC2NetworkAclEntryProperties();
    private AWSEC2NetworkAclEntryResourceInfo info = new AWSEC2NetworkAclEntryResourceInfo();

    public AWSEC2NetworkAclEntryResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSEC2NetworkAclEntryProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSEC2NetworkAclEntryResourceInfo)resourceInfo;
    }

    private PortRangeType convertPortRange(EC2PortRange portRange) {
        if (portRange == null) {
            return null;
        }
        PortRangeType portRangeType = new PortRangeType();
        portRangeType.setFrom(portRange.getFrom());
        portRangeType.setTo(portRange.getTo());
        return portRangeType;
    }

    private IcmpTypeCodeType convertIcmpTypeCode(EC2ICMP icmp) {
        if (icmp == null) {
            return null;
        }
        IcmpTypeCodeType icmpTypeCodeType = new IcmpTypeCodeType();
        icmpTypeCodeType.setCode(icmp.getCode());
        icmpTypeCodeType.setType(icmp.getType());
        return icmpTypeCodeType;
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_NETWORK_ACL_ENTRY{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2NetworkAclEntryResourceAction action = (AWSEC2NetworkAclEntryResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                DescribeNetworkAclsType describeNetworkAclsType = MessageHelper.createMessage(DescribeNetworkAclsType.class, action.info.getEffectiveUserId());
                NetworkAclIdSetType networkAclIdSet = new NetworkAclIdSetType();
                NetworkAclIdSetItemType networkAclIdSetItem = new NetworkAclIdSetItemType();
                networkAclIdSetItem.setNetworkAclId(action.properties.getNetworkAclId());
                networkAclIdSet.setItem(Lists.newArrayList((Object[])new NetworkAclIdSetItemType[]{networkAclIdSetItem}));
                describeNetworkAclsType.setNetworkAclIdSet(networkAclIdSet);
                DescribeNetworkAclsResponseType describeNetworkAclsResponseType = (DescribeNetworkAclsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeNetworkAclsType);
                if (describeNetworkAclsResponseType.getNetworkAclSet() == null || describeNetworkAclsResponseType.getNetworkAclSet().getItem() == null || describeNetworkAclsResponseType.getNetworkAclSet().getItem().isEmpty()) {
                    return action;
                }
                boolean foundEntry = false;
                block0: for (NetworkAclType networkAclType : describeNetworkAclsResponseType.getNetworkAclSet().getItem()) {
                    if (networkAclType.getEntrySet() == null || networkAclType.getEntrySet().getItem() == null) continue;
                    for (NetworkAclEntryType networkAclEntryType : networkAclType.getEntrySet().getItem()) {
                        if (!action.properties.getRuleNumber().equals(networkAclEntryType.getRuleNumber()) || !action.properties.getEgress().equals(networkAclEntryType.getEgress())) continue;
                        foundEntry = true;
                        continue block0;
                    }
                }
                if (!foundEntry) {
                    return action;
                }
                DeleteNetworkAclEntryType deleteNetworkAclEntryType = MessageHelper.createMessage(DeleteNetworkAclEntryType.class, action.info.getEffectiveUserId());
                deleteNetworkAclEntryType.setNetworkAclId(action.properties.getNetworkAclId());
                deleteNetworkAclEntryType.setEgress(action.properties.getEgress());
                deleteNetworkAclEntryType.setRuleNumber(action.properties.getRuleNumber());
                DeleteNetworkAclEntryResponseType deleteNetworkAclEntryResponseType = (DeleteNetworkAclEntryResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deleteNetworkAclEntryType);
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_NETWORK_ACL_ENTRY{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2NetworkAclEntryResourceAction action = (AWSEC2NetworkAclEntryResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (action.properties.getNetworkAclId().isEmpty()) {
                    throw new ValidationErrorException("NetworkAclId is a required field");
                }
                DescribeNetworkAclsType describeNetworkAclsType = MessageHelper.createMessage(DescribeNetworkAclsType.class, action.info.getEffectiveUserId());
                NetworkAclIdSetType networkAclIdSet = new NetworkAclIdSetType();
                NetworkAclIdSetItemType networkAclIdSetItem = new NetworkAclIdSetItemType();
                networkAclIdSetItem.setNetworkAclId(action.properties.getNetworkAclId());
                networkAclIdSet.setItem(Lists.newArrayList((Object[])new NetworkAclIdSetItemType[]{networkAclIdSetItem}));
                describeNetworkAclsType.setNetworkAclIdSet(networkAclIdSet);
                DescribeNetworkAclsResponseType describeNetworkAclsResponseType = (DescribeNetworkAclsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeNetworkAclsType);
                if (describeNetworkAclsResponseType.getNetworkAclSet() == null || describeNetworkAclsResponseType.getNetworkAclSet().getItem() == null || describeNetworkAclsResponseType.getNetworkAclSet().getItem().isEmpty()) {
                    throw new ValidationErrorException("No such network acl with id '" + action.properties.getNetworkAclId());
                }
                CreateNetworkAclEntryType createNetworkAclEntryType = MessageHelper.createMessage(CreateNetworkAclEntryType.class, action.info.getEffectiveUserId());
                createNetworkAclEntryType.setCidrBlock(action.properties.getCidrBlock());
                if (action.properties.getEgress() != null) {
                    createNetworkAclEntryType.setEgress(action.properties.getEgress());
                }
                createNetworkAclEntryType.setIcmpTypeCode(action.convertIcmpTypeCode(action.properties.getIcmp()));
                createNetworkAclEntryType.setNetworkAclId(action.properties.getNetworkAclId());
                createNetworkAclEntryType.setPortRange(action.convertPortRange(action.properties.getPortRange()));
                createNetworkAclEntryType.setProtocol(action.properties.getProtocol() == null ? null : String.valueOf(action.properties.getProtocol()));
                createNetworkAclEntryType.setRuleAction(action.properties.getRuleAction());
                createNetworkAclEntryType.setRuleNumber(action.properties.getRuleNumber());
                CreateNetworkAclEntryResponseType CreateNetworkAclEntryResponseType2 = (CreateNetworkAclEntryResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createNetworkAclEntryType);
                action.info.setPhysicalResourceId(action.getDefaultPhysicalResourceId());
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

