/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.auth.Accounts;
import com.eucalyptus.cloudformation.resources.EC2Helper;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.TagHelper;
import com.eucalyptus.cloudformation.resources.standard.info.AWSEC2InternetGatewayResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSEC2InternetGatewayProperties;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.EC2Tag;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.compute.common.CreateInternetGatewayResponseType;
import com.eucalyptus.compute.common.CreateInternetGatewayType;
import com.eucalyptus.compute.common.CreateTagsType;
import com.eucalyptus.compute.common.DeleteInternetGatewayType;
import com.eucalyptus.compute.common.DescribeInternetGatewaysResponseType;
import com.eucalyptus.compute.common.DescribeInternetGatewaysType;
import com.eucalyptus.compute.common.InternetGatewayIdSetItemType;
import com.eucalyptus.compute.common.InternetGatewayIdSetType;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.List;

public class AWSEC2InternetGatewayResourceAction
extends ResourceAction {
    private AWSEC2InternetGatewayProperties properties = new AWSEC2InternetGatewayProperties();
    private AWSEC2InternetGatewayResourceInfo info = new AWSEC2InternetGatewayResourceInfo();

    public AWSEC2InternetGatewayResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSEC2InternetGatewayProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSEC2InternetGatewayResourceInfo)resourceInfo;
    }

    private void setInternetGatewayId(DescribeInternetGatewaysType describeInternetGatewaysType, String internetGatewayId) {
        InternetGatewayIdSetType internetGatewaySet = new InternetGatewayIdSetType();
        describeInternetGatewaysType.setInternetGatewayIdSet(internetGatewaySet);
        ArrayList item = Lists.newArrayList();
        internetGatewaySet.setItem(item);
        InternetGatewayIdSetItemType internetGatewayIdSetItemType = new InternetGatewayIdSetItemType();
        item.add(internetGatewayIdSetItemType);
        internetGatewayIdSetItemType.setInternetGatewayId(internetGatewayId);
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_GATEWAY{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2InternetGatewayResourceAction action = (AWSEC2InternetGatewayResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                DescribeInternetGatewaysType describeInternetGatewaysType = MessageHelper.createMessage(DescribeInternetGatewaysType.class, action.info.getEffectiveUserId());
                action.setInternetGatewayId(describeInternetGatewaysType, action.info.getPhysicalResourceId());
                DescribeInternetGatewaysResponseType describeInternetGatewaysResponseType = (DescribeInternetGatewaysResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeInternetGatewaysType);
                if (describeInternetGatewaysResponseType.getInternetGatewaySet() == null || describeInternetGatewaysResponseType.getInternetGatewaySet().getItem() == null || describeInternetGatewaysResponseType.getInternetGatewaySet().getItem().isEmpty()) {
                    return action;
                }
                DeleteInternetGatewayType deleteInternetGatewayType = MessageHelper.createMessage(DeleteInternetGatewayType.class, action.info.getEffectiveUserId());
                deleteInternetGatewayType.setInternetGatewayId(action.info.getPhysicalResourceId());
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deleteInternetGatewayType);
                return action;
            }
        };


        @Override
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_GATEWAY{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2InternetGatewayResourceAction action = (AWSEC2InternetGatewayResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                CreateInternetGatewayType createInternetGatewayType = MessageHelper.createMessage(CreateInternetGatewayType.class, action.info.getEffectiveUserId());
                CreateInternetGatewayResponseType createInternetGatewayResponseType = (CreateInternetGatewayResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createInternetGatewayType);
                action.info.setPhysicalResourceId(createInternetGatewayResponseType.getInternetGateway().getInternetGatewayId());
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        }
        ,
        CREATE_TAGS{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2InternetGatewayResourceAction action = (AWSEC2InternetGatewayResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                String effectiveAdminUserId = Accounts.lookupUserById((String)action.info.getEffectiveUserId()).getAccount().lookupAdmin().getUserId();
                CreateTagsType createSystemTagsType = MessageHelper.createPrivilegedMessage(CreateTagsType.class, effectiveAdminUserId);
                createSystemTagsType.setResourcesSet(Lists.newArrayList((Object[])new String[]{action.info.getPhysicalResourceId()}));
                createSystemTagsType.setTagSet(EC2Helper.createTagSet(TagHelper.getEC2SystemTags(action.info, action.getStackEntity())));
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createSystemTagsType);
                List<EC2Tag> tags = TagHelper.getEC2StackTags(action.getStackEntity());
                if (action.properties.getTags() != null && !action.properties.getTags().isEmpty()) {
                    TagHelper.checkReservedEC2TemplateTags(action.properties.getTags());
                    tags.addAll(action.properties.getTags());
                }
                if (!tags.isEmpty()) {
                    CreateTagsType createTagsType = MessageHelper.createMessage(CreateTagsType.class, action.info.getEffectiveUserId());
                    createTagsType.setResourcesSet(Lists.newArrayList((Object[])new String[]{action.info.getPhysicalResourceId()}));
                    createTagsType.setTagSet(EC2Helper.createTagSet(tags));
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createTagsType);
                }
                return action;
            }
        };


        @Override
        public Integer getTimeout() {
            return null;
        }
    }
}

