/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.auth.Accounts;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.EC2Helper;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.TagHelper;
import com.eucalyptus.cloudformation.resources.standard.info.AWSEC2InstanceResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSEC2InstanceProperties;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.EC2BlockDeviceMapping;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.EC2MountPoint;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.EC2NetworkInterface;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.EC2NetworkInterfacePrivateIPSpecification;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.EC2Tag;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.ValidationFailedException;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.AttachVolumeType;
import com.eucalyptus.compute.common.AttachedVolume;
import com.eucalyptus.compute.common.BlockDeviceMappingItemType;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.compute.common.CreateTagsType;
import com.eucalyptus.compute.common.DescribeInstancesResponseType;
import com.eucalyptus.compute.common.DescribeInstancesType;
import com.eucalyptus.compute.common.DescribeSecurityGroupsResponseType;
import com.eucalyptus.compute.common.DescribeSecurityGroupsType;
import com.eucalyptus.compute.common.DescribeVolumesResponseType;
import com.eucalyptus.compute.common.DescribeVolumesType;
import com.eucalyptus.compute.common.EbsDeviceMapping;
import com.eucalyptus.compute.common.GroupItemType;
import com.eucalyptus.compute.common.InstanceNetworkInterfaceSetItemRequestType;
import com.eucalyptus.compute.common.InstanceNetworkInterfaceSetRequestType;
import com.eucalyptus.compute.common.PrivateIpAddressesSetItemRequestType;
import com.eucalyptus.compute.common.PrivateIpAddressesSetRequestType;
import com.eucalyptus.compute.common.ReservationInfoType;
import com.eucalyptus.compute.common.RunInstancesResponseType;
import com.eucalyptus.compute.common.RunInstancesType;
import com.eucalyptus.compute.common.RunningInstancesItemType;
import com.eucalyptus.compute.common.SecurityGroupIdSetItemType;
import com.eucalyptus.compute.common.SecurityGroupIdSetType;
import com.eucalyptus.compute.common.SecurityGroupItemType;
import com.eucalyptus.compute.common.TerminateInstancesType;
import com.eucalyptus.compute.common.Volume;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

@ConfigurableClass(root="cloudformation", description="Parameters controlling cloud formation")
public class AWSEC2InstanceResourceAction
extends ResourceAction {
    @ConfigurableField(initial="300", description="The amount of time (in seconds) to wait for an instance to be running after creation)")
    public static volatile Integer INSTANCE_RUNNING_MAX_CREATE_RETRY_SECS = 300;
    @ConfigurableField(initial="300", description="The amount of time (in seconds) to wait for an instance to have volumes attached after creation)")
    public static volatile Integer INSTANCE_ATTACH_VOLUME_MAX_CREATE_RETRY_SECS = 300;
    @ConfigurableField(initial="300", description="The amount of time (in seconds) to wait for an instance to be terminated after deletion)")
    public static volatile Integer INSTANCE_TERMINATED_MAX_DELETE_RETRY_SECS = 300;
    private AWSEC2InstanceProperties properties = new AWSEC2InstanceProperties();
    private AWSEC2InstanceResourceInfo info = new AWSEC2InstanceResourceInfo();

    public AWSEC2InstanceResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    private InstanceNetworkInterfaceSetRequestType convertNetworkInterfaceSet(List<EC2NetworkInterface> networkInterfaces) {
        InstanceNetworkInterfaceSetRequestType instanceNetworkInterfaceSetRequestType = new InstanceNetworkInterfaceSetRequestType();
        ArrayList item = Lists.newArrayList();
        for (EC2NetworkInterface networkInterface : networkInterfaces) {
            InstanceNetworkInterfaceSetItemRequestType instanceNetworkInterfaceSetItemRequestType = new InstanceNetworkInterfaceSetItemRequestType();
            if (networkInterface.getNetworkInterfaceId() != null) {
                instanceNetworkInterfaceSetItemRequestType.setNetworkInterfaceId(networkInterface.getNetworkInterfaceId());
            }
            if (networkInterface.getDeviceIndex() != null) {
                instanceNetworkInterfaceSetItemRequestType.setDeviceIndex(networkInterface.getDeviceIndex());
            }
            if (networkInterface.getDeleteOnTermination() != null) {
                instanceNetworkInterfaceSetItemRequestType.setDeleteOnTermination(networkInterface.getDeleteOnTermination());
            }
            if (networkInterface.getAssociatePublicIpAddress() != null) {
                instanceNetworkInterfaceSetItemRequestType.setAssociatePublicIpAddress(networkInterface.getAssociatePublicIpAddress());
            }
            if (networkInterface.getDescription() != null) {
                instanceNetworkInterfaceSetItemRequestType.setDescription(networkInterface.getDescription());
            }
            if (networkInterface.getGroupSet() != null) {
                instanceNetworkInterfaceSetItemRequestType.setGroupSet(this.convertGroupSet(networkInterface.getGroupSet()));
            }
            if (networkInterface.getPrivateIpAddress() != null) {
                instanceNetworkInterfaceSetItemRequestType.setPrivateIpAddress(networkInterface.getPrivateIpAddress());
            }
            if (networkInterface.getPrivateIpAddresses() != null) {
                instanceNetworkInterfaceSetItemRequestType.setPrivateIpAddressesSet(this.convertPrivateIpAddressSet(networkInterface.getPrivateIpAddresses()));
            }
            if (networkInterface.getSecondaryPrivateIpAddressCount() != null) {
                instanceNetworkInterfaceSetItemRequestType.setSecondaryPrivateIpAddressCount(networkInterface.getSecondaryPrivateIpAddressCount());
            }
            if (networkInterface.getSubnetId() != null) {
                instanceNetworkInterfaceSetItemRequestType.setSubnetId(networkInterface.getSubnetId());
            }
            item.add(instanceNetworkInterfaceSetItemRequestType);
        }
        instanceNetworkInterfaceSetRequestType.setItem(item);
        return instanceNetworkInterfaceSetRequestType;
    }

    private PrivateIpAddressesSetRequestType convertPrivateIpAddressSet(List<EC2NetworkInterfacePrivateIPSpecification> privateIpAddresses) {
        if (privateIpAddresses == null) {
            return null;
        }
        PrivateIpAddressesSetRequestType privateIpAddressesSetRequestType = new PrivateIpAddressesSetRequestType();
        ArrayList item = Lists.newArrayList();
        for (EC2NetworkInterfacePrivateIPSpecification ec2NetworkInterfacePrivateIPSpecification : privateIpAddresses) {
            PrivateIpAddressesSetItemRequestType privateIpAddressesSetItemRequestType = new PrivateIpAddressesSetItemRequestType();
            if (ec2NetworkInterfacePrivateIPSpecification.getPrimary() != null) {
                privateIpAddressesSetItemRequestType.setPrimary(ec2NetworkInterfacePrivateIPSpecification.getPrimary());
            }
            if (ec2NetworkInterfacePrivateIPSpecification.getPrivateIpAddress() != null) {
                privateIpAddressesSetItemRequestType.setPrivateIpAddress(ec2NetworkInterfacePrivateIPSpecification.getPrivateIpAddress());
            }
            item.add(privateIpAddressesSetItemRequestType);
        }
        privateIpAddressesSetRequestType.setItem(item);
        return privateIpAddressesSetRequestType;
    }

    private SecurityGroupIdSetType convertGroupSet(List<String> groupSet) {
        if (groupSet == null) {
            return null;
        }
        SecurityGroupIdSetType securityGroupIdSetType = new SecurityGroupIdSetType();
        ArrayList item = Lists.newArrayList();
        for (String groupId : groupSet) {
            SecurityGroupIdSetItemType securityGroupIdSetItemType = new SecurityGroupIdSetItemType();
            securityGroupIdSetItemType.setGroupId(groupId);
            item.add(securityGroupIdSetItemType);
        }
        securityGroupIdSetType.setItem(item);
        return securityGroupIdSetType;
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSEC2InstanceProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSEC2InstanceResourceInfo)resourceInfo;
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private ArrayList<GroupItemType> convertSecurityGroups(List<String> securityGroups, ServiceConfiguration configuration, String effectiveUserId) throws Exception {
        if (securityGroups == null) {
            return null;
        }
        DescribeSecurityGroupsType describeSecurityGroupsType = MessageHelper.createMessage(DescribeSecurityGroupsType.class, effectiveUserId);
        DescribeSecurityGroupsResponseType describeSecurityGroupsResponseType = (DescribeSecurityGroupsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeSecurityGroupsType);
        ArrayList securityGroupItemTypeArrayList = describeSecurityGroupsResponseType.getSecurityGroupInfo();
        HashMap nameToIdMap = Maps.newHashMap();
        if (securityGroupItemTypeArrayList != null) {
            for (SecurityGroupItemType securityGroupItemType : securityGroupItemTypeArrayList) {
                nameToIdMap.put(securityGroupItemType.getGroupName(), securityGroupItemType.getGroupId());
            }
        }
        ArrayList groupItemTypes = Lists.newArrayList();
        for (String securityGroup : securityGroups) {
            GroupItemType groupItemType = new GroupItemType();
            groupItemType.setGroupName(securityGroup);
            String groupId = (String)nameToIdMap.get(securityGroup);
            if (groupId == null) {
                throw new NoSuchElementException("No such security group with name " + securityGroup);
            }
            groupItemType.setGroupId(groupId);
            groupItemTypes.add(groupItemType);
        }
        return groupItemTypes;
    }

    private ArrayList<BlockDeviceMappingItemType> convertBlockDeviceMappings(List<EC2BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            return null;
        }
        ArrayList blockDeviceMappingItemTypes = Lists.newArrayList();
        for (EC2BlockDeviceMapping ec2BlockDeviceMapping : blockDeviceMappings) {
            BlockDeviceMappingItemType itemType = new BlockDeviceMappingItemType();
            itemType.setDeviceName(ec2BlockDeviceMapping.getDeviceName());
            itemType.setNoDevice(ec2BlockDeviceMapping.getNoDevice() != null ? Boolean.TRUE : null);
            itemType.setVirtualName(ec2BlockDeviceMapping.getVirtualName());
            if (ec2BlockDeviceMapping.getEbs() != null) {
                EbsDeviceMapping ebs = new EbsDeviceMapping();
                ebs.setDeleteOnTermination(ec2BlockDeviceMapping.getEbs().getDeleteOnTermination() == null ? Boolean.TRUE : ec2BlockDeviceMapping.getEbs().getDeleteOnTermination());
                ebs.setIops(ec2BlockDeviceMapping.getEbs().getIops());
                ebs.setSnapshotId(ec2BlockDeviceMapping.getEbs().getSnapshotId());
                ebs.setVolumeSize(ec2BlockDeviceMapping.getEbs().getVolumeSize() == null ? null : Integer.valueOf(ec2BlockDeviceMapping.getEbs().getVolumeSize()));
                ebs.setVolumeType(ec2BlockDeviceMapping.getEbs().getVolumeType() != null ? ec2BlockDeviceMapping.getEbs().getVolumeType() : "standard");
                itemType.setEbs(ebs);
            }
            blockDeviceMappingItemTypes.add(itemType);
        }
        return blockDeviceMappingItemTypes;
    }

    @Override
    public void refreshAttributes() throws Exception {
        ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
        DescribeInstancesType describeInstancesType = MessageHelper.createMessage(DescribeInstancesType.class, this.info.getEffectiveUserId());
        describeInstancesType.setInstancesSet(Lists.newArrayList((Object[])new String[]{this.info.getPhysicalResourceId()}));
        DescribeInstancesResponseType describeInstancesResponseType = (DescribeInstancesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeInstancesType);
        if (describeInstancesResponseType.getReservationSet().size() == 0) {
            return;
        }
        RunningInstancesItemType runningInstancesItemType = (RunningInstancesItemType)((ReservationInfoType)describeInstancesResponseType.getReservationSet().get(0)).getInstancesSet().get(0);
        this.info.setPrivateIp(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(runningInstancesItemType.getPrivateIpAddress())));
        this.info.setPublicIp(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(runningInstancesItemType.getIpAddress())));
        this.info.setAvailabilityZone(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(runningInstancesItemType.getPlacement())));
        this.info.setPrivateDnsName(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(runningInstancesItemType.getPrivateDnsName())));
        this.info.setPublicDnsName(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(runningInstancesItemType.getDnsName())));
        this.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(this.info.getPhysicalResourceId())));
    }

    private static enum DeleteSteps implements Step
    {
        TERMINATE_INSTANCE{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                Class<AWSEC2InstanceResourceAction> clazz = AWSEC2InstanceResourceAction.class;
                synchronized (AWSEC2InstanceResourceAction.class) {
                    AWSEC2InstanceResourceAction action = (AWSEC2InstanceResourceAction)resourceAction;
                    ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                    if (action.info.getPhysicalResourceId() == null) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return action;
                    }
                    DescribeInstancesType describeInstancesType = MessageHelper.createMessage(DescribeInstancesType.class, action.info.getEffectiveUserId());
                    describeInstancesType.setInstancesSet(Lists.newArrayList((Object[])new String[]{action.info.getPhysicalResourceId()}));
                    DescribeInstancesResponseType describeInstancesResponseType = (DescribeInstancesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeInstancesType);
                    if (describeInstancesResponseType.getReservationSet().size() == 0) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return action;
                    }
                    if ("terminated".equals(((RunningInstancesItemType)((ReservationInfoType)describeInstancesResponseType.getReservationSet().get(0)).getInstancesSet().get(0)).getStateName())) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return action;
                    }
                    TerminateInstancesType terminateInstancesType = MessageHelper.createMessage(TerminateInstancesType.class, action.info.getEffectiveUserId());
                    terminateInstancesType.setInstancesSet(Lists.newArrayList((Object[])new String[]{action.info.getPhysicalResourceId()}));
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)terminateInstancesType);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return action;
                }
            }
        }
        ,
        VERIFY_TERMINATED{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                Class<AWSEC2InstanceResourceAction> clazz = AWSEC2InstanceResourceAction.class;
                synchronized (AWSEC2InstanceResourceAction.class) {
                    AWSEC2InstanceResourceAction action = (AWSEC2InstanceResourceAction)resourceAction;
                    ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                    if (action.info.getPhysicalResourceId() == null) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return action;
                    }
                    DescribeInstancesType describeInstancesType = MessageHelper.createMessage(DescribeInstancesType.class, action.info.getEffectiveUserId());
                    describeInstancesType.setInstancesSet(Lists.newArrayList((Object[])new String[]{action.info.getPhysicalResourceId()}));
                    DescribeInstancesResponseType describeInstancesResponseType = (DescribeInstancesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeInstancesType);
                    if (describeInstancesResponseType.getReservationSet().size() == 0) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return action;
                    }
                    if ("terminated".equals(((RunningInstancesItemType)((ReservationInfoType)describeInstancesResponseType.getReservationSet().get(0)).getInstancesSet().get(0)).getStateName())) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return action;
                    }
                    throw new ValidationFailedException("Instance " + action.info.getPhysicalResourceId() + " is not yet terminated, currently " + ((RunningInstancesItemType)((ReservationInfoType)describeInstancesResponseType.getReservationSet().get(0)).getInstancesSet().get(0)).getStateName());
                }
            }

            @Override
            public Integer getTimeout() {
                return INSTANCE_TERMINATED_MAX_DELETE_RETRY_SECS;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        RUN_INSTANCE{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                Class<AWSEC2InstanceResourceAction> clazz = AWSEC2InstanceResourceAction.class;
                synchronized (AWSEC2InstanceResourceAction.class) {
                    AWSEC2InstanceResourceAction action = (AWSEC2InstanceResourceAction)resourceAction;
                    ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                    RunInstancesType runInstancesType = MessageHelper.createMessage(RunInstancesType.class, action.info.getEffectiveUserId());
                    runInstancesType.setImageId(action.properties.getImageId());
                    if (action.properties.getAvailabilityZone() != null && !action.properties.getAvailabilityZone().isEmpty()) {
                        runInstancesType.setAvailabilityZone(action.properties.getAvailabilityZone());
                    }
                    if (action.properties.getBlockDeviceMappings() != null && !action.properties.getBlockDeviceMappings().isEmpty()) {
                        runInstancesType.setBlockDeviceMapping(action.convertBlockDeviceMappings(action.properties.getBlockDeviceMappings()));
                    }
                    if (action.properties.getBlockDeviceMappings() != null) {
                        runInstancesType.setDisableTerminate(action.properties.getDisableApiTermination());
                    }
                    if (action.properties.getEbsOptimized() != null) {
                        runInstancesType.setEbsOptimized(action.properties.getEbsOptimized());
                    }
                    if (action.properties.getIamInstanceProfile() != null && !action.properties.getIamInstanceProfile().isEmpty()) {
                        runInstancesType.setIamInstanceProfileName(action.properties.getIamInstanceProfile());
                    }
                    if (action.properties.getInstanceType() != null && !action.properties.getInstanceType().isEmpty()) {
                        runInstancesType.setInstanceType(action.properties.getInstanceType());
                    }
                    if (action.properties.getKernelId() != null && !action.properties.getKernelId().isEmpty()) {
                        runInstancesType.setKernelId(action.properties.getKernelId());
                    }
                    if (action.properties.getKeyName() != null && !action.properties.getKeyName().isEmpty()) {
                        runInstancesType.setKeyName(action.properties.getKeyName());
                    }
                    if (action.properties.getMonitoring() != null) {
                        runInstancesType.setMonitoring(action.properties.getMonitoring());
                    }
                    if (action.properties.getNetworkInterfaces() != null && !action.properties.getNetworkInterfaces().isEmpty()) {
                        runInstancesType.setNetworkInterfaceSet(action.convertNetworkInterfaceSet(action.properties.getNetworkInterfaces()));
                    }
                    if (action.properties.getPlacementGroupName() != null && !action.properties.getPlacementGroupName().isEmpty()) {
                        runInstancesType.setPlacementGroup(action.properties.getPlacementGroupName());
                    }
                    if (action.properties.getPrivateIpAddress() != null && !action.properties.getPrivateIpAddress().isEmpty()) {
                        runInstancesType.setPrivateIpAddress(action.properties.getPrivateIpAddress());
                    }
                    if (action.properties.getRamdiskId() != null && !action.properties.getRamdiskId().isEmpty()) {
                        runInstancesType.setRamdiskId(action.properties.getRamdiskId());
                    }
                    if (action.properties.getSecurityGroupIds() != null && !action.properties.getSecurityGroupIds().isEmpty() && action.properties.getSecurityGroups() != null && !action.properties.getSecurityGroups().isEmpty()) {
                        throw new ValidationErrorException("SecurityGroupIds and SecurityGroups can not both be set on an AWS::EC2::Instance");
                    }
                    if (action.properties.getSecurityGroupIds() != null && !action.properties.getSecurityGroupIds().isEmpty()) {
                        runInstancesType.setGroupIdSet(Lists.newArrayList(action.properties.getSecurityGroupIds()));
                    }
                    if (action.properties.getSecurityGroups() != null && !action.properties.getSecurityGroups().isEmpty()) {
                        runInstancesType.setGroupSet(Lists.newArrayList(action.properties.getSecurityGroups()));
                    }
                    if (action.properties.getSubnetId() != null && !action.properties.getSubnetId().isEmpty()) {
                        runInstancesType.setSubnetId(action.properties.getSubnetId());
                    }
                    if (action.properties.getTenancy() != null && !action.properties.getTenancy().isEmpty()) {
                        if (!"default".equals(action.properties.getTenancy()) && !"dedicated".equals(action.properties.getTenancy())) {
                            throw new ValidationErrorException("Tenancy must be 'default' or 'dedicated'");
                        }
                        runInstancesType.setPlacementTenancy(action.properties.getTenancy());
                    }
                    if (action.properties.getUserData() != null && !action.properties.getUserData().isEmpty()) {
                        runInstancesType.setUserData(action.properties.getUserData());
                    }
                    if (action.properties.getVolumes() != null && !action.properties.getVolumes().isEmpty()) {
                        DescribeVolumesType describeVolumesType = MessageHelper.createMessage(DescribeVolumesType.class, action.info.getEffectiveUserId());
                        ArrayList volumeIds = Lists.newArrayList();
                        for (EC2MountPoint ec2MountPoint : action.properties.getVolumes()) {
                            volumeIds.add(ec2MountPoint.getVolumeId());
                        }
                        describeVolumesType.setVolumeSet(volumeIds);
                        DescribeVolumesResponseType describeVolumesResponseType = (DescribeVolumesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeVolumesType);
                        HashMap volumeStatusMap = Maps.newHashMap();
                        for (Volume volume : describeVolumesResponseType.getVolumeSet()) {
                            volumeStatusMap.put(volume.getVolumeId(), volume.getStatus());
                        }
                        for (String volumeId : volumeIds) {
                            if (!volumeStatusMap.containsKey(volumeId)) {
                                throw new ValidationErrorException("No such volume " + volumeId);
                            }
                            if ("available".equals(volumeStatusMap.get(volumeId))) continue;
                            throw new ValidationErrorException("Volume " + volumeId + " not available");
                        }
                    }
                    runInstancesType.setMinCount(1);
                    runInstancesType.setMaxCount(1);
                    RunInstancesResponseType runInstancesResponseType = (RunInstancesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)runInstancesType);
                    action.info.setPhysicalResourceId(((RunningInstancesItemType)runInstancesResponseType.getRsvInfo().getInstancesSet().get(0)).getInstanceId());
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return action;
                }
            }
        }
        ,
        WAIT_UNTIL_RUNNING{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                Class<AWSEC2InstanceResourceAction> clazz = AWSEC2InstanceResourceAction.class;
                synchronized (AWSEC2InstanceResourceAction.class) {
                    AWSEC2InstanceResourceAction action = (AWSEC2InstanceResourceAction)resourceAction;
                    ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                    DescribeInstancesType describeInstancesType = MessageHelper.createMessage(DescribeInstancesType.class, action.info.getEffectiveUserId());
                    describeInstancesType.setInstancesSet(Lists.newArrayList((Object[])new String[]{action.info.getPhysicalResourceId()}));
                    DescribeInstancesResponseType describeInstancesResponseType = (DescribeInstancesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeInstancesType);
                    if (describeInstancesResponseType.getReservationSet().size() == 0) {
                        throw new ValidationFailedException("Instance " + action.info.getAccountId() + " does not yet exist");
                    }
                    RunningInstancesItemType runningInstancesItemType = (RunningInstancesItemType)((ReservationInfoType)describeInstancesResponseType.getReservationSet().get(0)).getInstancesSet().get(0);
                    if ("running".equals(runningInstancesItemType.getStateName())) {
                        action.info.setPrivateIp(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(runningInstancesItemType.getPrivateIpAddress())));
                        action.info.setPublicIp(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(runningInstancesItemType.getIpAddress())));
                        action.info.setAvailabilityZone(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(runningInstancesItemType.getPlacement())));
                        action.info.setPrivateDnsName(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(runningInstancesItemType.getPrivateDnsName())));
                        action.info.setPublicDnsName(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(runningInstancesItemType.getDnsName())));
                        action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return action;
                    }
                    throw new ValidationFailedException("Instance " + action.info.getPhysicalResourceId() + " is not yet running, currently " + runningInstancesItemType.getStateName());
                }
            }

            @Override
            public Integer getTimeout() {
                return INSTANCE_RUNNING_MAX_CREATE_RETRY_SECS;
            }
        }
        ,
        CREATE_TAGS{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                Class<AWSEC2InstanceResourceAction> clazz = AWSEC2InstanceResourceAction.class;
                synchronized (AWSEC2InstanceResourceAction.class) {
                    AWSEC2InstanceResourceAction action = (AWSEC2InstanceResourceAction)resourceAction;
                    ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                    String effectiveAdminUserId = Accounts.lookupUserById((String)action.info.getEffectiveUserId()).getAccount().lookupAdmin().getUserId();
                    CreateTagsType createSystemTagsType = MessageHelper.createPrivilegedMessage(CreateTagsType.class, effectiveAdminUserId);
                    createSystemTagsType.setResourcesSet(Lists.newArrayList((Object[])new String[]{action.info.getPhysicalResourceId()}));
                    createSystemTagsType.setTagSet(EC2Helper.createTagSet(TagHelper.getEC2SystemTags(action.info, action.getStackEntity())));
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createSystemTagsType);
                    List<EC2Tag> tags = TagHelper.getEC2StackTags(action.getStackEntity());
                    if (action.properties.getTags() != null && !action.properties.getTags().isEmpty()) {
                        TagHelper.checkReservedEC2TemplateTags(action.properties.getTags());
                        tags.addAll(action.properties.getTags());
                    }
                    if (!tags.isEmpty()) {
                        CreateTagsType createTagsType = MessageHelper.createMessage(CreateTagsType.class, action.info.getEffectiveUserId());
                        createTagsType.setResourcesSet(Lists.newArrayList((Object[])new String[]{action.info.getPhysicalResourceId()}));
                        createTagsType.setTagSet(EC2Helper.createTagSet(tags));
                        AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createTagsType);
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return action;
                }
            }
        }
        ,
        ATTACH_VOLUMES{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                Class<AWSEC2InstanceResourceAction> clazz = AWSEC2InstanceResourceAction.class;
                synchronized (AWSEC2InstanceResourceAction.class) {
                    AWSEC2InstanceResourceAction action = (AWSEC2InstanceResourceAction)resourceAction;
                    ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                    if (action.properties.getVolumes() != null && !action.properties.getVolumes().isEmpty()) {
                        ArrayList volumeIds = Lists.newArrayList();
                        HashMap deviceMap = Maps.newHashMap();
                        for (EC2MountPoint ec2MountPoint : action.properties.getVolumes()) {
                            volumeIds.add(ec2MountPoint.getVolumeId());
                            deviceMap.put(ec2MountPoint.getVolumeId(), ec2MountPoint.getDevice());
                            AttachVolumeType attachVolumeType = MessageHelper.createMessage(AttachVolumeType.class, action.info.getEffectiveUserId());
                            attachVolumeType.setInstanceId(action.info.getPhysicalResourceId());
                            attachVolumeType.setVolumeId(ec2MountPoint.getVolumeId());
                            attachVolumeType.setDevice(ec2MountPoint.getDevice());
                            AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)attachVolumeType);
                        }
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return action;
                }
            }
        }
        ,
        WAIT_UNTIL_VOLUMES_ATTACHED{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                Class<AWSEC2InstanceResourceAction> clazz = AWSEC2InstanceResourceAction.class;
                synchronized (AWSEC2InstanceResourceAction.class) {
                    AWSEC2InstanceResourceAction action = (AWSEC2InstanceResourceAction)resourceAction;
                    ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                    if (action.properties.getVolumes() != null && !action.properties.getVolumes().isEmpty()) {
                        ArrayList volumeIds = Lists.newArrayList();
                        HashMap deviceMap = Maps.newHashMap();
                        for (EC2MountPoint ec2MountPoint : action.properties.getVolumes()) {
                            volumeIds.add(ec2MountPoint.getVolumeId());
                            deviceMap.put(ec2MountPoint.getVolumeId(), ec2MountPoint.getDevice());
                        }
                        DescribeVolumesType describeVolumesType = MessageHelper.createMessage(DescribeVolumesType.class, action.info.getEffectiveUserId());
                        describeVolumesType.setVolumeSet(Lists.newArrayList((Iterable)volumeIds));
                        DescribeVolumesResponseType describeVolumesResponseType = (DescribeVolumesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeVolumesType);
                        HashMap volumeStatusMap = Maps.newHashMap();
                        for (Volume volume : describeVolumesResponseType.getVolumeSet()) {
                            for (AttachedVolume attachedVolume : volume.getAttachmentSet()) {
                                if (!attachedVolume.getInstanceId().equals(action.info.getPhysicalResourceId()) || !attachedVolume.getDevice().equals(deviceMap.get(volume.getVolumeId()))) continue;
                                volumeStatusMap.put(volume.getVolumeId(), attachedVolume.getStatus());
                            }
                        }
                        for (String volumeId : volumeIds) {
                            if ("attached".equals(volumeStatusMap.get(volumeId))) continue;
                            throw new ValidationFailedException("One or more volumes is not yet attached to the instance");
                        }
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return action;
                }
            }

            @Override
            public Integer getTimeout() {
                return INSTANCE_ATTACH_VOLUME_MAX_CREATE_RETRY_SECS;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

