/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.EC2Helper;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSEC2EIPResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSEC2EIPProperties;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.AllocateAddressResponseType;
import com.eucalyptus.compute.common.AllocateAddressType;
import com.eucalyptus.compute.common.AssociateAddressType;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.compute.common.DescribeAddressesResponseType;
import com.eucalyptus.compute.common.DescribeAddressesType;
import com.eucalyptus.compute.common.DescribeInstancesResponseType;
import com.eucalyptus.compute.common.DescribeInstancesType;
import com.eucalyptus.compute.common.ReleaseAddressType;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class AWSEC2EIPResourceAction
extends ResourceAction {
    private static final Logger LOG = Logger.getLogger(AWSEC2EIPResourceAction.class);
    private AWSEC2EIPProperties properties = new AWSEC2EIPProperties();
    private AWSEC2EIPResourceInfo info = new AWSEC2EIPResourceInfo();

    public AWSEC2EIPResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSEC2EIPProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSEC2EIPResourceInfo)resourceInfo;
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_EIP_ADDRESS{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2EIPResourceAction action = (AWSEC2EIPResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                DescribeAddressesType describeAddressesType = MessageHelper.createMessage(DescribeAddressesType.class, action.info.getEffectiveUserId());
                if (action.properties.getDomain() != null) {
                    describeAddressesType.setAllocationIds(Lists.newArrayList((Object[])new String[]{JsonHelper.getJsonNodeFromString(action.info.getAllocationId()).asText()}));
                } else {
                    describeAddressesType.setPublicIpsSet(Lists.newArrayList((Object[])new String[]{action.info.getPhysicalResourceId()}));
                }
                DescribeAddressesResponseType describeAddressesResponseType = (DescribeAddressesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeAddressesType);
                if (describeAddressesResponseType.getAddressesSet() != null && !describeAddressesResponseType.getAddressesSet().isEmpty()) {
                    ReleaseAddressType releaseAddressType = MessageHelper.createMessage(ReleaseAddressType.class, action.info.getEffectiveUserId());
                    if (action.properties.getDomain() != null) {
                        releaseAddressType.setAllocationId(JsonHelper.getJsonNodeFromString(action.info.getAllocationId()).asText());
                    } else {
                        releaseAddressType.setPublicIp(action.info.getPhysicalResourceId());
                    }
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)releaseAddressType);
                }
                if (action.properties.getInstanceId() != null) {
                    EC2Helper.refreshInstanceAttributes(action.getStackEntity(), action.properties.getInstanceId(), action.info.getEffectiveUserId());
                }
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_EIP__ADDRESS{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2EIPResourceAction action = (AWSEC2EIPResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                AllocateAddressType allocateAddressType = MessageHelper.createMessage(AllocateAddressType.class, action.info.getEffectiveUserId());
                if (action.properties.getDomain() != null && !"vpc".equals(action.properties.getDomain())) {
                    throw new ValidationErrorException("vpc is the only supported value for Domain");
                }
                if (action.properties.getDomain() != null) {
                    allocateAddressType.setDomain(action.properties.getDomain());
                }
                AllocateAddressResponseType allocateAddressResponseType = (AllocateAddressResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)allocateAddressType);
                String publicIp = allocateAddressResponseType.getPublicIp();
                action.info.setPhysicalResourceId(publicIp);
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                if (action.properties.getDomain() != null) {
                    action.info.setAllocationId(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(allocateAddressResponseType.getAllocationId())));
                }
                return action;
            }
        }
        ,
        ATTACH_TO_INSTANCE{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2EIPResourceAction action = (AWSEC2EIPResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (action.properties.getInstanceId() != null) {
                    DescribeInstancesType describeInstancesType = MessageHelper.createMessage(DescribeInstancesType.class, action.info.getEffectiveUserId());
                    describeInstancesType.setInstancesSet(Lists.newArrayList((Object[])new String[]{action.properties.getInstanceId()}));
                    DescribeInstancesResponseType describeInstancesResponseType = (DescribeInstancesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeInstancesType);
                    if (describeInstancesResponseType.getReservationSet() == null || describeInstancesResponseType.getReservationSet().isEmpty()) {
                        throw new ValidationErrorException("No such instance " + action.properties.getInstanceId());
                    }
                    AssociateAddressType associateAddressType = MessageHelper.createMessage(AssociateAddressType.class, action.info.getEffectiveUserId());
                    if (action.properties.getDomain() != null) {
                        associateAddressType.setAllocationId(JsonHelper.getJsonNodeFromString(action.info.getAllocationId()).asText());
                    } else {
                        associateAddressType.setPublicIp(action.info.getPhysicalResourceId());
                    }
                    associateAddressType.setInstanceId(action.properties.getInstanceId());
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)associateAddressType);
                    if (action.properties.getInstanceId() != null) {
                        EC2Helper.refreshInstanceAttributes(action.getStackEntity(), action.properties.getInstanceId(), action.info.getEffectiveUserId());
                    }
                }
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

