/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.EC2Helper;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSEC2EIPAssociationResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSEC2EIPAssociationProperties;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.AssociateAddressResponseType;
import com.eucalyptus.compute.common.AssociateAddressType;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.compute.common.DescribeAddressesResponseType;
import com.eucalyptus.compute.common.DescribeAddressesType;
import com.eucalyptus.compute.common.DescribeInstancesResponseType;
import com.eucalyptus.compute.common.DescribeInstancesType;
import com.eucalyptus.compute.common.DescribeNetworkInterfacesResponseType;
import com.eucalyptus.compute.common.DescribeNetworkInterfacesType;
import com.eucalyptus.compute.common.DisassociateAddressType;
import com.eucalyptus.compute.common.NetworkInterfaceIdSetItemType;
import com.eucalyptus.compute.common.NetworkInterfaceIdSetType;
import com.eucalyptus.compute.common.NetworkInterfaceType;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class AWSEC2EIPAssociationResourceAction
extends ResourceAction {
    private static final Logger LOG = Logger.getLogger(AWSEC2EIPAssociationResourceAction.class);
    private AWSEC2EIPAssociationProperties properties = new AWSEC2EIPAssociationProperties();
    private AWSEC2EIPAssociationResourceInfo info = new AWSEC2EIPAssociationResourceInfo();

    public AWSEC2EIPAssociationResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSEC2EIPAssociationProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSEC2EIPAssociationResourceInfo)resourceInfo;
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_EIP_ASSOCIATION{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                DisassociateAddressType disassociateAddressType;
                DescribeAddressesResponseType describeAddressesResponseType;
                DescribeAddressesType describeAddressesType;
                AWSEC2EIPAssociationResourceAction action = (AWSEC2EIPAssociationResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                if (action.properties.getAllocationId() != null) {
                    describeAddressesType = MessageHelper.createMessage(DescribeAddressesType.class, action.info.getEffectiveUserId());
                    describeAddressesType.setAllocationIds(Lists.newArrayList((Object[])new String[]{action.properties.getAllocationId()}));
                    describeAddressesResponseType = (DescribeAddressesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeAddressesType);
                    if (describeAddressesResponseType.getAddressesSet() != null && !describeAddressesResponseType.getAddressesSet().isEmpty()) {
                        disassociateAddressType = MessageHelper.createMessage(DisassociateAddressType.class, action.info.getEffectiveUserId());
                        disassociateAddressType.setAssociationId(action.info.getPhysicalResourceId());
                        AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)disassociateAddressType);
                    }
                }
                if (action.properties.getEip() != null) {
                    describeAddressesType = MessageHelper.createMessage(DescribeAddressesType.class, action.info.getEffectiveUserId());
                    describeAddressesType.setPublicIpsSet(Lists.newArrayList((Object[])new String[]{action.properties.getEip()}));
                    describeAddressesResponseType = (DescribeAddressesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeAddressesType);
                    if (describeAddressesResponseType.getAddressesSet() != null && !describeAddressesResponseType.getAddressesSet().isEmpty()) {
                        disassociateAddressType = MessageHelper.createMessage(DisassociateAddressType.class, action.info.getEffectiveUserId());
                        disassociateAddressType.setPublicIp(action.properties.getEip());
                        AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)disassociateAddressType);
                    }
                }
                if (action.properties.getInstanceId() != null) {
                    EC2Helper.refreshInstanceAttributes(action.getStackEntity(), action.properties.getInstanceId(), action.info.getEffectiveUserId());
                }
                if (action.properties.getNetworkInterfaceId() != null) {
                    DescribeNetworkInterfacesType describeNetworkInterfacesType = MessageHelper.createMessage(DescribeNetworkInterfacesType.class, action.info.getEffectiveUserId());
                    NetworkInterfaceIdSetType networkInterfaceIdSetType = new NetworkInterfaceIdSetType();
                    NetworkInterfaceIdSetItemType networkInterfaceIdSetItemType = new NetworkInterfaceIdSetItemType();
                    networkInterfaceIdSetItemType.setNetworkInterfaceId(action.properties.getNetworkInterfaceId());
                    ArrayList networkInterfaceIdSetItemTypes = Lists.newArrayList((Object[])new NetworkInterfaceIdSetItemType[]{networkInterfaceIdSetItemType});
                    networkInterfaceIdSetType.setItem(networkInterfaceIdSetItemTypes);
                    describeNetworkInterfacesType.setNetworkInterfaceIdSet(networkInterfaceIdSetType);
                    DescribeNetworkInterfacesResponseType describeNetworkInterfacesResponseType = (DescribeNetworkInterfacesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeNetworkInterfacesType);
                    if (describeNetworkInterfacesResponseType.getNetworkInterfaceSet() != null && describeNetworkInterfacesResponseType.getNetworkInterfaceSet().getItem() != null && !describeNetworkInterfacesResponseType.getNetworkInterfaceSet().getItem().isEmpty()) {
                        for (NetworkInterfaceType networkInterfaceType : describeNetworkInterfacesResponseType.getNetworkInterfaceSet().getItem()) {
                            if (networkInterfaceType == null || networkInterfaceType.getAttachment() == null || networkInterfaceType.getAttachment().getDeviceIndex() != 0 || networkInterfaceType.getAttachment().getInstanceId() == null) continue;
                            EC2Helper.refreshInstanceAttributes(action.getStackEntity(), networkInterfaceType.getAttachment().getInstanceId(), action.info.getEffectiveUserId());
                        }
                    }
                }
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_EIP_ASSOCIATION{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                DescribeAddressesResponseType describeAddressesResponseType;
                DescribeAddressesType describeAddressesType;
                AWSEC2EIPAssociationResourceAction action = (AWSEC2EIPAssociationResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                AssociateAddressType associateAddressType = MessageHelper.createMessage(AssociateAddressType.class, action.info.getEffectiveUserId());
                if (action.properties.getInstanceId() == null && action.properties.getNetworkInterfaceId() == null) {
                    throw new ValidationErrorException("Either instance ID or network interface id must be specified");
                }
                if (action.properties.getInstanceId() != null) {
                    DescribeInstancesType describeInstancesType = MessageHelper.createMessage(DescribeInstancesType.class, action.info.getEffectiveUserId());
                    describeInstancesType.setInstancesSet(Lists.newArrayList((Object[])new String[]{action.properties.getInstanceId()}));
                    DescribeInstancesResponseType describeInstancesResponseType = (DescribeInstancesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeInstancesType);
                    if (describeInstancesResponseType.getReservationSet() == null || describeInstancesResponseType.getReservationSet().isEmpty()) {
                        throw new ValidationErrorException("No such instance " + action.properties.getInstanceId());
                    }
                    associateAddressType.setInstanceId(action.properties.getInstanceId());
                }
                if (action.properties.getEip() != null) {
                    describeAddressesType = MessageHelper.createMessage(DescribeAddressesType.class, action.info.getEffectiveUserId());
                    describeAddressesType.setPublicIpsSet(Lists.newArrayList((Object[])new String[]{action.properties.getEip()}));
                    describeAddressesResponseType = (DescribeAddressesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeAddressesType);
                    if (describeAddressesResponseType.getAddressesSet() == null || describeAddressesResponseType.getAddressesSet().isEmpty()) {
                        throw new ValidationErrorException("No such EIP " + action.properties.getEip());
                    }
                    associateAddressType.setPublicIp(action.properties.getEip());
                }
                if (action.properties.getAllocationId() != null) {
                    describeAddressesType = MessageHelper.createMessage(DescribeAddressesType.class, action.info.getEffectiveUserId());
                    describeAddressesType.setAllocationIds(Lists.newArrayList((Object[])new String[]{action.properties.getAllocationId()}));
                    describeAddressesResponseType = (DescribeAddressesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeAddressesType);
                    if (describeAddressesResponseType.getAddressesSet() == null || describeAddressesResponseType.getAddressesSet().isEmpty()) {
                        throw new ValidationErrorException("No such allocation-id " + action.properties.getAllocationId());
                    }
                    associateAddressType.setAllocationId(action.properties.getAllocationId());
                }
                if (action.properties.getNetworkInterfaceId() != null) {
                    associateAddressType.setNetworkInterfaceId(action.properties.getNetworkInterfaceId());
                }
                if (action.properties.getPrivateIpAddress() != null) {
                    associateAddressType.setNetworkInterfaceId(action.properties.getNetworkInterfaceId());
                }
                AssociateAddressResponseType associateAddressResponseType = (AssociateAddressResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)associateAddressType);
                if (action.properties.getAllocationId() != null) {
                    action.info.setPhysicalResourceId(associateAddressResponseType.getAssociationId());
                } else {
                    action.info.setPhysicalResourceId(action.getDefaultPhysicalResourceId());
                }
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                if (action.properties.getInstanceId() != null) {
                    EC2Helper.refreshInstanceAttributes(action.getStackEntity(), action.properties.getInstanceId(), action.info.getEffectiveUserId());
                }
                if (action.properties.getNetworkInterfaceId() != null) {
                    DescribeNetworkInterfacesType describeNetworkInterfacesType = MessageHelper.createMessage(DescribeNetworkInterfacesType.class, action.info.getEffectiveUserId());
                    NetworkInterfaceIdSetType networkInterfaceIdSetType = new NetworkInterfaceIdSetType();
                    NetworkInterfaceIdSetItemType networkInterfaceIdSetItemType = new NetworkInterfaceIdSetItemType();
                    networkInterfaceIdSetItemType.setNetworkInterfaceId(action.properties.getNetworkInterfaceId());
                    ArrayList networkInterfaceIdSetItemTypes = Lists.newArrayList((Object[])new NetworkInterfaceIdSetItemType[]{networkInterfaceIdSetItemType});
                    networkInterfaceIdSetType.setItem(networkInterfaceIdSetItemTypes);
                    describeNetworkInterfacesType.setNetworkInterfaceIdSet(networkInterfaceIdSetType);
                    DescribeNetworkInterfacesResponseType describeNetworkInterfacesResponseType = (DescribeNetworkInterfacesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeNetworkInterfacesType);
                    if (describeNetworkInterfacesResponseType.getNetworkInterfaceSet() != null && describeNetworkInterfacesResponseType.getNetworkInterfaceSet().getItem() != null && !describeNetworkInterfacesResponseType.getNetworkInterfaceSet().getItem().isEmpty()) {
                        for (NetworkInterfaceType networkInterfaceType : describeNetworkInterfacesResponseType.getNetworkInterfaceSet().getItem()) {
                            if (networkInterfaceType == null || networkInterfaceType.getAttachment() == null || networkInterfaceType.getAttachment().getDeviceIndex() != 0 || networkInterfaceType.getAttachment().getInstanceId() == null) continue;
                            EC2Helper.refreshInstanceAttributes(action.getStackEntity(), networkInterfaceType.getAttachment().getInstanceId(), action.info.getEffectiveUserId());
                        }
                    }
                }
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

