/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.auth.Accounts;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.EC2Helper;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.TagHelper;
import com.eucalyptus.cloudformation.resources.standard.info.AWSEC2DHCPOptionsResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSEC2DHCPOptionsProperties;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.EC2Tag;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.compute.common.CreateDhcpOptionsResponseType;
import com.eucalyptus.compute.common.CreateDhcpOptionsType;
import com.eucalyptus.compute.common.CreateTagsType;
import com.eucalyptus.compute.common.DeleteDhcpOptionsType;
import com.eucalyptus.compute.common.DescribeDhcpOptionsResponseType;
import com.eucalyptus.compute.common.DescribeDhcpOptionsType;
import com.eucalyptus.compute.common.DhcpConfigurationItemSetType;
import com.eucalyptus.compute.common.DhcpConfigurationItemType;
import com.eucalyptus.compute.common.DhcpOptionsIdSetItemType;
import com.eucalyptus.compute.common.DhcpOptionsIdSetType;
import com.eucalyptus.compute.common.DhcpValueSetType;
import com.eucalyptus.compute.common.DhcpValueType;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class AWSEC2DHCPOptionsResourceAction
extends ResourceAction {
    private AWSEC2DHCPOptionsProperties properties = new AWSEC2DHCPOptionsProperties();
    private AWSEC2DHCPOptionsResourceInfo info = new AWSEC2DHCPOptionsResourceInfo();

    public AWSEC2DHCPOptionsResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSEC2DHCPOptionsProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSEC2DHCPOptionsResourceInfo)resourceInfo;
    }

    private DhcpConfigurationItemType createDhcpConfigurationItemType(String key, DhcpValueSetType valueSet) {
        DhcpConfigurationItemType dhcpConfigurationItemType = new DhcpConfigurationItemType();
        dhcpConfigurationItemType.setKey(key);
        dhcpConfigurationItemType.setValueSet(valueSet);
        return dhcpConfigurationItemType;
    }

    private DhcpValueSetType createValueSet(String value) {
        return this.createValueSet(Lists.newArrayList((Object[])new String[]{value}));
    }

    private DhcpValueSetType createValueSet(List<String> values) {
        DhcpValueSetType dhcpValueSetType = new DhcpValueSetType();
        dhcpValueSetType.setItem(Lists.newArrayList());
        for (String value : values) {
            DhcpValueType dhcpValueType = new DhcpValueType();
            dhcpValueType.setValue(value);
            dhcpValueSetType.getItem().add(dhcpValueType);
        }
        return dhcpValueSetType;
    }

    private void validateProperties() throws ValidationErrorException {
        if (!(this.properties.getDomainNameServers() != null && !this.properties.getDomainNameServers().isEmpty() || this.properties.getNetbiosNameServers() != null && !this.properties.getNetbiosNameServers().isEmpty() || this.properties.getNtpServers() != null && !this.properties.getNtpServers().isEmpty())) {
            throw new ValidationErrorException("At least one of DomainNameServers, NetbiosNameServers, NtpServers must be specified.");
        }
        if (this.properties.getNetbiosNameServers() != null && !this.properties.getNetbiosNameServers().isEmpty() && this.properties.getNetbiosNodeType() == null) {
            throw new ValidationErrorException("If you specify NetbiosNameServers, then NetbiosNodeType is required.");
        }
    }

    private void setDhcpOptionsId(DescribeDhcpOptionsType describeDhcpOptionsType, String dhcpOptionsId) {
        DhcpOptionsIdSetType dhcpOptionsSet = new DhcpOptionsIdSetType();
        ArrayList item = Lists.newArrayList();
        DhcpOptionsIdSetItemType dhcpOptionsIdSetItemType = new DhcpOptionsIdSetItemType();
        dhcpOptionsIdSetItemType.setDhcpOptionsId(dhcpOptionsId);
        item.add(dhcpOptionsIdSetItemType);
        dhcpOptionsSet.setItem(item);
        item.add(dhcpOptionsIdSetItemType);
        describeDhcpOptionsType.setDhcpOptionsSet(dhcpOptionsSet);
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_DHCP_OPTIONS{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2DHCPOptionsResourceAction action = (AWSEC2DHCPOptionsResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                DescribeDhcpOptionsType describeDhcpOptionsType = MessageHelper.createMessage(DescribeDhcpOptionsType.class, action.info.getEffectiveUserId());
                action.setDhcpOptionsId(describeDhcpOptionsType, action.info.getPhysicalResourceId());
                DescribeDhcpOptionsResponseType describeDhcpOptionsResponseType = (DescribeDhcpOptionsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeDhcpOptionsType);
                if (describeDhcpOptionsResponseType.getDhcpOptionsSet() == null || describeDhcpOptionsResponseType.getDhcpOptionsSet().getItem() == null || describeDhcpOptionsResponseType.getDhcpOptionsSet().getItem().isEmpty()) {
                    return action;
                }
                DeleteDhcpOptionsType deleteDhcpOptionsType = MessageHelper.createMessage(DeleteDhcpOptionsType.class, action.info.getEffectiveUserId());
                deleteDhcpOptionsType.setDhcpOptionsId(action.info.getPhysicalResourceId());
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deleteDhcpOptionsType);
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_DHCP_OPTIONS{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2DHCPOptionsResourceAction action = (AWSEC2DHCPOptionsResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                action.validateProperties();
                CreateDhcpOptionsType createDhcpOptionsType = MessageHelper.createMessage(CreateDhcpOptionsType.class, action.info.getEffectiveUserId());
                DhcpConfigurationItemSetType dhcpConfigurationSet = new DhcpConfigurationItemSetType();
                dhcpConfigurationSet.setItem(Lists.newArrayList());
                ArrayList item = Lists.newArrayList();
                if (!Strings.isNullOrEmpty((String)action.properties.getDomainName())) {
                    dhcpConfigurationSet.getItem().add(action.createDhcpConfigurationItemType("domain-name", action.createValueSet(action.properties.getDomainName())));
                }
                if (action.properties.getDomainNameServers() != null && !action.properties.getDomainNameServers().isEmpty()) {
                    dhcpConfigurationSet.getItem().add(action.createDhcpConfigurationItemType("domain-name-servers", action.createValueSet(action.properties.getDomainNameServers())));
                }
                if (action.properties.getNtpServers() != null && !action.properties.getNtpServers().isEmpty()) {
                    dhcpConfigurationSet.getItem().add(action.createDhcpConfigurationItemType("ntp-servers", action.createValueSet(action.properties.getNtpServers())));
                }
                if (action.properties.getNetbiosNameServers() != null && !action.properties.getNetbiosNameServers().isEmpty()) {
                    dhcpConfigurationSet.getItem().add(action.createDhcpConfigurationItemType("netbios-name-servers", action.createValueSet(action.properties.getNetbiosNameServers())));
                }
                if (action.properties.getNetbiosNodeType() != null) {
                    dhcpConfigurationSet.getItem().add(action.createDhcpConfigurationItemType("netbios-node-type", action.createValueSet(String.valueOf(action.properties.getNetbiosNodeType()))));
                }
                createDhcpOptionsType.setDhcpConfigurationSet(dhcpConfigurationSet);
                CreateDhcpOptionsResponseType createDhcpOptionsResponseType = (CreateDhcpOptionsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createDhcpOptionsType);
                action.info.setPhysicalResourceId(createDhcpOptionsResponseType.getDhcpOptions().getDhcpOptionsId());
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        }
        ,
        CREATE_TAGS{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSEC2DHCPOptionsResourceAction action = (AWSEC2DHCPOptionsResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                String effectiveAdminUserId = Accounts.lookupUserById((String)action.info.getEffectiveUserId()).getAccount().lookupAdmin().getUserId();
                CreateTagsType createSystemTagsType = MessageHelper.createPrivilegedMessage(CreateTagsType.class, effectiveAdminUserId);
                createSystemTagsType.setResourcesSet(Lists.newArrayList((Object[])new String[]{action.info.getPhysicalResourceId()}));
                createSystemTagsType.setTagSet(EC2Helper.createTagSet(TagHelper.getEC2SystemTags(action.info, action.getStackEntity())));
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createSystemTagsType);
                List<EC2Tag> tags = TagHelper.getEC2StackTags(action.getStackEntity());
                if (action.properties.getTags() != null && !action.properties.getTags().isEmpty()) {
                    TagHelper.checkReservedEC2TemplateTags(action.properties.getTags());
                    tags.addAll(action.properties.getTags());
                }
                if (!tags.isEmpty()) {
                    CreateTagsType createTagsType = MessageHelper.createMessage(CreateTagsType.class, action.info.getEffectiveUserId());
                    createTagsType.setResourcesSet(Lists.newArrayList((Object[])new String[]{action.info.getPhysicalResourceId()}));
                    createTagsType.setTagSet(EC2Helper.createTagSet(tags));
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createTagsType);
                }
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

