/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSCloudWatchAlarmResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSCloudWatchAlarmProperties;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.CloudWatchMetricDimension;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.cloudwatch.common.CloudWatch;
import com.eucalyptus.cloudwatch.common.msgs.AlarmNames;
import com.eucalyptus.cloudwatch.common.msgs.DeleteAlarmsType;
import com.eucalyptus.cloudwatch.common.msgs.DescribeAlarmsResponseType;
import com.eucalyptus.cloudwatch.common.msgs.DescribeAlarmsType;
import com.eucalyptus.cloudwatch.common.msgs.Dimension;
import com.eucalyptus.cloudwatch.common.msgs.Dimensions;
import com.eucalyptus.cloudwatch.common.msgs.PutMetricAlarmType;
import com.eucalyptus.cloudwatch.common.msgs.ResourceList;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class AWSCloudWatchAlarmResourceAction
extends ResourceAction {
    private AWSCloudWatchAlarmProperties properties = new AWSCloudWatchAlarmProperties();
    private AWSCloudWatchAlarmResourceInfo info = new AWSCloudWatchAlarmResourceInfo();

    public AWSCloudWatchAlarmResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSCloudWatchAlarmProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSCloudWatchAlarmResourceInfo)resourceInfo;
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_ALARM{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSCloudWatchAlarmResourceAction action = (AWSCloudWatchAlarmResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(CloudWatch.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                DescribeAlarmsType describeAlarmsType = MessageHelper.createMessage(DescribeAlarmsType.class, action.info.getEffectiveUserId());
                AlarmNames alarmNames = new AlarmNames();
                alarmNames.setMember(Lists.newArrayList((Object[])new String[]{action.info.getPhysicalResourceId()}));
                describeAlarmsType.setAlarmNames(alarmNames);
                DescribeAlarmsResponseType describeAlarmsResponseType = (DescribeAlarmsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeAlarmsType);
                if (describeAlarmsResponseType.getDescribeAlarmsResult() != null && describeAlarmsResponseType.getDescribeAlarmsResult().getMetricAlarms() != null && describeAlarmsResponseType.getDescribeAlarmsResult().getMetricAlarms().getMember() != null && describeAlarmsResponseType.getDescribeAlarmsResult().getMetricAlarms().getMember().size() > 0) {
                    DeleteAlarmsType deleteAlarmsType = MessageHelper.createMessage(DeleteAlarmsType.class, action.info.getEffectiveUserId());
                    deleteAlarmsType.setAlarmNames(alarmNames);
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deleteAlarmsType);
                }
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_ALARM{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSCloudWatchAlarmResourceAction action = (AWSCloudWatchAlarmResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(CloudWatch.class, (Partition[])new Partition[0]);
                if (action.properties.getAlarmName() == null) {
                    action.properties.setAlarmName(action.getDefaultPhysicalResourceId());
                }
                DescribeAlarmsType describeAlarmsType = MessageHelper.createMessage(DescribeAlarmsType.class, action.info.getEffectiveUserId());
                AlarmNames alarmNames = new AlarmNames();
                alarmNames.setMember(Lists.newArrayList((Object[])new String[]{action.properties.getAlarmName()}));
                describeAlarmsType.setAlarmNames(alarmNames);
                DescribeAlarmsResponseType describeAlarmsResponseType = (DescribeAlarmsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeAlarmsType);
                if (describeAlarmsResponseType.getDescribeAlarmsResult() != null && describeAlarmsResponseType.getDescribeAlarmsResult().getMetricAlarms() != null && describeAlarmsResponseType.getDescribeAlarmsResult().getMetricAlarms().getMember() != null && describeAlarmsResponseType.getDescribeAlarmsResult().getMetricAlarms().getMember().size() > 0) {
                    throw new ValidationErrorException("Alarm " + action.properties.getAlarmName() + " already exists");
                }
                PutMetricAlarmType putMetricAlarmType = MessageHelper.createMessage(PutMetricAlarmType.class, action.info.getEffectiveUserId());
                putMetricAlarmType.setActionsEnabled(action.properties.getActionsEnabled() == null ? Boolean.TRUE : action.properties.getActionsEnabled());
                if (action.properties.getAlarmActions() != null) {
                    ResourceList alarmActions = new ResourceList();
                    ArrayList alarmActionsMember = Lists.newArrayList(action.properties.getAlarmActions());
                    alarmActions.setMember(alarmActionsMember);
                    putMetricAlarmType.setAlarmActions(alarmActions);
                }
                putMetricAlarmType.setAlarmDescription(action.properties.getAlarmDescription());
                putMetricAlarmType.setAlarmName(action.properties.getAlarmName());
                putMetricAlarmType.setComparisonOperator(action.properties.getComparisonOperator());
                if (action.properties.getDimensions() != null) {
                    Dimensions dimensions = new Dimensions();
                    ArrayList dimensionsMember = Lists.newArrayList();
                    for (CloudWatchMetricDimension cloudWatchMetricDimension : action.properties.getDimensions()) {
                        Dimension dimension = new Dimension();
                        dimension.setName(cloudWatchMetricDimension.getName());
                        dimension.setValue(cloudWatchMetricDimension.getValue());
                        dimensionsMember.add(dimension);
                    }
                    dimensions.setMember(dimensionsMember);
                    putMetricAlarmType.setDimensions(dimensions);
                }
                putMetricAlarmType.setEvaluationPeriods(action.properties.getEvaluationPeriods());
                if (action.properties.getInsufficientDataActions() != null) {
                    ResourceList insufficientDataActions = new ResourceList();
                    ArrayList insufficientDataActionsMember = Lists.newArrayList(action.properties.getInsufficientDataActions());
                    insufficientDataActions.setMember(insufficientDataActionsMember);
                    putMetricAlarmType.setInsufficientDataActions(insufficientDataActions);
                }
                putMetricAlarmType.setMetricName(action.properties.getMetricName());
                putMetricAlarmType.setNamespace(action.properties.getNamespace());
                if (action.properties.getOkActions() != null) {
                    ResourceList okActions = new ResourceList();
                    ArrayList okActionsMember = Lists.newArrayList(action.properties.getOkActions());
                    okActions.setMember(okActionsMember);
                    putMetricAlarmType.setOkActions(okActions);
                }
                putMetricAlarmType.setPeriod(action.properties.getPeriod());
                putMetricAlarmType.setStatistic(action.properties.getStatistic());
                putMetricAlarmType.setThreshold(action.properties.getThreshold());
                putMetricAlarmType.setUnit(action.properties.getUnit());
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)putMetricAlarmType);
                action.info.setPhysicalResourceId(action.properties.getAlarmName());
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

