/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3VersionSummary;
import com.amazonaws.services.s3.model.VersionListing;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.bootstrap.CloudFormationAWSCredentialsProvider;
import com.eucalyptus.cloudformation.entity.StackResourceEntity;
import com.eucalyptus.cloudformation.entity.StackResourceEntityManager;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSCloudFormationWaitConditionHandleResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.info.AWSCloudFormationWaitConditionResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSCloudFormationWaitConditionProperties;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.workflow.ResourceFailureException;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.ValidationFailedException;
import com.eucalyptus.cloudformation.workflow.steps.AWSCloudFormationWaitConditionCreatePromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.objectstorage.client.EucaS3Client;
import com.eucalyptus.objectstorage.client.EucaS3ClientFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.glisten.WorkflowOperations;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class AWSCloudFormationWaitConditionResourceAction
extends ResourceAction {
    private static final Logger LOG = Logger.getLogger(AWSCloudFormationWaitConditionResourceAction.class);
    private AWSCloudFormationWaitConditionProperties properties = new AWSCloudFormationWaitConditionProperties();
    private AWSCloudFormationWaitConditionResourceInfo info = new AWSCloudFormationWaitConditionResourceInfo();

    public AWSCloudFormationWaitConditionResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSCloudFormationWaitConditionProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSCloudFormationWaitConditionResourceInfo)resourceInfo;
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        return new AWSCloudFormationWaitConditionCreatePromise(workflowOperations, CreateSteps.CREATE_WAIT_CONDITION.name()).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DO_NOTHING{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                return resourceAction;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_WAIT_CONDITION{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                LOG.trace((Object)"Creating wait condition");
                AWSCloudFormationWaitConditionResourceAction action = (AWSCloudFormationWaitConditionResourceAction)resourceAction;
                int numSignals = action.properties.getCount() != null && action.properties.getCount() > 0 ? action.properties.getCount() : 1;
                LOG.trace((Object)("num signals = " + numSignals));
                if (action.properties.getTimeout() > 43200) {
                    throw new ValidationErrorException("timeout can not be more than 43200");
                }
                LOG.trace((Object)("Timeout = " + action.properties.getTimeout()));
                LOG.trace((Object)("Looking for handle : " + action.properties.getHandle()));
                List<StackResourceEntity> stackResourceEntityList = StackResourceEntityManager.getStackResources(action.getStackEntity().getStackId(), action.info.getAccountId());
                StackResourceEntity handleEntity = null;
                for (StackResourceEntity stackResourceEntity : stackResourceEntityList) {
                    if (stackResourceEntity.getPhysicalResourceId() == null || !stackResourceEntity.getPhysicalResourceId().equals(action.properties.getHandle())) continue;
                    LOG.trace((Object)("found something with the same physical id, type:" + stackResourceEntity.getResourceType()));
                    if (!stackResourceEntity.getResourceType().equals("AWS::CloudFormation::WaitConditionHandle")) continue;
                    handleEntity = stackResourceEntity;
                    break;
                }
                if (handleEntity == null) {
                    throw new Exception("Handle URL:" + action.properties.getHandle() + " does not match a WaitConditionHandle from this stack");
                }
                AWSCloudFormationWaitConditionHandleResourceInfo handleResourceInfo = (AWSCloudFormationWaitConditionHandleResourceInfo)StackResourceEntityManager.getResourceInfo(handleEntity);
                ObjectNode objectNode = (ObjectNode)JsonHelper.getJsonNodeFromString(handleResourceInfo.getEucaParts());
                if (!"1.0".equals(objectNode.get("version").asText())) {
                    throw new Exception("Invalid version for eucaParts");
                }
                String bucketName = objectNode.get("bucket").asText();
                LOG.trace((Object)("bucketName=" + bucketName));
                String keyName = objectNode.get("key").asText();
                LOG.trace((Object)("keyName=" + bucketName));
                boolean foundFailure = false;
                HashMap dataMap = Maps.newHashMap();
                try (EucaS3Client s3c = EucaS3ClientFactory.getEucaS3Client((AWSCredentialsProvider)new CloudFormationAWSCredentialsProvider());){
                    LOG.trace((Object)("Handle:" + action.properties.getHandle()));
                    VersionListing versionListing = s3c.listVersions(bucketName, "");
                    LOG.trace((Object)("Found " + versionListing.getVersionSummaries() + " versions to check"));
                    for (S3VersionSummary versionSummary : versionListing.getVersionSummaries()) {
                        LOG.trace((Object)("Key:" + versionSummary.getKey()));
                        if (!versionSummary.getKey().equals(keyName)) continue;
                        LOG.trace((Object)("Getting version: " + versionSummary.getVersionId()));
                        try {
                            GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, keyName, versionSummary.getVersionId());
                            S3Object s3Object = s3c.getObject(getObjectRequest);
                            JsonNode jsonNode = null;
                            try (S3ObjectInputStream s3ObjectInputStream = s3Object.getObjectContent();){
                                jsonNode = new ObjectMapper().readTree((InputStream)s3ObjectInputStream);
                            }
                            if (!jsonNode.isObject()) {
                                LOG.trace((Object)"Read object, json but not object..skipping file");
                                continue;
                            }
                            ObjectNode localObjectNode = (ObjectNode)jsonNode;
                            String status = localObjectNode.get("Status").asText();
                            if (status == null) {
                                LOG.trace((Object)"Null status, skipping");
                                continue;
                            }
                            String data = localObjectNode.get("Data").asText();
                            if (data == null) {
                                LOG.trace((Object)"Null data, skipping");
                                continue;
                            }
                            String uniqueId = localObjectNode.get("UniqueId").asText();
                            if (data == null) {
                                LOG.trace((Object)"Null uniqueId, skipping");
                                continue;
                            }
                            if ("FAILURE".equals(status)) {
                                foundFailure = true;
                                LOG.trace((Object)"found failure, gonna die");
                                break;
                            }
                            if (!"SUCCESS".equals(status)) {
                                LOG.trace((Object)"weird status...skipping");
                                continue;
                            }
                            LOG.trace((Object)("found success, uniqueId=" + uniqueId));
                            dataMap.put(uniqueId, data);
                        }
                        catch (Exception ex) {
                            LOG.error((Object)ex, (Throwable)ex);
                            LOG.trace((Object)"Exception while going through the objects, will skip this one.");
                        }
                    }
                }
                if (foundFailure) {
                    throw new ResourceFailureException("Found failure signal");
                }
                LOG.trace((Object)("Have " + dataMap.size() + " success signals, need " + numSignals));
                if (dataMap.size() >= numSignals) {
                    LOG.trace((Object)"Success");
                    ObjectNode dataNode = new ObjectMapper().createObjectNode();
                    for (String uniqueId : dataMap.keySet()) {
                        dataNode.put(uniqueId, (String)dataMap.get(uniqueId));
                    }
                    action.info.setData(JsonHelper.getStringFromJsonNode((JsonNode)dataNode));
                    action.info.setPhysicalResourceId(keyName);
                    action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                    return action;
                }
                throw new ValidationFailedException("Not enough success signals yet");
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

