/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.HttpMethod;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.S3VersionSummary;
import com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest;
import com.amazonaws.services.s3.model.VersionListing;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.cloudformation.bootstrap.CloudFormationAWSCredentialsProvider;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSCloudFormationWaitConditionHandleResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSCloudFormationWaitConditionHandleProperties;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.objectstorage.client.EucaS3Client;
import com.eucalyptus.objectstorage.client.EucaS3ClientFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;

@ConfigurableClass(root="cloudformation", description="Parameters controlling cloud formation")
public class AWSCloudFormationWaitConditionHandleResourceAction
extends ResourceAction {
    @ConfigurableField(initial="cf-waitcondition", description="The prefix of the bucket used for wait condition handles")
    public static volatile String WAIT_CONDITION_BUCKET_PREFIX = "cf-waitcondition";
    private AWSCloudFormationWaitConditionHandleProperties properties = new AWSCloudFormationWaitConditionHandleProperties();
    private AWSCloudFormationWaitConditionHandleResourceInfo info = new AWSCloudFormationWaitConditionHandleResourceInfo();

    public AWSCloudFormationWaitConditionHandleResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSCloudFormationWaitConditionHandleProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSCloudFormationWaitConditionHandleResourceInfo)resourceInfo;
    }

    private Date in12Hours() {
        return new Date(System.currentTimeMillis() + 43200000L);
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_VERSIONS{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSCloudFormationWaitConditionHandleResourceAction action = (AWSCloudFormationWaitConditionHandleResourceAction)resourceAction;
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                try (EucaS3Client s3c = EucaS3ClientFactory.getEucaS3Client((AWSCredentialsProvider)new CloudFormationAWSCredentialsProvider());){
                    ObjectNode objectNode = (ObjectNode)JsonHelper.getJsonNodeFromString(action.info.getEucaParts());
                    if (!"1.0".equals(objectNode.get("version").asText())) {
                        throw new Exception("Invalid version for eucaParts");
                    }
                    String bucketName = objectNode.get("bucket").asText();
                    String keyName = objectNode.get("key").asText();
                    if (!s3c.doesBucketExist(bucketName)) {
                        AWSCloudFormationWaitConditionHandleResourceAction aWSCloudFormationWaitConditionHandleResourceAction = action;
                        return aWSCloudFormationWaitConditionHandleResourceAction;
                    }
                    VersionListing versionListing = s3c.listVersions(bucketName, "");
                    for (S3VersionSummary versionSummary : versionListing.getVersionSummaries()) {
                        if (!versionSummary.getKey().equals(keyName)) continue;
                        s3c.deleteVersion(versionSummary.getBucketName(), versionSummary.getKey(), versionSummary.getVersionId());
                    }
                }
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        GET_BUCKET_AND_CREATE_OBJECT{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSCloudFormationWaitConditionHandleResourceAction action = (AWSCloudFormationWaitConditionHandleResourceAction)resourceAction;
                try (EucaS3Client s3c = EucaS3ClientFactory.getEucaS3Client((AWSCredentialsProvider)new CloudFormationAWSCredentialsProvider());){
                    String bucketName = null;
                    ObjectNode objectNode = null;
                    List buckets = s3c.listBuckets();
                    for (Bucket bucket : buckets) {
                        if (!bucket.getName().toLowerCase().startsWith(WAIT_CONDITION_BUCKET_PREFIX.toLowerCase())) continue;
                        bucketName = bucket.getName();
                    }
                    if (bucketName == null) {
                        bucketName = (WAIT_CONDITION_BUCKET_PREFIX + "-" + Crypto.generateAlphanumericId((int)13, (String)"")).toLowerCase();
                    }
                    s3c.createBucket(bucketName);
                    String keyName = action.getStackEntity().getStackId() + "/" + action.info.getLogicalResourceId() + "/WaitHandle";
                    ObjectMapper mapper = new ObjectMapper();
                    objectNode = mapper.createObjectNode();
                    objectNode.put("version", "1.0");
                    objectNode.put("bucket", bucketName);
                    objectNode.put("key", keyName);
                    action.info.setEucaParts(JsonHelper.getStringFromJsonNode((JsonNode)objectNode));
                    String url = s3c.generatePresignedUrl(bucketName, keyName, action.in12Hours(), HttpMethod.PUT).toString();
                    action.info.setPhysicalResourceId(url);
                }
                return action;
            }
        }
        ,
        VERSION_BUCKET{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSCloudFormationWaitConditionHandleResourceAction action = (AWSCloudFormationWaitConditionHandleResourceAction)resourceAction;
                try (EucaS3Client s3c = EucaS3ClientFactory.getEucaS3Client((AWSCredentialsProvider)new CloudFormationAWSCredentialsProvider());){
                    ObjectNode objectNode = (ObjectNode)JsonHelper.getJsonNodeFromString(action.info.getEucaParts());
                    if (!"1.0".equals(objectNode.get("version").asText())) {
                        throw new Exception("Invalid version for eucaParts");
                    }
                    String bucketName = objectNode.get("bucket").asText();
                    s3c.setBucketVersioningConfiguration(new SetBucketVersioningConfigurationRequest(bucketName, new BucketVersioningConfiguration("Enabled")));
                }
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

