/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.autoscaling.common.AutoScaling;
import com.eucalyptus.autoscaling.common.msgs.AutoScalingGroupNames;
import com.eucalyptus.autoscaling.common.msgs.DeletePolicyType;
import com.eucalyptus.autoscaling.common.msgs.DescribeAutoScalingGroupsResponseType;
import com.eucalyptus.autoscaling.common.msgs.DescribeAutoScalingGroupsType;
import com.eucalyptus.autoscaling.common.msgs.PutScalingPolicyResponseType;
import com.eucalyptus.autoscaling.common.msgs.PutScalingPolicyType;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSAutoScalingScalingPolicyResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSAutoScalingScalingPolicyProperties;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class AWSAutoScalingScalingPolicyResourceAction
extends ResourceAction {
    private AWSAutoScalingScalingPolicyProperties properties = new AWSAutoScalingScalingPolicyProperties();
    private AWSAutoScalingScalingPolicyResourceInfo info = new AWSAutoScalingScalingPolicyResourceInfo();

    public AWSAutoScalingScalingPolicyResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSAutoScalingScalingPolicyProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSAutoScalingScalingPolicyResourceInfo)resourceInfo;
    }

    private boolean doesGroupNotExist(DescribeAutoScalingGroupsResponseType describeAutoScalingGroupsResponseType) {
        return describeAutoScalingGroupsResponseType == null || describeAutoScalingGroupsResponseType.getDescribeAutoScalingGroupsResult() == null || describeAutoScalingGroupsResponseType.getDescribeAutoScalingGroupsResult().getAutoScalingGroups() == null || describeAutoScalingGroupsResponseType.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember() == null || describeAutoScalingGroupsResponseType.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember().isEmpty();
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_SCALING_POLICY{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSAutoScalingScalingPolicyResourceAction action = (AWSAutoScalingScalingPolicyResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(AutoScaling.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                DescribeAutoScalingGroupsType describeAutoScalingGroupsType = MessageHelper.createMessage(DescribeAutoScalingGroupsType.class, action.info.getEffectiveUserId());
                AutoScalingGroupNames autoScalingGroupNames = new AutoScalingGroupNames();
                ArrayList member = Lists.newArrayList((Object[])new String[]{action.properties.getAutoScalingGroupName()});
                autoScalingGroupNames.setMember(member);
                describeAutoScalingGroupsType.setAutoScalingGroupNames(autoScalingGroupNames);
                DescribeAutoScalingGroupsResponseType describeAutoScalingGroupsResponseType = (DescribeAutoScalingGroupsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeAutoScalingGroupsType);
                if (action.doesGroupNotExist(describeAutoScalingGroupsResponseType)) {
                    return action;
                }
                DeletePolicyType deletePolicyType = MessageHelper.createMessage(DeletePolicyType.class, action.info.getEffectiveUserId());
                deletePolicyType.setPolicyName(action.info.getPhysicalResourceId());
                deletePolicyType.setAutoScalingGroupName(action.properties.getAutoScalingGroupName());
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deletePolicyType);
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_SCALING_POLICY{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSAutoScalingScalingPolicyResourceAction action = (AWSAutoScalingScalingPolicyResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(AutoScaling.class, (Partition[])new Partition[0]);
                DescribeAutoScalingGroupsType describeAutoScalingGroupsType = MessageHelper.createMessage(DescribeAutoScalingGroupsType.class, action.info.getEffectiveUserId());
                AutoScalingGroupNames autoScalingGroupNames = new AutoScalingGroupNames();
                ArrayList member = Lists.newArrayList((Object[])new String[]{action.properties.getAutoScalingGroupName()});
                autoScalingGroupNames.setMember(member);
                describeAutoScalingGroupsType.setAutoScalingGroupNames(autoScalingGroupNames);
                DescribeAutoScalingGroupsResponseType describeAutoScalingGroupsResponseType = (DescribeAutoScalingGroupsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeAutoScalingGroupsType);
                if (action.doesGroupNotExist(describeAutoScalingGroupsResponseType)) {
                    throw new Exception("Autoscaling group " + action.properties.getAutoScalingGroupName() + " does not exist");
                }
                String scalingPolicyName = action.getDefaultPhysicalResourceId();
                PutScalingPolicyType putScalingPolicyType = MessageHelper.createMessage(PutScalingPolicyType.class, action.info.getEffectiveUserId());
                putScalingPolicyType.setAutoScalingGroupName(action.properties.getAutoScalingGroupName());
                putScalingPolicyType.setAdjustmentType(action.properties.getAdjustmentType());
                putScalingPolicyType.setCooldown(action.properties.getCooldown());
                putScalingPolicyType.setPolicyName(scalingPolicyName);
                putScalingPolicyType.setScalingAdjustment(action.properties.getScalingAdjustment());
                PutScalingPolicyResponseType putScalingPolicyResponseType = (PutScalingPolicyResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)putScalingPolicyType);
                action.info.setPhysicalResourceId(putScalingPolicyResponseType.getPutScalingPolicyResult().getPolicyARN());
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

