/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.autoscaling.common.AutoScaling;
import com.eucalyptus.autoscaling.common.msgs.BlockDeviceMappingType;
import com.eucalyptus.autoscaling.common.msgs.BlockDeviceMappings;
import com.eucalyptus.autoscaling.common.msgs.CreateLaunchConfigurationType;
import com.eucalyptus.autoscaling.common.msgs.DeleteLaunchConfigurationType;
import com.eucalyptus.autoscaling.common.msgs.InstanceMonitoring;
import com.eucalyptus.autoscaling.common.msgs.SecurityGroups;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.info.AWSAutoScalingLaunchConfigurationResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSAutoScalingLaunchConfigurationProperties;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AutoScalingBlockDeviceMapping;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class AWSAutoScalingLaunchConfigurationResourceAction
extends ResourceAction {
    private AWSAutoScalingLaunchConfigurationProperties properties = new AWSAutoScalingLaunchConfigurationProperties();
    private AWSAutoScalingLaunchConfigurationResourceInfo info = new AWSAutoScalingLaunchConfigurationResourceInfo();

    public AWSAutoScalingLaunchConfigurationResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSAutoScalingLaunchConfigurationProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSAutoScalingLaunchConfigurationResourceInfo)resourceInfo;
    }

    private BlockDeviceMappings convertBlockDeviceMappings(List<AutoScalingBlockDeviceMapping> autoScalingBlockDeviceMappings) {
        ArrayList blockDeviceMappingsList = Lists.newArrayList();
        for (AutoScalingBlockDeviceMapping autoScalingBlockDeviceMapping : autoScalingBlockDeviceMappings) {
            blockDeviceMappingsList.add(new BlockDeviceMappingType(autoScalingBlockDeviceMapping.getDeviceName(), autoScalingBlockDeviceMapping.getVirtualName(), autoScalingBlockDeviceMapping.getEbs() != null ? autoScalingBlockDeviceMapping.getEbs().getSnapshotId() : null, autoScalingBlockDeviceMapping.getEbs() != null ? autoScalingBlockDeviceMapping.getEbs().getVolumeSize() : null));
        }
        return new BlockDeviceMappings((Collection)blockDeviceMappingsList);
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        DELETE_LAUNCH_CONFIG{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSAutoScalingLaunchConfigurationResourceAction action = (AWSAutoScalingLaunchConfigurationResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(AutoScaling.class, (Partition[])new Partition[0]);
                if (action.info.getPhysicalResourceId() == null) {
                    return action;
                }
                DeleteLaunchConfigurationType deleteLaunchConfigurationType = MessageHelper.createMessage(DeleteLaunchConfigurationType.class, action.info.getEffectiveUserId());
                deleteLaunchConfigurationType.setLaunchConfigurationName(action.info.getPhysicalResourceId());
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deleteLaunchConfigurationType);
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_LAUNCH_CONFIG{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSAutoScalingLaunchConfigurationResourceAction action = (AWSAutoScalingLaunchConfigurationResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(AutoScaling.class, (Partition[])new Partition[0]);
                CreateLaunchConfigurationType createLaunchConfigurationType = MessageHelper.createMessage(CreateLaunchConfigurationType.class, action.info.getEffectiveUserId());
                if (action.properties.getInstanceId() != null) {
                    throw new ValidationErrorException("InstanceId not supported");
                }
                if (action.properties.getBlockDeviceMappings() != null) {
                    createLaunchConfigurationType.setBlockDeviceMappings(action.convertBlockDeviceMappings(action.properties.getBlockDeviceMappings()));
                }
                createLaunchConfigurationType.setEbsOptimized(action.properties.getEbsOptimized() != null ? action.properties.getEbsOptimized() : Boolean.FALSE);
                createLaunchConfigurationType.setIamInstanceProfile(action.properties.getIamInstanceProfile());
                createLaunchConfigurationType.setImageId(action.properties.getImageId());
                InstanceMonitoring instanceMonitoring = new InstanceMonitoring();
                instanceMonitoring.setEnabled(action.properties.getInstanceMonitoring() != null ? action.properties.getInstanceMonitoring() : Boolean.TRUE);
                createLaunchConfigurationType.setInstanceMonitoring(instanceMonitoring);
                createLaunchConfigurationType.setInstanceType(action.properties.getInstanceType());
                createLaunchConfigurationType.setKernelId(action.properties.getKernelId());
                createLaunchConfigurationType.setKeyName(action.properties.getKeyName());
                createLaunchConfigurationType.setRamdiskId(action.properties.getRamDiskId());
                if (action.properties.getSecurityGroups() != null) {
                    createLaunchConfigurationType.setSecurityGroups(new SecurityGroups(action.properties.getSecurityGroups()));
                }
                createLaunchConfigurationType.setSpotPrice(action.properties.getSpotPrice());
                createLaunchConfigurationType.setUserData(action.properties.getUserData());
                String launchConfigurationName = action.getDefaultPhysicalResourceId();
                createLaunchConfigurationType.setLaunchConfigurationName(launchConfigurationName);
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createLaunchConfigurationType);
                action.info.setPhysicalResourceId(launchConfigurationName);
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        };


        @Override
        @Nullable
        public Integer getTimeout() {
            return null;
        }
    }
}

