/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard.actions;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.auth.Accounts;
import com.eucalyptus.autoscaling.common.AutoScaling;
import com.eucalyptus.autoscaling.common.msgs.AutoScalingGroupNames;
import com.eucalyptus.autoscaling.common.msgs.AutoScalingGroupType;
import com.eucalyptus.autoscaling.common.msgs.AutoScalingNotificationTypes;
import com.eucalyptus.autoscaling.common.msgs.AvailabilityZones;
import com.eucalyptus.autoscaling.common.msgs.CreateAutoScalingGroupType;
import com.eucalyptus.autoscaling.common.msgs.CreateOrUpdateTagsType;
import com.eucalyptus.autoscaling.common.msgs.DeleteAutoScalingGroupType;
import com.eucalyptus.autoscaling.common.msgs.DescribeAutoScalingGroupsResponseType;
import com.eucalyptus.autoscaling.common.msgs.DescribeAutoScalingGroupsType;
import com.eucalyptus.autoscaling.common.msgs.LoadBalancerNames;
import com.eucalyptus.autoscaling.common.msgs.PutNotificationConfigurationType;
import com.eucalyptus.autoscaling.common.msgs.TagType;
import com.eucalyptus.autoscaling.common.msgs.Tags;
import com.eucalyptus.autoscaling.common.msgs.TerminationPolicies;
import com.eucalyptus.autoscaling.common.msgs.UpdateAutoScalingGroupType;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.standard.TagHelper;
import com.eucalyptus.cloudformation.resources.standard.info.AWSAutoScalingAutoScalingGroupResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSAutoScalingAutoScalingGroupProperties;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AutoScalingTag;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.util.MessageHelper;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.ValidationFailedException;
import com.eucalyptus.cloudformation.workflow.steps.CreateMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.DeleteMultiStepPromise;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.eucalyptus.cloudformation.workflow.steps.StepTransform;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.util.async.AsyncRequests;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.netflix.glisten.WorkflowOperations;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.List;

@ConfigurableClass(root="cloudformation", description="Parameters controlling cloud formation")
public class AWSAutoScalingAutoScalingGroupResourceAction
extends ResourceAction {
    @ConfigurableField(initial="300", description="The amount of time (in seconds) to wait for an autoscaling group to have zero instances during delete")
    public static volatile Integer AUTOSCALING_GROUP_ZERO_INSTANCES_MAX_DELETE_RETRY_SECS = 300;
    @ConfigurableField(initial="300", description="The amount of time (in seconds) to wait for an autoscaling group to be deleted after deletion)")
    public static volatile Integer AUTOSCALING_GROUP_DELETED_MAX_DELETE_RETRY_SECS = 300;
    private AWSAutoScalingAutoScalingGroupProperties properties = new AWSAutoScalingAutoScalingGroupProperties();
    private AWSAutoScalingAutoScalingGroupResourceInfo info = new AWSAutoScalingAutoScalingGroupResourceInfo();

    public AWSAutoScalingAutoScalingGroupResourceAction() {
        for (CreateSteps createSteps : CreateSteps.values()) {
            this.createSteps.put(createSteps.name(), createSteps);
        }
        for (Enum enum_ : DeleteSteps.values()) {
            this.deleteSteps.put(enum_.name(), enum_);
        }
    }

    @Override
    public ResourceProperties getResourceProperties() {
        return this.properties;
    }

    @Override
    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.properties = (AWSAutoScalingAutoScalingGroupProperties)resourceProperties;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.info;
    }

    @Override
    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.info = (AWSAutoScalingAutoScalingGroupResourceInfo)resourceInfo;
    }

    private boolean doesGroupNotExist(DescribeAutoScalingGroupsResponseType describeAutoScalingGroupsResponseType) {
        return describeAutoScalingGroupsResponseType == null || describeAutoScalingGroupsResponseType.getDescribeAutoScalingGroupsResult() == null || describeAutoScalingGroupsResponseType.getDescribeAutoScalingGroupsResult().getAutoScalingGroups() == null || describeAutoScalingGroupsResponseType.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember() == null || describeAutoScalingGroupsResponseType.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember().isEmpty();
    }

    @Override
    public Promise<String> getCreatePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])CreateSteps.values()), (Function)StepTransform.INSTANCE);
        return new CreateMultiStepPromise(workflowOperations, stepIds, this).getCreatePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    @Override
    public Promise<String> getDeletePromise(WorkflowOperations<StackActivity> workflowOperations, String resourceId, String stackId, String accountId, String effectiveUserId) {
        List stepIds = Lists.transform((List)Lists.newArrayList((Object[])DeleteSteps.values()), (Function)StepTransform.INSTANCE);
        return new DeleteMultiStepPromise(workflowOperations, stepIds, this).getDeletePromise(resourceId, stackId, accountId, effectiveUserId);
    }

    private static enum DeleteSteps implements Step
    {
        SET_ZERO_CAPACITY{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSAutoScalingAutoScalingGroupResourceAction action = (AWSAutoScalingAutoScalingGroupResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(AutoScaling.class, (Partition[])new Partition[0]);
                if (DeleteSteps.groupDoesNotExist(configuration, action)) {
                    return action;
                }
                UpdateAutoScalingGroupType updateAutoScalingGroupType = MessageHelper.createMessage(UpdateAutoScalingGroupType.class, action.info.getEffectiveUserId());
                updateAutoScalingGroupType.setMinSize(Integer.valueOf(0));
                updateAutoScalingGroupType.setMaxSize(Integer.valueOf(0));
                updateAutoScalingGroupType.setDesiredCapacity(Integer.valueOf(0));
                updateAutoScalingGroupType.setAutoScalingGroupName(action.info.getPhysicalResourceId());
                updateAutoScalingGroupType.setEffectiveUserId(action.info.getEffectiveUserId());
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)updateAutoScalingGroupType);
                return action;
            }
        }
        ,
        VERIFY_ZERO_INSTANCES{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSAutoScalingAutoScalingGroupResourceAction action = (AWSAutoScalingAutoScalingGroupResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(AutoScaling.class, (Partition[])new Partition[0]);
                if (DeleteSteps.groupDoesNotExist(configuration, action)) {
                    return action;
                }
                DescribeAutoScalingGroupsType describeAutoScalingGroupsType = MessageHelper.createMessage(DescribeAutoScalingGroupsType.class, action.info.getEffectiveUserId());
                AutoScalingGroupNames autoScalingGroupNames = new AutoScalingGroupNames();
                ArrayList member = Lists.newArrayList((Object[])new String[]{action.info.getPhysicalResourceId()});
                autoScalingGroupNames.setMember(member);
                describeAutoScalingGroupsType.setAutoScalingGroupNames(autoScalingGroupNames);
                DescribeAutoScalingGroupsResponseType describeAutoScalingGroupsResponseType = (DescribeAutoScalingGroupsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeAutoScalingGroupsType);
                if (action.doesGroupNotExist(describeAutoScalingGroupsResponseType)) {
                    return action;
                }
                AutoScalingGroupType firstGroup = (AutoScalingGroupType)describeAutoScalingGroupsResponseType.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember().get(0);
                if (firstGroup.getInstances() == null || firstGroup.getInstances().getMember() == null || firstGroup.getInstances().getMember().isEmpty()) {
                    return action;
                }
                throw new ValidationFailedException("Autoscaling group " + action.info.getPhysicalResourceId() + " still has instances");
            }

            @Override
            public Integer getTimeout() {
                return AUTOSCALING_GROUP_ZERO_INSTANCES_MAX_DELETE_RETRY_SECS;
            }
        }
        ,
        DELETE_GROUP{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSAutoScalingAutoScalingGroupResourceAction action = (AWSAutoScalingAutoScalingGroupResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(AutoScaling.class, (Partition[])new Partition[0]);
                if (DeleteSteps.groupDoesNotExist(configuration, action)) {
                    return action;
                }
                DeleteAutoScalingGroupType deleteAutoScalingGroupType = MessageHelper.createMessage(DeleteAutoScalingGroupType.class, action.info.getEffectiveUserId());
                deleteAutoScalingGroupType.setAutoScalingGroupName(action.info.getPhysicalResourceId());
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)deleteAutoScalingGroupType);
                return action;
            }
        }
        ,
        VERIFY_GROUP_DELETED{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSAutoScalingAutoScalingGroupResourceAction action = (AWSAutoScalingAutoScalingGroupResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(AutoScaling.class, (Partition[])new Partition[0]);
                if (DeleteSteps.groupDoesNotExist(configuration, action)) {
                    return action;
                }
                throw new ValidationFailedException("Autoscaling group " + action.info.getPhysicalResourceId() + " is not yet deleted");
            }

            @Override
            public Integer getTimeout() {
                return AUTOSCALING_GROUP_DELETED_MAX_DELETE_RETRY_SECS;
            }
        };


        private static boolean groupDoesNotExist(ServiceConfiguration configuration, AWSAutoScalingAutoScalingGroupResourceAction action) throws Exception {
            if (action.info.getPhysicalResourceId() == null) {
                return true;
            }
            DescribeAutoScalingGroupsType describeAutoScalingGroupsType = MessageHelper.createMessage(DescribeAutoScalingGroupsType.class, action.info.getEffectiveUserId());
            AutoScalingGroupNames autoScalingGroupNames = new AutoScalingGroupNames();
            ArrayList member = Lists.newArrayList((Object[])new String[]{action.info.getPhysicalResourceId()});
            autoScalingGroupNames.setMember(member);
            describeAutoScalingGroupsType.setAutoScalingGroupNames(autoScalingGroupNames);
            DescribeAutoScalingGroupsResponseType describeAutoScalingGroupsResponseType = (DescribeAutoScalingGroupsResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeAutoScalingGroupsType);
            return action.doesGroupNotExist(describeAutoScalingGroupsResponseType);
        }

        @Override
        public Integer getTimeout() {
            return null;
        }
    }

    private static enum CreateSteps implements Step
    {
        CREATE_GROUP{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSAutoScalingAutoScalingGroupResourceAction action = (AWSAutoScalingAutoScalingGroupResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(AutoScaling.class, (Partition[])new Partition[0]);
                String autoScalingGroupName = action.getDefaultPhysicalResourceId();
                CreateAutoScalingGroupType createAutoScalingGroupType = MessageHelper.createMessage(CreateAutoScalingGroupType.class, action.info.getEffectiveUserId());
                createAutoScalingGroupType.setAutoScalingGroupName(autoScalingGroupName);
                if (action.properties.getInstanceId() != null) {
                    throw new ValidationErrorException("InstanceId not supported");
                }
                if (action.properties.getLaunchConfigurationName() == null) {
                    throw new ValidationErrorException("LaunchConfiguration required (as InstanceId not supported)");
                }
                if (action.properties.getAvailabilityZones() != null) {
                    createAutoScalingGroupType.setAvailabilityZones(new AvailabilityZones(action.properties.getAvailabilityZones()));
                }
                createAutoScalingGroupType.setDefaultCooldown(action.properties.getCooldown());
                createAutoScalingGroupType.setDesiredCapacity(action.properties.getDesiredCapacity());
                createAutoScalingGroupType.setHealthCheckGracePeriod(action.properties.getHealthCheckGracePeriod());
                createAutoScalingGroupType.setLaunchConfigurationName(action.properties.getLaunchConfigurationName());
                if (action.properties.getLoadBalancerNames() != null) {
                    createAutoScalingGroupType.setLoadBalancerNames(new LoadBalancerNames(action.properties.getLoadBalancerNames()));
                }
                createAutoScalingGroupType.setMaxSize(action.properties.getMaxSize());
                createAutoScalingGroupType.setMinSize(action.properties.getMinSize());
                if (action.properties.getTerminationPolicies() != null) {
                    createAutoScalingGroupType.setTerminationPolicies(new TerminationPolicies(action.properties.getTerminationPolicies()));
                }
                if (action.properties.getVpcZoneIdentifier() != null) {
                    createAutoScalingGroupType.setVpcZoneIdentifier(Strings.emptyToNull((String)Joiner.on((String)",").join(action.properties.getVpcZoneIdentifier())));
                }
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createAutoScalingGroupType);
                action.info.setPhysicalResourceId(autoScalingGroupName);
                action.info.setReferenceValueJson(JsonHelper.getStringFromJsonNode((JsonNode)new TextNode(action.info.getPhysicalResourceId())));
                return action;
            }
        }
        ,
        CREATE_TAGS{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSAutoScalingAutoScalingGroupResourceAction action = (AWSAutoScalingAutoScalingGroupResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(AutoScaling.class, (Partition[])new Partition[0]);
                String effectiveAdminUserId = Accounts.lookupUserById((String)action.info.getEffectiveUserId()).getAccount().lookupAdmin().getUserId();
                CreateOrUpdateTagsType createSystemTagsType = MessageHelper.createPrivilegedMessage(CreateOrUpdateTagsType.class, effectiveAdminUserId);
                createSystemTagsType.setTags(this.convertAutoScalingTagsToCreateOrUpdateTags(action.info.getPhysicalResourceId(), TagHelper.getAutoScalingSystemTags(action.info, action.getStackEntity())));
                AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createSystemTagsType);
                List<AutoScalingTag> tags = TagHelper.getAutoScalingStackTags(action.getStackEntity());
                if (action.properties.getTags() != null && !action.properties.getTags().isEmpty()) {
                    TagHelper.checkReservedAutoScalingTemplateTags(action.properties.getTags());
                    tags.addAll(action.properties.getTags());
                }
                if (!tags.isEmpty()) {
                    CreateOrUpdateTagsType createOrUpdateTagsType = MessageHelper.createMessage(CreateOrUpdateTagsType.class, action.info.getEffectiveUserId());
                    createOrUpdateTagsType.setTags(this.convertAutoScalingTagsToCreateOrUpdateTags(action.info.getPhysicalResourceId(), tags));
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)createOrUpdateTagsType);
                }
                return action;
            }

            private Tags convertAutoScalingTagsToCreateOrUpdateTags(String physicalResourceId, List<AutoScalingTag> autoScalingTags) {
                if (autoScalingTags == null) {
                    return null;
                }
                Tags tags = new Tags();
                ArrayList member = Lists.newArrayList();
                for (AutoScalingTag autoScalingTag : autoScalingTags) {
                    TagType tagType = new TagType();
                    tagType.setResourceType("auto-scaling-group");
                    tagType.setResourceId(physicalResourceId);
                    tagType.setKey(autoScalingTag.getKey());
                    tagType.setValue(autoScalingTag.getValue());
                    tagType.setPropagateAtLaunch(autoScalingTag.getPropagateAtLaunch());
                    member.add(tagType);
                }
                tags.setMember(member);
                return tags;
            }
        }
        ,
        ADD_NOTIFICATION_CONFIGURATIONS{

            @Override
            public ResourceAction perform(ResourceAction resourceAction) throws Exception {
                AWSAutoScalingAutoScalingGroupResourceAction action = (AWSAutoScalingAutoScalingGroupResourceAction)resourceAction;
                ServiceConfiguration configuration = Topology.lookup(AutoScaling.class, (Partition[])new Partition[0]);
                if (action.properties.getNotificationConfiguration() != null) {
                    PutNotificationConfigurationType putNotificationConfigurationType = MessageHelper.createMessage(PutNotificationConfigurationType.class, action.info.getEffectiveUserId());
                    putNotificationConfigurationType.setAutoScalingGroupName(action.info.getPhysicalResourceId());
                    putNotificationConfigurationType.setTopicARN(action.properties.getNotificationConfiguration().getTopicARN());
                    AutoScalingNotificationTypes autoScalingNotificationTypes = new AutoScalingNotificationTypes();
                    ArrayList member = Lists.newArrayList(action.properties.getNotificationConfiguration().getNotificationTypes());
                    autoScalingNotificationTypes.setMember(member);
                    putNotificationConfigurationType.setNotificationTypes(autoScalingNotificationTypes);
                    AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)putNotificationConfigurationType);
                }
                return action;
            }
        };


        @Override
        public Integer getTimeout() {
            return null;
        }
    }
}

