/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources.standard;

import com.eucalyptus.cloudformation.CloudFormationException;
import com.eucalyptus.cloudformation.Tag;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.entity.StackEntity;
import com.eucalyptus.cloudformation.entity.StackEntityHelper;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.info.AWSAutoScalingAutoScalingGroupResourceInfo;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AutoScalingTag;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.CloudFormationResourceTag;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.EC2Tag;
import com.eucalyptus.util.Strings;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class TagHelper {
    private static List<String> reservedPrefixes = Lists.newArrayList((Object[])new String[]{"euca:", "aws:"});

    public static List<CloudFormationResourceTag> getCloudFormationResourceSystemTags(ResourceInfo resourceInfo, StackEntity stackEntity) throws CloudFormationException {
        ArrayList tags = Lists.newArrayList();
        CloudFormationResourceTag logicalIdTag = new CloudFormationResourceTag();
        logicalIdTag.setKey("aws:cloudformation:logical-id");
        logicalIdTag.setValue(resourceInfo.getLogicalResourceId());
        tags.add(logicalIdTag);
        CloudFormationResourceTag stackIdTag = new CloudFormationResourceTag();
        stackIdTag.setKey("aws:cloudformation:stack-id");
        stackIdTag.setValue(stackEntity.getStackId());
        tags.add(stackIdTag);
        CloudFormationResourceTag stackNameTag = new CloudFormationResourceTag();
        stackNameTag.setKey("aws:cloudformation:stack-name");
        stackNameTag.setValue(stackEntity.getStackName());
        tags.add(stackNameTag);
        return tags;
    }

    public static List<CloudFormationResourceTag> getCloudFormationResourceStackTags(StackEntity stackEntity) throws CloudFormationException {
        ArrayList tags = Lists.newArrayList();
        if (stackEntity.getTagsJson() != null) {
            ArrayList<Tag> stackTags = StackEntityHelper.jsonToTags(stackEntity.getTagsJson());
            for (Tag stackTag : stackTags) {
                CloudFormationResourceTag cloudFormationResourceTag = new CloudFormationResourceTag();
                cloudFormationResourceTag.setKey(stackTag.getKey());
                cloudFormationResourceTag.setValue(stackTag.getValue());
                tags.add(cloudFormationResourceTag);
            }
        }
        return tags;
    }

    public static List<EC2Tag> getEC2StackTags(StackEntity stackEntity) throws CloudFormationException {
        ArrayList tags = Lists.newArrayList();
        for (CloudFormationResourceTag otherTag : TagHelper.getCloudFormationResourceStackTags(stackEntity)) {
            EC2Tag tag = new EC2Tag();
            tag.setKey(otherTag.getKey());
            tag.setValue(otherTag.getValue());
            tags.add(tag);
        }
        return tags;
    }

    public static List<EC2Tag> getEC2SystemTags(ResourceInfo info, StackEntity stackEntity) throws CloudFormationException {
        ArrayList tags = Lists.newArrayList();
        for (CloudFormationResourceTag otherTag : TagHelper.getCloudFormationResourceSystemTags(info, stackEntity)) {
            EC2Tag tag = new EC2Tag();
            tag.setKey(otherTag.getKey());
            tag.setValue(otherTag.getValue());
            tags.add(tag);
        }
        return tags;
    }

    public static List<AutoScalingTag> getAutoScalingStackTags(StackEntity stackEntity) throws CloudFormationException {
        ArrayList tags = Lists.newArrayList();
        for (CloudFormationResourceTag otherTag : TagHelper.getCloudFormationResourceStackTags(stackEntity)) {
            AutoScalingTag tag = new AutoScalingTag();
            tag.setKey(otherTag.getKey());
            tag.setValue(otherTag.getValue());
            tag.setPropagateAtLaunch(true);
            tags.add(tag);
        }
        return tags;
    }

    public static List<AutoScalingTag> getAutoScalingSystemTags(AWSAutoScalingAutoScalingGroupResourceInfo info, StackEntity stackEntity) throws CloudFormationException {
        ArrayList tags = Lists.newArrayList();
        for (CloudFormationResourceTag otherTag : TagHelper.getCloudFormationResourceSystemTags(info, stackEntity)) {
            AutoScalingTag tag = new AutoScalingTag();
            tag.setKey(otherTag.getKey());
            tag.setValue(otherTag.getValue());
            tag.setPropagateAtLaunch(true);
            tags.add(tag);
        }
        return tags;
    }

    public static void checkReservedAutoScalingTemplateTags(List<AutoScalingTag> tags) throws ValidationErrorException {
        if (tags == null) {
            return;
        }
        ArrayList tagNames = Lists.newArrayList();
        for (AutoScalingTag tag : tags) {
            if (!Iterables.any(reservedPrefixes, (Predicate)Strings.isPrefixOf((String)tag.getKey()))) continue;
            throw new ValidationErrorException("Tag " + tag.getKey() + " uses a reserved prefix " + reservedPrefixes);
        }
    }

    public static void checkReservedCloudFormationResourceTemplateTags(List<CloudFormationResourceTag> tags) throws ValidationErrorException {
        if (tags == null) {
            return;
        }
        ArrayList tagNames = Lists.newArrayList();
        for (CloudFormationResourceTag tag : tags) {
            if (!Iterables.any(reservedPrefixes, (Predicate)Strings.isPrefixOf((String)tag.getKey()))) continue;
            throw new ValidationErrorException("Tag " + tag.getKey() + " uses a reserved prefix " + reservedPrefixes);
        }
    }

    public static void checkReservedEC2TemplateTags(List<EC2Tag> tags) throws ValidationErrorException {
        if (tags == null) {
            return;
        }
        ArrayList tagNames = Lists.newArrayList();
        for (EC2Tag tag : tags) {
            if (!Iterables.any(reservedPrefixes, (Predicate)Strings.isPrefixOf((String)tag.getKey()))) continue;
            throw new ValidationErrorException("Tag " + tag.getKey() + " uses a reserved prefix " + reservedPrefixes);
        }
    }
}

