/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources;

import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceResolver;
import com.eucalyptus.cloudformation.resources.standard.StandardResourceResolver;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.log4j.Logger;

public class ResourceResolverManager {
    private static final Logger LOG = Logger.getLogger(ResourceResolverManager.class);
    private List<ResourceResolver> resourceResolvers = Lists.newArrayList((Object[])new ResourceResolver[]{new StandardResourceResolver()});

    public ResourceInfo resolveResourceInfo(String resourceType) {
        for (ResourceResolver resourceResolver : this.resourceResolvers) {
            ResourceInfo resourceInfo = resourceResolver.resolveResourceInfo(resourceType);
            if (resourceInfo == null) continue;
            LOG.trace((Object)("Resolving resourceInfo " + resourceType + " with " + resourceResolver.getClass().getCanonicalName()));
            return resourceInfo;
        }
        return null;
    }

    public ResourceAction resolveResourceAction(String resourceType) {
        for (ResourceResolver resourceResolver : this.resourceResolvers) {
            ResourceAction resourceAction = resourceResolver.resolveResourceAction(resourceType);
            if (resourceAction == null) continue;
            LOG.trace((Object)("Resolving resourceAction " + resourceType + " with " + resourceResolver.getClass().getCanonicalName()));
            return resourceAction;
        }
        return null;
    }
}

