/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources;

import com.eucalyptus.cloudformation.CloudFormationException;
import com.eucalyptus.cloudformation.InternalFailureException;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.resources.annotations.Property;
import com.eucalyptus.cloudformation.resources.annotations.Required;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ResourcePropertyResolver {
    private static final Logger LOG = Logger.getLogger(ResourcePropertyResolver.class);

    public static JsonNode getJsonNodeFromResourceProperties(ResourceProperties resourceProperties) throws CloudFormationException {
        return ResourcePropertyResolver.getJsonNodeFromObject(resourceProperties);
    }

    private static JsonNode getJsonNodeFromObject(Object object) throws CloudFormationException {
        if (object == null) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode jsonNode = mapper.createObjectNode();
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(object.getClass());
        }
        catch (IntrospectionException ex) {
            LOG.error((Object)("Unable to create bean info for class " + object.getClass().getCanonicalName() + ".  Check signatures for getters and setters"));
            throw new InternalFailureException(ex.getMessage());
        }
        HashMap propertyDescriptorMap = Maps.newHashMap();
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            propertyDescriptorMap.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        for (Field field : object.getClass().getDeclaredFields()) {
            Property property = field.getAnnotation(Property.class);
            if (property == null) continue;
            String defaultName = field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
            String name = property.name() == null || property.name().isEmpty() ? defaultName : property.name();
            Object objectValue = ResourcePropertyResolver.getField(propertyDescriptorMap, field, object);
            if (objectValue == null) continue;
            if (objectValue instanceof String) {
                jsonNode.put(name, (String)objectValue);
                continue;
            }
            if (objectValue instanceof Integer) {
                jsonNode.put(name, String.valueOf((Integer)objectValue));
                continue;
            }
            if (objectValue instanceof Double) {
                jsonNode.put(name, String.valueOf((Double)objectValue));
                continue;
            }
            if (objectValue instanceof Boolean) {
                jsonNode.put(name, String.valueOf((Boolean)objectValue));
                continue;
            }
            if (objectValue instanceof JsonNode) {
                jsonNode.put(name, (JsonNode)objectValue);
                continue;
            }
            if (objectValue instanceof Collection) {
                jsonNode.put(name, ResourcePropertyResolver.getJsonNodeFromCollection((Collection)objectValue));
                continue;
            }
            jsonNode.put(name, ResourcePropertyResolver.getJsonNodeFromObject(objectValue));
        }
        return jsonNode;
    }

    private static JsonNode getJsonNodeFromCollection(Collection<?> collection) throws CloudFormationException {
        if (collection == null) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode jsonNode = mapper.createArrayNode();
        for (Object object : collection) {
            if (object == null) {
                jsonNode.add((JsonNode)null);
                continue;
            }
            if (object instanceof String) {
                jsonNode.add((String)object);
                continue;
            }
            if (object instanceof Integer) {
                jsonNode.add(String.valueOf((Integer)object));
                continue;
            }
            if (object instanceof Double) {
                jsonNode.add(String.valueOf((Double)object));
                continue;
            }
            if (object instanceof Boolean) {
                jsonNode.add(String.valueOf((Boolean)object));
                continue;
            }
            if (object instanceof JsonNode) {
                jsonNode.add((JsonNode)object);
                continue;
            }
            if (object instanceof Collection) {
                jsonNode.add(ResourcePropertyResolver.getJsonNodeFromCollection((Collection)object));
                continue;
            }
            jsonNode.add(ResourcePropertyResolver.getJsonNodeFromObject(object));
        }
        return jsonNode;
    }

    public static void populateResourceProperties(Object object, JsonNode jsonNode) throws CloudFormationException {
        if (jsonNode == null) {
            return;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(object.getClass());
        }
        catch (IntrospectionException ex) {
            LOG.error((Object)("Unable to create bean info for class " + object.getClass().getCanonicalName() + ".  Check signatures for getters and setters"));
            throw new InternalFailureException(ex.getMessage());
        }
        HashMap propertyDescriptorMap = Maps.newHashMap();
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            propertyDescriptorMap.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        for (Field field : object.getClass().getDeclaredFields()) {
            Property property = field.getAnnotation(Property.class);
            if (property == null) continue;
            String defaultName = field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
            String name = property.name() == null || property.name().isEmpty() ? defaultName : property.name();
            Required required = field.getAnnotation(Required.class);
            if (required != null && !jsonNode.has(name)) {
                throw new ValidationErrorException("Template error: " + name + " is a required field");
            }
            if (!jsonNode.has(name)) continue;
            JsonNode valueNode = jsonNode.get(name);
            LOG.debug((Object)("Populating property with: " + name + "=" + valueNode + " " + valueNode.getClass()));
            if (field.getType().equals(String.class)) {
                if (!valueNode.isValueNode()) {
                    throw new ValidationErrorException("Template error: " + name + " must be of type String");
                }
                ResourcePropertyResolver.setField(propertyDescriptorMap, field, object, valueNode.asText());
                continue;
            }
            if (field.getType().equals(Integer.class)) {
                if (!valueNode.isValueNode()) {
                    throw new ValidationErrorException("Template error: " + name + " must be of type Number");
                }
                try {
                    ResourcePropertyResolver.setField(propertyDescriptorMap, field, object, Integer.valueOf(valueNode.asText()));
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new ValidationErrorException("Template error: " + name + " must be of type Integer (" + valueNode.asText() + ")");
                }
            }
            if (field.getType().equals(Double.class)) {
                if (!valueNode.isValueNode()) {
                    throw new ValidationErrorException("Template error: " + name + " must be of type Number");
                }
                try {
                    ResourcePropertyResolver.setField(propertyDescriptorMap, field, object, Double.valueOf(valueNode.asText()));
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new ValidationErrorException("Template error: " + name + " must be of type Number (" + valueNode.asText() + ")");
                }
            }
            if (field.getType().equals(Boolean.class)) {
                if (!valueNode.isValueNode()) {
                    throw new ValidationErrorException("Template error: " + name + " must be of type Boolean");
                }
                ResourcePropertyResolver.setField(propertyDescriptorMap, field, object, Boolean.valueOf(valueNode.asText()));
                continue;
            }
            if (field.getType().equals(Object.class)) {
                ResourcePropertyResolver.setField(propertyDescriptorMap, field, object, new Object());
                continue;
            }
            if (JsonNode.class.isAssignableFrom(field.getType())) {
                ResourcePropertyResolver.setField(propertyDescriptorMap, field, object, valueNode);
                continue;
            }
            if (Collection.class.isAssignableFrom(field.getType())) {
                Type genericFieldType = field.getGenericType();
                if (genericFieldType instanceof ParameterizedType) {
                    if (!valueNode.isArray()) {
                        throw new ValidationErrorException("Template error: " + name + " must be of type List");
                    }
                    Type collectionType = ((ParameterizedType)genericFieldType).getActualTypeArguments()[0];
                    if (ResourcePropertyResolver.getField(propertyDescriptorMap, field, object) == null) {
                        LOG.error((Object)("Class " + object.getClass() + " has a Collection type " + field.getName() + " that must be " + "non-null ResourcePropertyResolver.populateResourceProperties can be called"));
                        throw new InternalFailureException("Class " + object.getClass() + " has a Collection type " + field.getName() + " that must be " + "non-null ResourcePropertyResolver.populateResourceProperties can be called");
                    }
                    ResourcePropertyResolver.populateList((Collection)ResourcePropertyResolver.getField(propertyDescriptorMap, field, object), valueNode, collectionType, field.getName());
                    continue;
                }
                LOG.error((Object)("Class " + object.getClass() + " has a Collection type " + field.getName() + " which is a non-parameterized type.  This " + "is not supported for ResourcePropertyResolver.populateResourceProperties"));
                throw new InternalFailureException("Class " + object.getClass() + " has a Collection type " + field.getName() + " which is a non-parameterized type.  This " + "is not supported for ResourcePropertyResolver.populateResourceProperties");
            }
            if (ResourcePropertyResolver.getField(propertyDescriptorMap, field, object) == null) {
                try {
                    ResourcePropertyResolver.setField(propertyDescriptorMap, field, object, field.getType().newInstance());
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    LOG.error((Object)("Class " + object.getClass() + " may not have a public no-arg constructor.  This is needed for ResourcePropertyResolver.populateResourceProperties()"));
                    throw new InternalFailureException(ex.getMessage());
                }
            }
            ResourcePropertyResolver.populateResourceProperties(ResourcePropertyResolver.getField(propertyDescriptorMap, field, object), valueNode);
        }
    }

    private static void setField(Map<String, PropertyDescriptor> propertyDescriptorMap, Field field, Object object, Object value) throws CloudFormationException {
        if (!propertyDescriptorMap.containsKey(field.getName()) || propertyDescriptorMap.get(field.getName()).getWriteMethod() == null) {
            LOG.error((Object)("No public setter for " + field.getName() + " in class " + object.getClass().getName()));
            throw new InternalFailureException("No public setter for " + field.getName() + " in class " + object.getClass().getName());
        }
        try {
            propertyDescriptorMap.get(field.getName()).getWriteMethod().invoke(object, value);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            throw new InternalFailureException(ex.getMessage());
        }
    }

    private static Object getField(Map<String, PropertyDescriptor> propertyDescriptorMap, Field field, Object object) throws CloudFormationException {
        if (!propertyDescriptorMap.containsKey(field.getName()) || propertyDescriptorMap.get(field.getName()).getReadMethod() == null) {
            LOG.error((Object)("No public getter for " + field.getName() + " in class " + object.getClass().getName()));
            throw new InternalFailureException("No public getter for " + field.getName() + " in class " + object.getClass().getName());
        }
        try {
            return propertyDescriptorMap.get(field.getName()).getReadMethod().invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            throw new InternalFailureException(ex.getMessage());
        }
    }

    private static void populateList(Collection<?> collection, JsonNode valueNode, Type collectionType, String fieldName) throws CloudFormationException {
        for (int i = 0; i < valueNode.size(); ++i) {
            Class collectionTypeClass = (Class)collectionType;
            JsonNode itemNode = valueNode.get(i);
            if (collectionTypeClass.equals(String.class)) {
                if (!itemNode.isValueNode()) {
                    throw new ValidationErrorException("Template error: " + fieldName + " must have members of type String");
                }
                ResourcePropertyResolver.addToCollection(collection, collectionTypeClass, itemNode.asText());
                continue;
            }
            if (collectionTypeClass.equals(Integer.class)) {
                if (!itemNode.isValueNode()) {
                    throw new ValidationErrorException("Template error: " + fieldName + " must have members of type Integer");
                }
                try {
                    ResourcePropertyResolver.addToCollection(collection, collectionTypeClass, Integer.valueOf(itemNode.asText()));
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new ValidationErrorException("Template error: " + fieldName + " must have members of type Integer (" + itemNode.asText() + ")");
                }
            }
            if (collectionTypeClass.equals(Double.class)) {
                if (!itemNode.isValueNode()) {
                    throw new ValidationErrorException("Template error: " + fieldName + " must have members of type Number");
                }
                try {
                    ResourcePropertyResolver.addToCollection(collection, collectionTypeClass, Double.valueOf(itemNode.asText()));
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new ValidationErrorException("Template error: " + fieldName + " must have members of type Number (" + itemNode.asText() + ")");
                }
            }
            if (collectionTypeClass.equals(Boolean.class)) {
                if (!itemNode.isValueNode()) {
                    throw new ValidationErrorException("Template error: " + fieldName + " must have members of type Boolean");
                }
                ResourcePropertyResolver.addToCollection(collection, collectionTypeClass, Boolean.valueOf(itemNode.asText()));
                continue;
            }
            if (Collection.class.isAssignableFrom(collectionTypeClass)) {
                if (collectionType instanceof ParameterizedType) {
                    if (!itemNode.isArray()) {
                        throw new ValidationErrorException("Template error: " + fieldName + " must have members of type List");
                    }
                    Type innerCollectionType = ((ParameterizedType)((Object)collection)).getActualTypeArguments()[0];
                    Object newObject = null;
                    try {
                        newObject = collectionTypeClass.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException ex) {
                        LOG.error((Object)("Class " + collectionTypeClass.getCanonicalName() + " may not have a public no-arg constructor.  This is needed for ResourcePropertyResolver.populateResourceProperties()"));
                        throw new InternalFailureException(ex.getMessage());
                    }
                    ResourcePropertyResolver.populateList(newObject, itemNode, innerCollectionType, fieldName);
                    ResourcePropertyResolver.addToCollection(collection, collectionTypeClass, newObject);
                    continue;
                }
                LOG.error((Object)("Class " + collectionTypeClass.getCanonicalName() + " has a Collection type which is a non-parameterized type.  This " + "is not supported for ResourcePropertyResolver.populateResourceProperties"));
                throw new InternalFailureException("Class " + collectionTypeClass.getCanonicalName() + " has a Collection type which is a non-parameterized type.  This " + "is not supported for ResourcePropertyResolver.populateResourceProperties");
            }
            Object newObject = null;
            try {
                newObject = collectionTypeClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                LOG.error((Object)("Class " + collectionTypeClass + " may not have a public no-arg constructor.  This is needed for Reso/**/urceData.populateFields()"));
                throw new InternalFailureException(ex.getMessage());
            }
            ResourcePropertyResolver.populateResourceProperties(newObject, itemNode);
            ResourcePropertyResolver.addToCollection(collection, collectionTypeClass, newObject);
        }
    }

    private static void addToCollection(Collection<?> collection, Class<?> collectionTypeClass, Object newObject) throws CloudFormationException {
        try {
            Method method = collection.getClass().getMethod("add", Object.class);
            method.invoke(collection, newObject);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            LOG.error((Object)("It appears class " + collection.getClass().getCanonicalName() + " which implements collection does not have a public 'add' method."));
            LOG.error((Object)ex, (Throwable)ex);
            throw new InternalFailureException(ex.getMessage());
        }
    }
}

