/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources;

import com.eucalyptus.cloudformation.CloudFormationException;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceResolverManager;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ResourceInfoHelper {
    private static final Logger LOG = Logger.getLogger(ResourceInfoHelper.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static ResourceInfo jsonToResourceInfo(String json) throws CloudFormationException {
        JsonNode resourceNode = JsonHelper.getJsonNodeFromString(json);
        LOG.info((Object)("resourceNode=" + resourceNode));
        LOG.info((Object)("resourceNode.get(\"type\")=" + resourceNode.get("type")));
        String type = resourceNode.get("type").asText();
        ResourceInfo resourceInfo = new ResourceResolverManager().resolveResourceInfo(type);
        resourceInfo.setAccountId(resourceNode.get("accountId").asText());
        resourceInfo.setAllowedByCondition(resourceNode.get("allowedByCondition").booleanValue());
        resourceInfo.setDescription(resourceNode.get("description").asText());
        resourceInfo.setDeletionPolicy(resourceNode.get("deletionPolicy").asText());
        resourceInfo.setEffectiveUserId(resourceNode.get("effectiveUserId").asText());
        resourceInfo.setLogicalResourceId(resourceNode.get("logicalResourceId").asText());
        resourceInfo.setMetadataJson(resourceNode.get("metadataJson").asText());
        resourceInfo.setPhysicalResourceId(resourceNode.get("physicalResourceId").asText());
        resourceInfo.setPropertiesJson(resourceNode.get("propertiesJson").asText());
        resourceInfo.setReady(resourceNode.get("ready").booleanValue());
        resourceInfo.setReferenceValueJson(resourceNode.get("referenceValueJson").asText());
        resourceInfo.setUpdatePolicyJson(resourceNode.get("updatePolicyJson").asText());
        ResourceInfoHelper.setResourceAttributesJson(resourceInfo, resourceNode.get("attributes").asText());
        return resourceInfo;
    }

    public static void setResourceAttributesJson(ResourceInfo resourceInfo, String json) throws CloudFormationException {
        JsonNode attributeNode = JsonHelper.getJsonNodeFromString(json);
        for (String attributeName : Lists.newArrayList((Iterator)attributeNode.fieldNames())) {
            resourceInfo.setResourceAttributeJson(attributeName, attributeNode.get(attributeName).asText());
        }
    }

    public static String resourceInfoToJson(ResourceInfo resourceInfo) throws CloudFormationException {
        if (resourceInfo == null) {
            return null;
        }
        ObjectNode resourceNode = mapper.createObjectNode();
        resourceNode.put("accountId", resourceInfo.getAccountId());
        resourceNode.put("type", resourceInfo.getType());
        resourceNode.put("allowedByCondition", resourceInfo.getAllowedByCondition());
        resourceNode.put("deletionPolicy", resourceInfo.getDeletionPolicy());
        resourceNode.put("description", resourceInfo.getDescription());
        resourceNode.put("effectiveUserId", resourceInfo.getEffectiveUserId());
        resourceNode.put("logicalResourceId", resourceInfo.getLogicalResourceId());
        resourceNode.put("metadataJson", resourceInfo.getMetadataJson());
        resourceNode.put("physicalResourceId", resourceInfo.getPhysicalResourceId());
        resourceNode.put("propertiesJson", resourceInfo.getPropertiesJson());
        resourceNode.put("ready", resourceInfo.getReady());
        resourceNode.put("referenceValueJson", resourceInfo.getReferenceValueJson());
        resourceNode.put("updatePolicyJson", resourceInfo.getUpdatePolicyJson());
        Collection<String> attributeNames = resourceInfo.getAttributeNames();
        if (attributeNames == null) {
            resourceNode.put("attributes", (String)null);
        } else {
            resourceNode.put("attributes", ResourceInfoHelper.getResourceAttributesJson(resourceInfo));
        }
        return JsonHelper.getStringFromJsonNode((JsonNode)resourceNode);
    }

    public static String getResourceAttributesJson(ResourceInfo resourceInfo) throws CloudFormationException {
        ObjectMapper mapper = new ObjectMapper();
        Collection<String> attributeNames = resourceInfo.getAttributeNames();
        ObjectNode attributesNode = mapper.createObjectNode();
        if (attributeNames != null) {
            for (String attributeName : attributeNames) {
                attributesNode.put(attributeName, resourceInfo.getResourceAttributeJson(attributeName));
            }
        }
        return JsonHelper.getStringFromJsonNode((JsonNode)attributesNode);
    }

    public static String resourceInfoMapToJson(Map<String, ResourceInfo> resourceInfoMap) throws CloudFormationException {
        try {
            LinkedHashMap resourceInfoJsonMap = Maps.newLinkedHashMap();
            if (resourceInfoMap != null) {
                for (String key : resourceInfoMap.keySet()) {
                    resourceInfoJsonMap.put(key, ResourceInfoHelper.resourceInfoToJson(resourceInfoMap.get(key)));
                }
            }
            return mapper.writeValueAsString(resourceInfoMap);
        }
        catch (JsonProcessingException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    public static Map<String, ResourceInfo> jsonToResourceInfoMap(String resourceInfoMapJson) throws CloudFormationException {
        try {
            LinkedHashMap resourceInfoJsonMap = resourceInfoMapJson == null ? Maps.newLinkedHashMap() : (Map)mapper.readValue(resourceInfoMapJson, (TypeReference)new TypeReference<LinkedHashMap<String, String>>(){});
            LinkedHashMap resourceInfoMap = Maps.newLinkedHashMap();
            for (String key : resourceInfoJsonMap.keySet()) {
                resourceInfoMap.put(key, ResourceInfoHelper.jsonToResourceInfo((String)resourceInfoJsonMap.get(key)));
            }
            return resourceInfoMap;
        }
        catch (IOException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }
}

