/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources;

import com.eucalyptus.crypto.Crypto;

public class ResourceActionHelper {
    static final String getDefaultPhysicalResourceId(String stackName, String logicalResourceId, int maxLength) {
        String prefix = stackName != null ? stackName : "UNKNOWN";
        String middle = logicalResourceId != null ? logicalResourceId : "UNKNOWN";
        String suffix = Crypto.generateAlphanumericId((int)13, (String)"");
        String finalString = prefix + "-" + middle + "-" + suffix;
        if (finalString.length() > maxLength) {
            int prefixMiddleAndDashesLength = maxLength - suffix.length();
            int prefixAndDashLength = prefixMiddleAndDashesLength / 2;
            int middleAndDashLength = prefixMiddleAndDashesLength - prefixAndDashLength;
            int prefixLength = prefixAndDashLength - 1;
            int middleLength = middleAndDashLength - 1;
            if (prefix.length() < prefixLength) {
                int difference = prefixLength - prefix.length();
                prefixLength -= difference;
                middleLength += difference;
            } else if (middle.length() < middleLength) {
                int difference = middleLength - middle.length();
                middleLength -= difference;
                prefixLength += difference;
            }
            if (prefix.charAt(prefixLength - 1) == '-' && middleLength < middle.length()) {
                --prefixLength;
                ++middleLength;
            } else if (middle.charAt(middleLength - 1) == '-' && prefixLength < prefix.length()) {
                --middleLength;
                ++prefixLength;
            }
            return prefix.substring(0, prefixLength) + "-" + middle.substring(0, middleLength) + "-" + suffix;
        }
        return finalString;
    }
}

