/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.eucalyptus.cloudformation.entity.StackEntity;
import com.eucalyptus.cloudformation.resources.ResourceActionHelper;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceProperties;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.steps.Step;
import com.google.common.collect.Maps;
import com.netflix.glisten.WorkflowOperations;
import java.util.Map;

public abstract class ResourceAction {
    protected StackEntity stackEntity;
    protected Map<String, Step> createSteps = Maps.newLinkedHashMap();
    protected Map<String, Step> deleteSteps = Maps.newLinkedHashMap();

    public abstract ResourceProperties getResourceProperties();

    public abstract void setResourceProperties(ResourceProperties var1);

    public abstract ResourceInfo getResourceInfo();

    public abstract void setResourceInfo(ResourceInfo var1);

    public StackEntity getStackEntity() {
        return this.stackEntity;
    }

    public void setStackEntity(StackEntity stackEntity) {
        this.stackEntity = stackEntity;
    }

    public final String getDefaultPhysicalResourceId(int maxLength) {
        String stackName = this.getStackEntity() != null && this.getStackEntity().getStackName() != null ? this.getStackEntity().getStackName() : "UNKNOWN";
        String logicalResourceId = this.getResourceInfo() != null && this.getResourceInfo().getLogicalResourceId() != null ? this.getResourceInfo().getLogicalResourceId() : "UNKNOWN";
        return ResourceActionHelper.getDefaultPhysicalResourceId(stackName, logicalResourceId, maxLength);
    }

    public final String getDefaultPhysicalResourceId() {
        return this.getDefaultPhysicalResourceId(Integer.MAX_VALUE);
    }

    public final Step getCreateStep(String stepId) {
        return this.createSteps.get(stepId);
    }

    public final Step getDeleteStep(String stepId) {
        return this.deleteSteps.get(stepId);
    }

    public abstract Promise<String> getCreatePromise(WorkflowOperations<StackActivity> var1, String var2, String var3, String var4, String var5);

    public abstract Promise<String> getDeletePromise(WorkflowOperations<StackActivity> var1, String var2, String var3, String var4, String var5);

    public void refreshAttributes() throws Exception {
    }
}

