/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.resources;

import com.eucalyptus.cloudformation.entity.StackEntity;
import com.eucalyptus.cloudformation.entity.StackResourceEntity;
import com.eucalyptus.cloudformation.entity.StackResourceEntityManager;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourcePropertyResolver;
import com.eucalyptus.cloudformation.resources.ResourceResolverManager;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.EC2Tag;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.compute.common.ResourceTag;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class EC2Helper {
    public static ArrayList<ResourceTag> createTagSet(List<EC2Tag> tags) {
        ArrayList resourceTags = Lists.newArrayList();
        for (EC2Tag tag : tags) {
            ResourceTag resourceTag = new ResourceTag();
            resourceTag.setKey(tag.getKey());
            resourceTag.setValue(tag.getValue());
            resourceTags.add(resourceTag);
        }
        return resourceTags;
    }

    public static void refreshInstanceAttributes(StackEntity stackEntity, String instanceId, String effectiveUserId) throws Exception {
        String accountId;
        String stackId;
        StackResourceEntity instanceStackResourceEntity;
        if (instanceId != null && (instanceStackResourceEntity = StackResourceEntityManager.getStackResourceByPhysicalResourceId(stackId = stackEntity.getStackId(), accountId = stackEntity.getAccountId(), instanceId)) != null) {
            ResourceInfo instanceResourceInfo = StackResourceEntityManager.getResourceInfo(instanceStackResourceEntity);
            ResourceAction instanceResourceAction = new ResourceResolverManager().resolveResourceAction(instanceResourceInfo.getType());
            instanceResourceAction.setStackEntity(stackEntity);
            instanceResourceInfo.setEffectiveUserId(effectiveUserId);
            instanceResourceAction.setResourceInfo(instanceResourceInfo);
            ResourcePropertyResolver.populateResourceProperties(instanceResourceAction.getResourceProperties(), JsonHelper.getJsonNodeFromString(instanceResourceInfo.getPropertiesJson()));
            instanceResourceAction.refreshAttributes();
            instanceStackResourceEntity = StackResourceEntityManager.updateResourceInfo(instanceStackResourceEntity, instanceResourceInfo);
            StackResourceEntityManager.updateStackResource(instanceStackResourceEntity);
        }
    }
}

