/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.policy;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.policy.PolicySpec;
import com.eucalyptus.auth.policy.key.KeyUtils;
import com.eucalyptus.auth.policy.key.PolicyKey;
import com.eucalyptus.auth.policy.key.QuotaKey;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.auth.principal.Authorization;
import com.eucalyptus.cloudformation.CloudFormationMetadata;
import com.eucalyptus.cloudformation.entity.StackEntity;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.google.common.base.Function;
import net.sf.json.JSONException;

@PolicyKey(value="cloudformation:quota-stacknumber")
public class CloudFormationNumberQuotaKey
extends QuotaKey {
    public static final String KEY = "cloudformation:quota-stacknumber";

    public final void validateValueType(String value) throws JSONException {
        KeyUtils.validateIntegerValue((String)value, (String)KEY);
    }

    public final boolean canApply(String action, String resourceType) {
        return PolicySpec.qualifiedName((String)"cloudformation", (String)"createstack").equals(action);
    }

    public final String value(Authorization.Scope scope, String id, String resource, Long quantity) throws AuthException {
        AccountFullName name;
        switch (scope) {
            case ACCOUNT: {
                name = AccountFullName.getInstance((String)id, (String[])new String[0]);
                break;
            }
            case GROUP: {
                return "Not supported";
            }
            case USER: {
                return "Not supported";
            }
            default: {
                throw new AuthException("Invalid scope");
            }
        }
        return Long.toString((Long)RestrictedTypes.quantityMetricFunction(CloudFormationMetadata.StackMetadata.class).apply((Object)name) + quantity);
    }

    @RestrictedTypes.QuantityMetricFunction(value=CloudFormationMetadata.StackMetadata.class)
    public static enum CountStacks implements Function<OwnerFullName, Long>
    {
        INSTANCE;


        public Long apply(OwnerFullName input) {
            try (TransactionResource db = Entities.transactionFor(StackEntity.class);){
                long retVal = Entities.count((Object)((Object)StackEntity.exampleUndeletedWithAccount(input.getAccountNumber())));
                db.rollback();
                Long l = retVal;
                return l;
            }
        }
    }
}

