/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.entity;

import com.eucalyptus.cloudformation.CloudFormationException;
import com.eucalyptus.cloudformation.InternalFailureException;
import com.eucalyptus.cloudformation.entity.StackWorkflowEntity;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class StackWorkflowEntityManager {
    public static StackWorkflowEntity addOrUpdateStackWorkflowEntity(String stackId, StackWorkflowEntity.WorkflowType workflowType, String domain, String workflowId, String runId) throws CloudFormationException {
        StackWorkflowEntity stackWorkflowEntity = new StackWorkflowEntity();
        stackWorkflowEntity.setDomain(domain);
        stackWorkflowEntity.setStackId(stackId);
        stackWorkflowEntity.setRunId(runId);
        stackWorkflowEntity.setWorkflowId(workflowId);
        stackWorkflowEntity.setWorkflowType(workflowType);
        try (TransactionResource db = Entities.transactionFor(StackWorkflowEntity.class);){
            Criteria criteria = Entities.createCriteria(StackWorkflowEntity.class).add((Criterion)Restrictions.eq((String)"stackId", (Object)stackId)).add((Criterion)Restrictions.eq((String)"workflowType", (Object)((Object)workflowType)));
            List match = criteria.list();
            if (match != null && match.size() > 1) {
                throw new InternalFailureException("More than one stack workflow entity of type " + (Object)((Object)workflowType) + " already exists for stack id " + stackId);
            }
            if (match != null && match.size() == 1) {
                ((StackWorkflowEntity)((Object)match.get(0))).setDomain(domain);
                ((StackWorkflowEntity)((Object)match.get(0))).setStackId(stackId);
                ((StackWorkflowEntity)((Object)match.get(0))).setRunId(runId);
                ((StackWorkflowEntity)((Object)match.get(0))).setWorkflowId(workflowId);
                ((StackWorkflowEntity)((Object)match.get(0))).setWorkflowType(workflowType);
            } else {
                Entities.persist((Object)((Object)stackWorkflowEntity));
            }
            db.commit();
        }
        return stackWorkflowEntity;
    }

    public static List<StackWorkflowEntity> getStackWorkflowEntities(String stackId, StackWorkflowEntity.WorkflowType workflowType) {
        ArrayList workflows = Lists.newArrayList();
        try (TransactionResource db = Entities.transactionFor(StackWorkflowEntity.class);){
            Criteria criteria = Entities.createCriteria(StackWorkflowEntity.class).add((Criterion)Restrictions.eq((String)"stackId", (Object)stackId)).add((Criterion)Restrictions.eq((String)"workflowType", (Object)((Object)workflowType)));
            List match = criteria.list();
            if (match != null) {
                workflows.addAll(match);
            }
        }
        return workflows;
    }

    public static List<StackWorkflowEntity> getStackWorkflowEntities(String stackId) {
        ArrayList workflows = Lists.newArrayList();
        try (TransactionResource db = Entities.transactionFor(StackWorkflowEntity.class);){
            Criteria criteria = Entities.createCriteria(StackWorkflowEntity.class).add((Criterion)Restrictions.eq((String)"stackId", (Object)stackId));
            List match = criteria.list();
            if (match != null) {
                workflows.addAll(match);
            }
        }
        return workflows;
    }

    public static void deleteStackWorkflowEntities(String stackId) {
        try (TransactionResource db = Entities.transactionFor(StackWorkflowEntity.class);){
            Criteria criteria = Entities.createCriteria(StackWorkflowEntity.class).add((Criterion)Restrictions.eq((String)"stackId", (Object)stackId));
            List match = criteria.list();
            if (match != null) {
                for (StackWorkflowEntity stackWorkflowEntity : match) {
                    Entities.delete((Object)((Object)stackWorkflowEntity));
                }
            }
        }
    }
}

