/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.entity;

import com.eucalyptus.cloudformation.CloudFormationException;
import com.eucalyptus.cloudformation.InternalFailureException;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.entity.StackResourceEntity;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourceInfoHelper;
import com.eucalyptus.cloudformation.resources.ResourceResolverManager;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.google.common.collect.Lists;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class StackResourceEntityManager {
    public static void addStackResource(StackResourceEntity stackResourceEntity) {
        try (TransactionResource db = Entities.transactionFor(StackResourceEntity.class);){
            Entities.persist((Object)((Object)stackResourceEntity));
            db.commit();
        }
    }

    public static StackResourceEntity updateResourceInfo(StackResourceEntity stackResourceEntity, ResourceInfo resourceInfo) throws CloudFormationException {
        stackResourceEntity.setAccountId(resourceInfo.getAccountId());
        stackResourceEntity.setResourceType(resourceInfo.getType());
        stackResourceEntity.setAllowedByCondition(resourceInfo.getAllowedByCondition());
        stackResourceEntity.setDeletionPolicy(resourceInfo.getDeletionPolicy());
        stackResourceEntity.setDescription(resourceInfo.getDescription());
        stackResourceEntity.setLogicalResourceId(resourceInfo.getLogicalResourceId());
        stackResourceEntity.setMetadataJson(resourceInfo.getMetadataJson());
        stackResourceEntity.setPhysicalResourceId(resourceInfo.getPhysicalResourceId());
        stackResourceEntity.setPropertiesJson(resourceInfo.getPropertiesJson());
        stackResourceEntity.setReady(resourceInfo.getReady());
        stackResourceEntity.setReferenceValueJson(resourceInfo.getReferenceValueJson());
        stackResourceEntity.setUpdatePolicyJson(resourceInfo.getUpdatePolicyJson());
        stackResourceEntity.setResourceAttributesJson(ResourceInfoHelper.getResourceAttributesJson(resourceInfo));
        return stackResourceEntity;
    }

    public static void updateStackResource(StackResourceEntity stackResourceEntity) {
        try (TransactionResource db = Entities.transactionFor(StackResourceEntity.class);){
            Criteria criteria = Entities.createCriteria(StackResourceEntity.class).add((Criterion)Restrictions.eq((String)"naturalId", (Object)stackResourceEntity.getNaturalId()));
            StackResourceEntity dbEntity = (StackResourceEntity)((Object)criteria.uniqueResult());
            if (dbEntity == null) {
                Entities.persist((Object)((Object)stackResourceEntity));
            } else {
                dbEntity.setRecordDeleted(stackResourceEntity.getRecordDeleted());
                dbEntity.setDescription(stackResourceEntity.getDescription());
                dbEntity.setLogicalResourceId(stackResourceEntity.getLogicalResourceId());
                dbEntity.setPhysicalResourceId(stackResourceEntity.getPhysicalResourceId());
                dbEntity.setResourceStatus(stackResourceEntity.getResourceStatus());
                dbEntity.setResourceStatusReason(stackResourceEntity.getResourceStatusReason());
                dbEntity.setResourceType(stackResourceEntity.getResourceType());
                dbEntity.setStackId(stackResourceEntity.getStackId());
                dbEntity.setStackName(stackResourceEntity.getStackName());
                dbEntity.setAccountId(stackResourceEntity.getAccountId());
                dbEntity.setMetadataJson(stackResourceEntity.getMetadataJson());
                dbEntity.setReady(stackResourceEntity.getReady());
                dbEntity.setPropertiesJson(stackResourceEntity.getPropertiesJson());
                dbEntity.setUpdatePolicyJson(stackResourceEntity.getUpdatePolicyJson());
                dbEntity.setDeletionPolicy(stackResourceEntity.getDeletionPolicy());
                dbEntity.setAllowedByCondition(stackResourceEntity.getAllowedByCondition());
                dbEntity.setReferenceValueJson(stackResourceEntity.getReferenceValueJson());
                dbEntity.setResourceAttributesJson(stackResourceEntity.getResourceAttributesJson());
            }
            db.commit();
        }
    }

    public static StackResourceEntity getStackResource(String stackId, String accountId, String logicalResourceId) {
        StackResourceEntity stackResourceEntity = null;
        try (TransactionResource db = Entities.transactionFor(StackResourceEntity.class);){
            Criteria criteria = Entities.createCriteria(StackResourceEntity.class).add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId)).add((Criterion)Restrictions.eq((String)"stackId", (Object)stackId)).add((Criterion)Restrictions.eq((String)"logicalResourceId", (Object)logicalResourceId)).add((Criterion)Restrictions.eq((String)"recordDeleted", (Object)Boolean.FALSE));
            List stackResourceEntityList = criteria.list();
            if (stackResourceEntityList != null && !stackResourceEntityList.isEmpty()) {
                stackResourceEntity = (StackResourceEntity)((Object)stackResourceEntityList.get(0));
            }
            db.commit();
        }
        return stackResourceEntity;
    }

    public static StackResourceEntity getStackResourceByPhysicalResourceId(String stackId, String accountId, String physicalResourceId) {
        StackResourceEntity stackResourceEntity = null;
        try (TransactionResource db = Entities.transactionFor(StackResourceEntity.class);){
            Criteria criteria = Entities.createCriteria(StackResourceEntity.class).add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId)).add((Criterion)Restrictions.eq((String)"stackId", (Object)stackId)).add((Criterion)Restrictions.eq((String)"physicalResourceId", (Object)physicalResourceId)).add((Criterion)Restrictions.eq((String)"recordDeleted", (Object)Boolean.FALSE));
            List stackResourceEntityList = criteria.list();
            if (stackResourceEntityList != null && !stackResourceEntityList.isEmpty()) {
                stackResourceEntity = (StackResourceEntity)((Object)stackResourceEntityList.get(0));
            }
            db.commit();
        }
        return stackResourceEntity;
    }

    public static List<StackResourceEntity> getStackResources(String stackId, String accountId) {
        List stackResourceEntityList = Lists.newArrayList();
        try (TransactionResource db = Entities.transactionFor(StackResourceEntity.class);){
            Criteria criteria = Entities.createCriteria(StackResourceEntity.class).add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId)).add((Criterion)Restrictions.eq((String)"stackId", (Object)stackId)).add((Criterion)Restrictions.eq((String)"recordDeleted", (Object)Boolean.FALSE));
            stackResourceEntityList = criteria.list();
            db.commit();
        }
        return stackResourceEntityList;
    }

    public static void deleteStackResources(String stackId, String accountId) {
        try (TransactionResource db = Entities.transactionFor(StackResourceEntity.class);){
            Criteria criteria = Entities.createCriteria(StackResourceEntity.class).add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId)).add((Criterion)Restrictions.eq((String)"stackId", (Object)stackId)).add((Criterion)Restrictions.eq((String)"recordDeleted", (Object)Boolean.FALSE));
            for (StackResourceEntity stackResourceEntity : criteria.list()) {
                stackResourceEntity.setRecordDeleted(Boolean.TRUE);
            }
            db.commit();
        }
    }

    public static ResourceInfo getResourceInfo(String stackId, String accountId, String logicalResourceId) throws CloudFormationException {
        return StackResourceEntityManager.getResourceInfo(StackResourceEntityManager.getStackResource(stackId, accountId, logicalResourceId));
    }

    public static ResourceInfo getResourceInfo(StackResourceEntity stackResourceEntity) throws CloudFormationException {
        if (stackResourceEntity == null) {
            return null;
        }
        ResourceInfo resourceInfo = new ResourceResolverManager().resolveResourceInfo(stackResourceEntity.getResourceType());
        resourceInfo.setAccountId(stackResourceEntity.getAccountId());
        resourceInfo.setAllowedByCondition(stackResourceEntity.getAllowedByCondition());
        resourceInfo.setDescription(stackResourceEntity.getDescription());
        resourceInfo.setDeletionPolicy(stackResourceEntity.getDeletionPolicy());
        resourceInfo.setLogicalResourceId(stackResourceEntity.getLogicalResourceId());
        resourceInfo.setMetadataJson(stackResourceEntity.getMetadataJson());
        resourceInfo.setPhysicalResourceId(stackResourceEntity.getPhysicalResourceId());
        resourceInfo.setPropertiesJson(stackResourceEntity.getPropertiesJson());
        resourceInfo.setReady(stackResourceEntity.getReady());
        resourceInfo.setReferenceValueJson(stackResourceEntity.getReferenceValueJson());
        resourceInfo.setUpdatePolicyJson(stackResourceEntity.getUpdatePolicyJson());
        ResourceInfoHelper.setResourceAttributesJson(resourceInfo, stackResourceEntity.getResourceAttributesJson());
        return resourceInfo;
    }

    public static StackResourceEntity describeStackResource(String accountId, String stackNameOrId, String logicalResourceId) throws CloudFormationException {
        StackResourceEntity matchingStackResourceEntity = null;
        String stackId = null;
        try (TransactionResource db = Entities.transactionFor(StackResourceEntity.class);){
            Criteria criteria = Entities.createCriteria(StackResourceEntity.class).add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId)).add((Criterion)Restrictions.or((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"recordDeleted", (Object)Boolean.FALSE), (Criterion)Restrictions.eq((String)"stackName", (Object)stackNameOrId)), (Criterion)Restrictions.eq((String)"stackId", (Object)stackNameOrId))).add((Criterion)Restrictions.ne((String)"resourceStatus", (Object)((Object)StackResourceEntity.Status.NOT_STARTED)));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                throw new ValidationErrorException("Stack with name " + stackNameOrId + " does not exist");
            }
            for (StackResourceEntity stackResourceEntity : result) {
                if (stackId == null) {
                    stackId = stackResourceEntity.getStackId();
                } else if (!stackId.equals(stackResourceEntity.getStackId())) {
                    throw new InternalFailureException("Got results from more than one stack");
                }
                if (!logicalResourceId.equals(stackResourceEntity.getLogicalResourceId())) continue;
                if (matchingStackResourceEntity != null) {
                    throw new InternalFailureException("More than one record exists for Resource " + logicalResourceId + " on stack " + stackId);
                }
                matchingStackResourceEntity = stackResourceEntity;
            }
            if (matchingStackResourceEntity == null) {
                throw new ValidationErrorException("Resource " + logicalResourceId + " does not exist for stack " + stackId);
            }
            db.commit();
        }
        return matchingStackResourceEntity;
    }

    public static List<StackResourceEntity> describeStackResources(String accountId, String stackNameOrId, String physicalResourceId, String logicalResourceId) {
        List returnValue = null;
        Object stackId = null;
        try (TransactionResource db = Entities.transactionFor(StackResourceEntity.class);){
            Criteria criteria = Entities.createCriteria(StackResourceEntity.class).add((Criterion)(accountId != null ? Restrictions.eq((String)"accountId", (Object)accountId) : Restrictions.conjunction()));
            if (stackNameOrId != null) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"recordDeleted", (Object)Boolean.FALSE), (Criterion)Restrictions.eq((String)"stackName", (Object)stackNameOrId)), (Criterion)Restrictions.eq((String)"stackId", (Object)stackNameOrId)));
            }
            if (logicalResourceId != null) {
                criteria.add((Criterion)Restrictions.eq((String)"logicalResourceId", (Object)logicalResourceId));
            }
            if (physicalResourceId != null) {
                criteria.add((Criterion)Restrictions.eq((String)"physicalResourceId", (Object)logicalResourceId));
            }
            criteria.add((Criterion)Restrictions.ne((String)"resourceStatus", (Object)((Object)StackResourceEntity.Status.NOT_STARTED)));
            returnValue = criteria.list();
            db.commit();
        }
        return returnValue;
    }

    public static List<StackResourceEntity> listStackResources(String accountId, String stackNameOrId) {
        return StackResourceEntityManager.describeStackResources(accountId, stackNameOrId, null, null);
    }
}

