/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.entity;

import com.eucalyptus.entities.AbstractPersistent;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@PersistenceContext(name="eucalyptus_cloudformation")
@Table(name="stack_resources")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class StackResourceEntity
extends AbstractPersistent {
    @Column(name="account_id", nullable=false)
    String accountId;
    @Column(name="description", length=4000)
    String description;
    @Column(name="logical_resource_id", nullable=false)
    String logicalResourceId;
    @Column(name="metadata_json")
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    String metadataJson;
    @Column(name="physical_resource_id")
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    String physicalResourceId;
    @Column(name="resource_status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    Status resourceStatus;
    @Column(name="resource_status_reason")
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    String resourceStatusReason;
    @Column(name="resource_type", nullable=false)
    String resourceType;
    @Column(name="is_ready", nullable=false)
    Boolean ready = false;
    @Column(name="properties_json")
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    String propertiesJson;
    @Column(name="update_policy_json")
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    String updatePolicyJson;
    @Column(name="deletionPolicy", nullable=false)
    String deletionPolicy = "Delete";
    @Column(name="is_allowed_by_condition", nullable=false)
    Boolean allowedByCondition;
    @Column(name="reference_value_json")
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    String referenceValueJson;
    @Column(name="resource_attributes_json")
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    String resourceAttributesJson;
    @Column(name="stack_id", nullable=false, length=400)
    String stackId;
    @Column(name="stack_name", nullable=false)
    String stackName;
    @Column(name="is_record_deleted", nullable=false)
    Boolean recordDeleted;

    public Boolean getRecordDeleted() {
        return this.recordDeleted;
    }

    public void setRecordDeleted(Boolean recordDeleted) {
        this.recordDeleted = recordDeleted;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLogicalResourceId() {
        return this.logicalResourceId;
    }

    public void setLogicalResourceId(String logicalResourceId) {
        this.logicalResourceId = logicalResourceId;
    }

    public String getPhysicalResourceId() {
        return this.physicalResourceId;
    }

    public void setPhysicalResourceId(String physicalResourceId) {
        this.physicalResourceId = physicalResourceId;
    }

    public Status getResourceStatus() {
        return this.resourceStatus;
    }

    public void setResourceStatus(Status resourceStatus) {
        this.resourceStatus = resourceStatus;
    }

    public String getResourceStatusReason() {
        return this.resourceStatusReason;
    }

    public void setResourceStatusReason(String resourceStatusReason) {
        this.resourceStatusReason = resourceStatusReason;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getStackId() {
        return this.stackId;
    }

    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    public String getStackName() {
        return this.stackName;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getMetadataJson() {
        return this.metadataJson;
    }

    public void setMetadataJson(String metadataJson) {
        this.metadataJson = metadataJson;
    }

    public Boolean getReady() {
        return this.ready;
    }

    public void setReady(Boolean ready) {
        this.ready = ready;
    }

    public String getPropertiesJson() {
        return this.propertiesJson;
    }

    public void setPropertiesJson(String propertiesJson) {
        this.propertiesJson = propertiesJson;
    }

    public String getUpdatePolicyJson() {
        return this.updatePolicyJson;
    }

    public void setUpdatePolicyJson(String updatePolicyJson) {
        this.updatePolicyJson = updatePolicyJson;
    }

    public String getDeletionPolicy() {
        return this.deletionPolicy;
    }

    public void setDeletionPolicy(String deletionPolicy) {
        this.deletionPolicy = deletionPolicy;
    }

    public Boolean getAllowedByCondition() {
        return this.allowedByCondition;
    }

    public void setAllowedByCondition(Boolean allowedByCondition) {
        this.allowedByCondition = allowedByCondition;
    }

    public String getReferenceValueJson() {
        return this.referenceValueJson;
    }

    public void setReferenceValueJson(String referenceValueJson) {
        this.referenceValueJson = referenceValueJson;
    }

    public String getResourceAttributesJson() {
        return this.resourceAttributesJson;
    }

    public void setResourceAttributesJson(String resourceAttributesJson) {
        this.resourceAttributesJson = resourceAttributesJson;
    }

    public String toString() {
        return "StackResourceEntity{accountId='" + this.accountId + '\'' + ", description='" + this.description + '\'' + ", logicalResourceId='" + this.logicalResourceId + '\'' + ", metadataJson='" + this.metadataJson + '\'' + ", physicalResourceId='" + this.physicalResourceId + '\'' + ", resourceStatus=" + (Object)((Object)this.resourceStatus) + ", resourceStatusReason='" + this.resourceStatusReason + '\'' + ", resourceType='" + this.resourceType + '\'' + ", ready=" + this.ready + ", propertiesJson='" + this.propertiesJson + '\'' + ", updatePolicyJson='" + this.updatePolicyJson + '\'' + ", deletionPolicy='" + this.deletionPolicy + '\'' + ", allowedByCondition=" + this.allowedByCondition + ", referenceValueJson='" + this.referenceValueJson + '\'' + ", resourceAttributesJson='" + this.resourceAttributesJson + '\'' + ", stackId='" + this.stackId + '\'' + ", stackName='" + this.stackName + '\'' + ", recordDeleted=" + this.recordDeleted + '}';
    }

    public static enum Status {
        NOT_STARTED,
        CREATE_IN_PROGRESS,
        CREATE_FAILED,
        CREATE_COMPLETE,
        DELETE_IN_PROGRESS,
        DELETE_FAILED,
        DELETE_SKIPPED,
        DELETE_COMPLETE,
        ROLLBACK_IN_PROGRESS,
        ROLLBACK_FAILED,
        ROLLBACK_COMPLETE,
        UPDATE_IN_PROGRESS,
        UPDATE_FAILED,
        UPDATE_COMPLETE;

    }
}

