/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.entity;

import com.eucalyptus.cloudformation.StackEvent;
import com.eucalyptus.cloudformation.entity.StackEventEntity;
import com.eucalyptus.cloudformation.entity.StackResourceEntity;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class StackEventEntityManager {
    public static void addStackEvent(StackEvent stackEvent, String accountId) {
        try (TransactionResource db = Entities.transactionFor(StackEventEntity.class);){
            Entities.persist((Object)((Object)StackEventEntityManager.stackEventToStackEventEntity(stackEvent, accountId)));
            db.commit();
        }
    }

    public static void deleteStackEvents(String stackId, String accountId) {
        try (TransactionResource db = Entities.transactionFor(StackEventEntity.class);){
            Criteria criteria = Entities.createCriteria(StackEventEntity.class).add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId)).add((Criterion)Restrictions.eq((String)"stackId", (Object)stackId)).add((Criterion)Restrictions.eq((String)"recordDeleted", (Object)Boolean.FALSE));
            List entityList = criteria.list();
            for (StackEventEntity stackEventEntity : entityList) {
                stackEventEntity.setRecordDeleted(Boolean.TRUE);
            }
            db.commit();
        }
    }

    public static StackEventEntity stackEventToStackEventEntity(StackEvent stackEvent, String accountId) {
        StackEventEntity stackEventEntity = new StackEventEntity();
        stackEventEntity.setRecordDeleted(Boolean.FALSE);
        stackEventEntity.setAccountId(accountId);
        stackEventEntity.setEventId(stackEvent.getEventId());
        stackEventEntity.setLogicalResourceId(stackEvent.getLogicalResourceId());
        stackEventEntity.setPhysicalResourceId(stackEvent.getPhysicalResourceId());
        stackEventEntity.setResourceProperties(stackEvent.getResourceProperties());
        stackEventEntity.setResourceStatus(StackResourceEntity.Status.valueOf(stackEvent.getResourceStatus()));
        stackEventEntity.setResourceStatusReason(stackEvent.getResourceStatusReason());
        stackEventEntity.setResourceType(stackEvent.getResourceType());
        stackEventEntity.setStackId(stackEvent.getStackId());
        stackEventEntity.setStackName(stackEvent.getStackName());
        stackEventEntity.setTimestamp(stackEvent.getTimestamp());
        return stackEventEntity;
    }

    public static StackEvent stackEventEntityToStackEvent(StackEventEntity stackEventEntity) {
        StackEvent stackEvent = new StackEvent();
        stackEvent.setEventId(stackEventEntity.getEventId());
        stackEvent.setLogicalResourceId(stackEventEntity.getLogicalResourceId());
        stackEvent.setPhysicalResourceId(stackEventEntity.getPhysicalResourceId());
        stackEvent.setResourceProperties(stackEventEntity.getResourceProperties());
        stackEvent.setResourceStatus(stackEventEntity.getResourceStatus().toString());
        stackEvent.setResourceStatusReason(stackEventEntity.getResourceStatusReason());
        stackEvent.setResourceType(stackEventEntity.getResourceType());
        stackEvent.setStackId(stackEventEntity.getStackId());
        stackEvent.setStackName(stackEventEntity.getStackName());
        stackEvent.setTimestamp(stackEventEntity.getTimestamp());
        return stackEvent;
    }

    public static ArrayList<StackEvent> getStackEventsByNameOrId(String stackNameOrId, String accountId) {
        ArrayList returnValue = Lists.newArrayList();
        try (TransactionResource db = Entities.transactionFor(StackEventEntity.class);){
            Criteria criteria = Entities.createCriteria(StackEventEntity.class).add((Criterion)(accountId != null ? Restrictions.eq((String)"accountId", (Object)accountId) : Restrictions.conjunction())).add((Criterion)Restrictions.or((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"recordDeleted", (Object)Boolean.FALSE), (Criterion)Restrictions.eq((String)"stackName", (Object)stackNameOrId)), (Criterion)Restrictions.eq((String)"stackId", (Object)stackNameOrId))).addOrder(Order.desc((String)"timestamp"));
            List results = criteria.list();
            if (results != null) {
                for (StackEventEntity stackEventEntity : results) {
                    returnValue.add(StackEventEntityManager.stackEventEntityToStackEvent(stackEventEntity));
                }
            }
            db.commit();
        }
        return returnValue;
    }

    public static ArrayList<StackEventEntity> getStackEventEntitiesById(String stackId, String accountId) {
        ArrayList returnValue = Lists.newArrayList();
        try (TransactionResource db = Entities.transactionFor(StackEventEntity.class);){
            Criteria criteria = Entities.createCriteria(StackEventEntity.class).add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId)).add((Criterion)Restrictions.eq((String)"stackId", (Object)stackId)).add((Criterion)Restrictions.eq((String)"recordDeleted", (Object)Boolean.FALSE));
            List entityList = criteria.list();
            if (entityList != null) {
                returnValue.addAll(entityList);
            }
            db.commit();
        }
        return returnValue;
    }
}

